/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.services.activity.display;

import cottons.utils.StringHelper;
import io.intino.konos.builder.codegeneration.services.activity.display.ElementDisplaysTemplate;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.Display;
import io.intino.konos.model.graph.KonosGraph;
import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import org.siani.itrules.Template;
import org.siani.itrules.model.AbstractFrame;
import org.siani.itrules.model.Frame;

public class ElementDisplaysRenderer {
    private static final String DISPLAYS = "displays";
    private final File gen;
    private final String packageName;
    private final String boxName;
    private final List<Display> displays;

    public ElementDisplaysRenderer(KonosGraph graph, File gen, String packageName, String boxName) {
        this.gen = gen;
        this.packageName = packageName;
        this.displays = graph.displayList().stream().filter(d -> !((Object)d).getClass().equals(Display.class)).collect(Collectors.toList());
        this.boxName = boxName;
    }

    public void execute() {
        Frame frame = this.createFrame();
        for (Display display : this.displays) {
            frame.addSlot("display", new AbstractFrame[]{this.displayFrame(display)});
        }
        this.write(frame);
    }

    private Frame displayFrame(Display display) {
        return new Frame(new String[]{"display"}).addSlot("name", new String[]{display.name$()}).addSlot("type", new String[]{((Object)((Object)display)).getClass().getSimpleName()});
    }

    private void write(Frame frame) {
        String newDisplay = StringHelper.snakeCaseToCamelCase((String)"ElementDisplays");
        Commons.writeFrame(new File(this.gen, DISPLAYS), newDisplay, this.template().format((Object)frame));
    }

    private Template template() {
        return this.customize(ElementDisplaysTemplate.create());
    }

    private Template customize(Template template) {
        template.add("SnakeCaseToCamelCase", value -> StringHelper.snakeCaseToCamelCase((String)value.toString()));
        template.add("ReturnTypeFormatter", value -> value.equals("Void") ? "void" : value);
        template.add("validname", value -> value.toString().replace("-", "").toLowerCase());
        return template;
    }

    private Frame createFrame() {
        return new Frame(new String[]{"elementDisplays"}).addSlot("box", new String[]{this.boxName}).addSlot("package", new String[]{this.packageName});
    }
}

