/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.actions;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.PsiTestUtil;
import io.intino.konos.builder.KonosIcons;
import io.intino.konos.builder.actions.KonosAction;
import io.intino.konos.builder.codegeneration.FullRenderer;
import io.intino.konos.builder.utils.GraphLoader;
import io.intino.konos.builder.utils.KonosUtils;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.tara.Language;
import io.intino.tara.StashBuilder;
import io.intino.tara.compiler.shared.Configuration;
import io.intino.tara.io.Stash;
import io.intino.tara.plugin.lang.psi.impl.TaraUtil;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;
import tara.dsl.Konos;

public class CreateKonosBoxAction
extends KonosAction {
    private static final Logger LOG = Logger.getInstance((String)"CreateKonosBoxAction: ");
    private static final String BOX = "box";
    private static final String TEXT = "Create Konos Box";

    public CreateKonosBoxAction() {
        super(TEXT, "Creates Konos Box", KonosIcons.GENERATE_16);
        this.setShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"control alt S"}));
    }

    @Override
    public void update(AnActionEvent e) {
        e.getPresentation().setIcon(KonosIcons.GENERATE_16);
        super.update(e);
        File file = new File(((Object)((Object)this)).getClass().getProtectionDomain().getCodeSource().getLocation().getFile());
        if (!file.exists()) {
            return;
        }
        String version = file.getParentFile().getName();
        Module module = (Module)e.getData(LangDataKeys.MODULE);
        if (module != null) {
            e.getPresentation().setText("Create Konos Box for " + module.getName() + " (" + version + ")");
        }
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)e.getData(PlatformDataKeys.PROJECT);
        Module module = (Module)LangDataKeys.MODULE.getData(e.getDataContext());
        if (this.noProject(e, project) || module == null) {
            return;
        }
        project.save();
        FileDocumentManager.getInstance().saveAllDocuments();
        List<PsiFile> konosFiles = KonosUtils.findKonosFiles(module);
        new KonosGenerator(module, konosFiles).generate(TaraUtil.getSrcRoot((Module)module), this.getGenRoot(module), this.getResRoot(module));
    }

    private boolean noProject(AnActionEvent e, Project project) {
        if (project == null) {
            LOG.error("actionPerformed: no project for " + e);
            return true;
        }
        return false;
    }

    private VirtualFile getGenRoot(Module module) {
        for (VirtualFile file : TaraUtil.getSourceRoots((Module)module)) {
            if (!file.isDirectory() || !"gen".equals(file.getName())) continue;
            return file;
        }
        VirtualFile genDirectory = this.createDirectory(module, "gen");
        if (genDirectory == null) {
            return null;
        }
        PsiTestUtil.addSourceRoot((Module)module, (VirtualFile)genDirectory, (JpsModuleSourceRootType)JavaSourceRootType.SOURCE);
        return genDirectory;
    }

    private VirtualFile getResRoot(Module module) {
        for (VirtualFile file : TaraUtil.getSourceRoots((Module)module)) {
            if (!file.isDirectory() || !"res".equals(file.getName())) continue;
            return file;
        }
        VirtualFile resDirectory = this.createDirectory(module, "res");
        PsiTestUtil.addSourceRoot((Module)module, (VirtualFile)resDirectory, (JpsModuleSourceRootType)JavaResourceRootType.RESOURCE);
        return resDirectory;
    }

    private VirtualFile createDirectory(Module module, String name) {
        Application a = ApplicationManager.getApplication();
        if (a.isWriteAccessAllowed()) {
            return (VirtualFile)a.runWriteAction(() -> {
                try {
                    VirtualFile[] contentRoots = ModuleRootManager.getInstance((Module)module).getContentRoots();
                    return VfsUtil.createDirectoryIfMissing((VirtualFile)contentRoots[0], (String)name);
                }
                catch (IOException e) {
                    return null;
                }
            });
        }
        return null;
    }

    private class KonosGenerator {
        private final Module module;
        private final List<PsiFile> konosFiles;

        KonosGenerator(Module module, List<PsiFile> konosFiles) {
            this.module = module;
            this.konosFiles = konosFiles;
        }

        void generate(VirtualFile srcDirectory, VirtualFile genDirectory, VirtualFile resDirectory) {
            if (genDirectory == null) {
                this.notifyError("gen source root not found.");
                return;
            }
            Configuration configuration = TaraUtil.configurationOf((Module)this.module);
            String generationPackage = configuration == null ? CreateKonosBoxAction.BOX : configuration.workingPackage() + (configuration.boxPackage().isEmpty() ? "" : "." + configuration.boxPackage());
            File gen = new File(genDirectory.getPath(), generationPackage.replace(".", File.separator));
            gen.mkdirs();
            File src = new File(srcDirectory.getPath(), generationPackage.replace(".", File.separator));
            src.mkdirs();
            this.generate(generationPackage, gen, src, new File(resDirectory.getPath()));
        }

        private void generate(String packageName, File gen, File src, File res) {
            KonosGraph graph = this.loadGraph();
            if (graph == null) {
                this.notifyError("Models have errors");
                return;
            }
            if (!this.render(packageName, gen, src, res, graph)) {
                return;
            }
            this.refreshDirectories(gen, src, res);
            this.notifySuccess();
        }

        private KonosGraph loadGraph() {
            if (!this.konosFiles.isEmpty()) {
                Stash stash = new StashBuilder(this.konosFiles.stream().map(pf -> new File(pf.getVirtualFile().getPath())).collect(Collectors.toList()), (Language)new Konos(), this.module.getName()).build();
                if (stash == null) {
                    this.notifyError("Models have errors");
                    return null;
                }
                return GraphLoader.loadGraph(stash);
            }
            return GraphLoader.loadGraph(new Stash[0]);
        }

        private void refreshDirectories(File gen, File src, File res) {
            this.refreshDirectory(gen);
            this.refreshDirectory(src);
            this.refreshDirectory(res);
        }

        private boolean render(String packageName, File gen, File src, File res, KonosGraph graph) {
            try {
                new FullRenderer(this.module, graph, src, gen, res, packageName).execute();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.notifyError(e.getMessage() == null ? e.toString() : e.getMessage());
                return false;
            }
            return true;
        }

        private void notifySuccess() {
            VirtualFile genRoot = CreateKonosBoxAction.this.getGenRoot(this.module);
            if (genRoot != null) {
                Notifications.Bus.notify((Notification)new Notification("Boxing", "Services for " + this.module.getName(), "Generated", NotificationType.INFORMATION), (Project)this.module.getProject());
            }
        }

        private void notifyError(String message) {
            Notifications.Bus.notify((Notification)new Notification("Boxing", "Services cannot be generated", message, NotificationType.ERROR), (Project)this.module.getProject());
        }

        private void refreshDirectory(File dir) {
            VirtualFile vDir = VfsUtil.findFileByIoFile((File)dir, (boolean)true);
            if (vDir == null || !vDir.isValid()) {
                return;
            }
            VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)true, (boolean)true, (VirtualFile[])new VirtualFile[]{vDir});
            vDir.refresh(true, true);
        }
    }
}

