/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.model.graph;

import io.intino.konos.model.graph.Component;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.restricted.activity.RestrictedAbstractPage;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.Node;
import io.intino.tara.magritte.loaders.NodeLoader;
import io.intino.tara.magritte.loaders.StringLoader;
import io.intino.tara.magritte.loaders.WordLoader;
import io.intino.tara.magritte.tags.Terminal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class Activity
extends Layer
implements Terminal {
    protected Type type;
    protected Authenticated authenticated;
    protected List<AbstractPage> abstractPageList = new ArrayList<AbstractPage>();
    protected Home home;
    protected UserHome userHome;
    protected List<Page> pageList = new ArrayList<Page>();

    public Activity(Node node) {
        super(node);
    }

    public Type type() {
        return this.type;
    }

    public Activity type(Type value) {
        this.type = value;
        return this;
    }

    public Authenticated authenticated() {
        return this.authenticated;
    }

    public List<AbstractPage> abstractPageList() {
        return Collections.unmodifiableList(this.abstractPageList);
    }

    public AbstractPage abstractPage(int index) {
        return this.abstractPageList.get(index);
    }

    public List<AbstractPage> abstractPageList(Predicate<AbstractPage> predicate) {
        return this.abstractPageList().stream().filter(predicate).collect(Collectors.toList());
    }

    public Home home() {
        return this.home;
    }

    public UserHome userHome() {
        return this.userHome;
    }

    public List<Page> pageList() {
        return Collections.unmodifiableList(this.pageList);
    }

    public Page page(int index) {
        return this.pageList.get(index);
    }

    public List<Page> pageList(Predicate<Page> predicate) {
        return this.pageList().stream().filter(predicate).collect(Collectors.toList());
    }

    public Activity authenticated(Authenticated value) {
        this.authenticated = value;
        return this;
    }

    public Activity home(Home value) {
        this.home = value;
        return this;
    }

    public Activity userHome(UserHome value) {
        this.userHome = value;
        return this;
    }

    protected List<Node> componentList$() {
        LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList$());
        if (this.authenticated != null) {
            components.add(this.authenticated.core$());
        }
        new ArrayList<AbstractPage>(this.abstractPageList).forEach(c -> components.add(c.core$()));
        if (this.home != null) {
            components.add(this.home.core$());
        }
        if (this.userHome != null) {
            components.add(this.userHome.core$());
        }
        new ArrayList<Page>(this.pageList).forEach(c -> components.add(c.core$()));
        return new ArrayList<Node>(components);
    }

    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap();
        map.put("type", new ArrayList<Type>(Collections.singletonList(this.type)));
        return map;
    }

    protected void addNode$(Node node) {
        super.addNode$(node);
        if (node.is("Activity$Authenticated")) {
            this.authenticated = (Authenticated)node.as(Authenticated.class);
        }
        if (node.is("Activity$AbstractPage")) {
            this.abstractPageList.add((AbstractPage)node.as(AbstractPage.class));
        }
        if (node.is("Activity$Home")) {
            this.home = (Home)node.as(Home.class);
        }
        if (node.is("Activity$UserHome")) {
            this.userHome = (UserHome)node.as(UserHome.class);
        }
        if (node.is("Activity$Page")) {
            this.pageList.add((Page)node.as(Page.class));
        }
    }

    protected void removeNode$(Node node) {
        super.removeNode$(node);
        if (node.is("Activity$Authenticated")) {
            this.authenticated = null;
        }
        if (node.is("Activity$AbstractPage")) {
            this.abstractPageList.remove(node.as(AbstractPage.class));
        }
        if (node.is("Activity$Home")) {
            this.home = null;
        }
        if (node.is("Activity$UserHome")) {
            this.userHome = null;
        }
        if (node.is("Activity$Page")) {
            this.pageList.remove(node.as(Page.class));
        }
    }

    protected void load$(String name, List<?> values) {
        super.load$(name, values);
        if (name.equalsIgnoreCase("type")) {
            this.type = (Type)((Object)WordLoader.load(values, Type.class, (Layer)this).get(0));
        }
    }

    protected void set$(String name, List<?> values) {
        super.set$(name, values);
        if (name.equalsIgnoreCase("type")) {
            this.type = (Type)((Object)values.get(0));
        }
    }

    public Create create() {
        return new Create(null);
    }

    public Create create(String name) {
        return new Create(name);
    }

    public Clear clear() {
        return new Clear();
    }

    public KonosGraph graph() {
        return (KonosGraph)this.core$().graph().as(KonosGraph.class);
    }

    public static class Page
    extends AbstractPage
    implements Terminal {
        public Page(Node node) {
            super(node);
        }

        @Override
        public RestrictedAbstractPage asRestricted() {
            Layer as = this.a$(RestrictedAbstractPage.class);
            return as != null ? (RestrictedAbstractPage)as : (RestrictedAbstractPage)this.core$().addFacet(RestrictedAbstractPage.class);
        }

        @Override
        public boolean isRestricted() {
            return this.core$().is(RestrictedAbstractPage.class);
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
        }

        @Override
        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }
    }

    public static class UserHome
    extends AbstractPage
    implements Terminal {
        public UserHome(Node node) {
            super(node);
        }

        @Override
        public RestrictedAbstractPage asRestricted() {
            Layer as = this.a$(RestrictedAbstractPage.class);
            return as != null ? (RestrictedAbstractPage)as : (RestrictedAbstractPage)this.core$().addFacet(RestrictedAbstractPage.class);
        }

        @Override
        public boolean isRestricted() {
            return this.core$().is(RestrictedAbstractPage.class);
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
        }

        @Override
        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }
    }

    public static class Home
    extends AbstractPage
    implements Terminal {
        public Home(Node node) {
            super(node);
        }

        @Override
        public RestrictedAbstractPage asRestricted() {
            Layer as = this.a$(RestrictedAbstractPage.class);
            return as != null ? (RestrictedAbstractPage)as : (RestrictedAbstractPage)this.core$().addFacet(RestrictedAbstractPage.class);
        }

        @Override
        public boolean isRestricted() {
            return this.core$().is(RestrictedAbstractPage.class);
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
        }

        @Override
        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }
    }

    public static abstract class AbstractPage
    extends Layer
    implements Terminal {
        protected Component uses;
        protected List<String> paths = new ArrayList<String>();

        public AbstractPage(Node node) {
            super(node);
        }

        public Component uses() {
            return this.uses;
        }

        public List<String> paths() {
            return this.paths;
        }

        public String paths(int index) {
            return this.paths.get(index);
        }

        public List<String> paths(Predicate<String> predicate) {
            return this.paths().stream().filter(predicate).collect(Collectors.toList());
        }

        public AbstractPage uses(Component value) {
            this.uses = value;
            return this;
        }

        public RestrictedAbstractPage asRestricted() {
            Layer as = this.a$(RestrictedAbstractPage.class);
            return as != null ? (RestrictedAbstractPage)as : (RestrictedAbstractPage)this.core$().addFacet(RestrictedAbstractPage.class);
        }

        public boolean isRestricted() {
            return this.core$().is(RestrictedAbstractPage.class);
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("uses", this.uses != null ? new ArrayList<Component>(Collections.singletonList(this.uses)) : Collections.emptyList());
            map.put("paths", this.paths);
            return map;
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("uses")) {
                this.uses = (Component)((Object)NodeLoader.load(values, Component.class, (Layer)this).get(0));
            } else if (name.equalsIgnoreCase("paths")) {
                this.paths = StringLoader.load(values, (Layer)this);
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("uses")) {
                this.uses = values.get(0) != null ? (Component)this.core$().graph().load(((Layer)values.get(0)).core$().id()).as(Component.class) : null;
            } else if (name.equalsIgnoreCase("paths")) {
                this.paths = new ArrayList(values);
            }
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }
        }
    }

    public static class Authenticated
    extends Layer
    implements Terminal {
        protected String by;

        public Authenticated(Node node) {
            super(node);
        }

        public String by() {
            return this.by;
        }

        public Authenticated by(String value) {
            this.by = value;
            return this;
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("by", new ArrayList<String>(Collections.singletonList(this.by)));
            return map;
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("by")) {
                this.by = (String)StringLoader.load(values, (Layer)this).get(0);
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("by")) {
                this.by = (String)values.get(0);
            }
        }

        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }
    }

    public class Clear {
        public void page(Predicate<Page> filter) {
            new ArrayList<Page>(Activity.this.pageList()).stream().filter(filter).forEach(Layer::delete$);
        }
    }

    public class Create {
        protected final String name;

        public Create(String name) {
            this.name = name;
        }

        public Authenticated authenticated(String by) {
            Authenticated newElement = (Authenticated)Activity.this.core$().graph().concept(Authenticated.class).createNode(this.name, Activity.this.core$()).as(Authenticated.class);
            newElement.core$().set((Layer)newElement, "by", Collections.singletonList(by));
            return newElement;
        }

        public Home home(Component uses) {
            Home newElement = (Home)Activity.this.core$().graph().concept(Home.class).createNode(this.name, Activity.this.core$()).as(Home.class);
            newElement.core$().set((Layer)newElement, "uses", Collections.singletonList(uses));
            return newElement;
        }

        public UserHome userHome(Component uses) {
            UserHome newElement = (UserHome)Activity.this.core$().graph().concept(UserHome.class).createNode(this.name, Activity.this.core$()).as(UserHome.class);
            newElement.core$().set((Layer)newElement, "uses", Collections.singletonList(uses));
            return newElement;
        }

        public Page page(Component uses, List<String> paths) {
            Page newElement = (Page)Activity.this.core$().graph().concept(Page.class).createNode(this.name, Activity.this.core$()).as(Page.class);
            newElement.core$().set((Layer)newElement, "uses", Collections.singletonList(uses));
            newElement.core$().set((Layer)newElement, "paths", paths);
            return newElement;
        }
    }

    public static enum Type {
        Ajax;

    }
}

