/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.accessor.ui;

import com.intellij.openapi.module.Module;
import com.intellij.util.io.ZipUtil;
import cottons.utils.StringHelper;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.accessor.ui.ArtifactTemplate;
import io.intino.konos.builder.codegeneration.accessor.ui.DialogWidgetTemplate;
import io.intino.konos.builder.codegeneration.accessor.ui.DisplayWidgetTemplate;
import io.intino.konos.builder.codegeneration.accessor.ui.PageTemplate;
import io.intino.konos.builder.codegeneration.accessor.ui.WidgetNotifierTemplate;
import io.intino.konos.builder.codegeneration.accessor.ui.WidgetRequesterTemplate;
import io.intino.konos.builder.codegeneration.accessor.ui.WidgetsTemplate;
import io.intino.konos.model.graph.Activity;
import io.intino.konos.model.graph.Component;
import io.intino.konos.model.graph.Dialog;
import io.intino.konos.model.graph.Display;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.tara.compiler.shared.Configuration;
import io.intino.tara.magritte.Layer;
import io.intino.tara.plugin.lang.psi.impl.TaraUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.siani.itrules.model.AbstractFrame;
import org.siani.itrules.model.Frame;
import sun.net.www.protocol.file.FileURLConnection;

public class ActivityAccessorRenderer {
    private static final String SRC_DIRECTORY = "src";
    private static final String ARTIFACT_LEGIO = "artifact.legio";
    private Module appModule;
    private final File genDirectory;
    private final Activity activity;
    private String parent;

    ActivityAccessorRenderer(Module appModule, Module webModule, Activity activity, String parent) {
        this.appModule = appModule;
        this.genDirectory = this.rootDirectory(webModule);
        this.activity = activity;
        this.parent = parent;
    }

    public ActivityAccessorRenderer(File rootDirectory, Activity activity) {
        this.genDirectory = rootDirectory;
        this.activity = activity;
    }

    boolean createConfigurationFile() {
        Configuration configuration = TaraUtil.configurationOf((Module)this.appModule);
        Frame frame = new Frame(new String[0]);
        frame.addTypes(new String[]{"artifact", "legio"});
        frame.addSlot("groupID", new String[]{configuration.groupId()});
        frame.addSlot("artifactID", new String[]{configuration.artifactId()});
        frame.addSlot("version", new String[]{configuration.version()});
        Map<String, List<String>> repositories = this.reduce(configuration.releaseRepositories());
        for (String id : repositories.keySet()) {
            Frame repoFrame = new Frame(new String[0]).addTypes(new String[]{"repository", "release"}).addSlot("id", new String[]{id});
            for (String url : repositories.get(id)) {
                repoFrame.addSlot("url", new String[]{url});
            }
            frame.addSlot("repository", new AbstractFrame[]{repoFrame});
        }
        File file = new File(this.genDirectory, ARTIFACT_LEGIO);
        if (!file.exists()) {
            try {
                return Files.write(file.toPath(), ArtifactTemplate.create().format((Object)frame).getBytes(), new OpenOption[0]).toFile().exists();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    private Map<String, List<String>> reduce(Map<String, String> map) {
        HashMap<String, List<String>> reduced = new HashMap<String, List<String>>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (!reduced.containsKey(entry.getValue())) {
                reduced.put(entry.getValue(), new ArrayList());
            }
            ((List)reduced.get(entry.getValue())).add(entry.getKey());
        }
        return reduced;
    }

    public void execute() {
        try {
            this.createStaticFiles();
            this.createWidgets();
            this.createPages();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void createPages() throws IOException {
        for (Activity.AbstractPage page : this.activity.abstractPageList()) {
            Path pagePath = new File(this.genDirectory, SRC_DIRECTORY + File.separator + page.name$() + ".html").toPath();
            if (Files.exists(pagePath, new LinkOption[0])) continue;
            Files.write(pagePath, PageTemplate.create().format((Object)this.pageFrame(page)).getBytes(), new OpenOption[0]);
        }
    }

    private Frame pageFrame(Activity.AbstractPage page) {
        String usesDisplay = page.uses().name$() + (page.uses().i$(Dialog.class) ? Dialog.class.getSimpleName() : "");
        return new Frame(new String[0]).addTypes(new String[]{"page"}).addSlot("usesDisplay", new String[]{usesDisplay}).addSlot("uses", new String[]{page.uses().name$()}).addSlot("name", new String[]{page.name$()});
    }

    private void createDisplayWidget(Display display) throws IOException {
        File file;
        Frame frame = new Frame(new String[0]).addTypes(new String[]{"widget"}).addSlot("name", new String[]{display.name$()}).addSlot("innerDisplay", (String[])display.displays().stream().map(Layer::name$).toArray(String[]::new));
        if (display.parentDisplay() != null) {
            frame.addSlot("parent", new AbstractFrame[]{new Frame(new String[0]).addSlot("value", new String[]{display.parentDisplay()}).addSlot("dsl", new String[]{this.parent.substring(this.parent.lastIndexOf(".") + 1)})});
        }
        if (!(file = new File(this.genDirectory, SRC_DIRECTORY + File.separator + "widgets" + File.separator + StringHelper.camelCaseToSnakeCase((String)display.name$()).toLowerCase() + "-widget.html")).exists()) {
            Files.write(file.toPath(), Formatters.customize(DisplayWidgetTemplate.create()).format((Object)frame).getBytes(), new OpenOption[0]);
        }
    }

    private void createWidgets() throws IOException {
        Frame widgets = new Frame(new String[0]).addTypes(new String[]{"widgets"});
        for (Component component : KonosGraph.componentsOf(this.activity)) {
            if (component.i$(Display.class)) {
                this.createDisplay((Display)component.a$(Display.class));
            }
            if (component.i$(Dialog.class)) {
                this.createDialogWidget((Dialog)component.a$(Dialog.class));
            }
            widgets.addSlot("widget", new String[]{component.name$()});
        }
        Files.write(new File(this.genDirectory, SRC_DIRECTORY + File.separator + "widgets" + File.separator + "widgets.html").toPath(), Formatters.customize(WidgetsTemplate.create()).format((Object)widgets).getBytes(), new OpenOption[0]);
    }

    private void createDisplay(Display component) throws IOException {
        this.createNotifier(component);
        this.createRequester(component);
        this.createDisplayWidget(component);
    }

    private void createDialogWidget(Dialog dialog) throws IOException {
        Frame frame = new Frame(new String[0]).addTypes(new String[]{"dialog"}).addSlot("name", new String[]{dialog.name$()});
        File file = new File(this.genDirectory, SRC_DIRECTORY + File.separator + "widgets" + File.separator + StringHelper.camelCaseToSnakeCase((String)dialog.name$()).toLowerCase() + "-widget.html");
        if (!file.exists()) {
            Files.write(file.toPath(), Formatters.customize(DialogWidgetTemplate.create()).format((Object)frame).getBytes(), new OpenOption[0]);
        }
    }

    private void createRequester(Display display) throws IOException {
        Frame frame = new Frame(new String[0]).addTypes(new String[]{"widget"}).addSlot("name", new String[]{display.name$()}).addSlot("requester", (AbstractFrame[])((Frame[])display.requestList().stream().map(this::frameOf).toArray(Frame[]::new)));
        File file = new File(this.genDirectory, SRC_DIRECTORY + File.separator + "widgets" + File.separator + display.name$().toLowerCase() + "widget" + File.separator + "requester.js");
        file.getParentFile().mkdirs();
        Files.write(file.toPath(), Formatters.customize(WidgetRequesterTemplate.create()).format((Object)frame).getBytes(), new OpenOption[0]);
    }

    private void createNotifier(Display display) throws IOException {
        Frame frame = new Frame(new String[0]).addTypes(new String[]{"widget"}).addSlot("name", new String[]{display.name$()}).addSlot("notification", (AbstractFrame[])((Frame[])display.notificationList().stream().map(this::frameOf).toArray(Frame[]::new)));
        File file = new File(this.genDirectory, SRC_DIRECTORY + File.separator + "widgets" + File.separator + display.name$().toLowerCase() + "widget" + File.separator + "notifier-listener.js");
        file.getParentFile().mkdirs();
        Files.write(file.toPath(), Formatters.customize(WidgetNotifierTemplate.create()).format((Object)frame).getBytes(), new OpenOption[0]);
    }

    private Frame frameOf(Display.Request r) {
        Frame frame = new Frame(new String[0]).addTypes(new String[]{"requester"}).addSlot("name", new String[]{r.name$()});
        if (r.isType()) {
            frame.addSlot("parameter", new String[]{""});
            frame.addSlot("parameterSignature", new String[]{""});
        }
        frame.addSlot("method", new String[]{r.responseType().name()});
        return frame;
    }

    private Frame frameOf(Display.Notification n) {
        Frame frame = new Frame(new String[0]).addTypes(new String[]{"notification"}).addSlot("name", new String[]{n.name$()}).addSlot("to", new String[]{n.to().name()});
        if (n.asType() != null) {
            frame.addSlot("parameter", new String[]{""});
        }
        return frame;
    }

    private void createStaticFiles() throws IOException {
        File src = new File(this.genDirectory, SRC_DIRECTORY);
        src.mkdirs();
        File file = new File(src, "ui.zip");
        this.copyResourcesRecursively(this.getClass().getResource("/ui/ui.zip"), file);
        ZipUtil.extract((File)file, (File)src, null, (boolean)false);
        file.delete();
        new File(src, "images").mkdirs();
        new File(src, "widgets").mkdirs();
    }

    private File rootDirectory(Module webModule) {
        return new File(webModule.getModuleFilePath()).getParentFile();
    }

    private void copyResourcesRecursively(URL originUrl, File destination) {
        block4: {
            try {
                URLConnection urlConnection = originUrl.openConnection();
                if (urlConnection instanceof JarURLConnection) {
                    this.copyJarResourcesRecursively(destination, (JarURLConnection)urlConnection);
                    break block4;
                }
                if (urlConnection instanceof FileURLConnection) {
                    FileUtils.copyDirectory((File)new File(originUrl.getPath()), (File)destination);
                    break block4;
                }
                throw new Exception("URLConnection[" + urlConnection.getClass().getSimpleName() + "] is not a recognized/implemented connection type.");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void copyJarResourcesRecursively(File destination, JarURLConnection jarConnection) throws IOException {
        JarFile jarFile = jarConnection.getJarFile();
        Enumeration<JarEntry> list = jarFile.entries();
        while (list.hasMoreElements()) {
            JarEntry entry = list.nextElement();
            if (!entry.getName().startsWith(jarConnection.getEntryName())) continue;
            String fileName = StringUtils.removeStart((String)entry.getName(), (String)jarConnection.getEntryName());
            if (!entry.isDirectory()) {
                InputStream entryInputStream = jarFile.getInputStream(entry);
                Throwable throwable = null;
                try {
                    FileUtils.copyInputStreamToFile((InputStream)entryInputStream, (File)new File(destination, fileName));
                    continue;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (entryInputStream == null) continue;
                    if (throwable != null) {
                        try {
                            entryInputStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    entryInputStream.close();
                    continue;
                }
            }
            new File(destination, fileName).exists();
        }
    }
}

