/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.services.activity;

import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.schema.SchemaRenderer;
import io.intino.konos.builder.codegeneration.services.activity.SchemaAdapterTemplate;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.Schema;
import io.intino.konos.model.graph.Service;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.siani.itrules.Template;
import org.siani.itrules.model.AbstractFrame;
import org.siani.itrules.model.Frame;

public class SchemaAdaptersRenderer {
    private final Collection<Schema> schemas;
    private final File destination;
    private final String packageName;
    private final KonosGraph graph;

    public SchemaAdaptersRenderer(KonosGraph graph, File destination, String packageName) {
        this.graph = graph;
        this.schemas = this.findActivitySchemas();
        this.destination = destination;
        this.packageName = packageName;
    }

    public void execute() {
        if (this.graph.activityList().isEmpty()) {
            return;
        }
        Frame[] schemaFrames = (Frame[])this.schemas.stream().map(this::processSchema).toArray(Frame[]::new);
        Commons.writeFrame(new File(this.destination, "schemas"), "ActivitySchemaAdapters", this.template().format((Object)new Frame(new String[0]).addTypes(new String[]{"adapters"}).addSlot("package", new String[]{this.packageName}).addSlot("schema", (AbstractFrame[])schemaFrames)));
    }

    private Template template() {
        Template template = Formatters.customize(SchemaAdapterTemplate.create());
        template.add("typeFormat", value -> value.toString().contains(".") ? Formatters.firstLowerCase(value.toString()) : value);
        return template;
    }

    private Frame processSchema(Schema schema) {
        Service service = (Service)schema.core$().ownerAs(Service.class);
        String subPackage = "schemas" + (service != null ? File.separator + service.name$().toLowerCase() : "");
        return SchemaRenderer.createSchemaFrame(schema, subPackage.isEmpty() ? this.packageName : this.packageName + "." + subPackage.replace(File.separator, "."), this.packageName);
    }

    private Collection<Schema> findActivitySchemas() {
        ArrayList<Schema> schemas = new ArrayList<Schema>();
        for (Schema schema : this.graph.core$().find(Schema.class)) {
            if (this.isAlreadyAdded(schema, schemas)) continue;
            schemas.add(schema);
        }
        return schemas;
    }

    private boolean isAlreadyAdded(Schema schema, List<Schema> schemas) {
        for (Schema anSchema : schemas) {
            if (!schema.name$().equals(anSchema.name$())) continue;
            return true;
        }
        return false;
    }
}

