/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration;

import com.intellij.openapi.module.Module;
import cottons.utils.StringHelper;
import io.intino.konos.builder.codegeneration.BoxConfigurationTemplate;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.Activity;
import io.intino.konos.model.graph.DataLake;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.Service;
import io.intino.konos.model.graph.jms.JMSService;
import io.intino.konos.model.graph.jmx.JMXService;
import io.intino.konos.model.graph.rest.RESTService;
import io.intino.konos.model.graph.slackbot.SlackBotService;
import io.intino.tara.compiler.shared.Configuration;
import io.intino.tara.magritte.Layer;
import io.intino.tara.plugin.lang.psi.impl.TaraUtil;
import java.io.File;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.siani.itrules.Template;
import org.siani.itrules.model.AbstractFrame;
import org.siani.itrules.model.Frame;

public class BoxConfigurationRenderer {
    private final KonosGraph graph;
    private final File gen;
    private final String packageName;
    private final Module module;
    private final Configuration configuration;
    private String parent;
    private boolean isTara;

    public BoxConfigurationRenderer(KonosGraph graph, File gen, String packageName, Module module, String parent, boolean isTara) {
        this.graph = graph;
        this.gen = gen;
        this.packageName = packageName;
        this.module = module;
        this.configuration = module != null ? TaraUtil.configurationOf((Module)module) : null;
        this.parent = parent;
        this.isTara = isTara;
    }

    public Frame execute() {
        Frame frame = new Frame(new String[0]).addTypes(new String[]{"boxconfiguration"});
        String boxName = this.fillFrame(frame);
        Commons.writeFrame(this.gen, StringHelper.snakeCaseToCamelCase((String)boxName) + "Configuration", this.template().format((Object)frame));
        return frame;
    }

    private String fillFrame(Frame frame) {
        String boxName = this.name();
        frame.addSlot("name", new String[]{boxName});
        frame.addSlot("package", new String[]{this.packageName});
        if (this.parent != null && this.configuration != null && !Configuration.Level.Platform.equals((Object)this.configuration.level())) {
            frame.addSlot("parent", new String[]{this.parent});
        }
        this.addRESTServices(frame, boxName);
        this.addJMSServices(frame, boxName);
        this.addSlackServices(frame, boxName);
        this.addDataLakes(frame, boxName);
        this.addEventHandlers(frame, boxName);
        this.addActivities(frame, boxName);
        if (this.isTara) {
            frame.addSlot("tara", new String[]{""});
        }
        return boxName;
    }

    private void addRESTServices(Frame frame, String boxName) {
        for (RESTService service : this.graph.rESTServiceList()) {
            Frame restFrame = new Frame(new String[0]).addTypes(new String[]{"service", "rest"}).addSlot("name", new String[]{service.name$()}).addSlot("configuration", new String[]{boxName});
            if (service.authenticated() != null) {
                restFrame.addTypes(new String[]{"auth"});
            }
            this.addUserVariables(service.a$(Service.class), restFrame, this.findCustomParameters(service));
            frame.addSlot("service", new AbstractFrame[]{restFrame});
        }
    }

    private void addJMSServices(Frame frame, String boxName) {
        for (JMSService service : this.graph.jMSServiceList()) {
            Frame jmsFrame = new Frame(new String[0]).addTypes(new String[]{"service", "jms"}).addSlot("name", new String[]{service.name$()}).addSlot("configuration", new String[]{boxName});
            this.addUserVariables(service.a$(Service.class), jmsFrame, this.findCustomParameters(service));
            frame.addSlot("service", new AbstractFrame[]{jmsFrame});
        }
    }

    private void addJMXServices(Frame frame, String boxName) {
        for (JMXService service : this.graph.jMXServiceList()) {
            Frame jmsFrame = new Frame(new String[0]).addTypes(new String[]{"service", "jmx"}).addSlot("name", new String[]{service.name$()}).addSlot("configuration", new String[]{boxName});
            frame.addSlot("service", new AbstractFrame[]{jmsFrame});
        }
    }

    private void addDataLakes(Frame frame, String boxName) {
        DataLake dataLake = this.graph.dataLake();
        if (dataLake == null) {
            return;
        }
        Frame dataLakeFrame = new Frame(new String[0]).addTypes(new String[]{"service", "dataLake"}).addSlot("name", new String[]{dataLake.name$()}).addSlot("configuration", new String[]{boxName});
        frame.addSlot("service", new AbstractFrame[]{dataLakeFrame});
    }

    private void addEventHandlers(Frame frame, String boxName) {
        DataLake dataLake = this.graph.dataLake();
        if (dataLake == null) {
            return;
        }
        for (DataLake.Tank handler : dataLake.tankList()) {
            Frame channelFrame = new Frame(new String[0]).addTypes(new String[]{"service", "eventHandler"}).addSlot("name", new String[]{handler.name$()}).addSlot("configuration", new String[]{boxName});
            this.addUserVariables(handler, channelFrame, this.findCustomParameters(handler));
            frame.addSlot("service", new AbstractFrame[]{channelFrame});
        }
    }

    private void addActivities(Frame frame, String boxName) {
        for (Activity activity : this.graph.activityList()) {
            Frame activityFrame = new Frame(new String[0]).addTypes(new String[]{"service", "activity"}).addSlot("name", new String[]{activity.name$()}).addSlot("configuration", new String[]{boxName});
            frame.addSlot("service", new AbstractFrame[]{activityFrame});
            if (activity.authenticated() != null) {
                activityFrame.addTypes(new String[]{"auth"});
                activityFrame.addSlot("authURL", new AbstractFrame[]{new Frame(new String[0]).addSlot("name", new String[]{activity.name$()}).addSlot("configuration", new String[]{boxName})});
                activityFrame.addSlot("auth", new String[]{activity.authenticated().by()});
            }
            this.addUserVariables(activity, activityFrame, this.findCustomParameters(activity));
        }
    }

    private void addSlackServices(Frame frame, String boxName) {
        for (SlackBotService service : this.graph.slackBotServiceList()) {
            frame.addSlot("service", new AbstractFrame[]{new Frame(new String[0]).addTypes(new String[]{"service", "slack"}).addSlot("name", new String[]{service.name$()}).addSlot("configuration", new String[]{boxName})});
        }
    }

    private void addUserVariables(Layer layer, Frame frame, Collection<String> userVariables) {
        for (String custom : userVariables) {
            frame.addSlot("custom", new AbstractFrame[]{new Frame(new String[0]).addTypes(new String[]{"custom"}).addSlot("conf", new String[]{layer.name$()}).addSlot("name", new String[]{custom}).addSlot("type", new String[]{"String"})});
        }
    }

    private Set<String> findCustomParameters(DataLake.Tank channel) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        set.addAll(Commons.extractParameters(channel.topic()));
        return set;
    }

    private Set<String> findCustomParameters(JMSService service) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (JMSService.Request request : service.requestList()) {
            set.addAll(Commons.extractParameters(request.path()));
        }
        return set;
    }

    private Set<String> findCustomParameters(RESTService service) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (RESTService.Resource resource : service.resourceList()) {
            set.addAll(Commons.extractParameters(resource.path()));
        }
        return set;
    }

    private Set<String> findCustomParameters(Activity activity) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        if (activity.authenticated() != null) {
            set.addAll(Commons.extractParameters(activity.authenticated().by()));
        }
        for (Activity.AbstractPage page : activity.abstractPageList()) {
            for (String path : page.paths()) {
                set.addAll(Commons.extractParameters(path));
            }
        }
        return set;
    }

    private String name() {
        if (this.module != null) {
            Configuration configuration = TaraUtil.configurationOf((Module)this.module);
            String dsl = configuration.outDSL();
            if (dsl == null || dsl.isEmpty()) {
                return this.module.getName();
            }
            return dsl;
        }
        return "System";
    }

    private Template template() {
        return Formatters.customize(BoxConfigurationTemplate.create());
    }
}

