/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.services.activity.dialog;

import cottons.utils.StringHelper;
import io.intino.konos.builder.codegeneration.services.activity.dialog.DialogDisplayRenderer;
import io.intino.konos.builder.codegeneration.services.activity.dialog.DialogTemplate;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.Dialog;
import io.intino.konos.model.graph.KonosGraph;
import java.io.File;
import java.util.List;
import org.siani.itrules.Template;
import org.siani.itrules.model.AbstractFrame;
import org.siani.itrules.model.Frame;

public class DialogRenderer {
    private static final String DIALOGS = "dialogs";
    private KonosGraph graph;
    private final File gen;
    private final File src;
    private final String packageName;
    private final List<Dialog> dialogs;
    private final String boxName;

    public DialogRenderer(KonosGraph graph, File src, File gen, String packageName, String boxName) {
        this.graph = graph;
        this.gen = gen;
        this.src = src;
        this.packageName = packageName;
        this.dialogs = graph.dialogList();
        this.boxName = boxName;
    }

    public void execute() {
        this.dialogs.forEach(this::processDialog);
    }

    private void processDialog(Dialog dialog) {
        this.renderDialog(dialog);
        this.renderDialogDisplay();
    }

    private void renderDialog(Dialog dialog) {
        Frame frame = new Frame(new String[0]).addTypes(new String[]{"dialog"});
        frame.addSlot("package", new String[]{this.packageName});
        frame.addSlot("name", new String[]{dialog.name$()});
        frame.addSlot("box", new String[]{this.boxName});
        for (Dialog.Tab tab : dialog.tabList()) {
            this.processTab(frame, tab);
        }
        String newDialog = StringHelper.snakeCaseToCamelCase((String)(dialog.name$() + "Dialog"));
        if (!Commons.javaFile(new File(this.src, DIALOGS), newDialog).exists()) {
            Commons.writeFrame(new File(this.src, DIALOGS), newDialog, this.template().format((Object)frame));
        }
    }

    private void processTab(Frame frame, Dialog.Tab tab) {
        for (Dialog.Tab.Input input : tab.inputList()) {
            this.processInput(frame, input);
        }
    }

    private void processInput(Frame frame, Dialog.Tab.Input input) {
        this.processValidator(frame, input);
        if (input.i$(Dialog.Tab.OptionBox.class)) {
            this.processSources(frame, (Dialog.Tab.OptionBox)input.a$(Dialog.Tab.OptionBox.class));
        } else if (input.i$(Dialog.Tab.Section.class)) {
            for (Dialog.Tab.Input i : ((Dialog.Tab.Section)input).inputList()) {
                this.processInput(frame, i);
            }
        }
    }

    private void processSources(Frame frame, Dialog.Tab.OptionBox optionBox) {
        if (optionBox.source() != null && !optionBox.source().isEmpty()) {
            frame.addSlot("source", new AbstractFrame[]{new Frame(new String[0]).addTypes(new String[]{"source"}).addSlot("box", new String[]{this.boxName}).addSlot("name", new String[]{optionBox.source()}).addSlot("field", new String[]{((Object)((Object)optionBox)).getClass().getSimpleName()})});
        }
    }

    private void processValidator(Frame frame, Dialog.Tab.Input input) {
        if (input.validator() != null && !input.validator().isEmpty()) {
            frame.addSlot("validator", new AbstractFrame[]{new Frame(new String[0]).addTypes(new String[]{"validator"}).addSlot("box", new String[]{this.boxName}).addSlot("name", new String[]{input.validator()}).addSlot("field", new String[]{((Object)((Object)input)).getClass().getSimpleName()})});
        }
    }

    private void renderDialogDisplay() {
        new DialogDisplayRenderer(this.graph, this.gen, this.packageName, this.boxName).execute();
    }

    private Template template() {
        Template template = DialogTemplate.create();
        this.addFormats(template);
        return template;
    }

    private void addFormats(Template template) {
        template.add("SnakeCaseToCamelCase", value -> StringHelper.snakeCaseToCamelCase((String)value.toString()));
        template.add("ReturnTypeFormatter", value -> value.equals("Void") ? "void" : value);
        template.add("validname", value -> value.toString().replace("-", "").toLowerCase());
    }
}

