/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.services.activity.display;

import com.intellij.openapi.project.Project;
import cottons.utils.StringHelper;
import io.intino.konos.builder.codegeneration.services.activity.display.DisplayNotifierTemplate;
import io.intino.konos.builder.codegeneration.services.activity.display.DisplayRequesterTemplate;
import io.intino.konos.builder.codegeneration.services.activity.display.DisplayTemplate;
import io.intino.konos.builder.codegeneration.services.activity.display.DisplayUpdater;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.Display;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.date.DateData;
import io.intino.konos.model.graph.type.TypeData;
import io.intino.tara.magritte.Layer;
import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import org.siani.itrules.Template;
import org.siani.itrules.model.AbstractFrame;
import org.siani.itrules.model.Frame;

public class DisplayRenderer {
    private static final String DISPLAYS = "displays";
    private static final String NOTIFIERS = "notifiers";
    private static final String REQUESTERS = "requesters";
    private final Project project;
    private final File gen;
    private final File src;
    private final String packageName;
    private final List<Display> displays;
    private final String boxName;
    private final String parent;

    public DisplayRenderer(Project project, KonosGraph graph, File src, File gen, String packageName, String parent, String boxName) {
        this.project = project;
        this.gen = gen;
        this.src = src;
        this.packageName = packageName;
        this.parent = parent;
        this.displays = graph.displayList();
        this.boxName = boxName;
    }

    public void execute() {
        this.displays.forEach(this::processDisplay);
    }

    private void processDisplay(Display display) {
        Frame frame = new Frame(new String[0]).addTypes(new String[]{"display"});
        frame.addSlot("package", new String[]{this.packageName});
        frame.addSlot("name", new String[]{display.name$()});
        frame.addSlot("innerDisplay", (String[])display.displays().stream().map(Layer::name$).toArray(String[]::new));
        if (display.parentDisplay() != null) {
            this.addParent(display, frame);
        }
        if (!display.graph().schemaList().isEmpty()) {
            frame.addSlot("schemaImport", new AbstractFrame[]{new Frame(new String[0]).addTypes(new String[]{"schemaImport"}).addSlot("package", new String[]{this.packageName})});
        }
        frame.addSlot("notification", (AbstractFrame[])this.framesOfNotifications(display.notificationList()));
        frame.addSlot("request", (AbstractFrame[])this.framesOfRequests(display.requestList()));
        frame.addSlot("box", new String[]{this.boxName});
        Commons.writeFrame(new File(this.gen, DISPLAYS + File.separator + NOTIFIERS), StringHelper.snakeCaseToCamelCase((String)(display.name$() + "DisplayNotifier")), this.displayNotifierTemplate().format((Object)frame));
        Commons.writeFrame(new File(this.gen, DISPLAYS + File.separator + REQUESTERS), StringHelper.snakeCaseToCamelCase((String)(display.name$() + "DisplayRequester")), this.displayRequesterTemplate().format((Object)frame));
        String newDisplay = StringHelper.snakeCaseToCamelCase((String)(display.name$() + "Display"));
        if (!Commons.javaFile(new File(this.src, DISPLAYS), newDisplay).exists()) {
            Commons.writeFrame(new File(this.src, DISPLAYS), newDisplay, this.displayTemplate().format((Object)frame));
        } else {
            new DisplayUpdater(this.project, display, Commons.javaFile(new File(this.src, DISPLAYS), newDisplay)).update();
        }
    }

    private void addParent(Display display, Frame frame) {
        Frame parent = new Frame(new String[0]).addSlot("value", new String[]{display.parentDisplay()}).addSlot("dsl", new String[]{this.parent}).addSlot("package", new String[]{this.parent.substring(0, this.parent.lastIndexOf("."))});
        frame.addSlot("parent", new AbstractFrame[]{parent});
    }

    private Frame[] framesOfNotifications(List<Display.Notification> notifications) {
        List<Frame> frames = notifications.stream().map(this::frameOf).collect(Collectors.toList());
        return frames.toArray(new Frame[frames.size()]);
    }

    private Frame frameOf(Display.Notification notification) {
        Frame frame = new Frame(new String[0]).addTypes(new String[]{"notification"});
        frame.addSlot("name", new String[]{notification.name$()});
        frame.addSlot("target", new String[]{notification.to().name()});
        if (notification.asType() != null) {
            Frame parameterFrame = new Frame(new String[0]).addTypes(new String[]{"parameter"}).addSlot("value", new String[]{notification.asType().type()});
            if (notification.isList()) {
                parameterFrame.addTypes(new String[]{"list"});
            }
            frame.addSlot("parameter", new AbstractFrame[]{parameterFrame});
        }
        return frame;
    }

    private Frame[] framesOfRequests(List<Display.Request> requests) {
        List<Frame> frames = requests.stream().map(DisplayRenderer::frameOf).collect(Collectors.toList());
        return frames.toArray(new Frame[frames.size()]);
    }

    static Frame frameOf(Display.Request request) {
        Frame frame = new Frame(new String[0]).addTypes(new String[]{"request"});
        if (request.responseType().equals((Object)Display.Request.ResponseType.Asset)) {
            frame.addTypes(new String[]{"asset"});
        }
        frame.addSlot("name", new String[]{request.name$()});
        if (request.asType() != null) {
            Frame parameterFrame = new Frame(new String[0]).addTypes(new String[]{"parameter"}).addSlot("value", new String[]{request.asType().type()});
            if (request.isList()) {
                parameterFrame.addTypes(new String[]{"list"});
            }
            frame.addSlot("parameter", new AbstractFrame[]{parameterFrame});
        }
        return frame;
    }

    private String type(Display.Request request) {
        TypeData typeData = request.asType();
        if (typeData.i$(DateData.class)) {
            return "Long";
        }
        return typeData.type();
    }

    private Template displayNotifierTemplate() {
        Template template = DisplayNotifierTemplate.create();
        this.addFormats(template);
        return template;
    }

    private Template displayTemplate() {
        Template template = DisplayTemplate.create();
        this.addFormats(template);
        return template;
    }

    private Template displayRequesterTemplate() {
        Template template = DisplayRequesterTemplate.create();
        this.addFormats(template);
        return template;
    }

    private void addFormats(Template template) {
        template.add("SnakeCaseToCamelCase", value -> StringHelper.snakeCaseToCamelCase((String)value.toString()));
        template.add("ReturnTypeFormatter", value -> value.equals("Void") ? "void" : value);
        template.add("validname", value -> value.toString().replace("-", "").toLowerCase());
    }
}

