/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.model.graph;

import io.intino.konos.model.graph.KonosGraph;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.Node;
import io.intino.tara.magritte.loaders.StringLoader;
import io.intino.tara.magritte.tags.Terminal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class DataLake
extends Layer
implements Terminal {
    protected String clientID;
    protected List<Tank> tankList = new ArrayList<Tank>();
    protected List<Pipe> pipeList = new ArrayList<Pipe>();
    protected List<MailPipe> mailPipeList = new ArrayList<MailPipe>();
    protected List<PostPipe> postPipeList = new ArrayList<PostPipe>();

    public DataLake(Node node) {
        super(node);
    }

    public String clientID() {
        return this.clientID;
    }

    public DataLake clientID(String value) {
        this.clientID = value;
        return this;
    }

    public List<Tank> tankList() {
        return Collections.unmodifiableList(this.tankList);
    }

    public Tank tank(int index) {
        return this.tankList.get(index);
    }

    public List<Tank> tankList(Predicate<Tank> predicate) {
        return this.tankList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<Pipe> pipeList() {
        return Collections.unmodifiableList(this.pipeList);
    }

    public Pipe pipe(int index) {
        return this.pipeList.get(index);
    }

    public List<Pipe> pipeList(Predicate<Pipe> predicate) {
        return this.pipeList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<MailPipe> mailPipeList() {
        return Collections.unmodifiableList(this.mailPipeList);
    }

    public MailPipe mailPipe(int index) {
        return this.mailPipeList.get(index);
    }

    public List<MailPipe> mailPipeList(Predicate<MailPipe> predicate) {
        return this.mailPipeList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<PostPipe> postPipeList() {
        return Collections.unmodifiableList(this.postPipeList);
    }

    public PostPipe postPipe(int index) {
        return this.postPipeList.get(index);
    }

    public List<PostPipe> postPipeList(Predicate<PostPipe> predicate) {
        return this.postPipeList().stream().filter(predicate).collect(Collectors.toList());
    }

    protected List<Node> componentList$() {
        LinkedHashSet components = new LinkedHashSet(super.componentList$());
        new ArrayList<Tank>(this.tankList).forEach(c -> components.add(c.core$()));
        new ArrayList<Pipe>(this.pipeList).forEach(c -> components.add(c.core$()));
        new ArrayList<MailPipe>(this.mailPipeList).forEach(c -> components.add(c.core$()));
        new ArrayList<PostPipe>(this.postPipeList).forEach(c -> components.add(c.core$()));
        return new ArrayList<Node>(components);
    }

    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap();
        map.put("clientID", new ArrayList<String>(Collections.singletonList(this.clientID)));
        return map;
    }

    protected void addNode$(Node node) {
        super.addNode$(node);
        if (node.is("DataLake$Tank")) {
            this.tankList.add((Tank)node.as(Tank.class));
        }
        if (node.is("DataLake$Pipe")) {
            this.pipeList.add((Pipe)node.as(Pipe.class));
        }
        if (node.is("DataLake$MailPipe")) {
            this.mailPipeList.add((MailPipe)node.as(MailPipe.class));
        }
        if (node.is("DataLake$PostPipe")) {
            this.postPipeList.add((PostPipe)node.as(PostPipe.class));
        }
    }

    protected void removeNode$(Node node) {
        super.removeNode$(node);
        if (node.is("DataLake$Tank")) {
            this.tankList.remove(node.as(Tank.class));
        }
        if (node.is("DataLake$Pipe")) {
            this.pipeList.remove(node.as(Pipe.class));
        }
        if (node.is("DataLake$MailPipe")) {
            this.mailPipeList.remove(node.as(MailPipe.class));
        }
        if (node.is("DataLake$PostPipe")) {
            this.postPipeList.remove(node.as(PostPipe.class));
        }
    }

    protected void load$(String name, List<?> values) {
        super.load$(name, values);
        if (name.equalsIgnoreCase("clientID")) {
            this.clientID = (String)StringLoader.load(values, (Layer)this).get(0);
        }
    }

    protected void set$(String name, List<?> values) {
        super.set$(name, values);
        if (name.equalsIgnoreCase("clientID")) {
            this.clientID = (String)values.get(0);
        }
    }

    public Create create() {
        return new Create(null);
    }

    public Create create(String name) {
        return new Create(name);
    }

    public Clear clear() {
        return new Clear();
    }

    public KonosGraph graph() {
        return (KonosGraph)this.core$().graph().as(KonosGraph.class);
    }

    public static class PostPipe
    extends Pipe
    implements Terminal {
        public PostPipe(Node node) {
            super(node);
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
        }

        @Override
        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }
    }

    public static class MailPipe
    extends Pipe
    implements Terminal {
        public MailPipe(Node node) {
            super(node);
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
        }

        @Override
        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }
    }

    public static abstract class Pipe
    extends Layer
    implements Terminal {
        public Pipe(Node node) {
            super(node);
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            return map;
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }
        }
    }

    public static class Tank
    extends Layer
    implements Terminal {
        protected String topic;

        public Tank(Node node) {
            super(node);
        }

        public String topic() {
            return this.topic;
        }

        public Tank topic(String value) {
            this.topic = value;
            return this;
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("topic", new ArrayList<String>(Collections.singletonList(this.topic)));
            return map;
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("topic")) {
                this.topic = (String)StringLoader.load(values, (Layer)this).get(0);
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("topic")) {
                this.topic = (String)values.get(0);
            }
        }

        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }
    }

    public class Clear {
        public void tank(Predicate<Tank> filter) {
            new ArrayList<Tank>(DataLake.this.tankList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void mailPipe(Predicate<MailPipe> filter) {
            new ArrayList<MailPipe>(DataLake.this.mailPipeList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void postPipe(Predicate<PostPipe> filter) {
            new ArrayList<PostPipe>(DataLake.this.postPipeList()).stream().filter(filter).forEach(Layer::delete$);
        }
    }

    public class Create {
        protected final String name;

        public Create(String name) {
            this.name = name;
        }

        public Tank tank(String topic) {
            Tank newElement = (Tank)DataLake.this.core$().graph().concept(Tank.class).createNode(this.name, DataLake.this.core$()).as(Tank.class);
            newElement.core$().set((Layer)newElement, "topic", Collections.singletonList(topic));
            return newElement;
        }

        public MailPipe mailPipe() {
            MailPipe newElement = (MailPipe)DataLake.this.core$().graph().concept(MailPipe.class).createNode(this.name, DataLake.this.core$()).as(MailPipe.class);
            return newElement;
        }

        public PostPipe postPipe() {
            PostPipe newElement = (PostPipe)DataLake.this.core$().graph().concept(PostPipe.class).createNode(this.name, DataLake.this.core$()).as(PostPipe.class);
            return newElement;
        }
    }
}

