/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.main;

import com.intellij.openapi.module.Module;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.main.MainTemplate;
import io.intino.konos.builder.helpers.Commons;
import io.intino.tara.compiler.shared.Configuration;
import io.intino.tara.plugin.lang.psi.impl.TaraUtil;
import java.io.File;
import org.siani.itrules.Template;
import org.siani.itrules.model.Frame;

public class MainRenderer {
    private final File destination;
    private final String packageName;
    private final Module module;
    private final Configuration configuration;

    public MainRenderer(File destination, String packageName, Module module) {
        this.destination = destination;
        this.packageName = packageName;
        this.module = module;
        this.configuration = module != null ? TaraUtil.configurationOf((Module)module) : null;
    }

    public void execute() {
        if (this.configuration == null) {
            return;
        }
        Frame frame = new Frame(new String[0]).addTypes(new String[]{"main"}).addSlot("package", new String[]{this.packageName}).addSlot("name", new String[]{this.name()});
        if (!Commons.javaFile(this.destination, "Main").exists()) {
            Commons.writeFrame(this.destination, "Main", this.template().format((Object)frame));
        }
    }

    private Template template() {
        return Formatters.customize(MainTemplate.create());
    }

    private String name() {
        if (this.module != null) {
            String dsl = this.configuration.outDSL();
            if (dsl == null || dsl.isEmpty()) {
                return this.module.getName();
            }
            return dsl;
        }
        return "System";
    }
}

