/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration;

import com.intellij.openapi.module.Module;
import io.intino.konos.builder.utils.GraphLoader;
import io.intino.konos.model.graph.Activity;
import io.intino.konos.model.graph.DataLake;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.Service;
import io.intino.tara.compiler.shared.Configuration;
import io.intino.tara.plugin.lang.psi.impl.TaraUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class PackageParameterUpdater {
    private Map<String, List<String>> staticParams = new HashMap<String, List<String>>();
    private Module module;
    private KonosGraph graph;

    public PackageParameterUpdater(Module module) {
        this.module = module;
        this.graph = GraphLoader.loadGraph(module);
        this.staticParams.put("activity", Arrays.asList("port", "webDirectory"));
        this.staticParams.put("datalake", Arrays.asList("workingDirectory", "nessieToken"));
        this.staticParams.put("rest", Arrays.asList("port", "webDirectory"));
        this.staticParams.put("jms", Arrays.asList("url", "user", "password"));
        this.staticParams.put("slack", Arrays.asList("token"));
        this.staticParams.put("jmx", Arrays.asList("port"));
    }

    public void execute() {
        ArrayList<String> parameters = new ArrayList<String>();
        for (Service service : this.graph.serviceList()) {
            if (service.isREST()) {
                parameters.addAll(this.wrap(service.name$(), (Collection<String>)this.staticParams.get("rest")));
                parameters.addAll(this.wrap(service.name$(), this.graph.findCustomParameters(service.asREST())));
                continue;
            }
            if (!service.isJMS()) continue;
            parameters.addAll(this.wrap(service.name$(), (Collection<String>)this.staticParams.get("jms")));
            parameters.addAll(this.wrap(service.name$(), this.graph.findCustomParameters(service.asJMS())));
        }
        if (this.graph.dataLake() != null) {
            parameters.addAll(this.wrap(this.graph.dataLake().name$(), (Collection<String>)this.staticParams.get("datalake")));
            for (DataLake.Tank tank : this.graph.dataLake().tankList()) {
                parameters.addAll(this.wrap(this.graph.dataLake().name$(), this.graph.findCustomParameters(tank)));
            }
        }
        for (Activity activity : this.graph.activityList()) {
            parameters.addAll(this.wrap(activity.name$(), (Collection<String>)this.staticParams.get("activity")));
            parameters.addAll(this.wrap(activity.name$(), this.graph.findCustomParameters(activity)));
        }
        this.addParameterIfNotExist(parameters);
    }

    private List<String> wrap(String name, Collection<String> parameters) {
        return parameters.stream().map(p -> name + "_" + p).collect(Collectors.toList());
    }

    private void addParameterIfNotExist(List<String> parameters) {
        Configuration configuration = TaraUtil.configurationOf((Module)this.module);
        for (String string : parameters) {
        }
    }
}

