/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.actions;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import io.intino.konos.builder.actions.AccessorPomTemplate;
import io.intino.konos.builder.codegeneration.accessor.jms.JMSAccessorRenderer;
import io.intino.konos.builder.codegeneration.accessor.jmx.JMXAccessorRenderer;
import io.intino.konos.builder.codegeneration.accessor.rest.RESTAccessorRenderer;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.jms.JMSService;
import io.intino.konos.model.graph.jmx.JMXService;
import io.intino.konos.model.graph.rest.RESTService;
import io.intino.tara.compiler.shared.Configuration;
import io.intino.tara.plugin.actions.utils.FileSystemUtils;
import io.intino.tara.plugin.lang.psi.impl.TaraUtil;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.DefaultInvoker;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.InvocationResult;
import org.apache.maven.shared.invoker.Invoker;
import org.apache.maven.shared.invoker.MavenInvocationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenUtil;
import org.siani.itrules.Template;
import org.siani.itrules.model.AbstractFrame;
import org.siani.itrules.model.Frame;

class AccessorsPublisher {
    private static final Logger LOG = Logger.getInstance((String)"Publishing Accessor:");
    private static final String KONOS = "konos";
    private static final String ACCESSOR = "-accessor";
    private final Module module;
    private final KonosGraph graph;
    private final String generationPackage;
    private StringBuilder log = new StringBuilder();
    private File root;
    private Configuration configuration;

    AccessorsPublisher(Module module, KonosGraph graph, String generationPackage) {
        this.module = module;
        this.configuration = TaraUtil.configurationOf((Module)module);
        this.graph = graph;
        this.generationPackage = generationPackage;
        try {
            this.root = Files.createTempDirectory(KONOS, new FileAttribute[0]).toFile();
            FileSystemUtils.removeDir((File)this.root);
        }
        catch (IOException e) {
            this.root = null;
        }
    }

    void publish() {
        if (this.configuration == null) {
            return;
        }
        try {
            List<String> apps = this.createSources();
            if (apps.isEmpty()) {
                this.notify("No accessors found in module", NotificationType.INFORMATION);
                return;
            }
            if (this.configuration.distributionReleaseRepository() == null) {
                this.notify("There isn't distribution repository defined", NotificationType.ERROR);
                return;
            }
            this.mvn(this.configuration);
            this.notifySuccess(this.configuration, apps);
        }
        catch (IOException | MavenInvocationException e) {
            this.notifyError(e.getMessage());
            LOG.error(e.getMessage());
        }
    }

    private void mvn(Configuration conf) throws MavenInvocationException, IOException {
        File[] files = this.root.listFiles(File::isDirectory);
        for (File file : files != null ? files : new File[]{}) {
            File pom = this.createPom(file, conf.groupId(), file.getName() + ACCESSOR, conf.version());
            InvocationResult result = this.invoke(pom);
            if (result != null && result.getExitCode() != 0) {
                if (result.getExecutionException() != null) {
                    throw new IOException("Failed to publish accessor.", (Throwable)result.getExecutionException());
                }
                throw new IOException("Failed to publish accessor. Exit code: " + result.getExitCode());
            }
            if (result != null) continue;
            throw new IOException("Failed to publish accessor. Maven HOME not found");
        }
    }

    private InvocationResult invoke(File pom) throws MavenInvocationException, IOException {
        String ijMavenHome = MavenProjectsManager.getInstance((Project)this.module.getProject()).getGeneralSettings().getMavenHome();
        InvocationRequest request = new DefaultInvocationRequest().setPomFile(pom).setGoals(Arrays.asList("clean", "install", "deploy"));
        File mavenHome = MavenUtil.resolveMavenHomeDirectory((String)ijMavenHome);
        if (mavenHome == null) {
            return null;
        }
        LOG.info("Maven HOME: " + mavenHome.getAbsolutePath());
        Invoker invoker = new DefaultInvoker().setMavenHome(mavenHome);
        this.log(invoker);
        this.config(request, mavenHome);
        return invoker.execute(request);
    }

    private void log(Invoker invoker) throws IOException {
        invoker.setErrorHandler(arg_0 -> ((Logger)LOG).error(arg_0));
        invoker.setOutputHandler(line -> {
            System.out.println(line);
            if (line.contains("[ERROR]")) {
                this.log.append(line);
            }
        });
    }

    private void config(InvocationRequest request, File mavenHome) {
        File mvn = new File(mavenHome, "bin" + File.separator + "mvn");
        mvn.setExecutable(true);
        Sdk sdk = ModuleRootManager.getInstance((Module)this.module).getSdk();
        if (sdk != null && sdk.getHomePath() != null) {
            request.setJavaHome(new File(sdk.getHomePath()));
        }
    }

    private List<String> createSources() throws IOException {
        ArrayList<String> apps = new ArrayList<String>();
        if (this.graph == null) {
            return Collections.emptyList();
        }
        apps.addAll(this.rest());
        apps.addAll(this.jms());
        apps.addAll(this.jmx());
        return apps;
    }

    private List<String> jmx() {
        ArrayList<String> apps = new ArrayList<String>();
        for (JMXService service : this.graph.jMXServiceList()) {
            File sourcesDestiny = new File(new File(this.root, service.name$() + File.separator + "src"), this.generationPackage.replace(".", File.separator));
            sourcesDestiny.mkdirs();
            new JMXAccessorRenderer(service, sourcesDestiny, this.generationPackage).execute();
            apps.add(service.name$());
        }
        return apps;
    }

    private List<String> jms() {
        ArrayList<String> apps = new ArrayList<String>();
        for (JMSService service : this.graph.jMSServiceList()) {
            File sourcesDestiny = new File(new File(this.root, service.name$() + File.separator + "src"), this.generationPackage.replace(".", File.separator));
            sourcesDestiny.mkdirs();
            new JMSAccessorRenderer(service, sourcesDestiny, this.generationPackage).execute();
            apps.add(service.name$());
        }
        return apps;
    }

    private List<String> rest() {
        ArrayList<String> apps = new ArrayList<String>();
        for (RESTService service : this.graph.rESTServiceList()) {
            File sourcesDestiny = new File(new File(this.root, service.name$() + File.separator + "src"), this.generationPackage.replace(".", File.separator));
            sourcesDestiny.mkdirs();
            new RESTAccessorRenderer(service, sourcesDestiny, this.generationPackage).execute();
            apps.add(service.name$());
        }
        return apps;
    }

    private File createPom(File root, String group, String artifact, String version) throws IOException {
        Frame frame = new Frame(new String[0]).addTypes(new String[]{"pom"}).addSlot("group", new String[]{group}).addSlot("artifact", new String[]{artifact}).addSlot("version", new String[]{version});
        this.configuration.releaseRepositories().forEach((u, i) -> frame.addSlot("repository", new AbstractFrame[]{this.createRepositoryFrame((String)u, (String)i, "release")}));
        AbstractMap.SimpleEntry distroRepo = this.configuration.distributionReleaseRepository();
        frame.addSlot("repository", new AbstractFrame[]{this.createRepositoryFrame((String)distroRepo.getKey(), (String)distroRepo.getValue(), "distribution")});
        Template template = AccessorPomTemplate.create();
        File pomFile = new File(root, "pom.xml");
        Files.write(pomFile.toPath(), template.format((Object)frame).getBytes(), new OpenOption[0]);
        return pomFile;
    }

    private Frame createRepositoryFrame(String url, String id, String type) {
        return new Frame(new String[0]).addTypes(new String[]{"repository", "release", type}).addSlot("name", new String[]{id}).addSlot("random", new Integer[]{new Random().nextInt(10)}).addSlot("url", new String[]{url}).addSlot("type", new Integer[]{new Random().nextInt() % 10});
    }

    private void notifySuccess(Configuration conf, List<String> apps) {
        NotificationGroup balloon = NotificationGroup.toolWindowGroup((String)"Tara Language", (String)"Balloon");
        for (String app : apps) {
            balloon.createNotification("Accessors generated and uploaded", this.message(), NotificationType.INFORMATION, (n, e) -> {
                StringSelection selection = new StringSelection(this.newDependency(conf, app));
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(selection, selection);
            }).setImportant(true).notify(this.module.getProject());
        }
    }

    private void notify(String message, NotificationType type) {
        Notifications.Bus.notify((Notification)new Notification("Konos", message, this.module.getName(), type), (Project)this.module.getProject());
    }

    @NotNull
    private String message() {
        if ("<a href=\"#\">Copy maven dependency</a>" == null) {
            AccessorsPublisher.$$$reportNull$$$0(0);
        }
        return "<a href=\"#\">Copy maven dependency</a>";
    }

    @NotNull
    private String newDependency(Configuration conf, String app) {
        String string = "<dependency>\n    <groupId>" + conf.groupId().toLowerCase() + "</groupId>\n    <artifactId>" + app.toLowerCase() + ACCESSOR + "</artifactId>\n    <version>" + conf.version() + "</version>\n</dependency>";
        if (string == null) {
            AccessorsPublisher.$$$reportNull$$$0(1);
        }
        return string;
    }

    private void notifyError(String message) {
        String result = this.log.toString();
        Notifications.Bus.notify((Notification)new Notification("Konos", "Accessor cannot be published. ", message + "\n" + result, NotificationType.ERROR), (Project)this.module.getProject());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "io/intino/konos/builder/actions/AccessorsPublisher";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "message";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "newDependency";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

