/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.datalake;

import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.datalake.GraphProviderTemplate;
import io.intino.konos.builder.codegeneration.datalake.NessJMXOperationsTemplate;
import io.intino.konos.builder.helpers.Commons;
import java.io.File;
import org.siani.itrules.Template;
import org.siani.itrules.model.Frame;

public class NessJMXOperationsRenderer {
    private final File gen;
    private File src;
    private final String packageName;
    private final String boxName;

    public NessJMXOperationsRenderer(File gen, File src, String packageName, String boxName) {
        this.gen = gen;
        this.src = src;
        this.packageName = packageName;
        this.boxName = boxName;
    }

    public void execute() {
        Frame frame = new Frame(new String[]{"operations"}).addSlot("package", new String[]{this.packageName}).addSlot("box", new String[]{this.boxName});
        Commons.writeFrame(new File(this.gen, "ness"), "NessOperations", this.operationsTemplate().format((Object)frame));
        Commons.writeFrame(new File(this.gen, "ness"), "NessOperationsMBean", this.operationsTemplate().format((Object)frame.addTypes(new String[]{"interface"})));
        Commons.writeFrame(new File(this.src, "ness"), "GraphProvider", this.providerTemplate().format((Object)frame));
    }

    private Template operationsTemplate() {
        return Formatters.customize(NessJMXOperationsTemplate.create());
    }

    private Template providerTemplate() {
        return Formatters.customize(GraphProviderTemplate.create());
    }
}

