/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.swagger;

import io.intino.konos.builder.codegeneration.swagger.OpenApiDescriptor;
import io.intino.konos.model.rest.RESTService;
import io.swagger.codegen.Codegen;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;

public class SwaggerGenerator {
    private final List<RESTService> services;
    private final File outDirectory;

    public SwaggerGenerator(List<RESTService> services, File outDirectory) {
        this.services = services;
        this.outDirectory = outDirectory;
        this.outDirectory.mkdirs();
    }

    public void execute() {
        for (RESTService service : this.services) {
            String jsonFilePath = this.writeFile(new OpenApiDescriptor(service).createJSONDescriptor());
            File serviceDirectory = new File(this.outDirectory, service.name().toLowerCase());
            Codegen.main((String[])new String[]{"generate", "-i", jsonFilePath, "-o", serviceDirectory.getPath(), "-l", "io.swagger.codegen.languages.StaticDocCodegen"});
            new File(serviceDirectory, "main.js").delete();
            new File(serviceDirectory, "package.json").delete();
            new File(jsonFilePath).delete();
        }
    }

    private String writeFile(String json) {
        try {
            return Files.write(Files.createTempFile("__swagger", ".json", new FileAttribute[0]), json.getBytes(), new OpenOption[0]).toFile().getPath();
        }
        catch (IOException ignored) {
            return "";
        }
    }
}

