/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.services.jmx;

import cottons.utils.StringHelper;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.services.jmx.JMXServerTemplate;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.jmx.JMXService;
import io.intino.tara.magritte.Graph;
import java.io.File;
import java.util.List;
import org.siani.itrules.Template;
import org.siani.itrules.model.Frame;

public class JMXServerRenderer {
    private final List<JMXService> jmxServices;
    private final File destination;
    private final String packageName;
    private final String boxName;

    public JMXServerRenderer(Graph graph, File destination, String packageName, String boxName) {
        this.jmxServices = graph.find(JMXService.class);
        this.destination = destination;
        this.packageName = packageName;
        this.boxName = boxName;
    }

    public void execute() {
        this.jmxServices.forEach(this::processService);
    }

    private void processService(JMXService service) {
        List<JMXService.Operation> operations = service.operationList();
        if (operations.isEmpty()) {
            return;
        }
        Frame frame = new Frame().addTypes(new String[]{"jmxserver"});
        frame.addSlot("name", new String[]{service.name()});
        frame.addSlot("box", new String[]{this.boxName});
        frame.addSlot("package", new String[]{this.packageName});
        Commons.writeFrame(this.destination, "JMX" + StringHelper.snakeCaseToCamelCase((String)service.name()), this.template().format((Object)frame));
    }

    private Template template() {
        return Formatters.customize(JMXServerTemplate.create());
    }
}

