/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.model.jmx;

import io.intino.konos.model.Exception;
import io.intino.konos.model.Konos;
import io.intino.konos.model.Parameter;
import io.intino.konos.model.Response;
import io.intino.konos.model.Schema;
import io.intino.konos.model.Service;
import io.intino.konos.model.rules.ExceptionCodes;
import io.intino.tara.magritte.Concept;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.Node;
import io.intino.tara.magritte.loaders.StringLoader;
import io.intino.tara.magritte.tags.Terminal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class JMXService
extends Layer
implements Terminal {
    protected String path;
    protected List<Operation> operationList = new ArrayList<Operation>();
    protected List<Notification> notificationList = new ArrayList<Notification>();
    protected Service _service;

    public JMXService(Node node) {
        super(node);
    }

    public String path() {
        return this.path;
    }

    public void path(String value) {
        this.path = value;
    }

    public List<Operation> operationList() {
        return Collections.unmodifiableList(this.operationList);
    }

    public Operation operation(int index) {
        return this.operationList.get(index);
    }

    public List<Operation> operationList(Predicate<Operation> predicate) {
        return this.operationList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<Notification> notificationList() {
        return Collections.unmodifiableList(this.notificationList);
    }

    public Notification notification(int index) {
        return this.notificationList.get(index);
    }

    public List<Notification> notificationList(Predicate<Notification> predicate) {
        return this.notificationList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<Schema> schemaList() {
        return this._service.schemaList();
    }

    public Schema schemaList(int index) {
        return this._service.schemaList().get(index);
    }

    public List<Exception> exceptionList() {
        return this._service.exceptionList();
    }

    public Exception exceptionList(int index) {
        return this._service.exceptionList().get(index);
    }

    public List<Node> componentList() {
        LinkedHashSet components = new LinkedHashSet(super.componentList());
        this.operationList.stream().forEach(c -> components.add(c.node()));
        this.notificationList.stream().forEach(c -> components.add(c.node()));
        return new ArrayList<Node>(components);
    }

    public Map<String, List<?>> variables() {
        LinkedHashMap map = new LinkedHashMap();
        map.put("path", new ArrayList<String>(Collections.singletonList(this.path)));
        return map;
    }

    public Concept concept() {
        return this.graph().concept(Service.class);
    }

    protected void addNode(Node node) {
        super.addNode(node);
        if (node.is("JMX#Service$Operation")) {
            this.operationList.add((Operation)node.as(Operation.class));
        }
        if (node.is("JMX#Service$Notification")) {
            this.notificationList.add((Notification)node.as(Notification.class));
        }
    }

    protected void removeNode(Node node) {
        super.removeNode(node);
        if (node.is("JMX#Service$Operation")) {
            this.operationList.remove(node.as(Operation.class));
        }
        if (node.is("JMX#Service$Notification")) {
            this.notificationList.remove(node.as(Notification.class));
        }
    }

    protected void _load(String name, List<?> values) {
        super._load(name, values);
        if (name.equalsIgnoreCase("path")) {
            this.path = (String)StringLoader.load(values, (Layer)this).get(0);
        }
    }

    protected void _set(String name, List<?> values) {
        super._set(name, values);
        if (name.equalsIgnoreCase("path")) {
            this.path = (String)values.get(0);
        }
    }

    protected void _sync(Layer layer) {
        super._sync(layer);
        if (layer instanceof Service) {
            this._service = (Service)layer;
        }
    }

    public Create create() {
        return new Create(null);
    }

    public Create create(String name) {
        return new Create(name);
    }

    public Konos konosWrapper() {
        return (Konos)this.graph().wrapper(Konos.class);
    }

    public static class Notification
    extends Layer
    implements Terminal {
        public Notification(Node node) {
            super(node);
        }

        public Map<String, List<?>> variables() {
            LinkedHashMap map = new LinkedHashMap();
            return map;
        }

        public Concept concept() {
            return this.graph().concept(Notification.class);
        }

        protected void _load(String name, List<?> values) {
            super._load(name, values);
        }

        protected void _set(String name, List<?> values) {
            super._set(name, values);
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Konos konosWrapper() {
            return (Konos)this.graph().wrapper(Konos.class);
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }
        }
    }

    public static class Operation
    extends Layer
    implements Terminal {
        protected String description;
        protected List<Parameter> parameterList = new ArrayList<Parameter>();
        protected List<Exception> exceptionList = new ArrayList<Exception>();
        protected Response response;

        public Operation(Node node) {
            super(node);
        }

        public String description() {
            return this.description;
        }

        public void description(String value) {
            this.description = value;
        }

        public List<Parameter> parameterList() {
            return Collections.unmodifiableList(this.parameterList);
        }

        public Parameter parameter(int index) {
            return this.parameterList.get(index);
        }

        public List<Parameter> parameterList(Predicate<Parameter> predicate) {
            return this.parameterList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<Exception> exceptionList() {
            return Collections.unmodifiableList(this.exceptionList);
        }

        public Exception exception(int index) {
            return this.exceptionList.get(index);
        }

        public List<Exception> exceptionList(Predicate<Exception> predicate) {
            return this.exceptionList().stream().filter(predicate).collect(Collectors.toList());
        }

        public Response response() {
            return this.response;
        }

        public void response(Response value) {
            this.response = value;
        }

        public List<Node> componentList() {
            LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList());
            this.parameterList.stream().forEach(c -> components.add(c.node()));
            this.exceptionList.stream().forEach(c -> components.add(c.node()));
            if (this.response != null) {
                components.add(this.response.node());
            }
            return new ArrayList<Node>(components);
        }

        public Map<String, List<?>> variables() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("description", new ArrayList<String>(Collections.singletonList(this.description)));
            return map;
        }

        public Concept concept() {
            return this.graph().concept(Operation.class);
        }

        protected void addNode(Node node) {
            super.addNode(node);
            if (node.is("Parameter")) {
                this.parameterList.add((Parameter)node.as(Parameter.class));
            }
            if (node.is("Exception")) {
                this.exceptionList.add((Exception)node.as(Exception.class));
            }
            if (node.is("Response")) {
                this.response = (Response)node.as(Response.class);
            }
        }

        protected void removeNode(Node node) {
            super.removeNode(node);
            if (node.is("Parameter")) {
                this.parameterList.remove(node.as(Parameter.class));
            }
            if (node.is("Exception")) {
                this.exceptionList.remove(node.as(Exception.class));
            }
            if (node.is("Response")) {
                this.response = null;
            }
        }

        protected void _load(String name, List<?> values) {
            super._load(name, values);
            if (name.equalsIgnoreCase("description")) {
                this.description = (String)StringLoader.load(values, (Layer)this).get(0);
            }
        }

        protected void _set(String name, List<?> values) {
            super._set(name, values);
            if (name.equalsIgnoreCase("description")) {
                this.description = (String)values.get(0);
            }
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Konos konosWrapper() {
            return (Konos)this.graph().wrapper(Konos.class);
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }

            public Parameter parameter() {
                Parameter newElement = (Parameter)Operation.this.graph().concept(Parameter.class).createNode(this.name, Operation.this.node()).as(Parameter.class);
                return newElement;
            }

            public Exception exception(ExceptionCodes code) {
                Exception newElement = (Exception)Operation.this.graph().concept(Exception.class).createNode(this.name, Operation.this.node()).as(Exception.class);
                newElement.node().set((Layer)newElement, "code", Collections.singletonList(code));
                return newElement;
            }

            public Response response() {
                Response newElement = (Response)Operation.this.graph().concept(Response.class).createNode(this.name, Operation.this.node()).as(Response.class);
                return newElement;
            }
        }
    }

    public class Create {
        protected final String name;

        public Create(String name) {
            this.name = name;
        }

        public Operation operation(String description) {
            Operation newElement = (Operation)JMXService.this.graph().concept(Operation.class).createNode(this.name, JMXService.this.node()).as(Operation.class);
            newElement.node().set((Layer)newElement, "description", Collections.singletonList(description));
            return newElement;
        }

        public Notification notification() {
            Notification newElement = (Notification)JMXService.this.graph().concept(Notification.class).createNode(this.name, JMXService.this.node()).as(Notification.class);
            return newElement;
        }

        public Schema schema() {
            Schema newElement = (Schema)JMXService.this.graph().concept(Schema.class).createNode(this.name, JMXService.this.node()).as(Schema.class);
            return newElement;
        }

        public Exception exception(ExceptionCodes code) {
            Exception newElement = (Exception)JMXService.this.graph().concept(Exception.class).createNode(this.name, JMXService.this.node()).as(Exception.class);
            newElement.node().set((Layer)newElement, "code", Collections.singletonList(code));
            return newElement;
        }
    }
}

