/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.model;

import io.intino.konos.model.Component;
import io.intino.konos.model.Konos;
import io.intino.konos.model.restricted.activity.RestrictedAbstractPage;
import io.intino.tara.magritte.Concept;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.Node;
import io.intino.tara.magritte.loaders.NodeLoader;
import io.intino.tara.magritte.loaders.StringLoader;
import io.intino.tara.magritte.loaders.WordLoader;
import io.intino.tara.magritte.tags.Terminal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class Activity
extends Layer
implements Terminal {
    protected Type type;
    protected Authenticated authenticated;
    protected List<AbstractPage> abstractPageList = new ArrayList<AbstractPage>();
    protected Home home;
    protected List<Page> pageList = new ArrayList<Page>();

    public Activity(Node node) {
        super(node);
    }

    public Type type() {
        return this.type;
    }

    public void type(Type value) {
        this.type = value;
    }

    public Authenticated authenticated() {
        return this.authenticated;
    }

    public List<AbstractPage> abstractPageList() {
        return Collections.unmodifiableList(this.abstractPageList);
    }

    public AbstractPage abstractPage(int index) {
        return this.abstractPageList.get(index);
    }

    public List<AbstractPage> abstractPageList(Predicate<AbstractPage> predicate) {
        return this.abstractPageList().stream().filter(predicate).collect(Collectors.toList());
    }

    public Home home() {
        return this.home;
    }

    public List<Page> pageList() {
        return Collections.unmodifiableList(this.pageList);
    }

    public Page page(int index) {
        return this.pageList.get(index);
    }

    public List<Page> pageList(Predicate<Page> predicate) {
        return this.pageList().stream().filter(predicate).collect(Collectors.toList());
    }

    public void authenticated(Authenticated value) {
        this.authenticated = value;
    }

    public void home(Home value) {
        this.home = value;
    }

    public List<Node> componentList() {
        LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList());
        if (this.authenticated != null) {
            components.add(this.authenticated.node());
        }
        this.abstractPageList.stream().forEach(c -> components.add(c.node()));
        if (this.home != null) {
            components.add(this.home.node());
        }
        this.pageList.stream().forEach(c -> components.add(c.node()));
        return new ArrayList<Node>(components);
    }

    public Map<String, List<?>> variables() {
        LinkedHashMap map = new LinkedHashMap();
        map.put("type", new ArrayList<Type>(Collections.singletonList(this.type)));
        return map;
    }

    public Concept concept() {
        return this.graph().concept(Activity.class);
    }

    protected void addNode(Node node) {
        super.addNode(node);
        if (node.is("Activity$Authenticated")) {
            this.authenticated = (Authenticated)node.as(Authenticated.class);
        }
        if (node.is("Activity$AbstractPage")) {
            this.abstractPageList.add((AbstractPage)node.as(AbstractPage.class));
        }
        if (node.is("Activity$Home")) {
            this.home = (Home)node.as(Home.class);
        }
        if (node.is("Activity$Page")) {
            this.pageList.add((Page)node.as(Page.class));
        }
    }

    protected void removeNode(Node node) {
        super.removeNode(node);
        if (node.is("Activity$Authenticated")) {
            this.authenticated = null;
        }
        if (node.is("Activity$AbstractPage")) {
            this.abstractPageList.remove(node.as(AbstractPage.class));
        }
        if (node.is("Activity$Home")) {
            this.home = null;
        }
        if (node.is("Activity$Page")) {
            this.pageList.remove(node.as(Page.class));
        }
    }

    protected void _load(String name, List<?> values) {
        super._load(name, values);
        if (name.equalsIgnoreCase("type")) {
            this.type = (Type)((Object)WordLoader.load(values, Type.class, (Layer)this).get(0));
        }
    }

    protected void _set(String name, List<?> values) {
        super._set(name, values);
        if (name.equalsIgnoreCase("type")) {
            this.type = (Type)((Object)values.get(0));
        }
    }

    public Create create() {
        return new Create(null);
    }

    public Create create(String name) {
        return new Create(name);
    }

    public Konos konosWrapper() {
        return (Konos)this.graph().wrapper(Konos.class);
    }

    public static class Page
    extends AbstractPage
    implements Terminal {
        public Page(Node node) {
            super(node);
        }

        @Override
        public RestrictedAbstractPage asRestricted() {
            Layer as = this.as(RestrictedAbstractPage.class);
            return as != null ? (RestrictedAbstractPage)as : (RestrictedAbstractPage)this.addFacet(RestrictedAbstractPage.class);
        }

        @Override
        public boolean isRestricted() {
            return this.is(RestrictedAbstractPage.class);
        }

        @Override
        public Map<String, List<?>> variables() {
            LinkedHashMap map = new LinkedHashMap(super.variables());
            return map;
        }

        @Override
        public Concept concept() {
            return this.graph().concept(Page.class);
        }

        @Override
        protected void _load(String name, List<?> values) {
            super._load(name, values);
        }

        @Override
        protected void _set(String name, List<?> values) {
            super._set(name, values);
        }

        @Override
        public Create create() {
            return new Create(null);
        }

        @Override
        public Create create(String name) {
            return new Create(name);
        }

        @Override
        public Konos konosWrapper() {
            return (Konos)this.graph().wrapper(Konos.class);
        }

        public class Create
        extends AbstractPage.Create {
            public Create(String name) {
                super(name);
            }
        }
    }

    public static class Home
    extends AbstractPage
    implements Terminal {
        public Home(Node node) {
            super(node);
        }

        @Override
        public RestrictedAbstractPage asRestricted() {
            Layer as = this.as(RestrictedAbstractPage.class);
            return as != null ? (RestrictedAbstractPage)as : (RestrictedAbstractPage)this.addFacet(RestrictedAbstractPage.class);
        }

        @Override
        public boolean isRestricted() {
            return this.is(RestrictedAbstractPage.class);
        }

        @Override
        public Map<String, List<?>> variables() {
            LinkedHashMap map = new LinkedHashMap(super.variables());
            return map;
        }

        @Override
        public Concept concept() {
            return this.graph().concept(Home.class);
        }

        @Override
        protected void _load(String name, List<?> values) {
            super._load(name, values);
        }

        @Override
        protected void _set(String name, List<?> values) {
            super._set(name, values);
        }

        @Override
        public Create create() {
            return new Create(null);
        }

        @Override
        public Create create(String name) {
            return new Create(name);
        }

        @Override
        public Konos konosWrapper() {
            return (Konos)this.graph().wrapper(Konos.class);
        }

        public class Create
        extends AbstractPage.Create {
            public Create(String name) {
                super(name);
            }
        }
    }

    public static abstract class AbstractPage
    extends Layer
    implements Terminal {
        protected Component uses;
        protected List<String> paths = new ArrayList<String>();

        public AbstractPage(Node node) {
            super(node);
        }

        public Component uses() {
            return this.uses;
        }

        public List<String> paths() {
            return this.paths;
        }

        public String paths(int index) {
            return this.paths.get(index);
        }

        public List<String> paths(Predicate<String> predicate) {
            return this.paths().stream().filter(predicate).collect(Collectors.toList());
        }

        public void uses(Component value) {
            this.uses = value;
        }

        public RestrictedAbstractPage asRestricted() {
            Layer as = this.as(RestrictedAbstractPage.class);
            return as != null ? (RestrictedAbstractPage)as : (RestrictedAbstractPage)this.addFacet(RestrictedAbstractPage.class);
        }

        public boolean isRestricted() {
            return this.is(RestrictedAbstractPage.class);
        }

        public Map<String, List<?>> variables() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("uses", this.uses != null ? new ArrayList<Component>(Collections.singletonList(this.uses)) : Collections.emptyList());
            map.put("paths", this.paths);
            return map;
        }

        public Concept concept() {
            return this.graph().concept(AbstractPage.class);
        }

        protected void _load(String name, List<?> values) {
            super._load(name, values);
            if (name.equalsIgnoreCase("uses")) {
                this.uses = (Component)((Object)NodeLoader.load(values, Component.class, (Layer)this).get(0));
            } else if (name.equalsIgnoreCase("paths")) {
                this.paths = StringLoader.load(values, (Layer)this);
            }
        }

        protected void _set(String name, List<?> values) {
            super._set(name, values);
            if (name.equalsIgnoreCase("uses")) {
                this.uses = values.get(0) != null ? (Component)this.graph().loadNode(((Layer)values.get(0)).id()).as(Component.class) : null;
            } else if (name.equalsIgnoreCase("paths")) {
                this.paths = new ArrayList(values);
            }
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Konos konosWrapper() {
            return (Konos)this.graph().wrapper(Konos.class);
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }
        }
    }

    public static class Authenticated
    extends Layer
    implements Terminal {
        protected String by;

        public Authenticated(Node node) {
            super(node);
        }

        public String by() {
            return this.by;
        }

        public void by(String value) {
            this.by = value;
        }

        public Map<String, List<?>> variables() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("by", new ArrayList<String>(Collections.singletonList(this.by)));
            return map;
        }

        public Concept concept() {
            return this.graph().concept(Authenticated.class);
        }

        protected void _load(String name, List<?> values) {
            super._load(name, values);
            if (name.equalsIgnoreCase("by")) {
                this.by = (String)StringLoader.load(values, (Layer)this).get(0);
            }
        }

        protected void _set(String name, List<?> values) {
            super._set(name, values);
            if (name.equalsIgnoreCase("by")) {
                this.by = (String)values.get(0);
            }
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Konos konosWrapper() {
            return (Konos)this.graph().wrapper(Konos.class);
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }
        }
    }

    public class Create {
        protected final String name;

        public Create(String name) {
            this.name = name;
        }

        public Authenticated authenticated(String by) {
            Authenticated newElement = (Authenticated)Activity.this.graph().concept(Authenticated.class).createNode(this.name, Activity.this.node()).as(Authenticated.class);
            newElement.node().set((Layer)newElement, "by", Collections.singletonList(by));
            return newElement;
        }

        public Home home(Component uses) {
            Home newElement = (Home)Activity.this.graph().concept(Home.class).createNode(this.name, Activity.this.node()).as(Home.class);
            newElement.node().set((Layer)newElement, "uses", Collections.singletonList(uses));
            return newElement;
        }

        public Page page(Component uses, List<String> paths) {
            Page newElement = (Page)Activity.this.graph().concept(Page.class).createNode(this.name, Activity.this.node()).as(Page.class);
            newElement.node().set((Layer)newElement, "uses", Collections.singletonList(uses));
            newElement.node().set((Layer)newElement, "paths", paths);
            return newElement;
        }
    }

    public static enum Type {
        Ajax;

    }
}

