/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.datalake;

import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.datalake.MessageHandlerTemplate;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.DataLake;
import io.intino.tara.magritte.Graph;
import java.io.File;
import java.util.List;
import org.siani.itrules.model.Frame;

public class MessageHandlerRenderer {
    private final List<DataLake.Tank> eventHandlers;
    private final File src;
    private final String packageName;
    private final String boxName;

    public MessageHandlerRenderer(Graph graph, File src, String packageName, String boxName) {
        this.eventHandlers = graph.find(DataLake.Tank.class);
        this.src = src;
        this.packageName = packageName;
        this.boxName = boxName;
    }

    public void execute() {
        for (DataLake.Tank eventHandler : this.eventHandlers) {
            Frame frame = new Frame().addTypes(new String[]{"messageHandler"}).addSlot("box", new String[]{this.boxName}).addSlot("package", new String[]{this.packageName}).addSlot("name", new String[]{eventHandler.name()});
            File destination = new File(this.src, "messagehandlers");
            String name = Formatters.firstUpperCase(eventHandler.name()) + "MessageHandler";
            if (this.alreadyRendered(destination, name)) continue;
            Commons.writeFrame(destination, name, Formatters.customize(MessageHandlerTemplate.create()).format((Object)frame));
        }
    }

    private boolean alreadyRendered(File destination, String action) {
        return Commons.javaFile(destination, action).exists();
    }
}

