/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.model;

import io.intino.konos.model.Activity;
import io.intino.konos.model.Component;
import io.intino.konos.model.DataLake;
import io.intino.konos.model.Dialog;
import io.intino.konos.model.Display;
import io.intino.konos.model.GraphWrapper;
import io.intino.konos.model.jms.JMSService;
import io.intino.konos.model.rest.RESTService;
import io.intino.tara.magritte.Graph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class Konos
extends GraphWrapper {
    public Konos(Graph graph) {
        super(graph);
    }

    public static List<Display> displaysOf(Activity activity) {
        return activity.abstractPageList().stream().filter(page -> page.uses().is(Display.class)).map(page -> (Display)page.uses().as(Display.class)).map(Konos::allDisplays).flatMap(Collection::stream).distinct().collect(Collectors.toList());
    }

    public static List<Dialog> dialogsOf(Activity activity) {
        return activity.abstractPageList().stream().filter(page -> page.uses().is(Dialog.class)).map(page -> (Dialog)page.uses().as(Dialog.class)).collect(Collectors.toList());
    }

    public static List<Component> componentsOf(Activity activity) {
        ArrayList<Component> components = new ArrayList<Component>();
        components.addAll(Konos.dialogsOf(activity));
        components.addAll(Konos.displaysOf(activity));
        return components;
    }

    private static HashSet<Display> allDisplays(Display d) {
        HashSet<Display> displays = new HashSet<Display>();
        Konos.displaysOf(d, displays);
        return displays;
    }

    private static void displaysOf(Display display, Set<Display> collection) {
        if (collection.add(display)) {
            display.displays().forEach(child -> Konos.displaysOf(child, collection));
        }
    }

    public Set<String> findCustomParameters(DataLake.Tank channel) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        set.addAll(Konos.extractParameters(channel.topic()));
        return set;
    }

    public Set<String> findCustomParameters(JMSService service) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (JMSService.Request request : service.requestList()) {
            set.addAll(Konos.extractParameters(request.path()));
        }
        return set;
    }

    public Set<String> findCustomParameters(RESTService service) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (RESTService.Resource resource : service.resourceList()) {
            set.addAll(Konos.extractParameters(resource.path()));
        }
        return set;
    }

    public Set<String> findCustomParameters(Activity activity) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        if (activity.authenticated() != null) {
            set.addAll(Konos.extractParameters(activity.authenticated().by()));
        }
        for (Activity.AbstractPage page : activity.abstractPageList()) {
            for (String path : page.paths()) {
                set.addAll(Konos.extractParameters(path));
            }
        }
        return set;
    }

    private static Set<String> extractParameters(String text) {
        LinkedHashSet<String> list = new LinkedHashSet<String>();
        Pattern pattern = Pattern.compile("\\{([^\\}]*)\\}");
        Matcher matcher = pattern.matcher(text);
        while (matcher.find()) {
            list.add(matcher.group(1));
        }
        return list;
    }
}

