/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.model;

import io.intino.konos.model.Konos;
import io.intino.tara.magritte.Concept;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.Node;
import io.intino.tara.magritte.loaders.StringLoader;
import io.intino.tara.magritte.tags.Terminal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class DataLake
extends Layer
implements Terminal {
    protected String clientID;
    protected List<Tank> tankList = new ArrayList<Tank>();
    protected List<Pipe> pipeList = new ArrayList<Pipe>();
    protected List<MailPipe> mailPipeList = new ArrayList<MailPipe>();
    protected List<PostPipe> postPipeList = new ArrayList<PostPipe>();

    public DataLake(Node node) {
        super(node);
    }

    public String clientID() {
        return this.clientID;
    }

    public void clientID(String value) {
        this.clientID = value;
    }

    public List<Tank> tankList() {
        return Collections.unmodifiableList(this.tankList);
    }

    public Tank tank(int index) {
        return this.tankList.get(index);
    }

    public List<Tank> tankList(Predicate<Tank> predicate) {
        return this.tankList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<Pipe> pipeList() {
        return Collections.unmodifiableList(this.pipeList);
    }

    public Pipe pipe(int index) {
        return this.pipeList.get(index);
    }

    public List<Pipe> pipeList(Predicate<Pipe> predicate) {
        return this.pipeList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<MailPipe> mailPipeList() {
        return Collections.unmodifiableList(this.mailPipeList);
    }

    public MailPipe mailPipe(int index) {
        return this.mailPipeList.get(index);
    }

    public List<MailPipe> mailPipeList(Predicate<MailPipe> predicate) {
        return this.mailPipeList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<PostPipe> postPipeList() {
        return Collections.unmodifiableList(this.postPipeList);
    }

    public PostPipe postPipe(int index) {
        return this.postPipeList.get(index);
    }

    public List<PostPipe> postPipeList(Predicate<PostPipe> predicate) {
        return this.postPipeList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<Node> componentList() {
        LinkedHashSet components = new LinkedHashSet(super.componentList());
        this.tankList.stream().forEach(c -> components.add(c.node()));
        this.pipeList.stream().forEach(c -> components.add(c.node()));
        this.mailPipeList.stream().forEach(c -> components.add(c.node()));
        this.postPipeList.stream().forEach(c -> components.add(c.node()));
        return new ArrayList<Node>(components);
    }

    public Map<String, List<?>> variables() {
        LinkedHashMap map = new LinkedHashMap();
        map.put("clientID", new ArrayList<String>(Collections.singletonList(this.clientID)));
        return map;
    }

    public Concept concept() {
        return this.graph().concept(DataLake.class);
    }

    protected void addNode(Node node) {
        super.addNode(node);
        if (node.is("DataLake$Tank")) {
            this.tankList.add((Tank)node.as(Tank.class));
        }
        if (node.is("DataLake$Pipe")) {
            this.pipeList.add((Pipe)node.as(Pipe.class));
        }
        if (node.is("DataLake$MailPipe")) {
            this.mailPipeList.add((MailPipe)node.as(MailPipe.class));
        }
        if (node.is("DataLake$PostPipe")) {
            this.postPipeList.add((PostPipe)node.as(PostPipe.class));
        }
    }

    protected void removeNode(Node node) {
        super.removeNode(node);
        if (node.is("DataLake$Tank")) {
            this.tankList.remove(node.as(Tank.class));
        }
        if (node.is("DataLake$Pipe")) {
            this.pipeList.remove(node.as(Pipe.class));
        }
        if (node.is("DataLake$MailPipe")) {
            this.mailPipeList.remove(node.as(MailPipe.class));
        }
        if (node.is("DataLake$PostPipe")) {
            this.postPipeList.remove(node.as(PostPipe.class));
        }
    }

    protected void _load(String name, List<?> values) {
        super._load(name, values);
        if (name.equalsIgnoreCase("clientID")) {
            this.clientID = (String)StringLoader.load(values, (Layer)this).get(0);
        }
    }

    protected void _set(String name, List<?> values) {
        super._set(name, values);
        if (name.equalsIgnoreCase("clientID")) {
            this.clientID = (String)values.get(0);
        }
    }

    public Create create() {
        return new Create(null);
    }

    public Create create(String name) {
        return new Create(name);
    }

    public Konos konosWrapper() {
        return (Konos)this.graph().wrapper(Konos.class);
    }

    public static class PostPipe
    extends Pipe
    implements Terminal {
        public PostPipe(Node node) {
            super(node);
        }

        @Override
        public Map<String, List<?>> variables() {
            LinkedHashMap map = new LinkedHashMap(super.variables());
            return map;
        }

        @Override
        public Concept concept() {
            return this.graph().concept(PostPipe.class);
        }

        @Override
        protected void _load(String name, List<?> values) {
            super._load(name, values);
        }

        @Override
        protected void _set(String name, List<?> values) {
            super._set(name, values);
        }

        @Override
        public Create create() {
            return new Create(null);
        }

        @Override
        public Create create(String name) {
            return new Create(name);
        }

        @Override
        public Konos konosWrapper() {
            return (Konos)this.graph().wrapper(Konos.class);
        }

        public class Create
        extends Pipe.Create {
            public Create(String name) {
                super(name);
            }
        }
    }

    public static class MailPipe
    extends Pipe
    implements Terminal {
        public MailPipe(Node node) {
            super(node);
        }

        @Override
        public Map<String, List<?>> variables() {
            LinkedHashMap map = new LinkedHashMap(super.variables());
            return map;
        }

        @Override
        public Concept concept() {
            return this.graph().concept(MailPipe.class);
        }

        @Override
        protected void _load(String name, List<?> values) {
            super._load(name, values);
        }

        @Override
        protected void _set(String name, List<?> values) {
            super._set(name, values);
        }

        @Override
        public Create create() {
            return new Create(null);
        }

        @Override
        public Create create(String name) {
            return new Create(name);
        }

        @Override
        public Konos konosWrapper() {
            return (Konos)this.graph().wrapper(Konos.class);
        }

        public class Create
        extends Pipe.Create {
            public Create(String name) {
                super(name);
            }
        }
    }

    public static abstract class Pipe
    extends Layer
    implements Terminal {
        public Pipe(Node node) {
            super(node);
        }

        public Map<String, List<?>> variables() {
            LinkedHashMap map = new LinkedHashMap();
            return map;
        }

        public Concept concept() {
            return this.graph().concept(Pipe.class);
        }

        protected void _load(String name, List<?> values) {
            super._load(name, values);
        }

        protected void _set(String name, List<?> values) {
            super._set(name, values);
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Konos konosWrapper() {
            return (Konos)this.graph().wrapper(Konos.class);
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }
        }
    }

    public static class Tank
    extends Layer
    implements Terminal {
        protected String topic;

        public Tank(Node node) {
            super(node);
        }

        public String topic() {
            return this.topic;
        }

        public void topic(String value) {
            this.topic = value;
        }

        public Map<String, List<?>> variables() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("topic", new ArrayList<String>(Collections.singletonList(this.topic)));
            return map;
        }

        public Concept concept() {
            return this.graph().concept(Tank.class);
        }

        protected void _load(String name, List<?> values) {
            super._load(name, values);
            if (name.equalsIgnoreCase("topic")) {
                this.topic = (String)StringLoader.load(values, (Layer)this).get(0);
            }
        }

        protected void _set(String name, List<?> values) {
            super._set(name, values);
            if (name.equalsIgnoreCase("topic")) {
                this.topic = (String)values.get(0);
            }
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Konos konosWrapper() {
            return (Konos)this.graph().wrapper(Konos.class);
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }
        }
    }

    public class Create {
        protected final String name;

        public Create(String name) {
            this.name = name;
        }

        public Tank tank(String topic) {
            Tank newElement = (Tank)DataLake.this.graph().concept(Tank.class).createNode(this.name, DataLake.this.node()).as(Tank.class);
            newElement.node().set((Layer)newElement, "topic", Collections.singletonList(topic));
            return newElement;
        }

        public MailPipe mailPipe() {
            MailPipe newElement = (MailPipe)DataLake.this.graph().concept(MailPipe.class).createNode(this.name, DataLake.this.node()).as(MailPipe.class);
            return newElement;
        }

        public PostPipe postPipe() {
            PostPipe newElement = (PostPipe)DataLake.this.graph().concept(PostPipe.class).createNode(this.name, DataLake.this.node()).as(PostPipe.class);
            return newElement;
        }
    }
}

