/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.server.jmx;

import com.intellij.openapi.project.Project;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.action.JMXActionRenderer;
import io.intino.konos.builder.codegeneration.server.jmx.JMXServerTemplate;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.Parameter;
import io.intino.konos.model.Schema;
import io.intino.konos.model.jmx.JMXService;
import io.intino.konos.model.list.ListData;
import io.intino.konos.model.object.ObjectData;
import io.intino.konos.model.type.TypeData;
import io.intino.tara.magritte.Graph;
import java.io.File;
import java.util.List;
import org.siani.itrules.Template;
import org.siani.itrules.model.AbstractFrame;
import org.siani.itrules.model.Frame;

public class JMXOperationsServiceRenderer {
    private final Project project;
    private final List<JMXService> services;
    private File src;
    private final File gen;
    private String packageName;
    private final String boxName;

    public JMXOperationsServiceRenderer(Project project, Graph graph, File src, File gen, String packageName, String boxName) {
        this.project = project;
        this.services = graph.find(JMXService.class);
        this.src = src;
        this.gen = gen;
        this.packageName = packageName;
        this.boxName = boxName;
    }

    public void execute() {
        this.services.forEach(service -> {
            this.createInterface((JMXService)((Object)service));
            this.createImplementation((JMXService)((Object)service));
            this.createCorrespondingActions(service.operationList());
        });
    }

    private void createInterface(JMXService service) {
        Frame frame = new Frame().addTypes(new String[]{"jmx", "interface"});
        frame.addSlot("name", new String[]{service.name()});
        frame.addSlot("package", new String[]{this.packageName});
        frame.addSlot("box", new String[]{this.boxName});
        if (!service.graph().find(Schema.class).isEmpty()) {
            frame.addSlot("schemaImport", new AbstractFrame[]{new Frame().addTypes(new String[]{"schemaImport"}).addSlot("package", new String[]{this.packageName})});
        }
        for (JMXService.Operation operation : service.operationList()) {
            frame.addSlot("operation", new AbstractFrame[]{this.frameOf(operation)});
        }
        Commons.writeFrame(this.destinationPackage(), service.name() + "MBean", this.template().format((Object)frame));
    }

    private void createImplementation(JMXService service) {
        Frame frame = new Frame().addTypes(new String[]{"jmx", "implementation"});
        frame.addSlot("name", new String[]{service.name()});
        frame.addSlot("box", new String[]{this.boxName});
        frame.addSlot("package", new String[]{this.packageName});
        for (JMXService.Operation operation : service.operationList()) {
            frame.addSlot("operation", new AbstractFrame[]{this.frameOf(operation)});
        }
        Commons.writeFrame(this.destinationPackage(), service.name(), this.template().format((Object)frame));
    }

    private void createCorrespondingActions(List<JMXService.Operation> operations) {
        for (JMXService.Operation operation : operations) {
            new JMXActionRenderer(this.project, operation, this.src, this.packageName, this.boxName).execute();
        }
    }

    private Frame frameOf(JMXService.Operation operation) {
        Frame frame = new Frame().addTypes(new String[]{"operation"}).addSlot("name", new String[]{operation.name()}).addSlot("action", new String[]{operation.name()}).addSlot("package", new String[]{this.packageName}).addSlot("returnType", new AbstractFrame[]{this.returnType(operation)});
        frame.addSlot("description", new String[]{operation.description()});
        this.setupParameters(operation.parameterList(), frame);
        return frame;
    }

    private Frame returnType(JMXService.Operation operation) {
        Frame frame = new Frame().addTypes(new String[]{"returnType"}).addSlot("value", new String[]{operation.response() == null ? "void" : this.formatType(operation.response().asType())});
        if (operation.response() != null && operation.response().is(ListData.class)) {
            frame.addTypes(new String[]{"list"});
        }
        return frame;
    }

    private String formatType(TypeData typeData) {
        return (typeData.is(ObjectData.class) ? this.packageName + ".schemas." : "") + typeData.type();
    }

    private void setupParameters(List<Parameter> parameters, Frame frame) {
        for (Parameter parameter : parameters) {
            Frame parameterFrame = new Frame().addTypes(new String[]{"parameter"}).addSlot("name", new String[]{parameter.name()}).addSlot("type", new String[]{this.formatType(parameter.asType())});
            if (parameter.is(ListData.class)) {
                parameterFrame.addTypes(new String[]{"list"});
            }
            frame.addSlot("parameter", new AbstractFrame[]{parameterFrame});
        }
    }

    private Template template() {
        return Formatters.customize(JMXServerTemplate.create());
    }

    private File destinationPackage() {
        return new File(this.gen, "jmx");
    }
}

