/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.datalake;

import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.datalake.NessEventsTemplate;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.DataLake;
import io.intino.konos.model.Konos;
import io.intino.tara.magritte.Graph;
import java.io.File;
import org.siani.itrules.Template;
import org.siani.itrules.model.AbstractFrame;
import org.siani.itrules.model.Frame;

public class NessEventsRenderer {
    private final DataLake dataLake;
    private final File gen;
    private final String packageName;
    private final String boxName;

    public NessEventsRenderer(Graph graph, File gen, String packageName, String boxName) {
        this.dataLake = ((Konos)graph.wrapper(Konos.class)).dataLake();
        this.gen = gen;
        this.packageName = packageName;
        this.boxName = boxName;
    }

    public void execute() {
        if (this.dataLake == null) {
            return;
        }
        Frame frame = new Frame().addTypes(new String[]{"events"}).addSlot("package", new String[]{this.packageName}).addSlot("name", new String[]{this.dataLake.name()}).addSlot("box", new String[]{this.boxName}).addSlot("messageHandler", (AbstractFrame[])this.dataLake.tankList().stream().map(this::frameOf).toArray(Frame[]::new));
        if (!this.dataLake.tankList().isEmpty()) {
            frame.addSlot("messageHandlerImport", new String[]{this.packageName});
        }
        Commons.writeFrame(this.gen, "NessEvents", this.template().format((Object)frame));
    }

    private Frame frameOf(DataLake.Tank handler) {
        return new Frame().addTypes(new String[]{"messageHandler"}).addSlot("name", new String[]{handler.name()}).addSlot("messageType", new AbstractFrame[]{this.customize(handler.name(), handler.topic())}).addSlot("simpleMessageType", new String[]{handler.topic()});
    }

    private Frame customize(String name, String topic) {
        Frame frame = new Frame().addTypes(new String[]{"messageType"});
        frame.addSlot("name", new String[]{topic});
        for (String parameter : Commons.extractParameters(topic)) {
            frame.addSlot("custom", new AbstractFrame[]{this.custom(name, parameter)});
        }
        return frame;
    }

    private Frame custom(String name, String parameter) {
        return new Frame().addSlot("value", new String[]{parameter}).addSlot("conf", new String[]{name});
    }

    private Template template() {
        return Formatters.customize(NessEventsTemplate.create()).add("shortPath", value -> {
            String[] names = value.toString().split("\\.");
            return names[names.length - 1];
        });
    }
}

