/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.model;

import io.intino.konos.model.Konos;
import io.intino.konos.model.Sensor;
import io.intino.konos.model.multiple.dialog.tab.MultipleInput;
import io.intino.tara.magritte.Concept;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.Node;
import io.intino.tara.magritte.loaders.BooleanLoader;
import io.intino.tara.magritte.loaders.DoubleLoader;
import io.intino.tara.magritte.loaders.IntegerLoader;
import io.intino.tara.magritte.loaders.StringLoader;
import io.intino.tara.magritte.loaders.WordLoader;
import io.intino.tara.magritte.tags.Terminal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class Dialog
extends Sensor
implements Terminal {
    protected String url;
    protected String label;
    protected String description;
    protected Mode mode;
    protected boolean readonly;
    protected List<Tab> tabList = new ArrayList<Tab>();

    public Dialog(Node node) {
        super(node);
    }

    public String url() {
        return this.url;
    }

    public String label() {
        return this.label;
    }

    public String description() {
        return this.description;
    }

    public Mode mode() {
        return this.mode;
    }

    public boolean readonly() {
        return this.readonly;
    }

    public void url(String value) {
        this.url = value;
    }

    public void label(String value) {
        this.label = value;
    }

    public void description(String value) {
        this.description = value;
    }

    public void mode(Mode value) {
        this.mode = value;
    }

    public void readonly(boolean value) {
        this.readonly = value;
    }

    public List<Tab> tabList() {
        return Collections.unmodifiableList(this.tabList);
    }

    public Tab tab(int index) {
        return this.tabList.get(index);
    }

    public List<Tab> tabList(Predicate<Tab> predicate) {
        return this.tabList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<Node> componentList() {
        LinkedHashSet components = new LinkedHashSet(super.componentList());
        this.tabList.stream().forEach(c -> components.add(c.node()));
        return new ArrayList<Node>(components);
    }

    @Override
    public Map<String, List<?>> variables() {
        LinkedHashMap map = new LinkedHashMap(super.variables());
        map.put("url", new ArrayList<String>(Collections.singletonList(this.url)));
        map.put("label", new ArrayList<String>(Collections.singletonList(this.label)));
        map.put("description", new ArrayList<String>(Collections.singletonList(this.description)));
        map.put("mode", new ArrayList<Mode>(Collections.singletonList(this.mode)));
        map.put("readonly", new ArrayList<Boolean>(Collections.singletonList(this.readonly)));
        return map;
    }

    @Override
    public Concept concept() {
        return this.graph().concept(Dialog.class);
    }

    protected void addNode(Node node) {
        super.addNode(node);
        if (node.is("Dialog$Tab")) {
            this.tabList.add((Tab)node.as(Tab.class));
        }
    }

    protected void removeNode(Node node) {
        super.removeNode(node);
        if (node.is("Dialog$Tab")) {
            this.tabList.remove(node.as(Tab.class));
        }
    }

    @Override
    protected void _load(String name, List<?> values) {
        super._load(name, values);
        if (name.equalsIgnoreCase("url")) {
            this.url = (String)StringLoader.load(values, (Layer)this).get(0);
        } else if (name.equalsIgnoreCase("label")) {
            this.label = (String)StringLoader.load(values, (Layer)this).get(0);
        } else if (name.equalsIgnoreCase("description")) {
            this.description = (String)StringLoader.load(values, (Layer)this).get(0);
        } else if (name.equalsIgnoreCase("mode")) {
            this.mode = (Mode)((Object)WordLoader.load(values, Mode.class, (Layer)this).get(0));
        } else if (name.equalsIgnoreCase("readonly")) {
            this.readonly = (Boolean)BooleanLoader.load(values, (Layer)this).get(0);
        }
    }

    @Override
    protected void _set(String name, List<?> values) {
        super._set(name, values);
        if (name.equalsIgnoreCase("url")) {
            this.url = (String)values.get(0);
        } else if (name.equalsIgnoreCase("label")) {
            this.label = (String)values.get(0);
        } else if (name.equalsIgnoreCase("description")) {
            this.description = (String)values.get(0);
        } else if (name.equalsIgnoreCase("mode")) {
            this.mode = (Mode)((Object)values.get(0));
        } else if (name.equalsIgnoreCase("readonly")) {
            this.readonly = (Boolean)values.get(0);
        }
    }

    @Override
    public Create create() {
        return new Create(null);
    }

    @Override
    public Create create(String name) {
        return new Create(name);
    }

    @Override
    public Konos konosWrapper() {
        return (Konos)this.graph().wrapper(Konos.class);
    }

    public static class Tab
    extends Layer
    implements Terminal {
        protected String label;
        protected List<Input> inputList = new ArrayList<Input>();
        protected List<Text> textList = new ArrayList<Text>();
        protected List<Section> sectionList = new ArrayList<Section>();
        protected List<Memo> memoList = new ArrayList<Memo>();
        protected List<Password> passwordList = new ArrayList<Password>();
        protected List<OptionBox> optionBoxList = new ArrayList<OptionBox>();
        protected List<RadioBox> radioBoxList = new ArrayList<RadioBox>();
        protected List<CheckBox> checkBoxList = new ArrayList<CheckBox>();
        protected List<ComboBox> comboBoxList = new ArrayList<ComboBox>();
        protected List<Resource> resourceList = new ArrayList<Resource>();
        protected List<File> fileList = new ArrayList<File>();
        protected List<Picture> pictureList = new ArrayList<Picture>();
        protected List<Date> dateList = new ArrayList<Date>();
        protected List<DateTime> dateTimeList = new ArrayList<DateTime>();

        public Tab(Node node) {
            super(node);
        }

        public String label() {
            return this.label;
        }

        public void label(String value) {
            this.label = value;
        }

        public List<Input> inputList() {
            return Collections.unmodifiableList(this.inputList);
        }

        public Input input(int index) {
            return this.inputList.get(index);
        }

        public List<Input> inputList(Predicate<Input> predicate) {
            return this.inputList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<Text> textList() {
            return Collections.unmodifiableList(this.textList);
        }

        public Text text(int index) {
            return this.textList.get(index);
        }

        public List<Text> textList(Predicate<Text> predicate) {
            return this.textList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<Section> sectionList() {
            return Collections.unmodifiableList(this.sectionList);
        }

        public Section section(int index) {
            return this.sectionList.get(index);
        }

        public List<Section> sectionList(Predicate<Section> predicate) {
            return this.sectionList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<Memo> memoList() {
            return Collections.unmodifiableList(this.memoList);
        }

        public Memo memo(int index) {
            return this.memoList.get(index);
        }

        public List<Memo> memoList(Predicate<Memo> predicate) {
            return this.memoList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<Password> passwordList() {
            return Collections.unmodifiableList(this.passwordList);
        }

        public Password password(int index) {
            return this.passwordList.get(index);
        }

        public List<Password> passwordList(Predicate<Password> predicate) {
            return this.passwordList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<OptionBox> optionBoxList() {
            return Collections.unmodifiableList(this.optionBoxList);
        }

        public OptionBox optionBox(int index) {
            return this.optionBoxList.get(index);
        }

        public List<OptionBox> optionBoxList(Predicate<OptionBox> predicate) {
            return this.optionBoxList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<RadioBox> radioBoxList() {
            return Collections.unmodifiableList(this.radioBoxList);
        }

        public RadioBox radioBox(int index) {
            return this.radioBoxList.get(index);
        }

        public List<RadioBox> radioBoxList(Predicate<RadioBox> predicate) {
            return this.radioBoxList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<CheckBox> checkBoxList() {
            return Collections.unmodifiableList(this.checkBoxList);
        }

        public CheckBox checkBox(int index) {
            return this.checkBoxList.get(index);
        }

        public List<CheckBox> checkBoxList(Predicate<CheckBox> predicate) {
            return this.checkBoxList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<ComboBox> comboBoxList() {
            return Collections.unmodifiableList(this.comboBoxList);
        }

        public ComboBox comboBox(int index) {
            return this.comboBoxList.get(index);
        }

        public List<ComboBox> comboBoxList(Predicate<ComboBox> predicate) {
            return this.comboBoxList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<Resource> resourceList() {
            return Collections.unmodifiableList(this.resourceList);
        }

        public Resource resource(int index) {
            return this.resourceList.get(index);
        }

        public List<Resource> resourceList(Predicate<Resource> predicate) {
            return this.resourceList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<File> fileList() {
            return Collections.unmodifiableList(this.fileList);
        }

        public File file(int index) {
            return this.fileList.get(index);
        }

        public List<File> fileList(Predicate<File> predicate) {
            return this.fileList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<Picture> pictureList() {
            return Collections.unmodifiableList(this.pictureList);
        }

        public Picture picture(int index) {
            return this.pictureList.get(index);
        }

        public List<Picture> pictureList(Predicate<Picture> predicate) {
            return this.pictureList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<Date> dateList() {
            return Collections.unmodifiableList(this.dateList);
        }

        public Date date(int index) {
            return this.dateList.get(index);
        }

        public List<Date> dateList(Predicate<Date> predicate) {
            return this.dateList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<DateTime> dateTimeList() {
            return Collections.unmodifiableList(this.dateTimeList);
        }

        public DateTime dateTime(int index) {
            return this.dateTimeList.get(index);
        }

        public List<DateTime> dateTimeList(Predicate<DateTime> predicate) {
            return this.dateTimeList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<Node> componentList() {
            LinkedHashSet components = new LinkedHashSet(super.componentList());
            this.inputList.stream().forEach(c -> components.add(c.node()));
            this.textList.stream().forEach(c -> components.add(c.node()));
            this.sectionList.stream().forEach(c -> components.add(c.node()));
            this.memoList.stream().forEach(c -> components.add(c.node()));
            this.passwordList.stream().forEach(c -> components.add(c.node()));
            this.optionBoxList.stream().forEach(c -> components.add(c.node()));
            this.radioBoxList.stream().forEach(c -> components.add(c.node()));
            this.checkBoxList.stream().forEach(c -> components.add(c.node()));
            this.comboBoxList.stream().forEach(c -> components.add(c.node()));
            this.resourceList.stream().forEach(c -> components.add(c.node()));
            this.fileList.stream().forEach(c -> components.add(c.node()));
            this.pictureList.stream().forEach(c -> components.add(c.node()));
            this.dateList.stream().forEach(c -> components.add(c.node()));
            this.dateTimeList.stream().forEach(c -> components.add(c.node()));
            return new ArrayList<Node>(components);
        }

        public Map<String, List<?>> variables() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("label", new ArrayList<String>(Collections.singletonList(this.label)));
            return map;
        }

        public Concept concept() {
            return this.graph().concept(Tab.class);
        }

        protected void addNode(Node node) {
            super.addNode(node);
            if (node.is("Dialog$Tab$Input")) {
                this.inputList.add((Input)node.as(Input.class));
            }
            if (node.is("Dialog$Tab$Text")) {
                this.textList.add((Text)node.as(Text.class));
            }
            if (node.is("Dialog$Tab$Section")) {
                this.sectionList.add((Section)node.as(Section.class));
            }
            if (node.is("Dialog$Tab$Memo")) {
                this.memoList.add((Memo)node.as(Memo.class));
            }
            if (node.is("Dialog$Tab$Password")) {
                this.passwordList.add((Password)node.as(Password.class));
            }
            if (node.is("Dialog$Tab$OptionBox")) {
                this.optionBoxList.add((OptionBox)node.as(OptionBox.class));
            }
            if (node.is("Dialog$Tab$RadioBox")) {
                this.radioBoxList.add((RadioBox)node.as(RadioBox.class));
            }
            if (node.is("Dialog$Tab$CheckBox")) {
                this.checkBoxList.add((CheckBox)node.as(CheckBox.class));
            }
            if (node.is("Dialog$Tab$ComboBox")) {
                this.comboBoxList.add((ComboBox)node.as(ComboBox.class));
            }
            if (node.is("Dialog$Tab$Resource")) {
                this.resourceList.add((Resource)node.as(Resource.class));
            }
            if (node.is("Dialog$Tab$File")) {
                this.fileList.add((File)node.as(File.class));
            }
            if (node.is("Dialog$Tab$Picture")) {
                this.pictureList.add((Picture)node.as(Picture.class));
            }
            if (node.is("Dialog$Tab$Date")) {
                this.dateList.add((Date)node.as(Date.class));
            }
            if (node.is("Dialog$Tab$DateTime")) {
                this.dateTimeList.add((DateTime)node.as(DateTime.class));
            }
        }

        protected void removeNode(Node node) {
            super.removeNode(node);
            if (node.is("Dialog$Tab$Input")) {
                this.inputList.remove(node.as(Input.class));
            }
            if (node.is("Dialog$Tab$Text")) {
                this.textList.remove(node.as(Text.class));
            }
            if (node.is("Dialog$Tab$Section")) {
                this.sectionList.remove(node.as(Section.class));
            }
            if (node.is("Dialog$Tab$Memo")) {
                this.memoList.remove(node.as(Memo.class));
            }
            if (node.is("Dialog$Tab$Password")) {
                this.passwordList.remove(node.as(Password.class));
            }
            if (node.is("Dialog$Tab$OptionBox")) {
                this.optionBoxList.remove(node.as(OptionBox.class));
            }
            if (node.is("Dialog$Tab$RadioBox")) {
                this.radioBoxList.remove(node.as(RadioBox.class));
            }
            if (node.is("Dialog$Tab$CheckBox")) {
                this.checkBoxList.remove(node.as(CheckBox.class));
            }
            if (node.is("Dialog$Tab$ComboBox")) {
                this.comboBoxList.remove(node.as(ComboBox.class));
            }
            if (node.is("Dialog$Tab$Resource")) {
                this.resourceList.remove(node.as(Resource.class));
            }
            if (node.is("Dialog$Tab$File")) {
                this.fileList.remove(node.as(File.class));
            }
            if (node.is("Dialog$Tab$Picture")) {
                this.pictureList.remove(node.as(Picture.class));
            }
            if (node.is("Dialog$Tab$Date")) {
                this.dateList.remove(node.as(Date.class));
            }
            if (node.is("Dialog$Tab$DateTime")) {
                this.dateTimeList.remove(node.as(DateTime.class));
            }
        }

        protected void _load(String name, List<?> values) {
            super._load(name, values);
            if (name.equalsIgnoreCase("label")) {
                this.label = (String)StringLoader.load(values, (Layer)this).get(0);
            }
        }

        protected void _set(String name, List<?> values) {
            super._set(name, values);
            if (name.equalsIgnoreCase("label")) {
                this.label = (String)values.get(0);
            }
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Konos konosWrapper() {
            return (Konos)this.graph().wrapper(Konos.class);
        }

        public static class DateTime
        extends Input
        implements Terminal {
            protected String format;

            public DateTime(Node node) {
                super(node);
            }

            public String format() {
                return this.format;
            }

            public void format(String value) {
                this.format = value;
            }

            @Override
            public MultipleInput asMultiple() {
                Layer as = this.as(MultipleInput.class);
                return as != null ? (MultipleInput)as : (MultipleInput)this.addFacet(MultipleInput.class);
            }

            @Override
            public boolean isMultiple() {
                return this.is(MultipleInput.class);
            }

            @Override
            public Map<String, List<?>> variables() {
                LinkedHashMap map = new LinkedHashMap(super.variables());
                map.put("format", new ArrayList<String>(Collections.singletonList(this.format)));
                return map;
            }

            @Override
            public Concept concept() {
                return this.graph().concept(DateTime.class);
            }

            @Override
            protected void _load(String name, List<?> values) {
                super._load(name, values);
                if (name.equalsIgnoreCase("format")) {
                    this.format = (String)StringLoader.load(values, (Layer)this).get(0);
                }
            }

            @Override
            protected void _set(String name, List<?> values) {
                super._set(name, values);
                if (name.equalsIgnoreCase("format")) {
                    this.format = (String)values.get(0);
                }
            }

            @Override
            public Create create() {
                return new Create(null);
            }

            @Override
            public Create create(String name) {
                return new Create(name);
            }

            @Override
            public Konos konosWrapper() {
                return (Konos)this.graph().wrapper(Konos.class);
            }

            public class Create
            extends Input.Create {
                public Create(String name) {
                    super(name);
                }
            }
        }

        public static class Date
        extends Input
        implements Terminal {
            protected String format;

            public Date(Node node) {
                super(node);
            }

            public String format() {
                return this.format;
            }

            public void format(String value) {
                this.format = value;
            }

            @Override
            public MultipleInput asMultiple() {
                Layer as = this.as(MultipleInput.class);
                return as != null ? (MultipleInput)as : (MultipleInput)this.addFacet(MultipleInput.class);
            }

            @Override
            public boolean isMultiple() {
                return this.is(MultipleInput.class);
            }

            @Override
            public Map<String, List<?>> variables() {
                LinkedHashMap map = new LinkedHashMap(super.variables());
                map.put("format", new ArrayList<String>(Collections.singletonList(this.format)));
                return map;
            }

            @Override
            public Concept concept() {
                return this.graph().concept(Date.class);
            }

            @Override
            protected void _load(String name, List<?> values) {
                super._load(name, values);
                if (name.equalsIgnoreCase("format")) {
                    this.format = (String)StringLoader.load(values, (Layer)this).get(0);
                }
            }

            @Override
            protected void _set(String name, List<?> values) {
                super._set(name, values);
                if (name.equalsIgnoreCase("format")) {
                    this.format = (String)values.get(0);
                }
            }

            @Override
            public Create create() {
                return new Create(null);
            }

            @Override
            public Create create(String name) {
                return new Create(name);
            }

            @Override
            public Konos konosWrapper() {
                return (Konos)this.graph().wrapper(Konos.class);
            }

            public class Create
            extends Input.Create {
                public Create(String name) {
                    super(name);
                }
            }
        }

        public static class Picture
        extends Resource
        implements Terminal {
            public Picture(Node node) {
                super(node);
            }

            @Override
            public MultipleInput asMultiple() {
                Layer as = this.as(MultipleInput.class);
                return as != null ? (MultipleInput)as : (MultipleInput)this.addFacet(MultipleInput.class);
            }

            @Override
            public boolean isMultiple() {
                return this.is(MultipleInput.class);
            }

            @Override
            public Map<String, List<?>> variables() {
                LinkedHashMap map = new LinkedHashMap(super.variables());
                return map;
            }

            @Override
            public Concept concept() {
                return this.graph().concept(Picture.class);
            }

            @Override
            protected void _load(String name, List<?> values) {
                super._load(name, values);
            }

            @Override
            protected void _set(String name, List<?> values) {
                super._set(name, values);
            }

            @Override
            public Create create() {
                return new Create(null);
            }

            @Override
            public Create create(String name) {
                return new Create(name);
            }

            @Override
            public Konos konosWrapper() {
                return (Konos)this.graph().wrapper(Konos.class);
            }

            public class Create
            extends Resource.Create {
                public Create(String name) {
                    super(name);
                }
            }
        }

        public static class File
        extends Resource
        implements Terminal {
            public File(Node node) {
                super(node);
            }

            @Override
            public MultipleInput asMultiple() {
                Layer as = this.as(MultipleInput.class);
                return as != null ? (MultipleInput)as : (MultipleInput)this.addFacet(MultipleInput.class);
            }

            @Override
            public boolean isMultiple() {
                return this.is(MultipleInput.class);
            }

            @Override
            public Map<String, List<?>> variables() {
                LinkedHashMap map = new LinkedHashMap(super.variables());
                return map;
            }

            @Override
            public Concept concept() {
                return this.graph().concept(File.class);
            }

            @Override
            protected void _load(String name, List<?> values) {
                super._load(name, values);
            }

            @Override
            protected void _set(String name, List<?> values) {
                super._set(name, values);
            }

            @Override
            public Create create() {
                return new Create(null);
            }

            @Override
            public Create create(String name) {
                return new Create(name);
            }

            @Override
            public Konos konosWrapper() {
                return (Konos)this.graph().wrapper(Konos.class);
            }

            public class Create
            extends Resource.Create {
                public Create(String name) {
                    super(name);
                }
            }
        }

        public static abstract class Resource
        extends Input
        implements Terminal {
            protected boolean showPreview;
            protected Validation validation;

            public Resource(Node node) {
                super(node);
            }

            public boolean showPreview() {
                return this.showPreview;
            }

            public void showPreview(boolean value) {
                this.showPreview = value;
            }

            public Validation validation() {
                return this.validation;
            }

            public void validation(Validation value) {
                this.validation = value;
            }

            @Override
            public MultipleInput asMultiple() {
                Layer as = this.as(MultipleInput.class);
                return as != null ? (MultipleInput)as : (MultipleInput)this.addFacet(MultipleInput.class);
            }

            @Override
            public boolean isMultiple() {
                return this.is(MultipleInput.class);
            }

            public List<Node> componentList() {
                LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList());
                if (this.validation != null) {
                    components.add(this.validation.node());
                }
                return new ArrayList<Node>(components);
            }

            @Override
            public Map<String, List<?>> variables() {
                LinkedHashMap map = new LinkedHashMap(super.variables());
                map.put("showPreview", new ArrayList<Boolean>(Collections.singletonList(this.showPreview)));
                return map;
            }

            @Override
            public Concept concept() {
                return this.graph().concept(Resource.class);
            }

            protected void addNode(Node node) {
                super.addNode(node);
                if (node.is("Dialog$Tab$Resource$Validation")) {
                    this.validation = (Validation)node.as(Validation.class);
                }
            }

            protected void removeNode(Node node) {
                super.removeNode(node);
                if (node.is("Dialog$Tab$Resource$Validation")) {
                    this.validation = null;
                }
            }

            @Override
            protected void _load(String name, List<?> values) {
                super._load(name, values);
                if (name.equalsIgnoreCase("showPreview")) {
                    this.showPreview = (Boolean)BooleanLoader.load(values, (Layer)this).get(0);
                }
            }

            @Override
            protected void _set(String name, List<?> values) {
                super._set(name, values);
                if (name.equalsIgnoreCase("showPreview")) {
                    this.showPreview = (Boolean)values.get(0);
                }
            }

            @Override
            public Create create() {
                return new Create(null);
            }

            @Override
            public Create create(String name) {
                return new Create(name);
            }

            @Override
            public Konos konosWrapper() {
                return (Konos)this.graph().wrapper(Konos.class);
            }

            public static class Validation
            extends Layer
            implements Terminal {
                protected double maxSize;
                protected List<String> allowedExtensions = new ArrayList<String>();

                public Validation(Node node) {
                    super(node);
                }

                public double maxSize() {
                    return this.maxSize;
                }

                public List<String> allowedExtensions() {
                    return this.allowedExtensions;
                }

                public String allowedExtensions(int index) {
                    return this.allowedExtensions.get(index);
                }

                public List<String> allowedExtensions(Predicate<String> predicate) {
                    return this.allowedExtensions().stream().filter(predicate).collect(Collectors.toList());
                }

                public void maxSize(double value) {
                    this.maxSize = value;
                }

                public Map<String, List<?>> variables() {
                    LinkedHashMap map = new LinkedHashMap();
                    map.put("maxSize", new ArrayList<Double>(Collections.singletonList(this.maxSize)));
                    map.put("allowedExtensions", this.allowedExtensions);
                    return map;
                }

                public Concept concept() {
                    return this.graph().concept(Validation.class);
                }

                protected void _load(String name, List<?> values) {
                    super._load(name, values);
                    if (name.equalsIgnoreCase("maxSize")) {
                        this.maxSize = (Double)DoubleLoader.load(values, (Layer)this).get(0);
                    } else if (name.equalsIgnoreCase("allowedExtensions")) {
                        this.allowedExtensions = StringLoader.load(values, (Layer)this);
                    }
                }

                protected void _set(String name, List<?> values) {
                    super._set(name, values);
                    if (name.equalsIgnoreCase("maxSize")) {
                        this.maxSize = (Double)values.get(0);
                    } else if (name.equalsIgnoreCase("allowedExtensions")) {
                        this.allowedExtensions = new ArrayList(values);
                    }
                }

                public Create create() {
                    return new Create(null);
                }

                public Create create(String name) {
                    return new Create(name);
                }

                public Konos konosWrapper() {
                    return (Konos)this.graph().wrapper(Konos.class);
                }

                public class Create {
                    protected final String name;

                    public Create(String name) {
                        this.name = name;
                    }
                }
            }

            public class Create
            extends Input.Create {
                public Create(String name) {
                    super(name);
                }

                public Validation validation(double maxSize) {
                    Validation newElement = (Validation)Resource.this.graph().concept(Validation.class).createNode(this.name, Resource.this.node()).as(Validation.class);
                    newElement.node().set((Layer)newElement, "maxSize", Collections.singletonList(maxSize));
                    return newElement;
                }
            }
        }

        public static class ComboBox
        extends OptionBox
        implements Terminal {
            public ComboBox(Node node) {
                super(node);
            }

            @Override
            public MultipleInput asMultiple() {
                Layer as = this.as(MultipleInput.class);
                return as != null ? (MultipleInput)as : (MultipleInput)this.addFacet(MultipleInput.class);
            }

            @Override
            public boolean isMultiple() {
                return this.is(MultipleInput.class);
            }

            @Override
            public Map<String, List<?>> variables() {
                LinkedHashMap map = new LinkedHashMap(super.variables());
                return map;
            }

            @Override
            public Concept concept() {
                return this.graph().concept(ComboBox.class);
            }

            @Override
            protected void _load(String name, List<?> values) {
                super._load(name, values);
            }

            @Override
            protected void _set(String name, List<?> values) {
                super._set(name, values);
            }

            @Override
            public Create create() {
                return new Create(null);
            }

            @Override
            public Create create(String name) {
                return new Create(name);
            }

            @Override
            public Konos konosWrapper() {
                return (Konos)this.graph().wrapper(Konos.class);
            }

            public class Create
            extends OptionBox.Create {
                public Create(String name) {
                    super(name);
                }
            }
        }

        public static class CheckBox
        extends OptionBox
        implements Terminal {
            protected Mode mode;

            public CheckBox(Node node) {
                super(node);
            }

            public Mode mode() {
                return this.mode;
            }

            public void mode(Mode value) {
                this.mode = value;
            }

            @Override
            public MultipleInput asMultiple() {
                Layer as = this.as(MultipleInput.class);
                return as != null ? (MultipleInput)as : (MultipleInput)this.addFacet(MultipleInput.class);
            }

            @Override
            public boolean isMultiple() {
                return this.is(MultipleInput.class);
            }

            @Override
            public Map<String, List<?>> variables() {
                LinkedHashMap map = new LinkedHashMap(super.variables());
                map.put("mode", new ArrayList<Mode>(Collections.singletonList(this.mode)));
                return map;
            }

            @Override
            public Concept concept() {
                return this.graph().concept(CheckBox.class);
            }

            @Override
            protected void _load(String name, List<?> values) {
                super._load(name, values);
                if (name.equalsIgnoreCase("mode")) {
                    this.mode = (Mode)((Object)WordLoader.load(values, Mode.class, (Layer)this).get(0));
                }
            }

            @Override
            protected void _set(String name, List<?> values) {
                super._set(name, values);
                if (name.equalsIgnoreCase("mode")) {
                    this.mode = (Mode)((Object)values.get(0));
                }
            }

            @Override
            public Create create() {
                return new Create(null);
            }

            @Override
            public Create create(String name) {
                return new Create(name);
            }

            @Override
            public Konos konosWrapper() {
                return (Konos)this.graph().wrapper(Konos.class);
            }

            public class Create
            extends OptionBox.Create {
                public Create(String name) {
                    super(name);
                }
            }

            public static enum Mode {
                Boolean,
                List;

            }
        }

        public static class RadioBox
        extends OptionBox
        implements Terminal {
            public RadioBox(Node node) {
                super(node);
            }

            @Override
            public MultipleInput asMultiple() {
                Layer as = this.as(MultipleInput.class);
                return as != null ? (MultipleInput)as : (MultipleInput)this.addFacet(MultipleInput.class);
            }

            @Override
            public boolean isMultiple() {
                return this.is(MultipleInput.class);
            }

            @Override
            public Map<String, List<?>> variables() {
                LinkedHashMap map = new LinkedHashMap(super.variables());
                return map;
            }

            @Override
            public Concept concept() {
                return this.graph().concept(RadioBox.class);
            }

            @Override
            protected void _load(String name, List<?> values) {
                super._load(name, values);
            }

            @Override
            protected void _set(String name, List<?> values) {
                super._set(name, values);
            }

            @Override
            public Create create() {
                return new Create(null);
            }

            @Override
            public Create create(String name) {
                return new Create(name);
            }

            @Override
            public Konos konosWrapper() {
                return (Konos)this.graph().wrapper(Konos.class);
            }

            public class Create
            extends OptionBox.Create {
                public Create(String name) {
                    super(name);
                }
            }
        }

        public static abstract class OptionBox
        extends Input
        implements Terminal {
            protected List<String> options = new ArrayList<String>();
            protected String source;

            public OptionBox(Node node) {
                super(node);
            }

            public List<String> options() {
                return this.options;
            }

            public String options(int index) {
                return this.options.get(index);
            }

            public List<String> options(Predicate<String> predicate) {
                return this.options().stream().filter(predicate).collect(Collectors.toList());
            }

            public String source() {
                return this.source;
            }

            public void source(String value) {
                this.source = value;
            }

            @Override
            public MultipleInput asMultiple() {
                Layer as = this.as(MultipleInput.class);
                return as != null ? (MultipleInput)as : (MultipleInput)this.addFacet(MultipleInput.class);
            }

            @Override
            public boolean isMultiple() {
                return this.is(MultipleInput.class);
            }

            @Override
            public Map<String, List<?>> variables() {
                LinkedHashMap map = new LinkedHashMap(super.variables());
                map.put("options", this.options);
                map.put("source", new ArrayList<String>(Collections.singletonList(this.source)));
                return map;
            }

            @Override
            public Concept concept() {
                return this.graph().concept(OptionBox.class);
            }

            @Override
            protected void _load(String name, List<?> values) {
                super._load(name, values);
                if (name.equalsIgnoreCase("options")) {
                    this.options = StringLoader.load(values, (Layer)this);
                } else if (name.equalsIgnoreCase("source")) {
                    this.source = (String)StringLoader.load(values, (Layer)this).get(0);
                }
            }

            @Override
            protected void _set(String name, List<?> values) {
                super._set(name, values);
                if (name.equalsIgnoreCase("options")) {
                    this.options = new ArrayList(values);
                } else if (name.equalsIgnoreCase("source")) {
                    this.source = (String)values.get(0);
                }
            }

            @Override
            public Create create() {
                return new Create(null);
            }

            @Override
            public Create create(String name) {
                return new Create(name);
            }

            @Override
            public Konos konosWrapper() {
                return (Konos)this.graph().wrapper(Konos.class);
            }

            public class Create
            extends Input.Create {
                public Create(String name) {
                    super(name);
                }
            }
        }

        public static class Password
        extends Input
        implements Terminal {
            protected Validation validation;

            public Password(Node node) {
                super(node);
            }

            public Validation validation() {
                return this.validation;
            }

            public void validation(Validation value) {
                this.validation = value;
            }

            @Override
            public MultipleInput asMultiple() {
                Layer as = this.as(MultipleInput.class);
                return as != null ? (MultipleInput)as : (MultipleInput)this.addFacet(MultipleInput.class);
            }

            @Override
            public boolean isMultiple() {
                return this.is(MultipleInput.class);
            }

            public List<Node> componentList() {
                LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList());
                if (this.validation != null) {
                    components.add(this.validation.node());
                }
                return new ArrayList<Node>(components);
            }

            @Override
            public Map<String, List<?>> variables() {
                LinkedHashMap map = new LinkedHashMap(super.variables());
                return map;
            }

            @Override
            public Concept concept() {
                return this.graph().concept(Password.class);
            }

            protected void addNode(Node node) {
                super.addNode(node);
                if (node.is("Dialog$Tab$Password$Validation")) {
                    this.validation = (Validation)node.as(Validation.class);
                }
            }

            protected void removeNode(Node node) {
                super.removeNode(node);
                if (node.is("Dialog$Tab$Password$Validation")) {
                    this.validation = null;
                }
            }

            @Override
            protected void _load(String name, List<?> values) {
                super._load(name, values);
            }

            @Override
            protected void _set(String name, List<?> values) {
                super._set(name, values);
            }

            @Override
            public Create create() {
                return new Create(null);
            }

            @Override
            public Create create(String name) {
                return new Create(name);
            }

            @Override
            public Konos konosWrapper() {
                return (Konos)this.graph().wrapper(Konos.class);
            }

            public static class Validation
            extends Layer
            implements Terminal {
                protected List<Required> required = new ArrayList<Required>();
                protected Length length;

                public Validation(Node node) {
                    super(node);
                }

                public List<Required> required() {
                    return this.required;
                }

                public Length length() {
                    return this.length;
                }

                public void length(Length value) {
                    this.length = value;
                }

                public List<Node> componentList() {
                    LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList());
                    if (this.length != null) {
                        components.add(this.length.node());
                    }
                    return new ArrayList<Node>(components);
                }

                public Map<String, List<?>> variables() {
                    LinkedHashMap map = new LinkedHashMap();
                    map.put("required", this.required);
                    return map;
                }

                public Concept concept() {
                    return this.graph().concept(Validation.class);
                }

                protected void addNode(Node node) {
                    super.addNode(node);
                    if (node.is("Dialog$Tab$Password$Validation$Length")) {
                        this.length = (Length)node.as(Length.class);
                    }
                }

                protected void removeNode(Node node) {
                    super.removeNode(node);
                    if (node.is("Dialog$Tab$Password$Validation$Length")) {
                        this.length = null;
                    }
                }

                protected void _load(String name, List<?> values) {
                    super._load(name, values);
                    if (name.equalsIgnoreCase("required")) {
                        this.required = WordLoader.load(values, Required.class, (Layer)this);
                    }
                }

                protected void _set(String name, List<?> values) {
                    super._set(name, values);
                    if (name.equalsIgnoreCase("required")) {
                        this.required = new ArrayList(values);
                    }
                }

                public Create create() {
                    return new Create(null);
                }

                public Create create(String name) {
                    return new Create(name);
                }

                public Konos konosWrapper() {
                    return (Konos)this.graph().wrapper(Konos.class);
                }

                public static class Length
                extends Layer
                implements Terminal {
                    protected int min;
                    protected int max;

                    public Length(Node node) {
                        super(node);
                    }

                    public int min() {
                        return this.min;
                    }

                    public int max() {
                        return this.max;
                    }

                    public void min(int value) {
                        this.min = value;
                    }

                    public void max(int value) {
                        this.max = value;
                    }

                    public Map<String, List<?>> variables() {
                        LinkedHashMap map = new LinkedHashMap();
                        map.put("min", new ArrayList<Integer>(Collections.singletonList(this.min)));
                        map.put("max", new ArrayList<Integer>(Collections.singletonList(this.max)));
                        return map;
                    }

                    public Concept concept() {
                        return this.graph().concept(Length.class);
                    }

                    protected void _load(String name, List<?> values) {
                        super._load(name, values);
                        if (name.equalsIgnoreCase("min")) {
                            this.min = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
                        } else if (name.equalsIgnoreCase("max")) {
                            this.max = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
                        }
                    }

                    protected void _set(String name, List<?> values) {
                        super._set(name, values);
                        if (name.equalsIgnoreCase("min")) {
                            this.min = (Integer)values.get(0);
                        } else if (name.equalsIgnoreCase("max")) {
                            this.max = (Integer)values.get(0);
                        }
                    }

                    public Create create() {
                        return new Create(null);
                    }

                    public Create create(String name) {
                        return new Create(name);
                    }

                    public Konos konosWrapper() {
                        return (Konos)this.graph().wrapper(Konos.class);
                    }

                    public class Create {
                        protected final String name;

                        public Create(String name) {
                            this.name = name;
                        }
                    }
                }

                public class Create {
                    protected final String name;

                    public Create(String name) {
                        this.name = name;
                    }

                    public Length length(int min, int max) {
                        Length newElement = (Length)Validation.this.graph().concept(Length.class).createNode(this.name, Validation.this.node()).as(Length.class);
                        newElement.node().set((Layer)newElement, "min", Collections.singletonList(min));
                        newElement.node().set((Layer)newElement, "max", Collections.singletonList(max));
                        return newElement;
                    }
                }

                public static enum Required {
                    letter,
                    number,
                    symbol;

                }
            }

            public class Create
            extends Input.Create {
                public Create(String name) {
                    super(name);
                }

                public Validation validation() {
                    Validation newElement = (Validation)Password.this.graph().concept(Validation.class).createNode(this.name, Password.this.node()).as(Validation.class);
                    return newElement;
                }
            }
        }

        public static class Memo
        extends Input
        implements Terminal {
            protected Mode mode;
            protected int height;

            public Memo(Node node) {
                super(node);
            }

            public Mode mode() {
                return this.mode;
            }

            public int height() {
                return this.height;
            }

            public void mode(Mode value) {
                this.mode = value;
            }

            public void height(int value) {
                this.height = value;
            }

            @Override
            public MultipleInput asMultiple() {
                Layer as = this.as(MultipleInput.class);
                return as != null ? (MultipleInput)as : (MultipleInput)this.addFacet(MultipleInput.class);
            }

            @Override
            public boolean isMultiple() {
                return this.is(MultipleInput.class);
            }

            @Override
            public Map<String, List<?>> variables() {
                LinkedHashMap map = new LinkedHashMap(super.variables());
                map.put("mode", new ArrayList<Mode>(Collections.singletonList(this.mode)));
                map.put("height", new ArrayList<Integer>(Collections.singletonList(this.height)));
                return map;
            }

            @Override
            public Concept concept() {
                return this.graph().concept(Memo.class);
            }

            @Override
            protected void _load(String name, List<?> values) {
                super._load(name, values);
                if (name.equalsIgnoreCase("mode")) {
                    this.mode = (Mode)((Object)WordLoader.load(values, Mode.class, (Layer)this).get(0));
                } else if (name.equalsIgnoreCase("height")) {
                    this.height = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
                }
            }

            @Override
            protected void _set(String name, List<?> values) {
                super._set(name, values);
                if (name.equalsIgnoreCase("mode")) {
                    this.mode = (Mode)((Object)values.get(0));
                } else if (name.equalsIgnoreCase("height")) {
                    this.height = (Integer)values.get(0);
                }
            }

            @Override
            public Create create() {
                return new Create(null);
            }

            @Override
            public Create create(String name) {
                return new Create(name);
            }

            @Override
            public Konos konosWrapper() {
                return (Konos)this.graph().wrapper(Konos.class);
            }

            public class Create
            extends Input.Create {
                public Create(String name) {
                    super(name);
                }
            }

            public static enum Mode {
                raw,
                rich;

            }
        }

        public static class Section
        extends Input
        implements Terminal {
            protected List<Input> inputList = new ArrayList<Input>();

            public Section(Node node) {
                super(node);
            }

            public List<Input> inputList() {
                return Collections.unmodifiableList(this.inputList);
            }

            public Input input(int index) {
                return this.inputList.get(index);
            }

            public List<Input> inputList(Predicate<Input> predicate) {
                return this.inputList().stream().filter(predicate).collect(Collectors.toList());
            }

            @Override
            public MultipleInput asMultiple() {
                Layer as = this.as(MultipleInput.class);
                return as != null ? (MultipleInput)as : (MultipleInput)this.addFacet(MultipleInput.class);
            }

            @Override
            public boolean isMultiple() {
                return this.is(MultipleInput.class);
            }

            public List<Node> componentList() {
                LinkedHashSet components = new LinkedHashSet(super.componentList());
                this.inputList.stream().forEach(c -> components.add(c.node()));
                return new ArrayList<Node>(components);
            }

            @Override
            public Map<String, List<?>> variables() {
                LinkedHashMap map = new LinkedHashMap(super.variables());
                return map;
            }

            @Override
            public Concept concept() {
                return this.graph().concept(Section.class);
            }

            protected void addNode(Node node) {
                super.addNode(node);
                if (node.is("Dialog$Tab$Input")) {
                    this.inputList.add((Input)node.as(Input.class));
                }
            }

            protected void removeNode(Node node) {
                super.removeNode(node);
                if (node.is("Dialog$Tab$Input")) {
                    this.inputList.remove(node.as(Input.class));
                }
            }

            @Override
            protected void _load(String name, List<?> values) {
                super._load(name, values);
            }

            @Override
            protected void _set(String name, List<?> values) {
                super._set(name, values);
            }

            @Override
            public Create create() {
                return new Create(null);
            }

            @Override
            public Create create(String name) {
                return new Create(name);
            }

            @Override
            public Konos konosWrapper() {
                return (Konos)this.graph().wrapper(Konos.class);
            }

            public class Create
            extends Input.Create {
                public Create(String name) {
                    super(name);
                }

                public Section section(String label) {
                    Section newElement = (Section)Section.this.graph().concept(Section.class).createNode(this.name, Section.this.node()).as(Section.class);
                    newElement.node().set((Layer)newElement, "label", Collections.singletonList(label));
                    return newElement;
                }

                public Picture picture(String label) {
                    Picture newElement = (Picture)Section.this.graph().concept(Picture.class).createNode(this.name, Section.this.node()).as(Picture.class);
                    newElement.node().set((Layer)newElement, "label", Collections.singletonList(label));
                    return newElement;
                }

                public Date date(String label) {
                    Date newElement = (Date)Section.this.graph().concept(Date.class).createNode(this.name, Section.this.node()).as(Date.class);
                    newElement.node().set((Layer)newElement, "label", Collections.singletonList(label));
                    return newElement;
                }

                public DateTime dateTime(String label) {
                    DateTime newElement = (DateTime)Section.this.graph().concept(DateTime.class).createNode(this.name, Section.this.node()).as(DateTime.class);
                    newElement.node().set((Layer)newElement, "label", Collections.singletonList(label));
                    return newElement;
                }

                public RadioBox radioBox(String label) {
                    RadioBox newElement = (RadioBox)Section.this.graph().concept(RadioBox.class).createNode(this.name, Section.this.node()).as(RadioBox.class);
                    newElement.node().set((Layer)newElement, "label", Collections.singletonList(label));
                    return newElement;
                }

                public Memo memo(String label) {
                    Memo newElement = (Memo)Section.this.graph().concept(Memo.class).createNode(this.name, Section.this.node()).as(Memo.class);
                    newElement.node().set((Layer)newElement, "label", Collections.singletonList(label));
                    return newElement;
                }

                public ComboBox comboBox(String label) {
                    ComboBox newElement = (ComboBox)Section.this.graph().concept(ComboBox.class).createNode(this.name, Section.this.node()).as(ComboBox.class);
                    newElement.node().set((Layer)newElement, "label", Collections.singletonList(label));
                    return newElement;
                }

                public File file(String label) {
                    File newElement = (File)Section.this.graph().concept(File.class).createNode(this.name, Section.this.node()).as(File.class);
                    newElement.node().set((Layer)newElement, "label", Collections.singletonList(label));
                    return newElement;
                }

                public CheckBox checkBox(String label, CheckBox.Mode mode) {
                    CheckBox newElement = (CheckBox)Section.this.graph().concept(CheckBox.class).createNode(this.name, Section.this.node()).as(CheckBox.class);
                    newElement.node().set((Layer)newElement, "label", Collections.singletonList(label));
                    newElement.node().set((Layer)newElement, "mode", Collections.singletonList(mode));
                    return newElement;
                }

                public Password password(String label) {
                    Password newElement = (Password)Section.this.graph().concept(Password.class).createNode(this.name, Section.this.node()).as(Password.class);
                    newElement.node().set((Layer)newElement, "label", Collections.singletonList(label));
                    return newElement;
                }

                public Text text(String label) {
                    Text newElement = (Text)Section.this.graph().concept(Text.class).createNode(this.name, Section.this.node()).as(Text.class);
                    newElement.node().set((Layer)newElement, "label", Collections.singletonList(label));
                    return newElement;
                }
            }
        }

        public static class Text
        extends Input
        implements Terminal {
            protected Edition edition;
            protected Validation validation;

            public Text(Node node) {
                super(node);
            }

            public Edition edition() {
                return this.edition;
            }

            public void edition(Edition value) {
                this.edition = value;
            }

            public Validation validation() {
                return this.validation;
            }

            public void validation(Validation value) {
                this.validation = value;
            }

            @Override
            public MultipleInput asMultiple() {
                Layer as = this.as(MultipleInput.class);
                return as != null ? (MultipleInput)as : (MultipleInput)this.addFacet(MultipleInput.class);
            }

            @Override
            public boolean isMultiple() {
                return this.is(MultipleInput.class);
            }

            public List<Node> componentList() {
                LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList());
                if (this.validation != null) {
                    components.add(this.validation.node());
                }
                return new ArrayList<Node>(components);
            }

            @Override
            public Map<String, List<?>> variables() {
                LinkedHashMap map = new LinkedHashMap(super.variables());
                map.put("edition", new ArrayList<Edition>(Collections.singletonList(this.edition)));
                return map;
            }

            @Override
            public Concept concept() {
                return this.graph().concept(Text.class);
            }

            protected void addNode(Node node) {
                super.addNode(node);
                if (node.is("Dialog$Tab$Text$Validation")) {
                    this.validation = (Validation)node.as(Validation.class);
                }
            }

            protected void removeNode(Node node) {
                super.removeNode(node);
                if (node.is("Dialog$Tab$Text$Validation")) {
                    this.validation = null;
                }
            }

            @Override
            protected void _load(String name, List<?> values) {
                super._load(name, values);
                if (name.equalsIgnoreCase("edition")) {
                    this.edition = (Edition)((Object)WordLoader.load(values, Edition.class, (Layer)this).get(0));
                }
            }

            @Override
            protected void _set(String name, List<?> values) {
                super._set(name, values);
                if (name.equalsIgnoreCase("edition")) {
                    this.edition = (Edition)((Object)values.get(0));
                }
            }

            @Override
            public Create create() {
                return new Create(null);
            }

            @Override
            public Create create(String name) {
                return new Create(name);
            }

            @Override
            public Konos konosWrapper() {
                return (Konos)this.graph().wrapper(Konos.class);
            }

            public static class Validation
            extends Layer
            implements Terminal {
                protected List<String> allowedValues = new ArrayList<String>();
                protected List<String> disallowedValues = new ArrayList<String>();
                protected boolean disallowEmptySpaces;
                protected String mask;
                protected Length length;

                public Validation(Node node) {
                    super(node);
                }

                public List<String> allowedValues() {
                    return this.allowedValues;
                }

                public String allowedValues(int index) {
                    return this.allowedValues.get(index);
                }

                public List<String> allowedValues(Predicate<String> predicate) {
                    return this.allowedValues().stream().filter(predicate).collect(Collectors.toList());
                }

                public List<String> disallowedValues() {
                    return this.disallowedValues;
                }

                public String disallowedValues(int index) {
                    return this.disallowedValues.get(index);
                }

                public List<String> disallowedValues(Predicate<String> predicate) {
                    return this.disallowedValues().stream().filter(predicate).collect(Collectors.toList());
                }

                public boolean disallowEmptySpaces() {
                    return this.disallowEmptySpaces;
                }

                public String mask() {
                    return this.mask;
                }

                public void disallowEmptySpaces(boolean value) {
                    this.disallowEmptySpaces = value;
                }

                public void mask(String value) {
                    this.mask = value;
                }

                public Length length() {
                    return this.length;
                }

                public void length(Length value) {
                    this.length = value;
                }

                public List<Node> componentList() {
                    LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList());
                    if (this.length != null) {
                        components.add(this.length.node());
                    }
                    return new ArrayList<Node>(components);
                }

                public Map<String, List<?>> variables() {
                    LinkedHashMap map = new LinkedHashMap();
                    map.put("allowedValues", this.allowedValues);
                    map.put("disallowedValues", this.disallowedValues);
                    map.put("disallowEmptySpaces", new ArrayList<Boolean>(Collections.singletonList(this.disallowEmptySpaces)));
                    map.put("mask", new ArrayList<String>(Collections.singletonList(this.mask)));
                    return map;
                }

                public Concept concept() {
                    return this.graph().concept(Validation.class);
                }

                protected void addNode(Node node) {
                    super.addNode(node);
                    if (node.is("Dialog$Tab$Text$Validation$Length")) {
                        this.length = (Length)node.as(Length.class);
                    }
                }

                protected void removeNode(Node node) {
                    super.removeNode(node);
                    if (node.is("Dialog$Tab$Text$Validation$Length")) {
                        this.length = null;
                    }
                }

                protected void _load(String name, List<?> values) {
                    super._load(name, values);
                    if (name.equalsIgnoreCase("allowedValues")) {
                        this.allowedValues = StringLoader.load(values, (Layer)this);
                    } else if (name.equalsIgnoreCase("disallowedValues")) {
                        this.disallowedValues = StringLoader.load(values, (Layer)this);
                    } else if (name.equalsIgnoreCase("disallowEmptySpaces")) {
                        this.disallowEmptySpaces = (Boolean)BooleanLoader.load(values, (Layer)this).get(0);
                    } else if (name.equalsIgnoreCase("mask")) {
                        this.mask = (String)StringLoader.load(values, (Layer)this).get(0);
                    }
                }

                protected void _set(String name, List<?> values) {
                    super._set(name, values);
                    if (name.equalsIgnoreCase("allowedValues")) {
                        this.allowedValues = new ArrayList(values);
                    } else if (name.equalsIgnoreCase("disallowedValues")) {
                        this.disallowedValues = new ArrayList(values);
                    } else if (name.equalsIgnoreCase("disallowEmptySpaces")) {
                        this.disallowEmptySpaces = (Boolean)values.get(0);
                    } else if (name.equalsIgnoreCase("mask")) {
                        this.mask = (String)values.get(0);
                    }
                }

                public Create create() {
                    return new Create(null);
                }

                public Create create(String name) {
                    return new Create(name);
                }

                public Konos konosWrapper() {
                    return (Konos)this.graph().wrapper(Konos.class);
                }

                public static class Length
                extends Layer
                implements Terminal {
                    protected int min;
                    protected int max;

                    public Length(Node node) {
                        super(node);
                    }

                    public int min() {
                        return this.min;
                    }

                    public int max() {
                        return this.max;
                    }

                    public void min(int value) {
                        this.min = value;
                    }

                    public void max(int value) {
                        this.max = value;
                    }

                    public Map<String, List<?>> variables() {
                        LinkedHashMap map = new LinkedHashMap();
                        map.put("min", new ArrayList<Integer>(Collections.singletonList(this.min)));
                        map.put("max", new ArrayList<Integer>(Collections.singletonList(this.max)));
                        return map;
                    }

                    public Concept concept() {
                        return this.graph().concept(Length.class);
                    }

                    protected void _load(String name, List<?> values) {
                        super._load(name, values);
                        if (name.equalsIgnoreCase("min")) {
                            this.min = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
                        } else if (name.equalsIgnoreCase("max")) {
                            this.max = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
                        }
                    }

                    protected void _set(String name, List<?> values) {
                        super._set(name, values);
                        if (name.equalsIgnoreCase("min")) {
                            this.min = (Integer)values.get(0);
                        } else if (name.equalsIgnoreCase("max")) {
                            this.max = (Integer)values.get(0);
                        }
                    }

                    public Create create() {
                        return new Create(null);
                    }

                    public Create create(String name) {
                        return new Create(name);
                    }

                    public Konos konosWrapper() {
                        return (Konos)this.graph().wrapper(Konos.class);
                    }

                    public class Create {
                        protected final String name;

                        public Create(String name) {
                            this.name = name;
                        }
                    }
                }

                public class Create {
                    protected final String name;

                    public Create(String name) {
                        this.name = name;
                    }

                    public Length length(int min, int max) {
                        Length newElement = (Length)Validation.this.graph().concept(Length.class).createNode(this.name, Validation.this.node()).as(Length.class);
                        newElement.node().set((Layer)newElement, "min", Collections.singletonList(min));
                        newElement.node().set((Layer)newElement, "max", Collections.singletonList(max));
                        return newElement;
                    }
                }
            }

            public class Create
            extends Input.Create {
                public Create(String name) {
                    super(name);
                }

                public Validation validation() {
                    Validation newElement = (Validation)Text.this.graph().concept(Validation.class).createNode(this.name, Text.this.node()).as(Validation.class);
                    return newElement;
                }
            }

            public static enum Edition {
                Normal,
                Uppercase,
                Lowercase,
                Email,
                Url;

            }
        }

        public static abstract class Input
        extends Layer
        implements Terminal {
            protected String label;
            protected boolean required;
            protected boolean readonly;
            protected String placeHolder;
            protected String helper;
            protected String defaultValue;
            protected String validator;

            public Input(Node node) {
                super(node);
            }

            public String label() {
                return this.label;
            }

            public boolean required() {
                return this.required;
            }

            public boolean readonly() {
                return this.readonly;
            }

            public String placeHolder() {
                return this.placeHolder;
            }

            public String helper() {
                return this.helper;
            }

            public String defaultValue() {
                return this.defaultValue;
            }

            public String validator() {
                return this.validator;
            }

            public void label(String value) {
                this.label = value;
            }

            public void required(boolean value) {
                this.required = value;
            }

            public void readonly(boolean value) {
                this.readonly = value;
            }

            public void placeHolder(String value) {
                this.placeHolder = value;
            }

            public void helper(String value) {
                this.helper = value;
            }

            public void defaultValue(String value) {
                this.defaultValue = value;
            }

            public void validator(String value) {
                this.validator = value;
            }

            public MultipleInput asMultiple() {
                Layer as = this.as(MultipleInput.class);
                return as != null ? (MultipleInput)as : (MultipleInput)this.addFacet(MultipleInput.class);
            }

            public boolean isMultiple() {
                return this.is(MultipleInput.class);
            }

            public Map<String, List<?>> variables() {
                LinkedHashMap map = new LinkedHashMap();
                map.put("label", new ArrayList<String>(Collections.singletonList(this.label)));
                map.put("required", new ArrayList<Boolean>(Collections.singletonList(this.required)));
                map.put("readonly", new ArrayList<Boolean>(Collections.singletonList(this.readonly)));
                map.put("placeHolder", new ArrayList<String>(Collections.singletonList(this.placeHolder)));
                map.put("helper", new ArrayList<String>(Collections.singletonList(this.helper)));
                map.put("defaultValue", new ArrayList<String>(Collections.singletonList(this.defaultValue)));
                map.put("validator", new ArrayList<String>(Collections.singletonList(this.validator)));
                return map;
            }

            public Concept concept() {
                return this.graph().concept(Input.class);
            }

            protected void _load(String name, List<?> values) {
                super._load(name, values);
                if (name.equalsIgnoreCase("label")) {
                    this.label = (String)StringLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("required")) {
                    this.required = (Boolean)BooleanLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("readonly")) {
                    this.readonly = (Boolean)BooleanLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("placeHolder")) {
                    this.placeHolder = (String)StringLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("helper")) {
                    this.helper = (String)StringLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("defaultValue")) {
                    this.defaultValue = (String)StringLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("validator")) {
                    this.validator = (String)StringLoader.load(values, (Layer)this).get(0);
                }
            }

            protected void _set(String name, List<?> values) {
                super._set(name, values);
                if (name.equalsIgnoreCase("label")) {
                    this.label = (String)values.get(0);
                } else if (name.equalsIgnoreCase("required")) {
                    this.required = (Boolean)values.get(0);
                } else if (name.equalsIgnoreCase("readonly")) {
                    this.readonly = (Boolean)values.get(0);
                } else if (name.equalsIgnoreCase("placeHolder")) {
                    this.placeHolder = (String)values.get(0);
                } else if (name.equalsIgnoreCase("helper")) {
                    this.helper = (String)values.get(0);
                } else if (name.equalsIgnoreCase("defaultValue")) {
                    this.defaultValue = (String)values.get(0);
                } else if (name.equalsIgnoreCase("validator")) {
                    this.validator = (String)values.get(0);
                }
            }

            public Create create() {
                return new Create(null);
            }

            public Create create(String name) {
                return new Create(name);
            }

            public Konos konosWrapper() {
                return (Konos)this.graph().wrapper(Konos.class);
            }

            public class Create {
                protected final String name;

                public Create(String name) {
                    this.name = name;
                }
            }
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }

            public Text text(String label) {
                Text newElement = (Text)Tab.this.graph().concept(Text.class).createNode(this.name, Tab.this.node()).as(Text.class);
                newElement.node().set((Layer)newElement, "label", Collections.singletonList(label));
                return newElement;
            }

            public Section section(String label) {
                Section newElement = (Section)Tab.this.graph().concept(Section.class).createNode(this.name, Tab.this.node()).as(Section.class);
                newElement.node().set((Layer)newElement, "label", Collections.singletonList(label));
                return newElement;
            }

            public Memo memo(String label) {
                Memo newElement = (Memo)Tab.this.graph().concept(Memo.class).createNode(this.name, Tab.this.node()).as(Memo.class);
                newElement.node().set((Layer)newElement, "label", Collections.singletonList(label));
                return newElement;
            }

            public Password password(String label) {
                Password newElement = (Password)Tab.this.graph().concept(Password.class).createNode(this.name, Tab.this.node()).as(Password.class);
                newElement.node().set((Layer)newElement, "label", Collections.singletonList(label));
                return newElement;
            }

            public RadioBox radioBox(String label) {
                RadioBox newElement = (RadioBox)Tab.this.graph().concept(RadioBox.class).createNode(this.name, Tab.this.node()).as(RadioBox.class);
                newElement.node().set((Layer)newElement, "label", Collections.singletonList(label));
                return newElement;
            }

            public CheckBox checkBox(String label, CheckBox.Mode mode) {
                CheckBox newElement = (CheckBox)Tab.this.graph().concept(CheckBox.class).createNode(this.name, Tab.this.node()).as(CheckBox.class);
                newElement.node().set((Layer)newElement, "label", Collections.singletonList(label));
                newElement.node().set((Layer)newElement, "mode", Collections.singletonList(mode));
                return newElement;
            }

            public ComboBox comboBox(String label) {
                ComboBox newElement = (ComboBox)Tab.this.graph().concept(ComboBox.class).createNode(this.name, Tab.this.node()).as(ComboBox.class);
                newElement.node().set((Layer)newElement, "label", Collections.singletonList(label));
                return newElement;
            }

            public File file(String label) {
                File newElement = (File)Tab.this.graph().concept(File.class).createNode(this.name, Tab.this.node()).as(File.class);
                newElement.node().set((Layer)newElement, "label", Collections.singletonList(label));
                return newElement;
            }

            public Picture picture(String label) {
                Picture newElement = (Picture)Tab.this.graph().concept(Picture.class).createNode(this.name, Tab.this.node()).as(Picture.class);
                newElement.node().set((Layer)newElement, "label", Collections.singletonList(label));
                return newElement;
            }

            public Date date(String label) {
                Date newElement = (Date)Tab.this.graph().concept(Date.class).createNode(this.name, Tab.this.node()).as(Date.class);
                newElement.node().set((Layer)newElement, "label", Collections.singletonList(label));
                return newElement;
            }

            public DateTime dateTime(String label) {
                DateTime newElement = (DateTime)Tab.this.graph().concept(DateTime.class).createNode(this.name, Tab.this.node()).as(DateTime.class);
                newElement.node().set((Layer)newElement, "label", Collections.singletonList(label));
                return newElement;
            }
        }
    }

    public class Create
    extends Sensor.Create {
        public Create(String name) {
            super(Dialog.this, name);
        }

        public Tab tab(String label) {
            Tab newElement = (Tab)Dialog.this.graph().concept(Tab.class).createNode(this.name, Dialog.this.node()).as(Tab.class);
            newElement.node().set((Layer)newElement, "label", Collections.singletonList(label));
            return newElement;
        }
    }

    public static enum Mode {
        Tabs,
        Wizard;

    }
}

