/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.server.jms.service;

import java.util.Locale;
import org.siani.itrules.LineSeparator;
import org.siani.itrules.Template;
import org.siani.itrules.model.Condition;
import org.siani.itrules.model.Rule;
import org.siani.itrules.model.Token;

public class JMSRequestTemplate
extends Template {
    protected JMSRequestTemplate(Locale locale, LineSeparator separator) {
        super(locale, separator);
    }

    public static Template create() {
        return new JMSRequestTemplate(Locale.ENGLISH, LineSeparator.LF).define();
    }

    public Template define() {
        this.add(new Rule[]{this.rule().add(new Condition[]{this.condition("type", "request")}).add((Token.Body)this.literal("package ")).add((Token.Body)this.mark("package", new String[0])).add((Token.Body)this.literal(".requests;\n\nimport io.intino.konos.exceptions.*;\nimport ")).add((Token.Body)this.mark("package", new String[0])).add((Token.Body)this.literal(".*;\nimport com.google.gson.Gson;\nimport io.intino.konos.Box;\nimport io.intino.konos.jms.RequestConsumer;\n\nimport javax.jms.*;\nimport java.util.List;\nimport java.util.logging.Level;\nimport java.util.logging.Logger;\n")).add((Token.Body)this.mark("schemaImport", new String[0])).add((Token.Body)this.literal("\n\npublic class ")).add((Token.Body)this.mark("name", new String[]{"firstUpperCase"})).add((Token.Body)this.literal("Request implements RequestConsumer {\n\n\tprivate ")).add((Token.Body)this.mark("box", new String[]{"firstUpperCase"})).add((Token.Body)this.literal("Box box;\n\n\tpublic ")).add((Token.Body)this.mark("name", new String[]{"firstUpperCase"})).add((Token.Body)this.literal("Request(")).add((Token.Body)this.mark("box", new String[]{"firstUpperCase"})).add((Token.Body)this.literal("Box box) {\n\t\tthis.box = box;\n\t}\n\n\tpublic void consume(Session session, Message request) {\n\t\t")).add((Token.Body)this.expression().add((Token.Body)this.mark("exception", new String[]{"try"})).add((Token.Body)this.literal("\n")).add((Token.Body)this.literal("\t\t\t"))).add((Token.Body)this.mark("call", new String[0])).add((Token.Body)this.expression().add((Token.Body)this.literal("\n")).add((Token.Body)this.literal("\t\t")).add((Token.Body)this.mark("exception", new String[]{"catch"}))).add((Token.Body)this.literal("\n\t}\n\n\tprivate ")).add((Token.Body)this.mark("package", new String[0])).add((Token.Body)this.literal(".actions.")).add((Token.Body)this.mark("name", new String[]{"firstUpperCase"})).add((Token.Body)this.literal("Action actionFor(Message message) {\n\t\tfinal ")).add((Token.Body)this.mark("package", new String[0])).add((Token.Body)this.literal(".actions.")).add((Token.Body)this.mark("name", new String[]{"firstUpperCase"})).add((Token.Body)this.literal("Action action = new ")).add((Token.Body)this.mark("package", new String[0])).add((Token.Body)this.literal(".actions.")).add((Token.Body)this.mark("name", new String[]{"firstUpperCase"})).add((Token.Body)this.literal("Action();\n\t\taction.box = this.box;")).add((Token.Body)this.expression().add((Token.Body)this.literal("\n")).add((Token.Body)this.literal("\t\ttry {")).add((Token.Body)this.literal("\n")).add((Token.Body)this.literal("\t\t\t")).add((Token.Body)this.mark("parameter", new String[]{"assign"}).multiple("\n")).add((Token.Body)this.literal("\n")).add((Token.Body)this.literal("\t\t} catch (JMSException e) {")).add((Token.Body)this.literal("\n")).add((Token.Body)this.literal("\t\t\tLogger.getGlobal().log(Level.SEVERE, e.getMessage(), e);")).add((Token.Body)this.literal("\n")).add((Token.Body)this.literal("\t\t}"))).add((Token.Body)this.literal("\n\t\treturn action;\n\t}\n\t")).add((Token.Body)this.expression().add((Token.Body)this.literal("\n")).add((Token.Body)this.literal("\tprivate Message responseMessage(Session session, String responseId, ")).add((Token.Body)this.mark("returnType", new String[0])).add((Token.Body)this.literal(" response) {")).add((Token.Body)this.literal("\n")).add((Token.Body)this.literal("\t\ttry {")).add((Token.Body)this.literal("\n")).add((Token.Body)this.literal("\t\t\t")).add((Token.Body)this.mark("returnMessageType", new String[0])).add((Token.Body)this.literal("Message message = session.create")).add((Token.Body)this.mark("returnMessageType", new String[0])).add((Token.Body)this.literal("Message();")).add((Token.Body)this.literal("\n")).add((Token.Body)this.literal("\t\t\tmessage.setJMSCorrelationID(responseId);")).add((Token.Body)this.literal("\n")).add((Token.Body)this.literal("\t\t\t")).add((Token.Body)this.mark("returnMessageType", new String[]{"return"})).add((Token.Body)this.literal("\n")).add((Token.Body)this.literal("\t\t\treturn message;")).add((Token.Body)this.literal("\n")).add((Token.Body)this.literal("\t\t} catch (JMSException e) {")).add((Token.Body)this.literal("\n")).add((Token.Body)this.literal("\t\t\tLogger.getGlobal().log(Level.SEVERE, e.getMessage(), e);")).add((Token.Body)this.literal("\n")).add((Token.Body)this.literal("\t\t\treturn null;")).add((Token.Body)this.literal("\n")).add((Token.Body)this.literal("\t\t}")).add((Token.Body)this.literal("\n")).add((Token.Body)this.literal("\t}"))).add((Token.Body)this.literal("\n}")), this.rule().add(new Condition[]{this.condition("attribute", "Bytes"), this.condition("trigger", "return")}).add((Token.Body)this.literal("message.writeBytes(toByteArray(response));")), this.rule().add(new Condition[]{this.condition("trigger", "return")}).add((Token.Body)this.literal("message.set")).add((Token.Body)this.mark("value", new String[0])).add((Token.Body)this.literal("(new Gson().toJson(response));")), this.rule().add(new Condition[]{this.not(this.condition("type", "void")), this.condition("trigger", "call")}).add((Token.Body)this.literal("response(session, replyTo(request), responseMessage(session, idOf(request), actionFor(request).execute()));")), this.rule().add(new Condition[]{this.condition("trigger", "call")}).add((Token.Body)this.literal("actionFor(request).execute();")), this.rule().add(new Condition[]{this.condition("trigger", "try")}).add((Token.Body)this.literal("try {")), this.rule().add(new Condition[]{this.condition("trigger", "catch")}).add((Token.Body)this.literal("} catch (KonosException e) {\n\tresponse(session, replyTo(request), exceptionMessage(session, idOf(request), e));\n}")), this.rule().add(new Condition[]{this.condition("type", "parameter & FileData"), this.condition("trigger", "assign")}).add((Token.Body)this.literal("byte[] data = new byte[(int) ((BytesMessage) message).getBodyLength()];\n((BytesMessage) message).readBytes(data);\naction.")).add((Token.Body)this.mark("name", new String[]{"SnakeCaseToCamelCase", "firstLowerCase"})).add((Token.Body)this.literal(" = toInputStream(data);")), this.rule().add(new Condition[]{this.condition("type", "parameter & objectData"), this.condition("trigger", "assign")}).add((Token.Body)this.literal("action.")).add((Token.Body)this.mark("name", new String[]{"SnakeCaseToCamelCase", "firstLowerCase"})).add((Token.Body)this.literal(" = new Gson().fromJson(((TextMessage) message).getText(), ")).add((Token.Body)this.mark("type", new String[0])).add((Token.Body)this.literal(".class);")), this.rule().add(new Condition[]{this.condition("type", "parameter & List"), this.condition("trigger", "assign")}).add((Token.Body)this.literal("action.")).add((Token.Body)this.mark("name", new String[]{"SnakeCaseToCamelCase", "firstLowerCase"})).add((Token.Body)this.literal(" = new Gson().fromJson(message.getStringProperty(\"")).add((Token.Body)this.mark("name", new String[0])).add((Token.Body)this.literal("\"),  new com.google.gson.reflect.TypeToken<java.util.ArrayList<")).add((Token.Body)this.mark("type", new String[0])).add((Token.Body)this.literal(">>(){}.getType());")), this.rule().add(new Condition[]{this.condition("type", "parameter"), this.condition("trigger", "assign")}).add((Token.Body)this.literal("action.")).add((Token.Body)this.mark("name", new String[]{"SnakeCaseToCamelCase", "firstLowerCase"})).add((Token.Body)this.literal(" = message.get")).add((Token.Body)this.mark("type", new String[]{"format"})).add((Token.Body)this.literal("Property(\"")).add((Token.Body)this.mark("name", new String[0])).add((Token.Body)this.literal("\");")), this.rule().add(new Condition[]{this.condition("attribute", "Integer"), this.condition("trigger", "format")}).add((Token.Body)this.literal("Int")), this.rule().add(new Condition[]{this.condition("type", "schemaImport")}).add((Token.Body)this.literal("import ")).add((Token.Body)this.mark("package", new String[0])).add((Token.Body)this.literal(".schemas.*;"))});
        return this;
    }
}

