/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.server.activity.dialog;

import cottons.utils.StringHelper;
import io.intino.konos.builder.codegeneration.server.activity.dialog.DialogDisplayTemplate;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.Dialog;
import io.intino.konos.model.multiple.dialog.tab.MultipleInput;
import io.intino.tara.magritte.Graph;
import java.io.File;
import java.util.List;
import org.siani.itrules.Template;
import org.siani.itrules.model.AbstractFrame;
import org.siani.itrules.model.Frame;

public class DialogDisplayRenderer {
    private static final String DIALOGS = "dialogs";
    private final File gen;
    private final String packageName;
    private final List<Dialog> dialogs;
    private final String boxName;

    public DialogDisplayRenderer(Graph graph, File gen, String packageName, String boxName) {
        this.gen = gen;
        this.packageName = packageName;
        this.dialogs = graph.find(Dialog.class);
        this.boxName = boxName;
    }

    public void execute() {
        this.dialogs.forEach(this::processDialog);
    }

    private void processDialog(Dialog dialog) {
        Frame frame = new Frame().addTypes(new String[]{"dialogDisplay"});
        frame.addSlot("package", new String[]{this.packageName});
        frame.addSlot("name", new String[]{dialog.name()});
        frame.addSlot("box", new String[]{this.boxName});
        String newDialog = StringHelper.snakeCaseToCamelCase((String)(dialog.name() + "DialogDisplay"));
        Frame frameDialog = new Frame().addTypes(new String[]{"dialog"});
        if (!dialog.label().isEmpty()) {
            frameDialog.addSlot("label", new String[]{dialog.label()});
        }
        if (!dialog.description().isEmpty()) {
            frameDialog.addSlot("description", new String[]{dialog.description()});
        }
        frame.addSlot("dialog", new AbstractFrame[]{frameDialog});
        for (Dialog.Tab tab : dialog.tabList()) {
            frameDialog.addSlot("tab", new AbstractFrame[]{this.frameOf(tab)});
        }
        Commons.writeFrame(new File(this.gen, DIALOGS), newDialog, this.template().format((Object)frame));
    }

    private Frame frameOf(Dialog.Tab tab) {
        Frame tabFrame = new Frame().addTypes(new String[]{"tab"});
        if (!tab.name().isEmpty()) {
            tabFrame.addSlot("name", new String[]{tab.name()});
        }
        if (!tab.label().isEmpty()) {
            tabFrame.addSlot("label", new String[]{tab.label()});
        }
        for (Dialog.Tab.Input input : tab.inputList()) {
            this.processInput(tabFrame, input);
        }
        return tabFrame;
    }

    private Frame frameOf(Dialog.Tab.Text text) {
        Frame frame = new Frame().addTypes(new String[]{"text"});
        if (text.edition() != null) {
            frame.addSlot("edition", new Object[]{text.edition()});
        }
        if (text.validation() != null) {
            frame.addSlot("validation", new AbstractFrame[]{this.frameOf(text.validation())});
        }
        this.addCommon(frame, text);
        return frame;
    }

    private Frame frameOf(Dialog.Tab.Text.Validation validation) {
        Frame frame = new Frame().addTypes(new String[]{"text", "validation"});
        if (!validation.allowedValues().isEmpty()) {
            frame.addSlot("allowedValues", validation.allowedValues().toArray(new String[0]));
        }
        if (!validation.disallowedValues().isEmpty()) {
            frame.addSlot("disallowedValues", validation.disallowedValues().toArray(new String[0]));
        }
        frame.addSlot("disallowEmptySpaces", new Boolean[]{validation.disallowEmptySpaces()});
        return frame;
    }

    private Frame frameOf(Dialog.Tab.Section section) {
        Frame frame = new Frame().addTypes(new String[]{"section"});
        if (!section.name().isEmpty()) {
            frame.addSlot("name", new String[]{section.name()});
        }
        if (!section.label().isEmpty()) {
            frame.addSlot("label", new String[]{section.label()});
        }
        List<Dialog.Tab.Input> inputs = section.inputList();
        for (Dialog.Tab.Input input : inputs) {
            this.processInput(frame, input);
        }
        this.addCommon(frame, section);
        return frame;
    }

    private void processInput(Frame sectionFrame, Dialog.Tab.Input input) {
        if (input.is(Dialog.Tab.Text.class)) {
            sectionFrame.addSlot("input", new AbstractFrame[]{this.frameOf((Dialog.Tab.Text)input)});
        } else if (input.is(Dialog.Tab.Section.class)) {
            sectionFrame.addSlot("input", new AbstractFrame[]{this.frameOf((Dialog.Tab.Section)input)});
        } else if (input.is(Dialog.Tab.Memo.class)) {
            sectionFrame.addSlot("input", new AbstractFrame[]{this.frameOf((Dialog.Tab.Memo)input)});
        } else if (input.is(Dialog.Tab.RadioBox.class)) {
            sectionFrame.addSlot("input", new AbstractFrame[]{this.frameOf((Dialog.Tab.RadioBox)input)});
        } else if (input.is(Dialog.Tab.CheckBox.class)) {
            sectionFrame.addSlot("input", new AbstractFrame[]{this.frameOf((Dialog.Tab.CheckBox)input)});
        } else if (input.is(Dialog.Tab.ComboBox.class)) {
            sectionFrame.addSlot("input", new AbstractFrame[]{this.frameOf((Dialog.Tab.ComboBox)input)});
        } else if (input.is(Dialog.Tab.Password.class)) {
            sectionFrame.addSlot("input", new AbstractFrame[]{this.frameOf((Dialog.Tab.Password)input)});
        } else if (input.is(Dialog.Tab.File.class)) {
            sectionFrame.addSlot("input", new AbstractFrame[]{this.frameOf((Dialog.Tab.File)input)});
        } else if (input.is(Dialog.Tab.Picture.class)) {
            sectionFrame.addSlot("input", new AbstractFrame[]{this.frameOf((Dialog.Tab.Picture)input)});
        } else if (input.is(Dialog.Tab.Date.class)) {
            sectionFrame.addSlot("input", new AbstractFrame[]{this.frameOf((Dialog.Tab.Date)input)});
        } else if (input.is(Dialog.Tab.DateTime.class)) {
            sectionFrame.addSlot("input", new AbstractFrame[]{this.frameOf((Dialog.Tab.DateTime)input)});
        }
    }

    private Frame frameOf(Dialog.Tab.Memo memo) {
        Frame frame = new Frame().addTypes(new String[]{"memo"});
        frame.addSlot("mode", new String[]{memo.mode().name()});
        frame.addSlot("height", new Integer[]{memo.height()});
        this.addCommon(frame, memo);
        return frame;
    }

    private Frame frameOf(Dialog.Tab.Password password) {
        Frame frame = new Frame().addTypes(new String[]{"password"});
        if (password.validation() != null) {
            frame.addSlot("validation", new AbstractFrame[]{this.frameOf(password.validation())});
        }
        this.addCommon(frame, password);
        return frame;
    }

    private Frame frameOf(Dialog.Tab.Password.Validation validation) {
        Frame frame = new Frame().addTypes(new String[]{"password", "validation"});
        frame.addSlot("required", (String[])validation.required().stream().map(Enum::name).toArray(String[]::new));
        if (validation.length() != null) {
            frame.addSlot("min", new Integer[]{validation.length().min()}).addSlot("max", new Integer[]{validation.length().max()});
        }
        return frame;
    }

    private Frame frameOf(Dialog.Tab.ComboBox combo) {
        Frame frame = new Frame().addTypes(new String[]{"combo"});
        this.addSources(combo, frame);
        this.addCommon(frame, combo);
        return frame;
    }

    private Frame frameOf(Dialog.Tab.CheckBox check) {
        Frame frame = new Frame().addTypes(new String[]{"check"});
        this.addSources(check, frame);
        this.addCommon(frame, check);
        return frame;
    }

    private Frame frameOf(Dialog.Tab.RadioBox radio) {
        Frame frame = new Frame().addTypes(new String[]{"radio"});
        this.addSources(radio, frame);
        this.addCommon(frame, radio);
        return frame;
    }

    private void addSources(Dialog.Tab.OptionBox comboBox, Frame frame) {
        if (comboBox.source() != null && !comboBox.source().isEmpty()) {
            frame.addSlot("source", new AbstractFrame[]{this.sourceOf(comboBox)});
        } else if (comboBox.options() != null && !comboBox.options().isEmpty()) {
            frame.addSlot("options", comboBox.options().toArray(new String[0]));
        }
    }

    private Frame sourceOf(Dialog.Tab.OptionBox optionBox) {
        return new Frame().addSlot("dialog", new String[]{((Dialog)optionBox.ownerAs(Dialog.class)).name()}).addSlot("name", new String[]{optionBox.source()}).addSlot("type", new String[]{((Object)((Object)optionBox)).getClass().getSimpleName()});
    }

    private Frame frameOf(Dialog.Tab.File file) {
        Frame frame = new Frame().addTypes(new String[]{"file"});
        if (file.validation() != null) {
            frame.addSlot("validation", new AbstractFrame[]{this.frameOf(file.validation())});
        }
        this.addCommon(frame, file);
        return frame;
    }

    private Frame frameOf(Dialog.Tab.Picture picture) {
        Frame frame = new Frame().addTypes(new String[]{"picture"});
        if (picture.validation() != null) {
            frame.addSlot("validation", new AbstractFrame[]{this.frameOf(picture.validation())});
        }
        this.addCommon(frame, picture);
        return frame;
    }

    private AbstractFrame frameOf(Dialog.Tab.Resource.Validation validation) {
        Frame frame = new Frame().addTypes(new String[]{"resource", "validation"});
        if (validation.maxSize() > 0.0) {
            frame.addSlot("maxSize", new Double[]{validation.maxSize()});
        }
        if (!validation.allowedExtensions().isEmpty()) {
            frame.addSlot("allowedExtensions", new Object[]{validation.allowedExtensions()});
        }
        return frame;
    }

    private Frame frameOf(Dialog.Tab.Date date) {
        Frame frame = new Frame().addTypes(new String[]{"date"});
        frame.addSlot("format", new String[]{date.format()});
        this.addCommon(frame, date);
        return frame;
    }

    private Frame frameOf(Dialog.Tab.DateTime dateTime) {
        Frame frame = new Frame().addTypes(new String[]{"dateTime"});
        frame.addSlot("format", new String[]{dateTime.format()});
        this.addCommon(frame, dateTime);
        return frame;
    }

    private void addCommon(Frame frame, Dialog.Tab.Input input) {
        frame.addSlot("owner", new String[]{input.owner().name()});
        frame.addSlot("label", new String[]{input.label()});
        frame.addSlot("readonly", new Boolean[]{input.readonly()});
        frame.addSlot("required", new Boolean[]{input.required()});
        frame.addSlot("placeholder", new String[]{input.placeHolder()});
        frame.addSlot("defaultValue", new String[]{input.defaultValue()});
        if (input.is(MultipleInput.class)) {
            MultipleInput multiple = input.asMultiple();
            frame.addSlot("multiple", new AbstractFrame[]{new Frame().addTypes(new String[]{"multiple"}).addSlot("min", new Integer[]{multiple.min()}).addSlot("max", new Integer[]{multiple.max()})});
        }
        if (input.validator() != null && !input.validator().isEmpty()) {
            frame.addSlot("validator", new AbstractFrame[]{this.validator(input)});
        }
    }

    private Frame validator(Dialog.Tab.Input input) {
        return new Frame().addTypes(new String[]{"validator"}).addSlot("dialog", new String[]{((Dialog)input.ownerAs(Dialog.class)).name()}).addSlot("name", new String[]{input.validator()}).addSlot("type", new String[]{((Object)((Object)input)).getClass().getSimpleName()});
    }

    private Template template() {
        Template template = DialogDisplayTemplate.create();
        this.addFormats(template);
        return template;
    }

    private void addFormats(Template template) {
        template.add("SnakeCaseToCamelCase", value -> StringHelper.snakeCaseToCamelCase((String)value.toString()));
        template.add("ReturnTypeFormatter", value -> value.equals("Void") ? "void" : value);
        template.add("validname", value -> value.toString().replace("-", "").toLowerCase());
    }
}

