/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.model;

import io.intino.konos.model.Data;
import io.intino.konos.model.Konos;
import io.intino.konos.model.bool.BoolData;
import io.intino.konos.model.date.DateData;
import io.intino.konos.model.datetime.DateTimeData;
import io.intino.konos.model.file.FileData;
import io.intino.konos.model.integer.IntegerData;
import io.intino.konos.model.list.ListData;
import io.intino.konos.model.longinteger.LongIntegerData;
import io.intino.konos.model.object.ObjectData;
import io.intino.konos.model.real.RealData;
import io.intino.konos.model.text.TextData;
import io.intino.konos.model.type.TypeData;
import io.intino.tara.magritte.Concept;
import io.intino.tara.magritte.Expression;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.Node;
import io.intino.tara.magritte.loaders.BooleanLoader;
import io.intino.tara.magritte.loaders.NodeLoader;
import io.intino.tara.magritte.tags.Terminal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class Schema
extends Layer
implements Terminal {
    protected boolean required;
    protected boolean multiple;
    protected AttributeMap attributeMap;
    protected List<Attribute> attributeList = new ArrayList<Attribute>();
    protected List<Has> hasList = new ArrayList<Has>();
    protected List<Schema> schemaList = new ArrayList<Schema>();

    public Schema(Node node) {
        super(node);
    }

    public boolean required() {
        return this.required;
    }

    public boolean multiple() {
        return this.multiple;
    }

    public void required(boolean value) {
        this.required = value;
    }

    public void multiple(boolean value) {
        this.multiple = value;
    }

    public AttributeMap attributeMap() {
        return this.attributeMap;
    }

    public List<Attribute> attributeList() {
        return Collections.unmodifiableList(this.attributeList);
    }

    public Attribute attribute(int index) {
        return this.attributeList.get(index);
    }

    public List<Attribute> attributeList(Predicate<Attribute> predicate) {
        return this.attributeList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<Has> hasList() {
        return Collections.unmodifiableList(this.hasList);
    }

    public Has has(int index) {
        return this.hasList.get(index);
    }

    public List<Has> hasList(Predicate<Has> predicate) {
        return this.hasList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<Schema> schemaList() {
        return Collections.unmodifiableList(this.schemaList);
    }

    public Schema schema(int index) {
        return this.schemaList.get(index);
    }

    public List<Schema> schemaList(Predicate<Schema> predicate) {
        return this.schemaList().stream().filter(predicate).collect(Collectors.toList());
    }

    public void attributeMap(AttributeMap value) {
        this.attributeMap = value;
    }

    public List<Node> componentList() {
        LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList());
        if (this.attributeMap != null) {
            components.add(this.attributeMap.node());
        }
        this.attributeList.stream().forEach(c -> components.add(c.node()));
        this.hasList.stream().forEach(c -> components.add(c.node()));
        this.schemaList.stream().forEach(c -> components.add(c.node()));
        return new ArrayList<Node>(components);
    }

    public Map<String, List<?>> variables() {
        LinkedHashMap map = new LinkedHashMap();
        map.put("required", new ArrayList<Boolean>(Collections.singletonList(this.required)));
        map.put("multiple", new ArrayList<Boolean>(Collections.singletonList(this.multiple)));
        return map;
    }

    public Concept concept() {
        return this.graph().concept(Schema.class);
    }

    protected void addNode(Node node) {
        super.addNode(node);
        if (node.is("Schema$AttributeMap")) {
            this.attributeMap = (AttributeMap)node.as(AttributeMap.class);
        }
        if (node.is("Schema$Attribute")) {
            this.attributeList.add((Attribute)node.as(Attribute.class));
        }
        if (node.is("Schema$Has")) {
            this.hasList.add((Has)node.as(Has.class));
        }
        if (node.is("Schema")) {
            this.schemaList.add((Schema)node.as(Schema.class));
        }
    }

    protected void removeNode(Node node) {
        super.removeNode(node);
        if (node.is("Schema$AttributeMap")) {
            this.attributeMap = null;
        }
        if (node.is("Schema$Attribute")) {
            this.attributeList.remove(node.as(Attribute.class));
        }
        if (node.is("Schema$Has")) {
            this.hasList.remove(node.as(Has.class));
        }
        if (node.is("Schema")) {
            this.schemaList.remove(node.as(Schema.class));
        }
    }

    protected void _load(String name, List<?> values) {
        super._load(name, values);
        if (name.equalsIgnoreCase("required")) {
            this.required = (Boolean)BooleanLoader.load(values, (Layer)this).get(0);
        } else if (name.equalsIgnoreCase("multiple")) {
            this.multiple = (Boolean)BooleanLoader.load(values, (Layer)this).get(0);
        }
    }

    protected void _set(String name, List<?> values) {
        super._set(name, values);
        if (name.equalsIgnoreCase("required")) {
            this.required = (Boolean)values.get(0);
        } else if (name.equalsIgnoreCase("multiple")) {
            this.multiple = (Boolean)values.get(0);
        }
    }

    public Create create() {
        return new Create(null);
    }

    public Create create(String name) {
        return new Create(name);
    }

    public Konos konosWrapper() {
        return (Konos)this.graph().wrapper(Konos.class);
    }

    public static class Has
    extends Layer
    implements Terminal {
        protected Schema reference;
        protected boolean required;
        protected boolean multiple;

        public Has(Node node) {
            super(node);
        }

        public Schema reference() {
            return this.reference;
        }

        public boolean required() {
            return this.required;
        }

        public boolean multiple() {
            return this.multiple;
        }

        public void reference(Schema value) {
            this.reference = value;
        }

        public void required(boolean value) {
            this.required = value;
        }

        public void multiple(boolean value) {
            this.multiple = value;
        }

        public Map<String, List<?>> variables() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("reference", this.reference != null ? new ArrayList<Schema>(Collections.singletonList(this.reference)) : Collections.emptyList());
            map.put("required", new ArrayList<Boolean>(Collections.singletonList(this.required)));
            map.put("multiple", new ArrayList<Boolean>(Collections.singletonList(this.multiple)));
            return map;
        }

        public Concept concept() {
            return this.graph().concept(Has.class);
        }

        protected void _load(String name, List<?> values) {
            super._load(name, values);
            if (name.equalsIgnoreCase("reference")) {
                this.reference = (Schema)((Object)NodeLoader.load(values, Schema.class, (Layer)this).get(0));
            } else if (name.equalsIgnoreCase("required")) {
                this.required = (Boolean)BooleanLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("multiple")) {
                this.multiple = (Boolean)BooleanLoader.load(values, (Layer)this).get(0);
            }
        }

        protected void _set(String name, List<?> values) {
            super._set(name, values);
            if (name.equalsIgnoreCase("reference")) {
                this.reference = values.get(0) != null ? (Schema)this.graph().loadNode(((Layer)values.get(0)).id()).as(Schema.class) : null;
            } else if (name.equalsIgnoreCase("required")) {
                this.required = (Boolean)values.get(0);
            } else if (name.equalsIgnoreCase("multiple")) {
                this.multiple = (Boolean)values.get(0);
            }
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Konos konosWrapper() {
            return (Konos)this.graph().wrapper(Konos.class);
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }
        }
    }

    public static class Attribute
    extends Data
    implements Terminal {
        protected boolean required;
        protected boolean multiple;

        public Attribute(Node node) {
            super(node);
        }

        public boolean required() {
            return this.required;
        }

        public boolean multiple() {
            return this.multiple;
        }

        public void required(boolean value) {
            this.required = value;
        }

        public void multiple(boolean value) {
            this.multiple = value;
        }

        @Override
        public IntegerData asInteger() {
            Layer as = this.as(IntegerData.class);
            return as != null ? (IntegerData)as : (IntegerData)this.addFacet(IntegerData.class);
        }

        @Override
        public boolean isInteger() {
            return this.is(IntegerData.class);
        }

        @Override
        public TypeData asType() {
            return (TypeData)this.as(TypeData.class);
        }

        @Override
        public TypeData asType(Expression<String> type) {
            TypeData newElement = (TypeData)this.addFacet(TypeData.class);
            newElement.node().set((Layer)newElement, "type", Collections.singletonList(type));
            return newElement;
        }

        @Override
        public boolean isType() {
            return this.is(TypeData.class);
        }

        @Override
        public void removeType() {
            this.removeFacet(TypeData.class);
        }

        @Override
        public BoolData asBool() {
            Layer as = this.as(BoolData.class);
            return as != null ? (BoolData)as : (BoolData)this.addFacet(BoolData.class);
        }

        @Override
        public boolean isBool() {
            return this.is(BoolData.class);
        }

        @Override
        public RealData asReal() {
            Layer as = this.as(RealData.class);
            return as != null ? (RealData)as : (RealData)this.addFacet(RealData.class);
        }

        @Override
        public boolean isReal() {
            return this.is(RealData.class);
        }

        @Override
        public LongIntegerData asLongInteger() {
            Layer as = this.as(LongIntegerData.class);
            return as != null ? (LongIntegerData)as : (LongIntegerData)this.addFacet(LongIntegerData.class);
        }

        @Override
        public boolean isLongInteger() {
            return this.is(LongIntegerData.class);
        }

        @Override
        public TextData asText() {
            Layer as = this.as(TextData.class);
            return as != null ? (TextData)as : (TextData)this.addFacet(TextData.class);
        }

        @Override
        public boolean isText() {
            return this.is(TextData.class);
        }

        @Override
        public ObjectData asObject() {
            return (ObjectData)this.as(ObjectData.class);
        }

        @Override
        public ObjectData asObject(Schema schema) {
            ObjectData newElement = (ObjectData)this.addFacet(ObjectData.class);
            newElement.node().set((Layer)newElement, "schema", Collections.singletonList(schema));
            return newElement;
        }

        @Override
        public boolean isObject() {
            return this.is(ObjectData.class);
        }

        @Override
        public void removeObject() {
            this.removeFacet(ObjectData.class);
        }

        @Override
        public ListData asList() {
            Layer as = this.as(ListData.class);
            return as != null ? (ListData)as : (ListData)this.addFacet(ListData.class);
        }

        @Override
        public boolean isList() {
            return this.is(ListData.class);
        }

        @Override
        public FileData asFile() {
            Layer as = this.as(FileData.class);
            return as != null ? (FileData)as : (FileData)this.addFacet(FileData.class);
        }

        @Override
        public boolean isFile() {
            return this.is(FileData.class);
        }

        @Override
        public DateData asDate() {
            Layer as = this.as(DateData.class);
            return as != null ? (DateData)as : (DateData)this.addFacet(DateData.class);
        }

        @Override
        public boolean isDate() {
            return this.is(DateData.class);
        }

        @Override
        public DateTimeData asDateTime() {
            Layer as = this.as(DateTimeData.class);
            return as != null ? (DateTimeData)as : (DateTimeData)this.addFacet(DateTimeData.class);
        }

        @Override
        public boolean isDateTime() {
            return this.is(DateTimeData.class);
        }

        @Override
        public Map<String, List<?>> variables() {
            LinkedHashMap map = new LinkedHashMap(super.variables());
            map.put("required", new ArrayList<Boolean>(Collections.singletonList(this.required)));
            map.put("multiple", new ArrayList<Boolean>(Collections.singletonList(this.multiple)));
            return map;
        }

        @Override
        public Concept concept() {
            return this.graph().concept(Attribute.class);
        }

        @Override
        protected void _load(String name, List<?> values) {
            super._load(name, values);
            if (name.equalsIgnoreCase("required")) {
                this.required = (Boolean)BooleanLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("multiple")) {
                this.multiple = (Boolean)BooleanLoader.load(values, (Layer)this).get(0);
            }
        }

        @Override
        protected void _set(String name, List<?> values) {
            super._set(name, values);
            if (name.equalsIgnoreCase("required")) {
                this.required = (Boolean)values.get(0);
            } else if (name.equalsIgnoreCase("multiple")) {
                this.multiple = (Boolean)values.get(0);
            }
        }

        @Override
        public Create create() {
            return new Create(null);
        }

        @Override
        public Create create(String name) {
            return new Create(name);
        }

        @Override
        public Konos konosWrapper() {
            return (Konos)this.graph().wrapper(Konos.class);
        }

        public class Create
        extends Data.Create {
            public Create(String name) {
                super(name);
            }
        }
    }

    public static class AttributeMap
    extends Layer
    implements Terminal {
        public AttributeMap(Node node) {
            super(node);
        }

        public Map<String, List<?>> variables() {
            LinkedHashMap map = new LinkedHashMap();
            return map;
        }

        public Concept concept() {
            return this.graph().concept(AttributeMap.class);
        }

        protected void _load(String name, List<?> values) {
            super._load(name, values);
        }

        protected void _set(String name, List<?> values) {
            super._set(name, values);
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Konos konosWrapper() {
            return (Konos)this.graph().wrapper(Konos.class);
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }
        }
    }

    public class Create {
        protected final String name;

        public Create(String name) {
            this.name = name;
        }

        public AttributeMap attributeMap() {
            AttributeMap newElement = (AttributeMap)Schema.this.graph().concept(AttributeMap.class).createNode(this.name, Schema.this.node()).as(AttributeMap.class);
            return newElement;
        }

        public Attribute attribute() {
            Attribute newElement = (Attribute)Schema.this.graph().concept(Attribute.class).createNode(this.name, Schema.this.node()).as(Attribute.class);
            return newElement;
        }

        public Has has(Schema reference) {
            Has newElement = (Has)Schema.this.graph().concept(Has.class).createNode(this.name, Schema.this.node()).as(Has.class);
            newElement.node().set((Layer)newElement, "reference", Collections.singletonList(reference));
            return newElement;
        }

        public Schema schema() {
            Schema newElement = (Schema)Schema.this.graph().concept(Schema.class).createNode(this.name, Schema.this.node()).as(Schema.class);
            return newElement;
        }
    }
}

