/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.utils;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiFile;
import io.intino.konos.builder.utils.KonosUtils;
import io.intino.konos.model.Konos;
import io.intino.tara.Language;
import io.intino.tara.StashBuilder;
import io.intino.tara.io.Stash;
import io.intino.tara.magritte.Graph;
import java.io.File;
import java.util.List;
import java.util.stream.Collectors;

public class GraphLoader {
    private static final Logger LOG = Logger.getInstance((String)"GraphLoader");

    public static Konos loadGraph(Stash ... stashes) {
        ClassLoader currentLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(GraphLoader.class.getClassLoader());
        Graph graph = Graph.use((Class[])new Class[]{Konos.class}).load(new String[]{"Konos"}).loadStashes(stashes);
        Thread.currentThread().setContextClassLoader(currentLoader);
        return (Konos)graph.wrapper(Konos.class);
    }

    public static Graph loadGraph(Module module) {
        List<PsiFile> konosFiles = KonosUtils.findKonosFiles(module);
        if (!konosFiles.isEmpty()) {
            Stash stash = new StashBuilder(konosFiles.stream().map(pf -> new File(pf.getVirtualFile().getPath())).collect(Collectors.toList()), (Language)new tara.dsl.Konos(), module.getName()).build();
            if (stash == null) {
                return null;
            }
            return GraphLoader.loadGraph(stash).graph();
        }
        return GraphLoader.loadGraph(new Stash[0]).graph();
    }
}

