/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration;

import com.intellij.openapi.module.Module;
import io.intino.konos.builder.codegeneration.AbstractBoxTemplate;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.Activity;
import io.intino.konos.model.Konos;
import io.intino.konos.model.jms.JMSService;
import io.intino.konos.model.jmx.JMXService;
import io.intino.konos.model.rest.RESTService;
import io.intino.konos.model.slackbot.SlackBotService;
import io.intino.tara.compiler.shared.Configuration;
import io.intino.tara.magritte.Graph;
import io.intino.tara.plugin.lang.psi.impl.TaraUtil;
import java.io.File;
import java.util.List;
import org.siani.itrules.Template;
import org.siani.itrules.model.AbstractFrame;
import org.siani.itrules.model.Frame;

public class AbstractBoxRenderer {
    private final File gen;
    private final String packageName;
    private final Module module;
    private final Konos konos;
    private final Configuration configuration;
    private String parent;
    private final boolean hasModel;

    public AbstractBoxRenderer(Graph graph, File gen, String packageName, Module module, String parent, boolean hasModel) {
        this.konos = (Konos)graph.wrapper(Konos.class);
        this.gen = gen;
        this.packageName = packageName;
        this.module = module;
        this.configuration = module != null ? TaraUtil.configurationOf((Module)module) : null;
        this.parent = parent;
        this.hasModel = hasModel;
    }

    public void execute() {
        Frame frame = new Frame().addTypes(new String[]{"box"});
        String name = this.name();
        frame.addSlot("name", new String[]{name});
        frame.addSlot("package", new String[]{this.packageName});
        if (this.hasModel) {
            frame.addSlot("tara", new String[]{name});
        }
        this.parent(frame);
        this.services(frame, name);
        this.tasks(frame, name);
        this.dataLake(frame, name);
        this.activities(frame, name);
        Commons.writeFrame(this.gen, "AbstractBox", this.template().format((Object)frame));
    }

    private void activities(Frame frame, String name) {
        List<Activity> activities = this.konos.activityList();
        if (!activities.isEmpty()) {
            frame.addSlot("hasActivity", new String[]{""});
        }
        for (Activity activity : activities) {
            frame.addSlot("activity", new AbstractFrame[]{this.activityFrame(activity, name)});
        }
    }

    private void tasks(Frame frame, String name) {
        if (!this.konos.taskList().isEmpty()) {
            frame.addSlot("task", new AbstractFrame[]{new Frame().addTypes(new String[]{"task"}).addSlot("configuration", new String[]{name})});
        }
    }

    private void dataLake(Frame frame, String name) {
        if (this.konos.dataLake() != null) {
            frame.addSlot("dataLake", new AbstractFrame[]{new Frame().addTypes(new String[]{"dataLake"}).addSlot("name", new String[]{this.konos.dataLake().name()}).addSlot("package", new String[]{this.packageName}).addSlot("configuration", new String[]{name})});
        }
    }

    private void services(Frame frame, String name) {
        if (!this.konos.jMSServiceList().isEmpty()) {
            frame.addSlot("jms", new String[]{""});
        }
        for (RESTService rESTService : this.konos.rESTServiceList()) {
            frame.addSlot("service", new AbstractFrame[]{new Frame().addTypes(new String[]{"service", "rest"}).addSlot("name", new String[]{rESTService.name()}).addSlot("configuration", new String[]{name})});
        }
        for (JMSService jMSService : this.konos.jMSServiceList()) {
            frame.addSlot("service", new AbstractFrame[]{new Frame().addTypes(new String[]{"service", "jms"}).addSlot("name", new String[]{jMSService.name()}).addSlot("configuration", new String[]{name})});
        }
        for (JMXService jMXService : this.konos.jMXServiceList()) {
            frame.addSlot("service", new AbstractFrame[]{new Frame().addTypes(new String[]{"service", "jmx"}).addSlot("name", new String[]{jMXService.name()}).addSlot("configuration", new String[]{name})});
        }
        for (SlackBotService slackBotService : this.konos.slackBotServiceList()) {
            frame.addSlot("service", new AbstractFrame[]{new Frame().addTypes(new String[]{"service", "slack"}).addSlot("name", new String[]{slackBotService.name()}).addSlot("configuration", new String[]{name})});
        }
    }

    private void parent(Frame frame) {
        if (this.parent != null && this.configuration != null && !Configuration.Level.Platform.equals((Object)this.configuration.level())) {
            frame.addSlot("parent", new String[]{this.parent}).addSlot("hasParent", new String[]{""});
        } else {
            frame.addSlot("hasntParent", new String[]{""});
        }
    }

    private Frame activityFrame(Activity activity, String name) {
        Frame frame = new Frame();
        frame.addTypes(new String[]{"activity"}).addSlot("name", new String[]{activity.name()}).addSlot("configuration", new String[]{name});
        return frame;
    }

    private String name() {
        if (this.module != null) {
            String dsl = this.configuration.outDSL();
            if (dsl == null || dsl.isEmpty()) {
                return this.module.getName();
            }
            return dsl;
        }
        return "System";
    }

    private Template template() {
        return Formatters.customize(AbstractBoxTemplate.create());
    }
}

