/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.services.rest;

import com.intellij.platform.templates.github.ZipUtil;
import cottons.utils.StringHelper;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.services.rest.RESTServiceTemplate;
import io.intino.konos.builder.codegeneration.swagger.IndexTemplate;
import io.intino.konos.builder.codegeneration.swagger.SwaggerGenerator;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.rest.RESTService;
import io.intino.tara.magritte.Graph;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.zip.ZipInputStream;
import org.siani.itrules.Template;
import org.siani.itrules.model.AbstractFrame;
import org.siani.itrules.model.Frame;

public class RESTServiceRenderer {
    private final List<RESTService> services;
    private final File gen;
    private final File res;
    private String packageName;
    private final String boxName;

    public RESTServiceRenderer(Graph graph, File gen, File res, String packageName, String boxName) {
        this.services = graph.find(RESTService.class);
        this.gen = gen;
        this.res = res;
        this.packageName = packageName;
        this.boxName = boxName;
    }

    public void execute() {
        this.services.forEach(service -> this.processService((RESTService)service.as(RESTService.class), this.gen));
        if (!this.services.isEmpty()) {
            this.generateDoc();
        }
    }

    private void generateDoc() {
        File www = new File(this.res, "www" + File.separator + "developer");
        SwaggerGenerator generator = new SwaggerGenerator(this.services, www);
        generator.execute();
        this.createIndex(www);
        this.copyAssets(www);
    }

    private void copyAssets(File www) {
        try {
            ZipUtil.unzip(null, (File)www, (ZipInputStream)new ZipInputStream(this.getClass().getResourceAsStream("/swagger/assets.zip")), null, null, (boolean)false);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void createIndex(File www) {
        Frame doc = new Frame().addTypes(new String[]{"index"});
        for (RESTService service : this.services) {
            doc.addSlot("service", new AbstractFrame[]{new Frame().addTypes(new String[]{"service"}).addSlot("name", new String[]{service.name()}).addSlot("description", new String[]{service.description()})});
        }
        try {
            Files.write(new File(www, "index.html").toPath(), IndexTemplate.create().format((Object)doc).getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void processService(RESTService service, File gen) {
        if (service.resourceList().isEmpty()) {
            return;
        }
        Frame frame = new Frame().addTypes(new String[]{"server"}).addSlot("name", new String[]{service.name()}).addSlot("box", new String[]{this.boxName}).addSlot("package", new String[]{this.packageName}).addSlot("resource", (AbstractFrame[])this.processResources(service.resourceList()));
        RESTService.AuthenticatedWithCertificate secure = service.authenticatedWithCertificate();
        if (secure != null && secure.store() != null) {
            frame.addSlot("secure", new AbstractFrame[]{new Frame().addTypes(new String[]{"secure"}).addSlot("file", new String[]{secure.store().getPath()}).addSlot("password", new String[]{secure.storePassword()})});
        }
        Commons.writeFrame(gen, StringHelper.snakeCaseToCamelCase((String)service.name()) + "Resources", this.template().format((Object)frame));
    }

    private Frame[] processResources(List<RESTService.Resource> resources) {
        ArrayList<Frame> list = new ArrayList<Frame>();
        for (RESTService.Resource resource : resources) {
            list.addAll(this.processResource(resource, resource.operationList()));
        }
        return list.toArray(new Frame[list.size()]);
    }

    private List<Frame> processResource(RESTService.Resource resource, List<RESTService.Resource.Operation> operations) {
        return operations.stream().map(operation -> new Frame().addTypes(new String[]{"resource", operation.concept().name()}).addSlot("name", new String[]{resource.name()}).addSlot("operation", new String[]{operation.concept().name()}).addSlot("path", new AbstractFrame[]{this.customize(Commons.path(resource))}).addSlot("method", new String[]{operation.concept().name()})).collect(Collectors.toList());
    }

    private Frame customize(String path) {
        Frame frame = new Frame().addTypes(new String[]{"path"});
        frame.addSlot("name", new String[]{path});
        for (String parameter : Commons.extractParameters(path)) {
            frame.addSlot("custom", new String[]{parameter});
        }
        return frame;
    }

    private Template template() {
        return Formatters.customize(RESTServiceTemplate.create());
    }
}

