/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.model;

import io.intino.konos.model.Component;
import io.intino.konos.model.Data;
import io.intino.konos.model.Exception;
import io.intino.konos.model.Konos;
import io.intino.konos.model.Schema;
import io.intino.konos.model.bool.BoolData;
import io.intino.konos.model.date.DateData;
import io.intino.konos.model.datetime.DateTimeData;
import io.intino.konos.model.file.FileData;
import io.intino.konos.model.integer.IntegerData;
import io.intino.konos.model.list.ListData;
import io.intino.konos.model.longinteger.LongIntegerData;
import io.intino.konos.model.object.ObjectData;
import io.intino.konos.model.real.RealData;
import io.intino.konos.model.rules.ExceptionCodes;
import io.intino.konos.model.text.TextData;
import io.intino.konos.model.type.TypeData;
import io.intino.tara.magritte.Concept;
import io.intino.tara.magritte.Expression;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.Node;
import io.intino.tara.magritte.loaders.NodeLoader;
import io.intino.tara.magritte.loaders.WordLoader;
import io.intino.tara.magritte.tags.Terminal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class Display
extends Component
implements Terminal {
    protected List<Display> displays = new ArrayList<Display>();
    protected List<Request> requestList = new ArrayList<Request>();
    protected List<Notification> notificationList = new ArrayList<Notification>();

    public Display(Node node) {
        super(node);
    }

    public List<Display> displays() {
        return this.displays;
    }

    public Display displays(int index) {
        return this.displays.get(index);
    }

    public List<Display> displays(Predicate<Display> predicate) {
        return this.displays().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<Request> requestList() {
        return Collections.unmodifiableList(this.requestList);
    }

    public Request request(int index) {
        return this.requestList.get(index);
    }

    public List<Request> requestList(Predicate<Request> predicate) {
        return this.requestList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<Notification> notificationList() {
        return Collections.unmodifiableList(this.notificationList);
    }

    public Notification notification(int index) {
        return this.notificationList.get(index);
    }

    public List<Notification> notificationList(Predicate<Notification> predicate) {
        return this.notificationList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<Node> componentList() {
        LinkedHashSet components = new LinkedHashSet(super.componentList());
        this.requestList.stream().forEach(c -> components.add(c.node()));
        this.notificationList.stream().forEach(c -> components.add(c.node()));
        return new ArrayList<Node>(components);
    }

    @Override
    public Map<String, List<?>> variables() {
        LinkedHashMap map = new LinkedHashMap(super.variables());
        map.put("displays", this.displays);
        return map;
    }

    @Override
    public Concept concept() {
        return this.graph().concept(Display.class);
    }

    protected void addNode(Node node) {
        super.addNode(node);
        if (node.is("Display$Request")) {
            this.requestList.add((Request)node.as(Request.class));
        }
        if (node.is("Display$Notification")) {
            this.notificationList.add((Notification)node.as(Notification.class));
        }
    }

    protected void removeNode(Node node) {
        super.removeNode(node);
        if (node.is("Display$Request")) {
            this.requestList.remove(node.as(Request.class));
        }
        if (node.is("Display$Notification")) {
            this.notificationList.remove(node.as(Notification.class));
        }
    }

    @Override
    protected void _load(String name, List<?> values) {
        super._load(name, values);
        if (name.equalsIgnoreCase("displays")) {
            this.displays = NodeLoader.load(values, Display.class, (Layer)this);
        }
    }

    @Override
    protected void _set(String name, List<?> values) {
        super._set(name, values);
        if (name.equalsIgnoreCase("displays")) {
            this.displays = values.stream().map(s -> (Display)this.graph().loadNode(((Layer)s).id()).as(Display.class)).collect(Collectors.toList());
        }
    }

    @Override
    public Create create() {
        return new Create(null);
    }

    @Override
    public Create create(String name) {
        return new Create(name);
    }

    @Override
    public Konos konosWrapper() {
        return (Konos)this.graph().wrapper(Konos.class);
    }

    public static class Notification
    extends Data
    implements Terminal {
        protected To to;
        protected List<Exception> exceptionRefs = new ArrayList<Exception>();
        protected List<Exception> exceptionList = new ArrayList<Exception>();

        public Notification(Node node) {
            super(node);
        }

        public To to() {
            return this.to;
        }

        public List<Exception> exceptionRefs() {
            return this.exceptionRefs;
        }

        public Exception exceptionRefs(int index) {
            return this.exceptionRefs.get(index);
        }

        public List<Exception> exceptionRefs(Predicate<Exception> predicate) {
            return this.exceptionRefs().stream().filter(predicate).collect(Collectors.toList());
        }

        public void to(To value) {
            this.to = value;
        }

        public List<Exception> exceptionList() {
            return Collections.unmodifiableList(this.exceptionList);
        }

        public Exception exception(int index) {
            return this.exceptionList.get(index);
        }

        public List<Exception> exceptionList(Predicate<Exception> predicate) {
            return this.exceptionList().stream().filter(predicate).collect(Collectors.toList());
        }

        @Override
        public IntegerData asInteger() {
            Layer as = this.as(IntegerData.class);
            return as != null ? (IntegerData)as : (IntegerData)this.addFacet(IntegerData.class);
        }

        @Override
        public boolean isInteger() {
            return this.is(IntegerData.class);
        }

        @Override
        public TypeData asType() {
            return (TypeData)this.as(TypeData.class);
        }

        @Override
        public TypeData asType(Expression<String> type) {
            TypeData newElement = (TypeData)this.addFacet(TypeData.class);
            newElement.node().set((Layer)newElement, "type", Collections.singletonList(type));
            return newElement;
        }

        @Override
        public boolean isType() {
            return this.is(TypeData.class);
        }

        @Override
        public void removeType() {
            this.removeFacet(TypeData.class);
        }

        @Override
        public BoolData asBool() {
            Layer as = this.as(BoolData.class);
            return as != null ? (BoolData)as : (BoolData)this.addFacet(BoolData.class);
        }

        @Override
        public boolean isBool() {
            return this.is(BoolData.class);
        }

        @Override
        public RealData asReal() {
            Layer as = this.as(RealData.class);
            return as != null ? (RealData)as : (RealData)this.addFacet(RealData.class);
        }

        @Override
        public boolean isReal() {
            return this.is(RealData.class);
        }

        @Override
        public LongIntegerData asLongInteger() {
            Layer as = this.as(LongIntegerData.class);
            return as != null ? (LongIntegerData)as : (LongIntegerData)this.addFacet(LongIntegerData.class);
        }

        @Override
        public boolean isLongInteger() {
            return this.is(LongIntegerData.class);
        }

        @Override
        public TextData asText() {
            Layer as = this.as(TextData.class);
            return as != null ? (TextData)as : (TextData)this.addFacet(TextData.class);
        }

        @Override
        public boolean isText() {
            return this.is(TextData.class);
        }

        @Override
        public ObjectData asObject() {
            return (ObjectData)this.as(ObjectData.class);
        }

        @Override
        public ObjectData asObject(Schema schema) {
            ObjectData newElement = (ObjectData)this.addFacet(ObjectData.class);
            newElement.node().set((Layer)newElement, "schema", Collections.singletonList(schema));
            return newElement;
        }

        @Override
        public boolean isObject() {
            return this.is(ObjectData.class);
        }

        @Override
        public void removeObject() {
            this.removeFacet(ObjectData.class);
        }

        @Override
        public ListData asList() {
            Layer as = this.as(ListData.class);
            return as != null ? (ListData)as : (ListData)this.addFacet(ListData.class);
        }

        @Override
        public boolean isList() {
            return this.is(ListData.class);
        }

        @Override
        public FileData asFile() {
            Layer as = this.as(FileData.class);
            return as != null ? (FileData)as : (FileData)this.addFacet(FileData.class);
        }

        @Override
        public boolean isFile() {
            return this.is(FileData.class);
        }

        @Override
        public DateData asDate() {
            Layer as = this.as(DateData.class);
            return as != null ? (DateData)as : (DateData)this.addFacet(DateData.class);
        }

        @Override
        public boolean isDate() {
            return this.is(DateData.class);
        }

        @Override
        public DateTimeData asDateTime() {
            Layer as = this.as(DateTimeData.class);
            return as != null ? (DateTimeData)as : (DateTimeData)this.addFacet(DateTimeData.class);
        }

        @Override
        public boolean isDateTime() {
            return this.is(DateTimeData.class);
        }

        public List<Node> componentList() {
            LinkedHashSet components = new LinkedHashSet(super.componentList());
            this.exceptionList.stream().forEach(c -> components.add(c.node()));
            return new ArrayList<Node>(components);
        }

        @Override
        public Map<String, List<?>> variables() {
            LinkedHashMap map = new LinkedHashMap(super.variables());
            map.put("to", new ArrayList<To>(Collections.singletonList(this.to)));
            map.put("exceptionRefs", this.exceptionRefs);
            return map;
        }

        @Override
        public Concept concept() {
            return this.graph().concept(Notification.class);
        }

        protected void addNode(Node node) {
            super.addNode(node);
            if (node.is("Exception")) {
                this.exceptionList.add((Exception)node.as(Exception.class));
            }
        }

        protected void removeNode(Node node) {
            super.removeNode(node);
            if (node.is("Exception")) {
                this.exceptionList.remove(node.as(Exception.class));
            }
        }

        @Override
        protected void _load(String name, List<?> values) {
            super._load(name, values);
            if (name.equalsIgnoreCase("to")) {
                this.to = (To)((Object)WordLoader.load(values, To.class, (Layer)this).get(0));
            } else if (name.equalsIgnoreCase("exceptionRefs")) {
                this.exceptionRefs = NodeLoader.load(values, Exception.class, (Layer)this);
            }
        }

        @Override
        protected void _set(String name, List<?> values) {
            super._set(name, values);
            if (name.equalsIgnoreCase("to")) {
                this.to = (To)((Object)values.get(0));
            } else if (name.equalsIgnoreCase("exceptionRefs")) {
                this.exceptionRefs = values.stream().map(s -> (Exception)this.graph().loadNode(((Layer)s).id()).as(Exception.class)).collect(Collectors.toList());
            }
        }

        @Override
        public Create create() {
            return new Create(null);
        }

        @Override
        public Create create(String name) {
            return new Create(name);
        }

        @Override
        public Konos konosWrapper() {
            return (Konos)this.graph().wrapper(Konos.class);
        }

        public class Create
        extends Data.Create {
            public Create(String name) {
                super(name);
            }

            public Exception exception(ExceptionCodes code) {
                Exception newElement = (Exception)Notification.this.graph().concept(Exception.class).createNode(this.name, Notification.this.node()).as(Exception.class);
                newElement.node().set((Layer)newElement, "code", Collections.singletonList(code));
                return newElement;
            }
        }

        public static enum To {
            All,
            Client,
            Display;

        }
    }

    public static class Request
    extends Data
    implements Terminal {
        protected ResponseType responseType;
        protected List<Exception> exceptionRefs = new ArrayList<Exception>();
        protected List<Exception> exceptionList = new ArrayList<Exception>();

        public Request(Node node) {
            super(node);
        }

        public ResponseType responseType() {
            return this.responseType;
        }

        public List<Exception> exceptionRefs() {
            return this.exceptionRefs;
        }

        public Exception exceptionRefs(int index) {
            return this.exceptionRefs.get(index);
        }

        public List<Exception> exceptionRefs(Predicate<Exception> predicate) {
            return this.exceptionRefs().stream().filter(predicate).collect(Collectors.toList());
        }

        public void responseType(ResponseType value) {
            this.responseType = value;
        }

        public List<Exception> exceptionList() {
            return Collections.unmodifiableList(this.exceptionList);
        }

        public Exception exception(int index) {
            return this.exceptionList.get(index);
        }

        public List<Exception> exceptionList(Predicate<Exception> predicate) {
            return this.exceptionList().stream().filter(predicate).collect(Collectors.toList());
        }

        @Override
        public IntegerData asInteger() {
            Layer as = this.as(IntegerData.class);
            return as != null ? (IntegerData)as : (IntegerData)this.addFacet(IntegerData.class);
        }

        @Override
        public boolean isInteger() {
            return this.is(IntegerData.class);
        }

        @Override
        public TypeData asType() {
            return (TypeData)this.as(TypeData.class);
        }

        @Override
        public TypeData asType(Expression<String> type) {
            TypeData newElement = (TypeData)this.addFacet(TypeData.class);
            newElement.node().set((Layer)newElement, "type", Collections.singletonList(type));
            return newElement;
        }

        @Override
        public boolean isType() {
            return this.is(TypeData.class);
        }

        @Override
        public void removeType() {
            this.removeFacet(TypeData.class);
        }

        @Override
        public BoolData asBool() {
            Layer as = this.as(BoolData.class);
            return as != null ? (BoolData)as : (BoolData)this.addFacet(BoolData.class);
        }

        @Override
        public boolean isBool() {
            return this.is(BoolData.class);
        }

        @Override
        public RealData asReal() {
            Layer as = this.as(RealData.class);
            return as != null ? (RealData)as : (RealData)this.addFacet(RealData.class);
        }

        @Override
        public boolean isReal() {
            return this.is(RealData.class);
        }

        @Override
        public LongIntegerData asLongInteger() {
            Layer as = this.as(LongIntegerData.class);
            return as != null ? (LongIntegerData)as : (LongIntegerData)this.addFacet(LongIntegerData.class);
        }

        @Override
        public boolean isLongInteger() {
            return this.is(LongIntegerData.class);
        }

        @Override
        public TextData asText() {
            Layer as = this.as(TextData.class);
            return as != null ? (TextData)as : (TextData)this.addFacet(TextData.class);
        }

        @Override
        public boolean isText() {
            return this.is(TextData.class);
        }

        @Override
        public ObjectData asObject() {
            return (ObjectData)this.as(ObjectData.class);
        }

        @Override
        public ObjectData asObject(Schema schema) {
            ObjectData newElement = (ObjectData)this.addFacet(ObjectData.class);
            newElement.node().set((Layer)newElement, "schema", Collections.singletonList(schema));
            return newElement;
        }

        @Override
        public boolean isObject() {
            return this.is(ObjectData.class);
        }

        @Override
        public void removeObject() {
            this.removeFacet(ObjectData.class);
        }

        @Override
        public ListData asList() {
            Layer as = this.as(ListData.class);
            return as != null ? (ListData)as : (ListData)this.addFacet(ListData.class);
        }

        @Override
        public boolean isList() {
            return this.is(ListData.class);
        }

        @Override
        public FileData asFile() {
            Layer as = this.as(FileData.class);
            return as != null ? (FileData)as : (FileData)this.addFacet(FileData.class);
        }

        @Override
        public boolean isFile() {
            return this.is(FileData.class);
        }

        @Override
        public DateData asDate() {
            Layer as = this.as(DateData.class);
            return as != null ? (DateData)as : (DateData)this.addFacet(DateData.class);
        }

        @Override
        public boolean isDate() {
            return this.is(DateData.class);
        }

        @Override
        public DateTimeData asDateTime() {
            Layer as = this.as(DateTimeData.class);
            return as != null ? (DateTimeData)as : (DateTimeData)this.addFacet(DateTimeData.class);
        }

        @Override
        public boolean isDateTime() {
            return this.is(DateTimeData.class);
        }

        public List<Node> componentList() {
            LinkedHashSet components = new LinkedHashSet(super.componentList());
            this.exceptionList.stream().forEach(c -> components.add(c.node()));
            return new ArrayList<Node>(components);
        }

        @Override
        public Map<String, List<?>> variables() {
            LinkedHashMap map = new LinkedHashMap(super.variables());
            map.put("responseType", new ArrayList<ResponseType>(Collections.singletonList(this.responseType)));
            map.put("exceptionRefs", this.exceptionRefs);
            return map;
        }

        @Override
        public Concept concept() {
            return this.graph().concept(Request.class);
        }

        protected void addNode(Node node) {
            super.addNode(node);
            if (node.is("Exception")) {
                this.exceptionList.add((Exception)node.as(Exception.class));
            }
        }

        protected void removeNode(Node node) {
            super.removeNode(node);
            if (node.is("Exception")) {
                this.exceptionList.remove(node.as(Exception.class));
            }
        }

        @Override
        protected void _load(String name, List<?> values) {
            super._load(name, values);
            if (name.equalsIgnoreCase("responseType")) {
                this.responseType = (ResponseType)((Object)WordLoader.load(values, ResponseType.class, (Layer)this).get(0));
            } else if (name.equalsIgnoreCase("exceptionRefs")) {
                this.exceptionRefs = NodeLoader.load(values, Exception.class, (Layer)this);
            }
        }

        @Override
        protected void _set(String name, List<?> values) {
            super._set(name, values);
            if (name.equalsIgnoreCase("responseType")) {
                this.responseType = (ResponseType)((Object)values.get(0));
            } else if (name.equalsIgnoreCase("exceptionRefs")) {
                this.exceptionRefs = values.stream().map(s -> (Exception)this.graph().loadNode(((Layer)s).id()).as(Exception.class)).collect(Collectors.toList());
            }
        }

        @Override
        public Create create() {
            return new Create(null);
        }

        @Override
        public Create create(String name) {
            return new Create(name);
        }

        @Override
        public Konos konosWrapper() {
            return (Konos)this.graph().wrapper(Konos.class);
        }

        public class Create
        extends Data.Create {
            public Create(String name) {
                super(name);
            }

            public Exception exception(ExceptionCodes code) {
                Exception newElement = (Exception)Request.this.graph().concept(Exception.class).createNode(this.name, Request.this.node()).as(Exception.class);
                newElement.node().set((Layer)newElement, "code", Collections.singletonList(code));
                return newElement;
            }
        }

        public static enum ResponseType {
            Asset,
            Void;

        }
    }

    public class Create
    extends Component.Create {
        public Create(String name) {
            super(name);
        }

        public Request request() {
            Request newElement = (Request)Display.this.graph().concept(Request.class).createNode(this.name, Display.this.node()).as(Request.class);
            return newElement;
        }

        public Notification notification() {
            Notification newElement = (Notification)Display.this.graph().concept(Notification.class).createNode(this.name, Display.this.node()).as(Notification.class);
            return newElement;
        }
    }
}

