/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.server.activity.dialog;

import cottons.utils.StringHelper;
import io.intino.konos.builder.codegeneration.server.activity.dialog.DialogDisplayTemplate;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.Dialog;
import io.intino.konos.model.multiple.dialog.tab.MultipleInput;
import io.intino.tara.magritte.Graph;
import java.io.File;
import java.util.List;
import org.siani.itrules.Template;
import org.siani.itrules.model.AbstractFrame;
import org.siani.itrules.model.Frame;

public class DialogDisplayRenderer {
    private static final String DIALOGS = "dialogs";
    private final File gen;
    private final String packageName;
    private final List<Dialog> dialogs;
    private final String boxName;

    public DialogDisplayRenderer(Graph graph, File gen, String packageName, String boxName) {
        this.gen = gen;
        this.packageName = packageName;
        this.dialogs = graph.find(Dialog.class);
        this.boxName = boxName;
    }

    public void execute() {
        this.dialogs.forEach(this::processDialog);
    }

    private void processDialog(Dialog dialog) {
        Frame frame = new Frame().addTypes(new String[]{"dialogDisplay"});
        frame.addSlot("package", new String[]{this.packageName});
        frame.addSlot("name", new String[]{dialog.name()});
        frame.addSlot("box", new String[]{this.boxName});
        String newDialog = StringHelper.snakeCaseToCamelCase((String)(dialog.name() + "DialogDisplay"));
        Frame frameDialog = new Frame().addTypes(new String[]{"dialog"});
        if (!dialog.label().isEmpty()) {
            frameDialog.addSlot("label", new String[]{dialog.label()});
        }
        if (!dialog.description().isEmpty()) {
            frameDialog.addSlot("description", new String[]{dialog.description()});
        }
        frame.addSlot("dialog", new AbstractFrame[]{frameDialog});
        for (Dialog.Tab tab : dialog.tabList()) {
            frameDialog.addSlot("tab", new AbstractFrame[]{this.frameOf(tab)});
        }
        Commons.writeFrame(new File(this.gen, DIALOGS), newDialog, this.template().format((Object)frame));
    }

    private Frame frameOf(Dialog.Tab tab) {
        Frame tabFrame = new Frame().addTypes(new String[]{"tab"});
        if (!tab.name().isEmpty()) {
            tabFrame.addSlot("name", new String[]{tab.name()});
        }
        if (!tab.label().isEmpty()) {
            tabFrame.addSlot("label", new String[]{tab.label()});
        }
        for (Dialog.Tab.Text text : tab.textList()) {
            tabFrame.addSlot("text", new AbstractFrame[]{this.frameOf(text)});
        }
        for (Dialog.Tab.Section section : tab.sectionList()) {
            tabFrame.addSlot("section", new AbstractFrame[]{this.frameOf(section)});
        }
        for (Dialog.Tab.Memo memo : tab.memoList()) {
            tabFrame.addSlot("memo", new AbstractFrame[]{this.frameOf(memo)});
        }
        for (Dialog.Tab.RadioBox radio : tab.radioBoxList()) {
            tabFrame.addSlot("radio", new AbstractFrame[]{this.frameOf(radio)});
        }
        for (Dialog.Tab.CheckBox check : tab.checkBoxList()) {
            tabFrame.addSlot("check", new AbstractFrame[]{this.frameOf(check)});
        }
        for (Dialog.Tab.ComboBox combo : tab.comboBoxList()) {
            tabFrame.addSlot("combo", new AbstractFrame[]{this.frameOf(combo)});
        }
        for (Dialog.Tab.Password password : tab.passwordList()) {
            tabFrame.addSlot("password", new AbstractFrame[]{this.frameOf(password)});
        }
        for (Dialog.Tab.File file : tab.fileList()) {
            tabFrame.addSlot("file", new AbstractFrame[]{this.frameOf(file)});
        }
        for (Dialog.Tab.Picture picture : tab.pictureList()) {
            tabFrame.addSlot("picture", new AbstractFrame[]{this.frameOf(picture)});
        }
        for (Dialog.Tab.Date date : tab.dateList()) {
            tabFrame.addSlot("date", new AbstractFrame[]{this.frameOf(date)});
        }
        for (Dialog.Tab.DateTime dateTime : tab.dateTimeList()) {
            tabFrame.addSlot("dateTime", new AbstractFrame[]{this.frameOf(dateTime)});
        }
        return tabFrame;
    }

    private Frame frameOf(Dialog.Tab.Text text) {
        Frame frame = new Frame().addTypes(new String[]{"text"});
        if (text.edition() != null) {
            frame.addSlot("edition", new Object[]{text.edition()});
        }
        if (text.validation() != null) {
            frame.addSlot("validation", new AbstractFrame[]{this.frameOf(text.validation())});
        }
        this.addCommon(frame, text);
        return frame;
    }

    private Frame frameOf(Dialog.Tab.Text.Validation validation) {
        Frame frame = new Frame().addTypes(new String[]{"text", "validation"});
        if (!validation.allowedValues().isEmpty()) {
            frame.addSlot("allowedValues", validation.allowedValues().toArray(new String[0]));
        }
        if (!validation.disallowedValues().isEmpty()) {
            frame.addSlot("disallowedValues", validation.disallowedValues().toArray(new String[0]));
        }
        frame.addSlot("disallowEmptySpaces", new Boolean[]{validation.disallowEmptySpaces()});
        return frame;
    }

    private Frame frameOf(Dialog.Tab.Section section) {
        Frame sectionFrame = new Frame().addTypes(new String[]{"section"});
        if (!section.name().isEmpty()) {
            sectionFrame.addSlot("name", new String[]{section.name()});
        }
        if (!section.label().isEmpty()) {
            sectionFrame.addSlot("label", new String[]{section.label()});
        }
        List<Dialog.Tab.Input> inputs = section.inputList();
        inputs.stream().filter(i -> i.is(Dialog.Tab.Text.class)).map(i -> (Dialog.Tab.Text)i.as(Dialog.Tab.Text.class)).forEach(i -> sectionFrame.addSlot("text", new AbstractFrame[]{this.frameOf((Dialog.Tab.Text)((Object)i))}));
        inputs.stream().filter(i -> i.is(Dialog.Tab.Section.class)).map(i -> (Dialog.Tab.Section)i.as(Dialog.Tab.Section.class)).forEach(i -> sectionFrame.addSlot("section", new AbstractFrame[]{this.frameOf((Dialog.Tab.Section)((Object)i))}));
        inputs.stream().filter(i -> i.is(Dialog.Tab.Memo.class)).map(i -> (Dialog.Tab.Memo)i.as(Dialog.Tab.Memo.class)).forEach(i -> sectionFrame.addSlot("memo", new AbstractFrame[]{this.frameOf((Dialog.Tab.Memo)((Object)i))}));
        inputs.stream().filter(i -> i.is(Dialog.Tab.RadioBox.class)).map(i -> (Dialog.Tab.RadioBox)i.as(Dialog.Tab.RadioBox.class)).forEach(i -> sectionFrame.addSlot("radio", new AbstractFrame[]{this.frameOf((Dialog.Tab.RadioBox)((Object)i))}));
        inputs.stream().filter(i -> i.is(Dialog.Tab.CheckBox.class)).map(i -> (Dialog.Tab.CheckBox)i.as(Dialog.Tab.CheckBox.class)).forEach(i -> sectionFrame.addSlot("check", new AbstractFrame[]{this.frameOf((Dialog.Tab.CheckBox)((Object)i))}));
        inputs.stream().filter(i -> i.is(Dialog.Tab.ComboBox.class)).map(i -> (Dialog.Tab.ComboBox)i.as(Dialog.Tab.ComboBox.class)).forEach(i -> sectionFrame.addSlot("combo", new AbstractFrame[]{this.frameOf((Dialog.Tab.ComboBox)((Object)i))}));
        inputs.stream().filter(i -> i.is(Dialog.Tab.Password.class)).map(i -> (Dialog.Tab.Password)i.as(Dialog.Tab.Password.class)).forEach(i -> sectionFrame.addSlot("password", new AbstractFrame[]{this.frameOf((Dialog.Tab.Password)((Object)i))}));
        inputs.stream().filter(i -> i.is(Dialog.Tab.File.class)).map(i -> (Dialog.Tab.File)i.as(Dialog.Tab.File.class)).forEach(i -> sectionFrame.addSlot("file", new AbstractFrame[]{this.frameOf((Dialog.Tab.File)((Object)i))}));
        inputs.stream().filter(i -> i.is(Dialog.Tab.Picture.class)).map(i -> (Dialog.Tab.Picture)i.as(Dialog.Tab.Picture.class)).forEach(i -> sectionFrame.addSlot("picture", new AbstractFrame[]{this.frameOf((Dialog.Tab.Picture)((Object)i))}));
        inputs.stream().filter(i -> i.is(Dialog.Tab.Date.class)).map(i -> (Dialog.Tab.Date)i.as(Dialog.Tab.Date.class)).forEach(i -> sectionFrame.addSlot("date", new AbstractFrame[]{this.frameOf((Dialog.Tab.Date)((Object)i))}));
        inputs.stream().filter(i -> i.is(Dialog.Tab.DateTime.class)).map(i -> (Dialog.Tab.DateTime)i.as(Dialog.Tab.DateTime.class)).forEach(i -> sectionFrame.addSlot("dateTime", new AbstractFrame[]{this.frameOf((Dialog.Tab.DateTime)((Object)i))}));
        this.addCommon(sectionFrame, section);
        return sectionFrame;
    }

    private Frame frameOf(Dialog.Tab.Memo memo) {
        Frame frame = new Frame().addTypes(new String[]{"memo"});
        frame.addSlot("mode", new String[]{memo.mode().name()});
        frame.addSlot("height", new Integer[]{memo.height()});
        this.addCommon(frame, memo);
        return frame;
    }

    private Frame frameOf(Dialog.Tab.Password password) {
        Frame frame = new Frame().addTypes(new String[]{"password"});
        if (password.validation() != null) {
            frame.addSlot("validation", new AbstractFrame[]{this.frameOf(password.validation())});
        }
        this.addCommon(frame, password);
        return frame;
    }

    private Frame frameOf(Dialog.Tab.Password.Validation validation) {
        Frame frame = new Frame().addTypes(new String[]{"password", "validation"});
        frame.addSlot("required", (String[])validation.required().stream().map(Enum::name).toArray(String[]::new));
        if (validation.length() != null) {
            frame.addSlot("min", new Integer[]{validation.length().min()}).addSlot("max", new Integer[]{validation.length().max()});
        }
        return frame;
    }

    private Frame frameOf(Dialog.Tab.ComboBox combo) {
        Frame frame = new Frame().addTypes(new String[]{"combo"});
        this.addSources(combo, frame);
        this.addCommon(frame, combo);
        return frame;
    }

    private Frame frameOf(Dialog.Tab.CheckBox check) {
        Frame frame = new Frame().addTypes(new String[]{"check"});
        this.addSources(check, frame);
        this.addCommon(frame, check);
        return frame;
    }

    private Frame frameOf(Dialog.Tab.RadioBox radio) {
        Frame frame = new Frame().addTypes(new String[]{"radio"});
        this.addSources(radio, frame);
        this.addCommon(frame, radio);
        return frame;
    }

    private void addSources(Dialog.Tab.OptionBox comboBox, Frame frame) {
        if (comboBox.source() != null && !comboBox.source().isEmpty()) {
            frame.addSlot("source", new AbstractFrame[]{this.sourceOf(comboBox)});
        } else if (comboBox.options() != null && !comboBox.options().isEmpty()) {
            frame.addSlot("options", comboBox.options().toArray(new String[0]));
        }
    }

    private Frame sourceOf(Dialog.Tab.OptionBox optionBox) {
        return new Frame().addSlot("dialog", new String[]{((Dialog)optionBox.ownerAs(Dialog.class)).name()}).addSlot("name", new String[]{optionBox.source()}).addSlot("type", new String[]{((Object)((Object)optionBox)).getClass().getSimpleName()});
    }

    private Frame frameOf(Dialog.Tab.File file) {
        Frame frame = new Frame().addTypes(new String[]{"file"});
        if (file.validation() != null) {
            frame.addSlot("validation", new AbstractFrame[]{this.frameOf(file.validation())});
        }
        this.addCommon(frame, file);
        return frame;
    }

    private Frame frameOf(Dialog.Tab.Picture picture) {
        Frame frame = new Frame().addTypes(new String[]{"picture"});
        if (picture.validation() != null) {
            frame.addSlot("validation", new AbstractFrame[]{this.frameOf(picture.validation())});
        }
        this.addCommon(frame, picture);
        return frame;
    }

    private AbstractFrame frameOf(Dialog.Tab.Resource.Validation validation) {
        Frame frame = new Frame().addTypes(new String[]{"resource", "validation"});
        if (validation.maxSize() > 0.0) {
            frame.addSlot("maxSize", new Double[]{validation.maxSize()});
        }
        if (!validation.allowedExtensions().isEmpty()) {
            frame.addSlot("allowedExtensions", new Object[]{validation.allowedExtensions()});
        }
        return frame;
    }

    private Frame frameOf(Dialog.Tab.Date date) {
        Frame frame = new Frame().addTypes(new String[]{"date"});
        frame.addSlot("format", new String[]{date.format()});
        this.addCommon(frame, date);
        return frame;
    }

    private Frame frameOf(Dialog.Tab.DateTime dateTime) {
        Frame frame = new Frame().addTypes(new String[]{"dateTime"});
        frame.addSlot("format", new String[]{dateTime.format()});
        this.addCommon(frame, dateTime);
        return frame;
    }

    private void addCommon(Frame frame, Dialog.Tab.Input input) {
        frame.addSlot("owner", new String[]{input.owner().name()});
        frame.addSlot("label", new String[]{input.label()});
        frame.addSlot("readonly", new Boolean[]{input.readonly()});
        frame.addSlot("required", new Boolean[]{input.required()});
        frame.addSlot("placeholder", new String[]{input.placeHolder()});
        frame.addSlot("defaultValue", new String[]{input.defaultValue()});
        if (input.is(MultipleInput.class)) {
            MultipleInput multiple = input.asMultiple();
            frame.addSlot("multiple", new AbstractFrame[]{new Frame().addTypes(new String[]{"multiple"}).addSlot("min", new Integer[]{multiple.min()}).addSlot("max", new Integer[]{multiple.max()})});
        }
        if (input.validator() != null && !input.validator().isEmpty()) {
            frame.addSlot("validator", new AbstractFrame[]{this.validator(input)});
        }
    }

    private Frame validator(Dialog.Tab.Input input) {
        return new Frame().addTypes(new String[]{"validator"}).addSlot("dialog", new String[]{((Dialog)input.ownerAs(Dialog.class)).name()}).addSlot("name", new String[]{input.validator()}).addSlot("type", new String[]{((Object)((Object)input)).getClass().getSimpleName()});
    }

    private Template template() {
        Template template = DialogDisplayTemplate.create();
        this.addFormats(template);
        return template;
    }

    private void addFormats(Template template) {
        template.add("SnakeCaseToCamelCase", value -> StringHelper.snakeCaseToCamelCase((String)value.toString()));
        template.add("ReturnTypeFormatter", value -> value.equals("Void") ? "void" : value);
        template.add("validname", value -> value.toString().replace("-", "").toLowerCase());
    }
}

