/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.action;

import com.intellij.openapi.project.Project;
import io.intino.konos.builder.codegeneration.action.ActionRenderer;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.Activity;
import io.intino.konos.model.Dialog;
import io.intino.konos.model.Display;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.siani.itrules.model.AbstractFrame;
import org.siani.itrules.model.Frame;

public class UIActionRenderer
extends ActionRenderer {
    private final Activity.AbstractPage page;

    public UIActionRenderer(Project project, Activity.AbstractPage page, File src, String packageName, String boxName) {
        super(project, src, packageName, boxName);
        this.page = page;
    }

    public void execute() {
        Frame frame = new Frame().addTypes(new String[]{"action", "page"});
        frame.addSlot("name", new String[]{this.page.name()});
        frame.addSlot("activity", new String[]{((Activity)this.page.ownerAs(Activity.class)).name()});
        frame.addSlot("package", new String[]{this.packageName});
        frame.addSlot("box", new String[]{this.boxName});
        if (this.page.uses().is(Dialog.class)) {
            frame.addSlot("importDialogs", new String[]{this.packageName});
        } else {
            frame.addSlot("importDisplays", new String[]{this.packageName});
        }
        frame.addSlot("ui", new String[]{this.page.uses().name() + (this.page.uses().is(Dialog.class) ? Dialog.class.getSimpleName() : Display.class.getSimpleName())});
        frame.addSlot("parameter", (AbstractFrame[])this.parameters());
        if (!this.alreadyRendered(this.destiny, this.page.name())) {
            Commons.writeFrame(this.destinyPackage(this.destiny), this.page.name() + "Action", this.template().format((Object)frame));
        }
    }

    private Frame[] parameters() {
        List parameters = this.page.paths().stream().filter(path -> path.contains(":")).map(Commons::extractUrlPathParameters).flatMap(Collection::stream).collect(Collectors.toList());
        return parameters.stream().map(parameter -> new Frame().addTypes(new String[]{"parameter"}).addSlot("type", new String[]{"String"}).addSlot("name", new String[]{parameter})).collect(Collectors.toList()).toArray(new Frame[0]);
    }
}

