/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.accessor.ui.android;

import io.intino.konos.builder.codegeneration.accessor.ui.android.AndroidRendererWriter;
import io.intino.konos.builder.codegeneration.accessor.ui.android.DisplaysManifestRenderer;
import io.intino.konos.builder.codegeneration.accessor.ui.android.ThemeRenderer;
import io.intino.konos.builder.codegeneration.accessor.ui.android.resource.ResourceListRenderer;
import io.intino.konos.builder.codegeneration.ui.UIRenderer;
import io.intino.konos.builder.codegeneration.ui.displays.DisplayListRenderer;
import io.intino.konos.builder.context.CompilationContext;
import io.intino.konos.builder.context.KonosException;
import io.intino.konos.model.Component;
import io.intino.konos.model.PassiveView;
import io.intino.konos.model.Service;
import io.intino.magritte.framework.Layer;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class ServiceRenderer
extends UIRenderer {
    private final Service.UI service;
    private static final Set<String> FormatSet = Collections.synchronizedSet(new HashSet());

    public ServiceRenderer(CompilationContext compilationContext, Service.UI service) {
        super(compilationContext);
        this.service = service;
    }

    @Override
    public void render() throws KonosException {
        new DisplayListRenderer(this.context, this.service, new AndroidRendererWriter(this.context)).execute();
        new DisplaysManifestRenderer(this.context, this.service).execute();
        new ResourceListRenderer(this.context, this.service).execute();
        new ThemeRenderer(this.context, this.service, this.usedFormats()).execute();
    }

    private Set<String> usedFormats() {
        this.service.graph().rootDisplays(this.context.graphName()).forEach(this::registerFormats);
        return FormatSet;
    }

    private void registerFormats(PassiveView display) {
        this.components(display).forEach(this::registerFormats);
        if (!display.i$(Component.class)) {
            return;
        }
        Component component = (Component)display.a$(Component.class);
        if (component.format() == null) {
            return;
        }
        CharSequence[] format = (String[])component.format().stream().map(Layer::name$).sorted().toArray(String[]::new);
        if (format.length == 0) {
            return;
        }
        FormatSet.add(String.join((CharSequence)"-", format));
    }
}

