/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration;

import io.intino.alexandria.logger.Logger;
import io.intino.konos.builder.codegeneration.AbstractBoxRenderer;
import io.intino.konos.builder.codegeneration.BoxConfigurationRenderer;
import io.intino.konos.builder.codegeneration.BoxRenderer;
import io.intino.konos.builder.codegeneration.accessor.PomGenerator;
import io.intino.konos.builder.codegeneration.accessor.analytic.AnalyticBuilderRenderer;
import io.intino.konos.builder.codegeneration.accessor.messaging.MessagingAccessorRenderer;
import io.intino.konos.builder.codegeneration.accessor.rest.RESTAccessorRenderer;
import io.intino.konos.builder.codegeneration.accessor.ui.android.AndroidSchemaWriter;
import io.intino.konos.builder.codegeneration.accessor.ui.web.ServiceListRenderer;
import io.intino.konos.builder.codegeneration.analytic.AnalyticRenderer;
import io.intino.konos.builder.codegeneration.bpm.BpmRenderer;
import io.intino.konos.builder.codegeneration.datahub.mounter.MounterFactoryRenderer;
import io.intino.konos.builder.codegeneration.datahub.mounter.MounterRenderer;
import io.intino.konos.builder.codegeneration.datahub.subscriber.SubscriberRenderer;
import io.intino.konos.builder.codegeneration.exception.ExceptionRenderer;
import io.intino.konos.builder.codegeneration.main.MainRenderer;
import io.intino.konos.builder.codegeneration.schema.SchemaListRenderer;
import io.intino.konos.builder.codegeneration.sentinel.ListenerRenderer;
import io.intino.konos.builder.codegeneration.sentinel.SentinelsRenderer;
import io.intino.konos.builder.codegeneration.services.agenda.AgendaServiceRenderer;
import io.intino.konos.builder.codegeneration.services.cli.CliRenderer;
import io.intino.konos.builder.codegeneration.services.jmx.JMXOperationsServiceRenderer;
import io.intino.konos.builder.codegeneration.services.jmx.JMXServerRenderer;
import io.intino.konos.builder.codegeneration.services.messaging.MessagingRequestRenderer;
import io.intino.konos.builder.codegeneration.services.messaging.MessagingServiceRenderer;
import io.intino.konos.builder.codegeneration.services.rest.RESTResourceRenderer;
import io.intino.konos.builder.codegeneration.services.rest.RESTServiceRenderer;
import io.intino.konos.builder.codegeneration.services.slack.SlackRenderer;
import io.intino.konos.builder.codegeneration.services.soap.SoapOperationRenderer;
import io.intino.konos.builder.codegeneration.services.soap.SoapServiceRenderer;
import io.intino.konos.builder.codegeneration.ui.displays.components.ComponentRenderer;
import io.intino.konos.builder.context.CompilationContext;
import io.intino.konos.builder.context.KonosException;
import io.intino.konos.compiler.shared.KonosBuildConstants;
import io.intino.konos.model.KonosGraph;
import io.intino.konos.model.Service;
import java.io.File;

public class FullRenderer {
    private final KonosGraph graph;
    private final CompilationContext context;
    private final boolean hasModel;

    public FullRenderer(KonosGraph graph, CompilationContext context) {
        this.graph = graph;
        this.context = context;
        this.hasModel = this.hasModel();
    }

    public void execute() throws KonosException {
        this.render();
    }

    private void render() throws KonosException {
        try {
            if (this.context.mode().equals((Object)KonosBuildConstants.Mode.Normal)) {
                this.agendas();
                this.schemas();
                this.exceptions();
                this.rest();
                this.soap();
                this.tasks();
                this.jmx();
                this.jms();
                this.subscribers();
                this.mounters();
                this.processes();
                this.analytic();
                this.slack();
                this.cli();
                this.box();
                this.mainClass();
                this.ui();
                this.context.saveCache();
            } else if (this.context.mode().equals((Object)KonosBuildConstants.Mode.OnlyElements)) {
                this.ui();
            } else {
                this.accessors();
            }
        }
        catch (Throwable e) {
            Logger.error((Throwable)e);
            throw new KonosException(e.getMessage(), e);
        }
    }

    private void analytic() throws KonosException {
        new AnalyticRenderer(this.context, this.graph).execute();
    }

    private void accessors() throws KonosException {
        File dir;
        PomGenerator pomGenerator = new PomGenerator(this.context);
        for (Service.REST rest : this.graph.restServiceList()) {
            dir = this.genDirectory(this.context.configuration().genDirectory(), "rest#", rest.name$());
            new RESTAccessorRenderer(this.context, rest, dir).render();
            pomGenerator.generate("rest", dir);
        }
        for (Service.Messaging service : this.graph.messagingServiceList()) {
            dir = this.genDirectory(this.context.configuration().genDirectory(), "messaging#", service.name$());
            new MessagingAccessorRenderer(this.context, service, dir).render();
            pomGenerator.generate("messaging", dir);
        }
        if (!this.graph.cubeList().isEmpty()) {
            File dir2 = this.analyticBasePath();
            new AnalyticBuilderRenderer(this.context, this.graph, new File(dir2, "src"), new File(this.analyticBasePath(), "res")).render();
            pomGenerator.generate("analytic", dir2);
        }
        this.androidClient();
    }

    private File analyticBasePath() {
        return new File(this.context.configuration().genDirectory(), "analytic#analytic");
    }

    private File genDirectory(File tempDirectory, String serviceType, String serviceName) {
        return new File(tempDirectory, serviceType + serviceName + File.separator + "src");
    }

    private void schemas() throws KonosException {
        new SchemaListRenderer(this.context, this.graph).execute();
    }

    private void exceptions() throws KonosException {
        new ExceptionRenderer(this.context, this.graph).execute();
    }

    private void rest() throws KonosException {
        new RESTResourceRenderer(this.context, this.graph).execute();
        new RESTServiceRenderer(this.context, this.graph).execute();
    }

    private void soap() throws KonosException {
        new SoapOperationRenderer(this.context, this.graph).execute();
        new SoapServiceRenderer(this.context, this.graph).execute();
    }

    private void jmx() throws KonosException {
        new JMXOperationsServiceRenderer(this.context, this.graph).execute();
        new JMXServerRenderer(this.context, this.graph).execute();
    }

    private void jms() throws KonosException {
        new MessagingRequestRenderer(this.context, this.graph).execute();
        new MessagingServiceRenderer(this.context, this.graph).execute();
    }

    private void tasks() throws KonosException {
        new ListenerRenderer(this.context, this.graph).execute();
        new SentinelsRenderer(this.context, this.graph).execute();
    }

    private void agendas() throws KonosException {
        new AgendaServiceRenderer(this.context, this.graph).execute();
    }

    private void mounters() throws KonosException {
        new MounterFactoryRenderer(this.context, this.graph).execute();
        new MounterRenderer(this.context, this.graph).execute();
    }

    private void subscribers() throws KonosException {
        new SubscriberRenderer(this.context, this.graph).execute();
    }

    private void processes() throws KonosException {
        new BpmRenderer(this.context, this.graph).execute();
    }

    private void slack() throws KonosException {
        new SlackRenderer(this.context, this.graph).execute();
    }

    private void cli() throws KonosException {
        new CliRenderer(this.context, this.graph).execute();
    }

    private void ui() throws KonosException {
        if (this.context.mode() == KonosBuildConstants.Mode.Normal) {
            this.uiServer();
        }
        this.webClient();
    }

    private void uiServer() throws KonosException {
        new io.intino.konos.builder.codegeneration.services.ui.ServiceListRenderer(this.context, this.graph).execute();
    }

    private void webClient() throws KonosException {
        ComponentRenderer.clearCache();
        new ServiceListRenderer(this.context, this.graph).execute();
        ComponentRenderer.clearCache();
    }

    private void androidClient() throws KonosException {
        ComponentRenderer.clearCache();
        new io.intino.konos.builder.codegeneration.accessor.ui.android.ServiceListRenderer(this.context, this.graph, service -> this.context.configuration().genDirectory()).execute();
        AndroidSchemaWriter schemaWriter = new AndroidSchemaWriter(this.context);
        new SchemaListRenderer(this.context, this.graph, schemaWriter.destination(), schemaWriter.packageName(), schemaWriter).execute();
        ComponentRenderer.clearCache();
    }

    private void box() throws KonosException {
        AbstractBoxRenderer renderer = new AbstractBoxRenderer(this.context, this.graph);
        renderer.execute();
        new BoxRenderer(this.context, this.graph, this.hasModel).execute();
        new BoxConfigurationRenderer(this.context, this.hasModel, renderer.customParameters()).execute();
    }

    private void mainClass() {
        new MainRenderer(this.context, this.hasModel, this.graph).execute();
    }

    private boolean hasModel() {
        return this.context.configuration().model() != null && this.context.configuration().model().language() != null;
    }
}

