/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.model.rules;

import io.intino.tara.language.model.EmptyMogram;
import io.intino.tara.language.model.Mogram;
import io.intino.tara.language.model.Parameter;
import io.intino.tara.language.model.rules.NodeRule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class CheckPath
implements NodeRule {
    private Cause cause;

    public boolean accept(Mogram mogram) {
        return !this.pathIsWrong(mogram);
    }

    private boolean pathIsWrong(Mogram mogram) {
        if (this.parameter(mogram, "path") == null) {
            return false;
        }
        if (this.parameter(mogram, "path").values().get(0) instanceof EmptyMogram) {
            this.cause = Cause.NullPath;
            return true;
        }
        return this.pathIsWrong((String)this.parameter(mogram, "path").values().get(0), mogram);
    }

    private boolean pathIsWrong(String pathValue, Mogram mogram) {
        if (mogram == null) {
            return false;
        }
        List parametersInPath = Arrays.stream(pathValue.split("/")).filter(s -> s.startsWith(":")).map(s -> s.substring(1)).collect(Collectors.toList());
        List<String> parametersDeclaredInPath = this.pathParametersFromMogram(mogram);
        parametersDeclaredInPath.addAll(this.pathParametersInMethods(mogram.components()));
        for (String parameterName : parametersInPath) {
            if (parametersDeclaredInPath.contains(parameterName)) continue;
            this.cause = Cause.ParameterNotDeclared;
            return true;
        }
        for (String parameterName : parametersDeclaredInPath) {
            if (parametersInPath.contains(parameterName)) continue;
            this.cause = Cause.ParameterNotInPath;
            return true;
        }
        return false;
    }

    private List<String> pathParametersFromMogram(Mogram node) {
        return node.components().stream().filter(c -> this.isParameter((Mogram)c) && this.parameterIsInPath((Mogram)c)).map(Mogram::name).collect(Collectors.toList());
    }

    private List<String> pathParametersInMethods(List<Mogram> methods) {
        ArrayList<String> parameters = new ArrayList<String>();
        for (Mogram component : methods) {
            parameters.addAll(this.pathParametersFromMogram(component));
        }
        return parameters;
    }

    private boolean parameterIsInPath(Mogram node) {
        return "path".equals(this.parameter(node, "in").values().get(0).toString());
    }

    private Parameter parameter(Mogram node, String name) {
        return node.parameters().stream().filter(v -> v.name().equals(name)).findFirst().orElse(null);
    }

    private boolean isParameter(Mogram component) {
        return component.type().equals("Service.REST.Resource.Parameter");
    }

    public String errorMessage() {
        if (this.cause == Cause.NullPath) {
            return "Path cannot be empty";
        }
        if (this.cause == Cause.ParameterNotDeclared) {
            return "Parameters in path must be declared as \"Parameter\"";
        }
        return "Declared parameter is not visible in resource's path";
    }

    static enum Cause {
        NullPath,
        ParameterNotDeclared,
        ParameterNotInPath;

    }
}

