/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.analytic;

import io.intino.itrules.Rule;
import io.intino.itrules.RuleSet;
import io.intino.itrules.Template;

public class VirtualCubeTemplate
extends Template {
    public RuleSet ruleSet() {
        return new RuleSet().add(new Rule[]{this.rule().condition(this.allTypes(new String[]{"cube", "src"}), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("package ")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".analytic.cubes;\n\nimport io.intino.alexandria.Timetag;\nimport io.intino.alexandria.led.buffers.store.ByteStore;\n\nimport ")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".analytic.Axis;\nimport ")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".analytic.axes.*;\n\nimport java.io.File;\nimport java.util.*;\nimport java.util.stream.Collectors;\nimport java.util.function.Predicate;\n\npublic class ")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(" extends Abstract")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(" {\n\n\tpublic ")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("(List<Loader> loaders) {\n\t\tsuper(loaders);\n\t}\n\n\tpublic static long ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("Id(")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(".Fact fact) {\n\t\treturn fact.id();//TODO\n\t}\n\n\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("customDimension", new String[]{"staticMethod"}).multiple("\n\n")})}).output(new Rule.Output[]{this.literal("\n\n\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("customFilter", new String[]{"staticMethod"}).multiple("\n\n")})}).output(new Rule.Output[]{this.literal("\n\n\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("customIndicator", new String[]{"staticMethod"}).multiple("\n\n")})}).output(new Rule.Output[]{this.literal("\n\n\t@Override\n\tpublic ")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(" execute() {\n\t\tsuper.execute();\n\t\treturn this;\n\t}\n\n\tpublic static long idOf(")}).output(new Rule.Output[]{this.mark("mainCube", new String[]{"idOf"})}).output(new Rule.Output[]{this.literal(") {\n\t\treturn ")}).output(new Rule.Output[]{this.mark("mainCube", new String[0])}).output(new Rule.Output[]{this.literal(".id(); //TODO\n\t}\n\n\tpublic static class Loader extends Abstract")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(".Loader {\n\n\t\tpublic static List<Loader> create(File root, Timetag from, Timetag to, Collection<String> divisions) {\n\t\t\treturn divisions.stream().map(d -> new Loader(new Loader.Datasource(root, from, to), d)).collect(Collectors.toList());\n\t\t}\n\n\n\t\tpublic Loader(Datasource datasource")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.literal(", ")}).output(new Rule.Output[]{this.mark("split", new String[]{"parameter"})})}).output(new Rule.Output[]{this.literal(") {\n\t\t\tsuper(datasource")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.literal(", ")}).output(new Rule.Output[]{this.mark("split", new String[]{"name"})})}).output(new Rule.Output[]{this.literal(");\n\t\t}\n\n\t\t// TODO write here a cache if necessary\n\t}\n\n\tpublic static class Aggregation extends Abstract")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(".AbstractAggregation {\n\n\t\tpublic Aggregation(Timetag timetag, List<Axis.Component> components, Map<Axis, Predicate<Fact>> filters) {\n\t\t\tsuper(timetag, components, filters);\n\t\t}\n\n\t\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("customIndicator", new String[]{"implementation"}).multiple("\n\n")})}).output(new Rule.Output[]{this.literal("\n\t}\n}")}), this.rule().condition(this.trigger("idof"), new Rule.Condition[0]).output(new Rule.Output[]{this.mark("", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(".Fact ")}).output(new Rule.Output[]{this.mark("", new String[]{"firstLowerCase"})}), this.rule().condition(this.type("cube"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("package ")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".analytic.cubes;\n\nimport io.intino.alexandria.Timetag;\nimport io.intino.alexandria.led.LedReader;\nimport io.intino.alexandria.led.LedStream;\nimport io.intino.alexandria.led.Schema;\nimport io.intino.alexandria.led.buffers.store.ByteStore;\nimport io.intino.alexandria.led.util.iterators.MergedIterator;\nimport io.intino.alexandria.led.util.iterators.StatefulIterator;\nimport io.intino.alexandria.led.util.collections.SparseLongList;\n\nimport ")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".analytic.axes.*;\nimport ")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".analytic.Axis;\n\nimport java.io.File;\nimport java.util.*;\nimport java.util.stream.Collectors;\nimport java.util.function.Function;\nimport java.util.function.Predicate;\nimport java.util.stream.Stream;\nimport java.util.stream.StreamSupport;\n\nimport static java.util.Comparator.comparingLong;\nimport static java.util.Spliterators.spliteratorUnknownSize;\nimport ")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".analytic.cubes.")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(".Aggregation;\n\npublic abstract class Abstract")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(" implements Iterable<")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(".Aggregation> {\n\n\tpublic static final Fact NULL_FACT = new NullFact();\n\n\tprivate final List<? extends Loader> loaders;\n\tprivate Predicate<Fact> filter = fact -> true;\n\tprivate final List<Axis> axes = new ArrayList<>();\n\tprivate final Map<Axis, Set<Axis.Component>> components = new HashMap<>();\n\tprivate final List<Function<Fact, ? extends Axis.Component>> groupByList = new ArrayList<>();\n\tprivate final Map<Axis, Predicate<Fact>> filters = new LinkedHashMap<>();\n\tprivate Aggregation[] result;\n\n\tpublic Abstract")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("(List<? extends Loader> loaders) {\n\t\tthis.loaders = loaders;\n\t}\n\n\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("dimension", new String[]{"method"}).multiple("\n\n")})}).output(new Rule.Output[]{this.literal("\n\n\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("customDimension", new String[]{"method"}).multiple("\n\n")})}).output(new Rule.Output[]{this.literal("\n\n\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("customFilter", new String[]{"method"}).multiple("\n\n")})}).output(new Rule.Output[]{this.literal("\n\n\tpublic Abstract")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(" groupBy(Axis axis) {\n\t\tif(axis == null) throw new NullPointerException(\"Axis cannot be null\");\n\t\tswitch(axis.getTitle()) {\n\t\t\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("dimension", new String[]{"switchCaseGroupBy"}).multiple("\n")})}).output(new Rule.Output[]{this.literal("\n\t\t}\n\t\treturn this;\n\t}\n\n\t@SuppressWarnings(\"unchecked\")\n\tpublic Abstract")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(" filter(Axis axis, Set<? extends Axis.Component> components) {\n\t\tif(axis == null) throw new NullPointerException(\"Axis cannot be null\");\n\t\tswitch(axis.getTitle()) {\n\t\t\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("dimension", new String[]{"switchCaseFilterBy"}).multiple("\n")})}).output(new Rule.Output[]{this.literal("\n\t\t}\n\t\treturn this;\n\t}\n\n\tpublic Abstract")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal(" execute() {\n\t\tresult = new Aggregation[resultsSize()];\n\t\tresults().forEach(this::append);\n\t\tfillCategories();\n\t\tcalculateTotals();\n\n\t\treturn this;\n\t}\n\n\tpublic Aggregation[] result() {\n\t\tif(result == null) return new Aggregation[0];\n\t\treturn Arrays.stream(result).filter(java.util.Objects::nonNull).toArray(Aggregation[]::new);\n\t}\n\n\t@Override\n\tpublic Iterator<Aggregation> iterator() {\n\t\treturn result == null\n\t\t\t? Stream.<Aggregation>empty().iterator()\n\t\t\t: Arrays.stream(result).filter(java.util.Objects::nonNull).iterator();\n\t}\n\n\tpublic static List<Axis> dimensions() {\n\t\treturn List.of(")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("dimension", new String[]{"getInstance"}).multiple(", ")})}).output(new Rule.Output[]{this.literal(");\n\t}\n\n\tpublic boolean contains(Axis axis, Axis.Component component) {\n\t\tif(!components.containsKey(axis)) return false;\n\t\treturn components.get(axis).contains(component);\n\t}\n\n\tpublic Iterator<Fact> detail() {\n\t\tMergedIterator<Fact> iterator = new MergedIterator<>(loaders.stream().map(Iterable::iterator), comparingLong(Fact::id));\n\t\treturn StreamSupport.stream(spliteratorUnknownSize(iterator, Spliterator.SORTED), false).filter(this::check).iterator();\n\t}\n\n\tpublic Aggregation aggregation(List<Axis.Component> components) {\n\t\tif(result == null || result.length == 0) return null;\n\t\tfinal int index = indexOf(components);\n\t\treturn result[index];\n\t}\n\n\tpublic Aggregation aggregation(Axis.Component... components) {\n\t\tif(result == null || result.length == 0) return null;\n\t\tfinal int index = indexOf(components);\n\t\treturn result[index];\n\t}\n\n\tprivate void fillCategories() {\n\t\tfor (Aggregation aggregation : result) {\n\t\t\tif (aggregation == null) continue;\n\t\t\tList<Axis.Component> components = aggregation.components();\n\t\t\tfor (int i = 0; i < components.size(); i++)\n\t\t\t\tthis.components.get(axes.get(i)).add(components.get(i));\n\t\t}\n\t}\n\n\tprivate void calculateTotals() {\n\t\tfor (Loader loader : loaders) {\n\t\t\tif(loader.axes().size() != axes.size()) return;\n\t\t\tfor (int i = 0; i < loader.totals().length; i++) {\n\t\t\t\tif (result[i] == null) continue;\n\t\t\t\tresult[i].append(loader.totals()[i]);\n\t\t\t}\n\t\t}\n\t}\n\n\tprivate int resultsSize() {\n\t\tint accumulator = 1;\n\t\tfor (Axis axis : axes) accumulator *= axis.getSize() + 1;\n\t\treturn accumulator;\n\t}\n\n\tprivate Stream<Aggregation[]> results() {\n\t\treturn loaders.parallelStream().map(this::results);\n\t}\n\n\tprivate Aggregation[] results(Iterable<Fact> facts) {\n\t\tAggregation[] result = new Aggregation[resultsSize()];\n\t\tfor (Fact fact : facts) {\n\t\t\tfact.setCube(this);\n\t\t\tif (!check(fact)) continue;\n\t\t\tAxis.Component[] components = componentsOf(fact);\n\t\t\tint index = indexOf(components);\n\t\t\tif (result[index] == null) result[index] = new Aggregation(fact.timetag(), Arrays.asList(components), filters);\n\t\t\tresult[index].append(fact);\n\t\t}\n\t\treturn result;\n\t}\n\n\tprivate synchronized void append(Aggregation[] results) {\n\t\tfor (int i = 0; i < results.length; i++) {\n\t\t\tif (results[i] == null) continue;\n\t\t\tif (result[i] == null) result[i] = results[i];\n\t\t\telse result[i].append(results[i]);\n\t\t}\n\t}\n\n\tprivate int indexOf(Axis.Component[] components) {\n\t\tint index = 0;\n\t\tfor (int i = 0; i < components.length; i++) {\n\t\t\tindex *= axes.get(i).getSize();\n\t\t\tindex += components[i].index();\n\t\t}\n\t\treturn index;\n\t}\n\n\tprivate int indexOf(List<Axis.Component> components) {\n\t\tint index = 0;\n\t\tfor (int i = 0; i < components.size(); i++) {\n\t\t\tindex *= axes.get(i).getSize();\n\t\t\tindex += components.get(i).index();\n\t\t}\n\t\treturn index;\n\t}\n\n\tprivate boolean check(Fact item) {\n\t\treturn filter.test(item);\n\t}\n\n\tprivate Axis.Component[] componentsOf(Fact item) {\n\t\tAxis.Component[] components = new Axis.Component[groupByList.size()];\n\t\tfor (int i = 0; i < components.length; i++) components[i] = groupByList.get(i).apply(item);\n\t\treturn components;\n\t}\n\n\tpublic static class Fact {\n\n\t\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("cube", new String[]{"fieldFact"}).multiple("\n")})}).output(new Rule.Output[]{this.literal("\n\n\t\tprivate Abstract")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal(" cube;\n\n\t\tpublic Fact(")}).output(new Rule.Output[]{this.mark("cube", new String[]{"factParameter"}).multiple(", ")}).output(new Rule.Output[]{this.literal(") {\n\t\t\t")}).output(new Rule.Output[]{this.mark("cube", new String[]{"assignFact"}).multiple("\n")}).output(new Rule.Output[]{this.literal("\n\t\t}\n\n\t\tpublic ")}).output(new Rule.Output[]{this.mark("mainCube", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal(".Fact ")}).output(new Rule.Output[]{this.mark("mainCube", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("() {\n\t\t\treturn ")}).output(new Rule.Output[]{this.mark("mainCube", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal(";\n\t\t}\n\n\t\tpublic ")}).output(new Rule.Output[]{this.mark("joinCube", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal(".Fact ")}).output(new Rule.Output[]{this.mark("joinCube", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("() {\n\t\t\treturn ")}).output(new Rule.Output[]{this.mark("joinCube", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal(";\n\t\t}\n\n\t\tpublic Abstract")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal(" cube() {\n\t\t\treturn cube;\n\t\t}\n\n\t\tpublic Timetag timetag() {\n\t\t\treturn ")}).output(new Rule.Output[]{this.mark("joinCube", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal(".timetag();\n\t\t}\n\n\t\tpublic long id() {\n\t\t\treturn ")}).output(new Rule.Output[]{this.mark("mainCube", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal(".id();\n\t\t}\n\n\t\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("column", new String[]{"factGetter"}).multiple("\n\n")})}).output(new Rule.Output[]{this.literal("\n\n\t\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("virtualColumn", new String[]{"factGetter"}).multiple("\n\n")})}).output(new Rule.Output[]{this.literal("\n\n\t\tvoid setCube(Abstract")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal(" cube) {\n\t\t\tthis.cube = cube;\n\t\t}\n\n\t\tpublic int size() {\n\t\t\treturn ")}).output(new Rule.Output[]{this.mark("cube", new String[]{"size"}).multiple(" + ")}).output(new Rule.Output[]{this.literal(";\n\t\t}\n\n\t\t@Override\n\t\tpublic boolean equals(Object o) {\n\t\t\tif(o == null || o.getClass() != getClass()) return false;\n\t\t\tfinal Fact other = (Fact) o;\n\t\t\treturn Objects.equals(")}).output(new Rule.Output[]{this.mark("mainCube", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal(", other.")}).output(new Rule.Output[]{this.mark("mainCube", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal(");\n\t\t}\n\n\t\t@Override\n\t\tpublic int hashCode() {\n\t\t\treturn ")}).output(new Rule.Output[]{this.mark("mainCube", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal(".hashCode();\n\t\t}\n\n\t\t@Override\n\t\tpublic String toString() {\n\t\t\treturn \"")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal("Fact{\" +\n\t\t\t\t\t\"")}).output(new Rule.Output[]{this.mark("mainCube", new String[0])}).output(new Rule.Output[]{this.literal("=\" + ")}).output(new Rule.Output[]{this.mark("mainCube", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal(" +\n\t\t\t\t\t\", ")}).output(new Rule.Output[]{this.mark("joinCube", new String[0])}).output(new Rule.Output[]{this.literal("=\" + ")}).output(new Rule.Output[]{this.mark("joinCube", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal(" +\n\t\t\t\t\t\"}\";\n\t\t}\n\t}\n\n\tpublic static class NullFact extends Fact {\n\n\t\tprivate NullFact() {\n\t\t\tsuper(")}).output(new Rule.Output[]{this.mark("cube", new String[]{"nullFactParameter"}).multiple(", ")}).output(new Rule.Output[]{this.literal(");\n\t\t}\n\n\t\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("column", new String[]{"nullgetter"}).multiple("\n\n")})}).output(new Rule.Output[]{this.literal("\n\n\t\t@Override\n\t\tpublic long id() {\n\t\t\treturn 0;\n\t\t}\n\t}\n\n\tpublic enum Indicator {\n\n\t\tTotal(\"Total\", \"\", Mode.Sum, false),\n\t\tDistinct(\"Distinct\", \"\", Mode.Sum, false),\n\t\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("indicator", new String[]{"enum"}).multiple(",\n")})}).output(new Rule.Output[]{this.literal("\n\t\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.literal(",")}).output(new Rule.Output[]{this.mark("customIndicator", new String[]{"enum"}).multiple(",\n")})}).output(new Rule.Output[]{this.literal(";\n\n\n\t\tpublic static Indicator byName(String name) {\n\t\t\treturn Arrays.stream(values()).filter(i -> i.name().equalsIgnoreCase(name)).findFirst().orElse(null);\n\t\t}\n\n\t\tpublic final String title;\n\t\tpublic final String unit;\n\t\tpublic final Mode mode;\n\t\tprivate final boolean virtual;\n\n\t\tIndicator(String title, String unit, Mode mode, boolean virtual) {\n\t\t\tthis.title = title;\n\t\t\tthis.unit = unit;\n\t\t\tthis.mode = mode;\n\t\t\tthis.virtual = virtual;\n\t\t}\n\n\t\tpublic enum Mode {\n\t\t\tSum, Average\n\t\t}\n\t}\n\n\tpublic static abstract class AbstractAggregation {\n\n\t\tprivate static final long Long_NaN = Long.MIN_VALUE;\n\n\t\tprivate final Timetag timetag;\n\t\tprivate final List<Axis.Component> components;\n\t\tprivate final Map<Axis, Predicate<Fact>> filters;\n\t\tprivate long aggregationTotal = 0L;\n\t\tprivate long aggregationDistinct = 0L;\n\t\tprivate long lastID = Long.MIN_VALUE;\n\t\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("index", new String[]{"field"})})}).output(new Rule.Output[]{this.literal("\n\t\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("indicator", new String[]{"field"}).multiple("\n")})}).output(new Rule.Output[]{this.literal("\n\t\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("customIndicator", new String[]{"field"}).multiple("\n")})}).output(new Rule.Output[]{this.literal("\n\t\tprivate long total")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(";\n\n\t\tpublic AbstractAggregation(Timetag timetag, List<Axis.Component> components, Map<Axis, Predicate<Fact>> filters) {\n\t\t\tthis.timetag = timetag;\n\t\t\tthis.components = components;\n\t\t\tthis.filters = filters;\n\t\t}\n\n\t\tpublic void append(Fact fact) {\n\t\t\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("indicator", new String[]{"sum"}).multiple("\n")})}).output(new Rule.Output[]{this.literal("\n\t\t\tif(lastID != fact.id()) {\n\t\t\t\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("index", new String[]{"append"})})}).output(new Rule.Output[]{this.literal("\n\t\t\t\t++aggregationDistinct;\n\t\t\t\tlastID = fact.id();\n\t\t\t}\n\t\t\t++aggregationTotal;\n\t\t}\n\n\t\tpublic void append(AbstractAggregation aggregation) {\n\t\t\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("indicator", new String[]{"sumAggregation"}).multiple("\n")})}).output(new Rule.Output[]{this.literal("\n\t\t\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("customIndicator", new String[]{"sumAggregation"}).multiple("\n")})}).output(new Rule.Output[]{this.literal("\n\t\t\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("index", new String[]{"append2"})})}).output(new Rule.Output[]{this.literal("\n\t\t\taggregationDistinct = Math.max(aggregationDistinct, aggregation.aggregationDistinct);\n\t\t\taggregationTotal += aggregation.aggregationTotal();\n\t\t}\n\n\t\tpublic Aggregation append(long ids) {\n\t\t\tthis.total")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(" += ids;\n\t\t\treturn (Aggregation) this;\n\t\t}\n\n\t\tpublic long aggregationTotal() {\n\t\t\treturn aggregationTotal;\n\t\t}\n\n\t\tpublic long aggregationDistinct() {\n\t\t\treturn aggregationDistinct;\n\t\t}\n\n\t\tpublic long total")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("() {\n\t\t\treturn total")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(";\n\t\t}\n\n\t\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("index", new String[]{"getter"})})}).output(new Rule.Output[]{this.literal("\n\n\t\tpublic Timetag timetag() {\n\t\t\treturn timetag;\n\t\t}\n\n\t\tpublic List<Axis.Component> components() {\n\t\t\treturn components;\n\t\t}\n\n\t\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("indicator", new String[]{"getter"}).multiple("\n\n")})}).output(new Rule.Output[]{this.literal("\n\n\t\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("customIndicator", new String[]{"getter"}).multiple("\n\n")})}).output(new Rule.Output[]{this.literal("\n\n\t\tpublic Number indicator(Indicator indicator) {\n\t\t\tswitch(indicator) {\n\t\t\t\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("indicator", new String[]{"switchCase"}).multiple("\n")})}).output(new Rule.Output[]{this.literal("\n\t\t\t\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("customIndicator", new String[]{"switchCase"}).multiple("\n")})}).output(new Rule.Output[]{this.literal("\n\t\t\t\tcase Total: return aggregationTotal;\n\t\t\t\tcase Distinct: return aggregationDistinct;\n\t\t\t}\n\t\t\treturn 0L;\n\t\t}\n\n\t\t@Override\n\t\tpublic String toString() {\n\t\t\treturn \"")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(".Aggregation{\"\n\t\t\t\t+ \"total=\" + aggregationTotal\n\t\t\t\t+ \", distincts=\" + aggregationDistinct\n\t\t\t\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("index", new String[]{"toString"}).multiple("\n")})}).output(new Rule.Output[]{this.literal("\n\t\t\t\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("indicator", new String[]{"toString"}).multiple("\n")})}).output(new Rule.Output[]{this.literal("\n\t\t\t\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("customIndicator", new String[]{"toString"}).multiple("\n")})}).output(new Rule.Output[]{this.literal("\n\t\t\t\t+ \"}\";\n\t\t}\n\t}\n\n\tpublic static class Loader implements Iterable<Fact> {\n\n\t\tprivate final StatefulIterator<")}).output(new Rule.Output[]{this.mark("joinCube", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(".Fact> ids;\n\t\tprivate final List<Axis> axes = new ArrayList<>();\n\t\tprivate long[] totals;\n\t\tprivate final List<Predicate<")}).output(new Rule.Output[]{this.mark("joinCube", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(".Fact>> filters = new ArrayList<>();\n\t\tprivate final List<Function<")}).output(new Rule.Output[]{this.mark("joinCube", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(".Fact, Axis.Component>> groupsBy = new ArrayList<>();\n\t\tprotected final Datasource datasource;\n\t\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("split", new String[]{"field"})})}).output(new Rule.Output[]{this.literal("\n\n\t\tpublic Loader(Datasource datasource")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.literal(", ")}).output(new Rule.Output[]{this.mark("split", new String[]{"parameter"})})}).output(new Rule.Output[]{this.literal(") {\n\t\t\tthis.datasource = datasource;\n\t\t\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("split", new String[]{"assign"})})}).output(new Rule.Output[]{this.literal("\n\t\t\tthis.ids = StatefulIterator.of(new ")}).output(new Rule.Output[]{this.mark("joinCube", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(".Loader(new ")}).output(new Rule.Output[]{this.mark("joinCube", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(".Loader.Datasource(this.datasource.root, this.datasource.from, this.datasource.to)")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.literal(", ")}).output(new Rule.Output[]{this.mark("split", new String[]{"name"})})}).output(new Rule.Output[]{this.literal(").iterator());\n\t\t}\n\n\t\t@Override\n\t\tpublic Iterator<Fact> iterator() {\n\t\t\tif(!ids.hasNext()) return Stream.<Fact>empty().iterator();\n\t\t\tStatefulIterator<")}).output(new Rule.Output[]{this.mark("mainCube", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(".Fact> facts = StatefulIterator.of(new ")}).output(new Rule.Output[]{this.mark("mainCube", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(".Loader(new ")}).output(new Rule.Output[]{this.mark("mainCube", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(".Loader.Datasource(this.datasource.root, this.datasource.from, this.datasource.to)")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.literal(", ")}).output(new Rule.Output[]{this.mark("split", new String[]{"name"})})}).output(new Rule.Output[]{this.literal(").iterator());\n\t\t\tids.next();\n\t\t\tprocess(ids.current());\n\t\t\treturn StreamSupport.stream(Spliterators.spliteratorUnknownSize(facts, Spliterator.SORTED), false)\n\t\t\t\t\t.map(f -> {\n\t\t\t\t\t\tfinal long mainID = ")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(".idOf(facts.current());\n\t\t\t\t\t\twhile (ids.current() != null && ids.current().id() < mainID) {\n\t\t\t\t\t\t\tids.next();\n\t\t\t\t\t\t\tprocess(ids.current());\n\t\t\t\t\t\t}\n\t\t\t\t\t\tif (!facts.hasNext()) end();\n\t\t\t\t\t\treturn new Fact(f, ids.current() != null && ids.current().id() == mainID ?\n\t\t\t\t\t\t\t\tids.current() : Abstract")}).output(new Rule.Output[]{this.mark("joinCube", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(".NULL_FACT);\n\t\t\t\t\t})\n\t\t\t\t\t.iterator();\n\t\t}\n\n\t\tprivate void end() {\n\t\t\twhile (ids.hasNext()) {\n\t\t\t\tids.next();\n\t\t\t\tprocess(ids.current());\n\t\t\t}\n\t\t}\n\n\t\tpublic Timetag from() {\n\t\t\treturn datasource.from;\n\t\t}\n\n\t\tprivate int totalsSize() {\n\t\t\tint accumulator = 1;\n\t\t\tfor (Axis axis : axes) accumulator *= axis.getSize();\n\t\t\treturn accumulator;\n\t\t}\n\n\t\tprivate void process(")}).output(new Rule.Output[]{this.mark("joinCube", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(".Fact fact) {\n\t\t\tif (fact == null) return;\n\t\t\tif (totals == null) totals = new long[totalsSize()];\n\t\t\tfor (Predicate<")}).output(new Rule.Output[]{this.mark("joinCube", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(".Fact> filter : filters) if (!filter.test(fact)) return;\n\t\t\tAxis.Component[] components = componentsOf(fact);\n\t\t\ttotals[indexOf(components)] += 1;\n\t\t}\n\n\t\tprivate int indexOf(Axis.Component[] components) {\n\t\t\tint index = 0;\n\t\t\tfor (int i = 0; i < components.length; i++) {\n\t\t\t\ti *= axes.get(i).getSize();\n\t\t\t\ti += components[i].index();\n\t\t\t}\n\t\t\treturn index;\n\t\t}\n\n\t\tprivate Axis.Component[] componentsOf(")}).output(new Rule.Output[]{this.mark("joinCube", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(".Fact item) {\n\t\t\tAxis.Component[] components = new Axis.Component[axes.size()];\n\t\t\tfor (int i = 0; i < components.length; i++) components[i] = groupsBy.get(i).apply(item);\n\t\t\treturn components;\n\t\t}\n\n\t\tprivate long totalOf(List<Axis.Component> categories) {\n\t\t\treturn totals[indexOf(categories.toArray(new Axis.Component[0]))];\n\t\t}\n\n\t\tpublic Loader filter(Predicate<")}).output(new Rule.Output[]{this.mark("joinCube", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(".Fact> filter) {\n\t\t\tif (filter == null) return this;\n\t\t\tfilters.add(filter);\n\t\t\treturn this;\n\t\t}\n\n\t\tpublic Loader groupBy(Axis axis, Function<")}).output(new Rule.Output[]{this.mark("joinCube", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(".Fact, Axis.Component> dimension) {\n\t\t\tif (dimension == null) return this;\n\t\t\taxes.add(axis);\n\t\t\tgroupsBy.add(dimension);\n\t\t\treturn this;\n\t\t}\n\n\t\tpublic List<Axis> axes() {\n\t\t\treturn axes;\n\t\t}\n\n\t\tpublic long[] totals() {\n\t\t\tif(totals == null) totals = new long[totalsSize()];\n\t\t\treturn totals;\n\t\t}\n\n\t\tpublic static class Datasource {\n\n\t\t\tprivate final File root;\n\t\t\tprivate final Timetag from;\n\t\t\tprivate final Timetag to;\n\n\t\t\tpublic Datasource(File root, Timetag from, Timetag to) {\n\t\t\t\tthis.root = root;\n\t\t\t\tthis.from = from;\n\t\t\t\tthis.to = to;\n\t\t\t}\n\n\t\t\tpublic Timetag from() {\n\t\t\t\treturn from;\n\t\t\t}\n\n\t\t\tpublic Timetag to() {\n\t\t\t\treturn to;\n\t\t\t}\n\t\t}\n\t}\n}")}), this.rule().condition(this.type("indicator"), new Rule.Condition[]{this.trigger("enum")}).output(new Rule.Output[]{this.mark("fieldName", new String[]{"CamelCase", "FirstUpperCase"})}).output(new Rule.Output[]{this.literal("(\"")}).output(new Rule.Output[]{this.mark("label", new String[0])}).output(new Rule.Output[]{this.literal("\", \"")}).output(new Rule.Output[]{this.mark("unit", new String[0])}).output(new Rule.Output[]{this.literal("\", Mode.")}).output(new Rule.Output[]{this.mark("mode", new String[0])}).output(new Rule.Output[]{this.literal(", false)")}), this.rule().condition(this.type("customIndicator"), new Rule.Condition[]{this.trigger("enum")}).output(new Rule.Output[]{this.mark("fieldName", new String[]{"CamelCase", "FirstUpperCase"})}).output(new Rule.Output[]{this.literal("(\"")}).output(new Rule.Output[]{this.mark("label", new String[0])}).output(new Rule.Output[]{this.literal("\", \"")}).output(new Rule.Output[]{this.mark("unit", new String[0])}).output(new Rule.Output[]{this.literal("\", Mode.")}).output(new Rule.Output[]{this.mark("mode", new String[0])}).output(new Rule.Output[]{this.literal(", true)")}), this.rule().condition(this.type("indicator"), new Rule.Condition[]{this.trigger("switchcase")}).output(new Rule.Output[]{this.literal("case ")}).output(new Rule.Output[]{this.mark("fieldName", new String[]{"CamelCase", "FirstUpperCase"})}).output(new Rule.Output[]{this.literal(": return ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "FirstLowerCase"})}).output(new Rule.Output[]{this.literal(";")}), this.rule().condition(this.type("customIndicator"), new Rule.Condition[]{this.trigger("switchcase")}).output(new Rule.Output[]{this.literal("case ")}).output(new Rule.Output[]{this.mark("fieldName", new String[]{"CamelCase", "FirstUpperCase"})}).output(new Rule.Output[]{this.literal(": return ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "FirstLowerCase"})}).output(new Rule.Output[]{this.literal(";")}), this.rule().condition(this.type("index"), new Rule.Condition[]{this.trigger("field")}).output(new Rule.Output[]{this.literal("private final SparseLongList ids = new SparseLongList();")}), this.rule().condition(this.type("index"), new Rule.Condition[]{this.trigger("append")}).output(new Rule.Output[]{this.literal("ids.add(fact.id());")}), this.rule().condition(this.type("index"), new Rule.Condition[]{this.trigger("append2")}).output(new Rule.Output[]{this.literal("ids.addAll(aggregation.ids);")}), this.rule().condition(this.type("index"), new Rule.Condition[]{this.trigger("getter")}).output(new Rule.Output[]{this.literal("public List<Long> ids() {\n\treturn ids.asList();\n}")}), this.rule().condition(this.trigger("assignfact"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("this.")}).output(new Rule.Output[]{this.mark("", new String[]{"FirstLowerCase"})}).output(new Rule.Output[]{this.literal(" = ")}).output(new Rule.Output[]{this.mark("", new String[]{"FirstLowerCase"})}).output(new Rule.Output[]{this.literal(";")}), this.rule().condition(this.trigger("fieldfact"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("private final ")}).output(new Rule.Output[]{this.mark("", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(".Fact ")}).output(new Rule.Output[]{this.mark("", new String[]{"FirstLowerCase"})}).output(new Rule.Output[]{this.literal(";")}), this.rule().condition(this.trigger("factparameter"), new Rule.Condition[0]).output(new Rule.Output[]{this.mark("", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(".Fact ")}).output(new Rule.Output[]{this.mark("", new String[]{"FirstLowerCase"})}), this.rule().condition(this.trigger("nullfactparameter"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("Abstract")}).output(new Rule.Output[]{this.mark("", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(".NULL_FACT")}), this.rule().condition(this.trigger("size"), new Rule.Condition[0]).output(new Rule.Output[]{this.mark("", new String[]{"FirstLowerCase"})}).output(new Rule.Output[]{this.literal(".size()")}), this.rule().condition(this.trigger("nbits"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("NBits")}), this.rule().condition(this.type("customFilter"), new Rule.Condition[]{this.trigger("method")}).output(new Rule.Output[]{this.literal("public Abstract")}).output(new Rule.Output[]{this.mark("cube", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal(" filter")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal("() {\n\tfilter = filter.and(")}).output(new Rule.Output[]{this.mark("cube", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal("::")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("Filter);\n\treturn this;\n}")}), this.rule().condition(this.type("customFilter"), new Rule.Condition[]{this.trigger("staticmethod")}).output(new Rule.Output[]{this.literal("public static boolean ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("Filter(Fact fact) {\n\treturn true;\n}")}), this.rule().condition(this.type("dimension"), new Rule.Condition[]{this.trigger("switchcasegroupby")}).output(new Rule.Output[]{this.literal("case ")}).output(new Rule.Output[]{this.mark("axis", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal(".TITLE: return groupBy")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal("();")}), this.rule().condition(this.allTypes(new String[]{"dimension", "categorical"}), new Rule.Condition[]{this.trigger("switchcasefilter")}).output(new Rule.Output[]{this.literal("case ")}).output(new Rule.Output[]{this.mark("axis", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal(".TITLE: return filter")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal("((Set<")}).output(new Rule.Output[]{this.mark("axis", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal(".Component>) components);")}), this.rule().condition(this.allTypes(new String[]{"dimension", "continuous"}), new Rule.Condition[]{this.trigger("switchcasefilter")}).output(new Rule.Output[]{this.literal("case ")}).output(new Rule.Output[]{this.mark("axis", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal(".TITLE: return filter")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal("((Set<")}).output(new Rule.Output[]{this.mark("axis", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal(".Range>) components);")}), this.rule().condition(this.allTypes(new String[]{"customDimension", "categorical"}), new Rule.Condition[]{this.trigger("staticmethod")}).output(new Rule.Output[]{this.literal("public static ")}).output(new Rule.Output[]{this.mark("axis", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal(".Component ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("Function(Fact fact) {\n\t// TODO\n\treturn ")}).output(new Rule.Output[]{this.mark("axis", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal(".NA;\n}")}), this.rule().condition(this.allTypes(new String[]{"customDimension", "continuous"}), new Rule.Condition[]{this.trigger("staticmethod")}).output(new Rule.Output[]{this.literal("public static ")}).output(new Rule.Output[]{this.mark("axis", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal(".Range ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("Function(Fact fact) {\n\t// TODO\n\treturn ")}).output(new Rule.Output[]{this.mark("axis", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal(".component(0);\n}")}), this.rule().condition(this.allTypes(new String[]{"dimension", "categorical"}), new Rule.Condition[]{this.trigger("method")}).output(new Rule.Output[]{this.literal("public Abstract")}).output(new Rule.Output[]{this.mark("cube", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal(" filter")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal("(Set<")}).output(new Rule.Output[]{this.mark("axis", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal(".Component> ")}).output(new Rule.Output[]{this.mark("axis", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal(") {\n\tif(filters.containsKey(")}).output(new Rule.Output[]{this.mark("axis", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal(".get())) return this;\n\tPredicate<Fact> f = v -> ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("Filter(v, ")}).output(new Rule.Output[]{this.mark("axis", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal(");\n\tfilters.put(")}).output(new Rule.Output[]{this.mark("axis", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal(".get(), f);\n\tfilter = filter.and(f);\n\treturn this;\n}\n\npublic Abstract")}).output(new Rule.Output[]{this.mark("cube", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(" groupBy")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal("() {\n\taxes.add(")}).output(new Rule.Output[]{this.mark("axis", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal(".get());\n\tcomponents.put(")}).output(new Rule.Output[]{this.mark("axis", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal(".get(), new HashSet<>());\n\tgroupByList.add(v -> ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("Function(v));\n\treturn this;\n}\n\npublic static boolean ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("Filter(Fact fact, Set<")}).output(new Rule.Output[]{this.mark("axis", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal(".Component> ")}).output(new Rule.Output[]{this.mark("axis", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal(") {\n\treturn ")}).output(new Rule.Output[]{this.mark("axis", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal(".contains(")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("Function(fact));\n}\n\npublic static ")}).output(new Rule.Output[]{this.mark("axis", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal(".Component ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("Function(Fact fact) {\n\treturn fact.")}).output(new Rule.Output[]{this.mark("source", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("()")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.literal(".")}).output(new Rule.Output[]{this.mark("child", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("()")})}).output(new Rule.Output[]{this.literal(";\n}")}), this.rule().condition(this.allTypes(new String[]{"customDimension", "categorical"}), new Rule.Condition[]{this.trigger("method")}).output(new Rule.Output[]{this.literal("public Abstract")}).output(new Rule.Output[]{this.mark("cube", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal(" filter")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal("(Set<")}).output(new Rule.Output[]{this.mark("axis", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal(".Component> ")}).output(new Rule.Output[]{this.mark("axis", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal(") {\n\tif(filters.containsKey(")}).output(new Rule.Output[]{this.mark("axis", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal(".get())) return this;\n\tPredicate<Fact> f = v -> ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("Filter(v, ")}).output(new Rule.Output[]{this.mark("axis", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal(");\n\tfilters.put(")}).output(new Rule.Output[]{this.mark("axis", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal(".get(), f);\n\tfilter = filter.and(f);\n\treturn this;\n}\n\npublic Abstract")}).output(new Rule.Output[]{this.mark("cube", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(" groupBy")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal("() {\n\taxes.add(")}).output(new Rule.Output[]{this.mark("axis", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal(".get());\n\tcomponents.put(")}).output(new Rule.Output[]{this.mark("axis", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal(".get(), new HashSet<>());\n\tgroupByList.add(v -> ")}).output(new Rule.Output[]{this.mark("cube", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal(".")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("Function(v));\n\treturn this;\n}\n\npublic static boolean ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("Filter(Fact fact, Set<")}).output(new Rule.Output[]{this.mark("axis", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal(".Component> ")}).output(new Rule.Output[]{this.mark("axis", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal(") {\n\treturn ")}).output(new Rule.Output[]{this.mark("axis", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal(".contains(")}).output(new Rule.Output[]{this.mark("cube", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal(".")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("Function(fact));\n}")}), this.rule().condition(this.allTypes(new String[]{"dimension", "continuous"}), new Rule.Condition[]{this.trigger("method")}).output(new Rule.Output[]{this.literal("public Abstract")}).output(new Rule.Output[]{this.mark("cube", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal(" filter")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal("(Set<")}).output(new Rule.Output[]{this.mark("axis", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal(".Range> ")}).output(new Rule.Output[]{this.mark("axis", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal(") {\n\tif(filters.containsKey(")}).output(new Rule.Output[]{this.mark("axis", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal(".get())) return this;\n\tPredicate<Fact> f = v -> ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("Filter(v, ")}).output(new Rule.Output[]{this.mark("axis", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal(");\n\tfilters.put(")}).output(new Rule.Output[]{this.mark("axis", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal(".get(), f);\n\tfilter = filter.and(f);\n\treturn this;\n}\n\npublic Abstract")}).output(new Rule.Output[]{this.mark("cube", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(" groupBy")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal("() {\n\taxes.add(")}).output(new Rule.Output[]{this.mark("axis", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal(".get());\n\tcomponents.put(")}).output(new Rule.Output[]{this.mark("axis", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal(".get(), new HashSet<>());\n\tgroupByList.add(")}).output(new Rule.Output[]{this.mark("cube", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("::")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("Function);\n\treturn this;\n}\n\npublic static boolean ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("Filter(Fact fact, Set<")}).output(new Rule.Output[]{this.mark("axis", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal(".Range> ")}).output(new Rule.Output[]{this.mark("axis", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal(") {\n\treturn ")}).output(new Rule.Output[]{this.mark("axis", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal(".contains(")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("Function(fact));\n}\n\npublic static ")}).output(new Rule.Output[]{this.mark("axis", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal(".Range ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("Function(Fact fact) {\n\treturn ")}).output(new Rule.Output[]{this.mark("axis", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal(".rangeOf(fact.")}).output(new Rule.Output[]{this.mark("source", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("());\n}")}), this.rule().condition(this.allTypes(new String[]{"customDimension", "continuous"}), new Rule.Condition[]{this.trigger("method")}).output(new Rule.Output[]{this.literal("public Abstract")}).output(new Rule.Output[]{this.mark("cube", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal(" filter")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal("(Set<")}).output(new Rule.Output[]{this.mark("axis", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal(".Range> ")}).output(new Rule.Output[]{this.mark("axis", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal(") {\n\tif(filters.containsKey(")}).output(new Rule.Output[]{this.mark("axis", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal(".get())) return this;\n\tPredicate<Fact> f = v -> ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("Filter(v, ")}).output(new Rule.Output[]{this.mark("axis", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal(");\n\tfilters.put(")}).output(new Rule.Output[]{this.mark("axis", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal(".get(), f);\n\tfilter = filter.and(f);\n\treturn this;\n}\n\npublic Abstract")}).output(new Rule.Output[]{this.mark("cube", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(" groupBy")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal("() {\n\taxes.add(")}).output(new Rule.Output[]{this.mark("axis", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal(".get());\n\tcomponents.put(")}).output(new Rule.Output[]{this.mark("axis", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal(".get(), new HashSet<>());\n\tgroupByList.add(")}).output(new Rule.Output[]{this.mark("cube", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("::")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("Function);\n\treturn this;\n}\n\npublic static boolean ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("Filter(Fact fact, Set<")}).output(new Rule.Output[]{this.mark("axis", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal(".Range> ")}).output(new Rule.Output[]{this.mark("axis", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal(") {\n\treturn ")}).output(new Rule.Output[]{this.mark("axis", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal(".contains(")}).output(new Rule.Output[]{this.mark("cube", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal(".")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("Function(fact));\n}")}), this.rule().condition(this.type("dimension"), new Rule.Condition[]{this.trigger("ifgroupby")}).output(new Rule.Output[]{this.literal("if(axis.equals(")}).output(new Rule.Output[]{this.mark("axis", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal(".get())) return groupBy")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal("();")}), this.rule().condition(this.type("dimension"), new Rule.Condition[]{this.trigger("iffilterby")}).output(new Rule.Output[]{this.literal("if(axis.equals(")}).output(new Rule.Output[]{this.mark("axis", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal(".get())) return filter")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal("();")}), this.rule().condition(this.type("customIndicator"), new Rule.Condition[]{this.trigger("tostring")}).output(new Rule.Output[]{this.literal(" + \", ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("=\" + ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("()")}), this.rule().condition(this.type("indicator"), new Rule.Condition[]{this.trigger("sum")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal(" += fact.")}).output(new Rule.Output[]{this.mark("source", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("();")}), this.rule().condition(this.type("indicator"), new Rule.Condition[]{this.trigger("sumaggregation")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal(" += aggregation.")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal(";")}), this.rule().condition(this.allTypes(new String[]{"customIndicator", "sum"}), new Rule.Condition[]{this.trigger("sumaggregation")}).output(new Rule.Output[]{this.literal("if(")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal(" != Long_NaN && aggregation.")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal(" != Long_NaN)\n\t")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal(" += aggregation.")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal(";")}), this.rule().condition(this.allTypes(new String[]{"customIndicator", "average"}), new Rule.Condition[]{this.trigger("sumaggregation")}).output(new Rule.Output[]{this.literal("if(!Double.isNaN(")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal(") && !Double.isNaN(aggregation.")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("))\n\t")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal(" += aggregation.")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal(";")}), this.rule().condition(this.allTypes(new String[]{"customIndicator", "average"}), new Rule.Condition[]{this.trigger("field")}).output(new Rule.Output[]{this.literal("protected double ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal(" = Double.NaN;")}), this.rule().condition(this.allTypes(new String[]{"indicator", "average"}), new Rule.Condition[]{this.trigger("field")}).output(new Rule.Output[]{this.literal("protected double ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal(";")}), this.rule().condition(this.allTypes(new String[]{"indicator", "sum"}), new Rule.Condition[]{this.trigger("field")}).output(new Rule.Output[]{this.literal("protected long ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal(";")}), this.rule().condition(this.allTypes(new String[]{"customIndicator", "sum"}), new Rule.Condition[]{this.trigger("field")}).output(new Rule.Output[]{this.literal("protected long ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal(" = Long_NaN;")}), this.rule().condition(this.allTypes(new String[]{"indicator", "average"}), new Rule.Condition[]{this.trigger("getter")}).output(new Rule.Output[]{this.literal("public double ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("() {\n\treturn ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal(" / (double) aggregationDistinct;\n}")}), this.rule().condition(this.allTypes(new String[]{"customIndicator", "average"}), new Rule.Condition[]{this.trigger("getter")}).output(new Rule.Output[]{this.literal("public final double ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("() {\n\tif(Double.isNaN(")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("))\n\t\t")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal(" = calculate")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal("();\n\treturn ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal(";\n}\n\nprotected double calculate")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal("() {\n\treturn 0.0;\n}")}), this.rule().condition(this.allTypes(new String[]{"indicator", "sum"}), new Rule.Condition[]{this.trigger("getter")}).output(new Rule.Output[]{this.literal("public long ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("() {\n\treturn ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal(";\n}")}), this.rule().condition(this.allTypes(new String[]{"customIndicator", "sum"}), new Rule.Condition[]{this.trigger("getter")}).output(new Rule.Output[]{this.literal("public final long ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("() {\n\tif(")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal(" == Long_NaN)\n\t\t")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal(" = calculate")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal("();\n\treturn ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal(";\n}\n\nprotected long calculate")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal("() {\n\treturn 0L;\n}")}), this.rule().condition(this.type("index"), new Rule.Condition[]{this.trigger("index")}).output(new Rule.Output[]{this.literal("ids.size()")}), this.rule().condition(this.allTypes(new String[]{"indicator", "average"}), new Rule.Condition[]{this.trigger("staticmethod")}).output(new Rule.Output[]{this.literal("public static double ")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal("(Fact fact) {\n\treturn 0.0;\n}")}), this.rule().condition(this.allTypes(new String[]{"indicator", "sum"}), new Rule.Condition[]{this.trigger("staticmethod")}).output(new Rule.Output[]{this.literal("public static long ")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal("(Fact fact) {\n\treturn 0;\n}")}), this.rule().condition(this.type("split"), new Rule.Condition[]{this.trigger("parameter")}).output(new Rule.Output[]{this.literal("String ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}), this.rule().condition(this.type("split"), new Rule.Condition[]{this.trigger("setparameter")}).output(new Rule.Output[]{this.literal("java.util.Set<String> ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}), this.rule().condition(this.type("split"), new Rule.Condition[]{this.trigger("assign")}).output(new Rule.Output[]{this.literal("this.")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal(" = ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal(";")}), this.rule().condition(this.type("split"), new Rule.Condition[]{this.trigger("name")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}), this.rule().condition(this.type("split"), new Rule.Condition[]{this.trigger("nameupper")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstUpperCase"})}), this.rule().condition(this.type("split"), new Rule.Condition[]{this.trigger("field")}).output(new Rule.Output[]{this.literal("protected final String ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal(";")}), this.rule().condition(this.type("split"), new Rule.Condition[]{this.trigger("method")}).output(new Rule.Output[]{this.literal("private static Set<String> all")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("() {\n\treturn java.util.Set.of(")}).output(new Rule.Output[]{this.mark("value", new String[]{"quoted"}).multiple(", ")}).output(new Rule.Output[]{this.literal(");\n}")}), this.rule().condition(this.type("dimension"), new Rule.Condition[]{this.trigger("getinstance")}).output(new Rule.Output[]{this.mark("axis", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal(".get()")}), this.rule().condition(this.trigger("dimension"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("public static Predicate<")}).output(new Rule.Output[]{this.mark("cube", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(".Fact> ")}).output(new Rule.Output[]{this.mark("axis", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("(Set<")}).output(new Rule.Output[]{this.mark("axis", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal(".Component> ")}).output(new Rule.Output[]{this.mark("axis", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("List) {\n\treturn r -> ")}).output(new Rule.Output[]{this.mark("axis", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("List.contains(r.")}).output(new Rule.Output[]{this.mark("axis", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("());\n}\n\npublic static Function<")}).output(new Rule.Output[]{this.mark("cube", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(".Fact, String> ")}).output(new Rule.Output[]{this.mark("axis", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("() {\n\treturn r -> r.")}).output(new Rule.Output[]{this.mark("axis", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("().id();\n}")}), this.rule().condition(this.allTypes(new String[]{"column", "int", "unsigned"}), new Rule.Condition[]{this.trigger("factgetter")}).output(new Rule.Output[]{this.literal("public long ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("() {\n\treturn ")}).output(new Rule.Output[]{this.mark("cube", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal(".")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("();\n}")}), this.rule().condition(this.allTypes(new String[]{"column", "int"}), new Rule.Condition[]{this.trigger("factgetter")}).output(new Rule.Output[]{this.literal("public int ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("() {\n\treturn ")}).output(new Rule.Output[]{this.mark("cube", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal(".")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("();\n}")}), this.rule().condition(this.allTypes(new String[]{"column", "float"}), new Rule.Condition[]{this.trigger("factgetter")}).output(new Rule.Output[]{this.literal("public float ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("() {\n\treturn ")}).output(new Rule.Output[]{this.mark("cube", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal(".")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("();\n}")}), this.rule().condition(this.allTypes(new String[]{"column", "double"}), new Rule.Condition[]{this.trigger("factgetter")}).output(new Rule.Output[]{this.literal("public double ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("() {\n\treturn ")}).output(new Rule.Output[]{this.mark("cube", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal(".")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("();\n}")}), this.rule().condition(this.type("column"), new Rule.Condition[]{this.anyTypes(new String[]{"id", "long"}), this.trigger("factgetter")}).output(new Rule.Output[]{this.literal("public long ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("() {\n\treturn ")}).output(new Rule.Output[]{this.mark("cube", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal(".")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("();\n}")}), this.rule().condition(this.type("column"), new Rule.Condition[]{this.allTypes(new String[]{"byte", "unsigned"}), this.trigger("factgetter")}).output(new Rule.Output[]{this.literal("public short ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("() {\n\treturn ")}).output(new Rule.Output[]{this.mark("cube", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal(".")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("();\n}")}), this.rule().condition(this.type("column"), new Rule.Condition[]{this.type("byte"), this.trigger("factgetter")}).output(new Rule.Output[]{this.literal("public byte ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("() {\n\treturn ")}).output(new Rule.Output[]{this.mark("cube", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal(".")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("();\n}")}), this.rule().condition(this.type("column"), new Rule.Condition[]{this.allTypes(new String[]{"short", "unsigned"}), this.trigger("factgetter")}).output(new Rule.Output[]{this.literal("public int ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("() {\n\treturn ")}).output(new Rule.Output[]{this.mark("cube", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal(".")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("();\n}")}), this.rule().condition(this.type("column"), new Rule.Condition[]{this.type("short"), this.trigger("factgetter")}).output(new Rule.Output[]{this.literal("public short ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("() {\n\treturn ")}).output(new Rule.Output[]{this.mark("cube", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal(".")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("();\n}")}), this.rule().condition(this.type("column"), new Rule.Condition[]{this.type("boolean"), this.trigger("factgetter")}).output(new Rule.Output[]{this.literal("public boolean ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("() {\n\treturn ")}).output(new Rule.Output[]{this.mark("cube", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal(".")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("();\n}")}), this.rule().condition(this.allTypes(new String[]{"column", "categorical"}), new Rule.Condition[]{this.trigger("factgetter")}).output(new Rule.Output[]{this.literal("public ")}).output(new Rule.Output[]{this.mark("type", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal(".Component ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("() {\n\treturn ")}).output(new Rule.Output[]{this.mark("cube", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal(".")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("();\n}")}), this.rule().condition(this.type("column"), new Rule.Condition[]{this.trigger("factgetter")}).output(new Rule.Output[]{this.literal("public ")}).output(new Rule.Output[]{this.mark("type", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal(" ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("() {\n\treturn ")}).output(new Rule.Output[]{this.mark("cube", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal(".")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("();\n}")}), this.rule().condition(this.allTypes(new String[]{"column", "virtual"}), new Rule.Condition[]{this.trigger("factgetter")}).output(new Rule.Output[]{this.literal("public ")}).output(new Rule.Output[]{this.mark("type", new String[0])}).output(new Rule.Output[]{this.literal(" ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("() {\n\treturn ")}).output(new Rule.Output[]{this.mark("cube", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal(".")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("();\n}")}), this.rule().condition(this.allTypes(new String[]{"column", "categorical"}), new Rule.Condition[]{this.trigger("nullgetter")}).output(new Rule.Output[]{this.literal("public ")}).output(new Rule.Output[]{this.mark("type", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal(".Component ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("() {\n\treturn ")}).output(new Rule.Output[]{this.mark("type", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal(".NA;\n}")}), this.rule().condition(this.allTypes(new String[]{"column", "int", "unsigned"}), new Rule.Condition[]{this.trigger("nullgetter")}).output(new Rule.Output[]{this.literal("public long ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("() {\n\treturn 0;\n}")}), this.rule().condition(this.allTypes(new String[]{"column", "int"}), new Rule.Condition[]{this.trigger("nullgetter")}).output(new Rule.Output[]{this.literal("public int ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("() {\n\treturn 0;\n}")}), this.rule().condition(this.type("column"), new Rule.Condition[]{this.anyTypes(new String[]{"id", "long"}), this.trigger("nullgetter")}).output(new Rule.Output[]{this.literal("public long ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("() {\n\treturn 0L;\n}")}), this.rule().condition(this.allTypes(new String[]{"column", "short", "unsigned"}), new Rule.Condition[]{this.trigger("nullgetter")}).output(new Rule.Output[]{this.literal("public int ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("() {\n\treturn 0;\n}")}), this.rule().condition(this.allTypes(new String[]{"column", "short"}), new Rule.Condition[]{this.trigger("nullgetter")}).output(new Rule.Output[]{this.literal("public short ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("() {\n\treturn 0;\n}")}), this.rule().condition(this.allTypes(new String[]{"column", "byte", "unsigned"}), new Rule.Condition[]{this.trigger("nullgetter")}).output(new Rule.Output[]{this.literal("public short ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("() {\n\treturn 0;\n}")}), this.rule().condition(this.allTypes(new String[]{"column", "byte"}), new Rule.Condition[]{this.trigger("nullgetter")}).output(new Rule.Output[]{this.literal("public byte ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("() {\n\treturn 0;\n}")}), this.rule().condition(this.allTypes(new String[]{"column", "float"}), new Rule.Condition[]{this.trigger("nullgetter")}).output(new Rule.Output[]{this.literal("public float ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("() {\n\treturn 0.0f;\n}")}), this.rule().condition(this.allTypes(new String[]{"column", "double"}), new Rule.Condition[]{this.trigger("nullgetter")}).output(new Rule.Output[]{this.literal("public double ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("() {\n\treturn 0.0f;\n}")}), this.rule().condition(this.allTypes(new String[]{"column", "boolean"}), new Rule.Condition[]{this.trigger("nullgetter")}).output(new Rule.Output[]{this.literal("public boolean ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("() {\n\treturn false;\n}")}), this.rule().condition(this.allTypes(new String[]{"column", "boolean"}), new Rule.Condition[]{this.trigger("nullgetter")}).output(new Rule.Output[]{this.literal("public boolean ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("() {\n\treturn false;\n}")}), this.rule().condition(this.allTypes(new String[]{"column", "boolean"}), new Rule.Condition[]{this.trigger("nullgetter")}).output(new Rule.Output[]{this.literal("public boolean ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("() {\n\treturn false;\n}")}), this.rule().condition(this.allTypes(new String[]{"virtualColumn", "primitive"}), new Rule.Condition[]{this.trigger("factgetter")}).output(new Rule.Output[]{this.literal("public ")}).output(new Rule.Output[]{this.mark("type", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal(" ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("() {\n\treturn ")}).output(new Rule.Output[]{this.mark("cube", new String[0])}).output(new Rule.Output[]{this.literal(".")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("();\n}")}), this.rule().condition(this.type("virtualColumn"), new Rule.Condition[]{this.trigger("factgetter")}).output(new Rule.Output[]{this.literal("public ")}).output(new Rule.Output[]{this.mark("type", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal(" ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("() {\n\treturn ")}).output(new Rule.Output[]{this.mark("cube", new String[0])}).output(new Rule.Output[]{this.literal(".")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("();\n}")}), this.rule().condition(this.allTypes(new String[]{"customIndicator", "sum"}), new Rule.Condition[]{this.trigger("implementation")}).output(new Rule.Output[]{this.literal("@Override\nprotected long calculate")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal("() {\n\t// TODO: calculate and return ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("\n\treturn 0;\n}")}), this.rule().condition(this.allTypes(new String[]{"customIndicator", "average"}), new Rule.Condition[]{this.trigger("implementation")}).output(new Rule.Output[]{this.literal("@Override\nprotected double calculate")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal("() {\n\t// TODO: calculate and return ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("\n\treturn 0.0;\n}")})});
    }
}

