/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.accessor.ui.web;

import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.zip.Zip;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.accessor.ui.web.ServiceRenderer;
import io.intino.konos.builder.codegeneration.services.ui.Target;
import io.intino.konos.builder.codegeneration.ui.UIRenderer;
import io.intino.konos.builder.context.CompilationContext;
import io.intino.konos.builder.context.KonosException;
import io.intino.konos.builder.utils.FileHelper;
import io.intino.konos.compiler.shared.PostCompileActionMessage;
import io.intino.konos.compiler.shared.PostCompileDependantWebModuleActionMessage;
import io.intino.konos.model.Service;
import java.io.File;
import java.io.IOException;

public class ServiceCreator
extends UIRenderer {
    private final Service.UI service;

    public ServiceCreator(CompilationContext compilationContext, Service.UI service) {
        super(compilationContext);
        this.service = service;
    }

    @Override
    public void render() throws KonosException {
        try {
            this.context.postCompileActionMessages().add((PostCompileActionMessage)new PostCompileDependantWebModuleActionMessage(this.context.configuration().module(), this.service.name$()));
            this.context.serviceDirectory(new File(this.context.configuration().moduleDirectory().getParentFile(), Formatters.camelCaseToSnakeCase().format((Object)this.service.name$()).toString()));
            if (!this.context.serviceDirectory().exists()) {
                this.createSkeleton();
            }
            new ServiceRenderer(this.context, this.service).execute();
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    private void createSkeleton() throws IOException {
        File destiny = this.root(Target.Accessor);
        File file = new File(destiny, "web.zip");
        FileHelper.copyResourcesRecursively(this.getClass().getResource("/ui/web.zip"), file);
        new Zip(file).unzip(destiny.getAbsolutePath());
        file.delete();
        new File(destiny, "images").mkdirs();
    }
}

