/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.model;

import io.intino.konos.model.AbstractGraph;
import io.intino.konos.model.CatalogComponents;
import io.intino.konos.model.Display;
import io.intino.konos.model.HelperComponents;
import io.intino.konos.model.PassiveView;
import io.intino.konos.model.Service;
import io.intino.konos.model.Template;
import io.intino.magritte.framework.Graph;
import io.intino.magritte.framework.Store;
import io.intino.magritte.io.Stash;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class KonosGraph
extends AbstractGraph {
    private static final Map<String, Set<String>> hierarchyDisplays = new HashMap<String, Set<String>>();
    private static Map<String, List<CatalogComponents.Moldable.Mold.Item>> items = new HashMap<String, List<CatalogComponents.Moldable.Mold.Item>>();
    private static Map<String, List<HelperComponents.Row>> rows = new HashMap<String, List<HelperComponents.Row>>();
    private static Map<String, List<CatalogComponents.Table>> tables = new HashMap<String, List<CatalogComponents.Table>>();
    private static final Map<String, List<CatalogComponents.DynamicTable>> dynamicTables = new HashMap<String, List<CatalogComponents.DynamicTable>>();
    private List<CatalogComponents.Collection> collectionDisplays;
    private List<CatalogComponents.Table> tableDisplays;
    private List<CatalogComponents.List> listDisplays;
    private List<CatalogComponents.Magazine> magazines;
    private List<CatalogComponents.Map> mapDisplays;
    private List<CatalogComponents.DynamicTable> dynamicTablesDisplays;

    public KonosGraph(Graph graph) {
        super(graph);
    }

    public KonosGraph(Graph graph, KonosGraph wrapper) {
        super(graph, wrapper);
    }

    public KonosGraph init(String group) {
        this.resetCache();
        this.createPrivateComponents(group);
        return this;
    }

    public static KonosGraph load(Stash ... startingModel) {
        return (KonosGraph)new Graph().loadLanguage("Konos", KonosGraph._language()).loadStashes(startingModel).as(KonosGraph.class);
    }

    public static KonosGraph load(Store store, Stash ... startingModel) {
        return (KonosGraph)new Graph(store).loadLanguage("Konos", KonosGraph._language()).loadStashes(startingModel).as(KonosGraph.class);
    }

    private void resetCache() {
        tables = new HashMap<String, List<CatalogComponents.Table>>();
        items = new HashMap<String, List<CatalogComponents.Moldable.Mold.Item>>();
        rows = new HashMap<String, List<HelperComponents.Row>>();
    }

    public List<Display> rootDisplays(String group) {
        KonosGraph graph = this;
        List<Display> rootDisplays = graph.displayList().stream().filter(d -> d.core$().ownerAs(PassiveView.class) == null).collect(Collectors.toList());
        rootDisplays.addAll(this.itemsDisplays(group));
        rootDisplays.addAll(this.rowsDisplays(group));
        rootDisplays.addAll(this.collectionsDisplays(group));
        return rootDisplays;
    }

    public List<CatalogComponents.Moldable.Mold.Item> itemsDisplays(String group) {
        if (!items.containsKey(group)) {
            items.put(group, this.core$().find(CatalogComponents.Moldable.Mold.Item.class));
        }
        return items.get(group);
    }

    public List<HelperComponents.Row> rowsDisplays(String group) {
        if (!rows.containsKey(group)) {
            rows.put(group, this.core$().find(HelperComponents.Row.class));
        }
        return rows.get(group);
    }

    public List<CatalogComponents.Collection> collectionsDisplays(String group) {
        KonosGraph graph = this;
        if (this.collectionDisplays == null) {
            this.collectionDisplays = graph.displayList().stream().filter(d -> d.core$().ownerAs(PassiveView.class) == null && d.i$(CatalogComponents.Collection.class)).map(d -> (CatalogComponents.Collection)d.a$(CatalogComponents.Collection.class)).collect(Collectors.toList());
        }
        return this.collectionDisplays;
    }

    public List<CatalogComponents.Table> tablesDisplays(String group) {
        if (this.tableDisplays == null) {
            this.tableDisplays = this.collectionsDisplays(group).stream().filter(c -> c.i$(CatalogComponents.Table.class)).map(c -> (CatalogComponents.Table)c.a$(CatalogComponents.Table.class)).collect(Collectors.toList());
        }
        return this.tableDisplays;
    }

    public List<CatalogComponents.List> listsDisplays(String group) {
        if (this.listDisplays == null) {
            this.listDisplays = this.collectionsDisplays(group).stream().filter(c -> c.i$(CatalogComponents.List.class)).map(c -> (CatalogComponents.List)c.a$(CatalogComponents.List.class)).collect(Collectors.toList());
        }
        return this.listDisplays;
    }

    public List<CatalogComponents.Magazine> magazinesDisplays(String group) {
        if (this.magazines == null) {
            this.magazines = this.collectionsDisplays(group).stream().filter(c -> c.i$(CatalogComponents.Magazine.class)).map(c -> (CatalogComponents.Magazine)c.a$(CatalogComponents.Magazine.class)).collect(Collectors.toList());
        }
        return this.magazines;
    }

    public List<CatalogComponents.Map> mapsDisplays(String group) {
        if (this.mapDisplays == null) {
            this.mapDisplays = this.collectionsDisplays(group).stream().filter(c -> c.i$(CatalogComponents.Map.class)).map(c -> (CatalogComponents.Map)c.a$(CatalogComponents.Map.class)).collect(Collectors.toList());
        }
        return this.mapDisplays;
    }

    public List<CatalogComponents.DynamicTable> dynamicTablesDisplays(String group) {
        if (this.dynamicTablesDisplays == null) {
            this.dynamicTablesDisplays = this.collectionsDisplays(group).stream().filter(c -> c.i$(CatalogComponents.Magazine.class)).map(c -> (CatalogComponents.DynamicTable)c.a$(CatalogComponents.DynamicTable.class)).collect(Collectors.toList());
        }
        return this.dynamicTablesDisplays;
    }

    public static List<CatalogComponents.Table> tablesDisplays(KonosGraph graph, String group) {
        if (!tables.containsKey(group)) {
            tables.put(group, graph.core$().find(CatalogComponents.Table.class));
        }
        return tables.get(group);
    }

    public static List<CatalogComponents.DynamicTable> dynamicTablesDisplays(KonosGraph graph, String group) {
        if (!dynamicTables.containsKey(group)) {
            dynamicTables.put(group, graph.core$().find(CatalogComponents.DynamicTable.class));
        }
        return dynamicTables.get(group);
    }

    public static Template templateFor(Service.UI.Resource resource) {
        return resource.asPage().template();
    }

    public static boolean isParent(String group, PassiveView passiveView) {
        KonosGraph.loadParents(group, passiveView.graph());
        return hierarchyDisplays.get(group).contains(passiveView.name$());
    }

    public Set<String> findCustomParameters(Service.Messaging service) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (Service.Messaging.Request request : service.requestList()) {
            set.addAll(KonosGraph.extractParameters(request.path()));
        }
        return set;
    }

    public Set<String> findCustomParameters(Service.REST service) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (Service.REST.Resource resource : service.resourceList()) {
            set.addAll(KonosGraph.extractParameters(resource.path()));
        }
        return set;
    }

    public Set<String> findCustomParameters(Service.UI service) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        if (service.authentication() != null) {
            set.addAll(KonosGraph.extractParameters(service.authentication().by()));
        }
        for (Service.UI.Resource resource : service.resourceList()) {
            set.addAll(KonosGraph.extractParameters(resource.path()));
        }
        return set;
    }

    private static Set<String> extractParameters(String text) {
        LinkedHashSet<String> list = new LinkedHashSet<String>();
        Pattern pattern = Pattern.compile("\\{([^\\}]*)\\}");
        Matcher matcher = pattern.matcher(text);
        while (matcher.find()) {
            list.add(matcher.group(1));
        }
        return list;
    }

    private static void loadParents(String group, KonosGraph graph) {
        if (hierarchyDisplays.containsKey(group)) {
            return;
        }
        hierarchyDisplays.put(group, graph.core$().find(PassiveView.ExtensionOf.class).stream().map(d -> ((PassiveView.ExtensionOf)d.core$().as(PassiveView.ExtensionOf.class)).parentView().name$()).collect(Collectors.toSet()));
    }

    private void createPrivateComponents(String group) {
        KonosGraph.tablesDisplays(this, group).forEach(this::createUiTableRow);
        KonosGraph.dynamicTablesDisplays(this, group).forEach(this::createUiTableRow);
    }

    private void createUiTableRow(CatalogComponents.Moldable element) {
        List<CatalogComponents.Moldable.Mold.Item> itemList = element.moldList().stream().map(CatalogComponents.Moldable.Mold::item).collect(Collectors.toList());
        String name = KonosGraph.firstUpperCase(element.name$()) + "Row";
        HelperComponents privateComponents = this.helperComponentsList().size() <= 0 ? this.create(element.core$().stash()).helperComponents() : this.helperComponents(0);
        HelperComponents.Row row = privateComponents.rowList().stream().filter(c -> c.name$().equals(name)).findFirst().orElse(null);
        if (row == null) {
            privateComponents.create(name).row(itemList);
        }
    }

    private static String firstUpperCase(String value) {
        return value.substring(0, 1).toUpperCase() + value.substring(1);
    }

    public List<Service.Messaging> messagingServiceList() {
        return this.serviceList(Service::isMessaging).map(Service::asMessaging).collect(Collectors.toList());
    }

    public List<Service.REST> restServiceList() {
        return this.serviceList(Service::isREST).map(Service::asREST).collect(Collectors.toList());
    }

    public List<Service.CLI> cliServiceList() {
        return this.serviceList(Service::isCLI).map(Service::asCLI).collect(Collectors.toList());
    }

    public List<Service.Soap> soapServiceList() {
        return this.serviceList(Service::isSoap).map(Service::asSoap).collect(Collectors.toList());
    }

    public List<Service.UI> uiServiceList() {
        return this.serviceList(Service::isUI).map(Service::asUI).collect(Collectors.toList());
    }

    public List<Service.Agenda> agendaServiceList() {
        return this.serviceList(Service::isAgenda).map(Service::asAgenda).collect(Collectors.toList());
    }

    public List<Service.JMX> jmxServiceList() {
        return this.serviceList(Service::isJMX).map(Service::asJMX).collect(Collectors.toList());
    }

    public List<Service.SlackBot> slackBotServiceList() {
        return this.serviceList(Service::isSlackBot).map(Service::asSlackBot).collect(Collectors.toList());
    }
}

