/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.exception;

import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.konos.builder.OutputItem;
import io.intino.konos.builder.codegeneration.Renderer;
import io.intino.konos.builder.codegeneration.exception.ExceptionTemplate;
import io.intino.konos.builder.codegeneration.services.ui.Target;
import io.intino.konos.builder.context.CompilationContext;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.Exception;
import io.intino.konos.model.KonosGraph;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class ExceptionRenderer
extends Renderer {
    private static final String EXCEPTIONS = "exceptions";
    private final List<Exception> exceptions;

    public ExceptionRenderer(CompilationContext compilationContext, KonosGraph graph) {
        super(compilationContext);
        this.exceptions = graph.exceptionList();
    }

    public void clean() {
        File folder = this.destinyPackage(this.gen(Target.Server));
        if (!folder.exists()) {
            return;
        }
        List filenames = this.exceptions.stream().map(e -> Commons.javaFile(folder, e.name$()).getAbsolutePath()).collect(Collectors.toList());
        Arrays.stream(Objects.requireNonNull(folder.listFiles((file, name) -> !filenames.contains(name)))).forEach(File::delete);
    }

    @Override
    public void render() {
        this.exceptions.forEach(this::processException);
    }

    private void processException(Exception exception) {
        Commons.writeFrame(this.destinyPackage(this.gen(Target.Server)), exception.name$(), this.template().render((Object)new FrameBuilder(new String[]{"exception"}).add("name", (Object)exception.name$()).add("code", (Object)exception.code()).add("package", (Object)this.packageName()).toFrame()));
        this.context.compiledFiles().add(new OutputItem(this.context.sourceFileOf(exception), Commons.javaFile(this.destinyPackage(this.gen(Target.Server)), exception.name$()).getAbsolutePath()));
    }

    private File destinyPackage(File destiny) {
        return new File(destiny, EXCEPTIONS);
    }

    private Template template() {
        return new ExceptionTemplate();
    }
}

