/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.model;

import io.intino.konos.model.Data;
import io.intino.konos.model.Exception;
import io.intino.konos.model.KonosGraph;
import io.intino.konos.model.Service;
import io.intino.konos.model.rules.ExceptionCodes;
import io.intino.magritte.framework.Layer;
import io.intino.magritte.framework.Node;
import io.intino.magritte.framework.loaders.BooleanLoader;
import io.intino.magritte.framework.loaders.NodeLoader;
import io.intino.magritte.framework.loaders.WordLoader;
import io.intino.magritte.framework.tags.Terminal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public abstract class PassiveView
extends Layer
implements Terminal {
    protected List<Request> requestList = new ArrayList<Request>();
    protected List<Notification> notificationList = new ArrayList<Notification>();
    protected ExtensionOf _extensionOf;

    public PassiveView(Node node) {
        super(node);
    }

    public List<Request> requestList() {
        return Collections.unmodifiableList(this.requestList);
    }

    public Request request(int index) {
        return this.requestList.get(index);
    }

    public List<Request> requestList(Predicate<Request> predicate) {
        return this.requestList().stream().filter(predicate).collect(Collectors.toList());
    }

    public Request request(Predicate<Request> predicate) {
        return this.requestList().stream().filter(predicate).findFirst().orElse(null);
    }

    public List<Notification> notificationList() {
        return Collections.unmodifiableList(this.notificationList);
    }

    public Notification notification(int index) {
        return this.notificationList.get(index);
    }

    public List<Notification> notificationList(Predicate<Notification> predicate) {
        return this.notificationList().stream().filter(predicate).collect(Collectors.toList());
    }

    public Notification notification(Predicate<Notification> predicate) {
        return this.notificationList().stream().filter(predicate).findFirst().orElse(null);
    }

    public ExtensionOf asExtensionOf() {
        return (ExtensionOf)this.a$(ExtensionOf.class);
    }

    public ExtensionOf asExtensionOf(PassiveView parentView) {
        ExtensionOf newElement = (ExtensionOf)this.core$().addAspect(ExtensionOf.class);
        newElement.core$().set((Layer)newElement, "parentView", Collections.singletonList(parentView));
        return newElement;
    }

    public boolean isExtensionOf() {
        return this.core$().is(ExtensionOf.class);
    }

    public void removeExtensionOf() {
        this.core$().removeAspect(ExtensionOf.class);
    }

    protected List<Node> componentList$() {
        LinkedHashSet components = new LinkedHashSet(super.componentList$());
        new ArrayList<Request>(this.requestList).forEach(c -> components.add(c.core$()));
        new ArrayList<Notification>(this.notificationList).forEach(c -> components.add(c.core$()));
        return new ArrayList<Node>(components);
    }

    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap();
        return map;
    }

    protected void addNode$(Node node) {
        super.addNode$(node);
        if (node.is("PassiveView$Request")) {
            this.requestList.add((Request)node.as(Request.class));
        }
        if (node.is("PassiveView$Notification")) {
            this.notificationList.add((Notification)node.as(Notification.class));
        }
    }

    protected void removeNode$(Node node) {
        super.removeNode$(node);
        if (node.is("PassiveView$Request")) {
            this.requestList.remove(node.as(Request.class));
        }
        if (node.is("PassiveView$Notification")) {
            this.notificationList.remove(node.as(Notification.class));
        }
    }

    protected void load$(String name, List<?> values) {
        super.load$(name, values);
    }

    protected void set$(String name, List<?> values) {
        super.set$(name, values);
    }

    public Create create() {
        return new Create(null);
    }

    public Create create(String name) {
        return new Create(name);
    }

    public Clear clear() {
        return new Clear();
    }

    public KonosGraph graph() {
        return (KonosGraph)this.core$().graph().as(KonosGraph.class);
    }

    public static class Request
    extends Data
    implements Terminal {
        protected ResponseType responseType;
        protected List<Exception> exceptionRefs = new ArrayList<Exception>();
        protected List<Exception> exceptionList = new ArrayList<Exception>();
        protected Addressable _addressable;

        public Request(Node node) {
            super(node);
        }

        public ResponseType responseType() {
            return this.responseType;
        }

        public List<Exception> exceptionRefs() {
            return this.exceptionRefs;
        }

        public Exception exceptionRefs(int index) {
            return this.exceptionRefs.get(index);
        }

        public List<Exception> exceptionRefs(Predicate<Exception> predicate) {
            return this.exceptionRefs().stream().filter(predicate).collect(Collectors.toList());
        }

        public Request responseType(ResponseType value) {
            this.responseType = value;
            return this;
        }

        public List<Exception> exceptionList() {
            return Collections.unmodifiableList(this.exceptionList);
        }

        public Exception exception(int index) {
            return this.exceptionList.get(index);
        }

        public List<Exception> exceptionList(Predicate<Exception> predicate) {
            return this.exceptionList().stream().filter(predicate).collect(Collectors.toList());
        }

        public Exception exception(Predicate<Exception> predicate) {
            return this.exceptionList().stream().filter(predicate).findFirst().orElse(null);
        }

        public Addressable asAddressable() {
            return (Addressable)this.a$(Addressable.class);
        }

        public Addressable asAddressable(Service.UI.Resource addressableResource) {
            Addressable newElement = (Addressable)this.core$().addAspect(Addressable.class);
            newElement.core$().set((Layer)newElement, "addressableResource", Collections.singletonList(addressableResource));
            return newElement;
        }

        public boolean isAddressable() {
            return this.core$().is(Addressable.class);
        }

        public void removeAddressable() {
            this.core$().removeAspect(Addressable.class);
        }

        protected List<Node> componentList$() {
            LinkedHashSet components = new LinkedHashSet(super.componentList$());
            new ArrayList<Exception>(this.exceptionList).forEach(c -> components.add(c.core$()));
            return new ArrayList<Node>(components);
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            map.put("responseType", new ArrayList<ResponseType>(Collections.singletonList(this.responseType)));
            map.put("exceptionRefs", this.exceptionRefs);
            return map;
        }

        protected void addNode$(Node node) {
            super.addNode$(node);
            if (node.is("Exception")) {
                this.exceptionList.add((Exception)node.as(Exception.class));
            }
        }

        protected void removeNode$(Node node) {
            super.removeNode$(node);
            if (node.is("Exception")) {
                this.exceptionList.remove(node.as(Exception.class));
            }
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("responseType")) {
                this.responseType = (ResponseType)((Object)WordLoader.load(values, ResponseType.class, (Layer)this).get(0));
            } else if (name.equalsIgnoreCase("exceptionRefs")) {
                this.exceptionRefs = NodeLoader.load(values, Exception.class, (Layer)this);
            }
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("responseType")) {
                this.responseType = (ResponseType)((Object)values.get(0));
            } else if (name.equalsIgnoreCase("exceptionRefs")) {
                this.exceptionRefs = values.stream().map(s -> (Exception)this.graph().core$().load(((Layer)s).core$().id()).as(Exception.class)).collect(Collectors.toList());
            }
        }

        @Override
        public Create create() {
            return new Create(null);
        }

        @Override
        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        @Override
        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }

        public static enum ResponseType {
            Asset,
            Void;

        }

        public static class Addressable
        extends Layer
        implements Terminal {
            protected Service.UI.Resource addressableResource;
            protected boolean encoded;
            protected boolean listenForChanges;
            protected Request _request;

            public Addressable(Node node) {
                super(node);
            }

            public Service.UI.Resource addressableResource() {
                return this.addressableResource;
            }

            public boolean encoded() {
                return this.encoded;
            }

            public boolean listenForChanges() {
                return this.listenForChanges;
            }

            public ResponseType responseType() {
                return this._request.responseType();
            }

            public List<Exception> exceptionRefs() {
                return this._request.exceptionRefs();
            }

            public Exception exceptionRefs(int index) {
                return this._request.exceptionRefs().get(index);
            }

            public Addressable addressableResource(Service.UI.Resource value) {
                this.addressableResource = value;
                return this;
            }

            public Addressable encoded(boolean value) {
                this.encoded = value;
                return this;
            }

            public Addressable listenForChanges(boolean value) {
                this.listenForChanges = value;
                return this;
            }

            public Addressable responseType(ResponseType value) {
                this._request.responseType(value);
                return this;
            }

            public List<Exception> exceptionList() {
                return this._request.exceptionList();
            }

            public Exception exceptionList(int index) {
                return this._request.exceptionList().get(index);
            }

            public Request asRequest() {
                return (Request)this.a$(Request.class);
            }

            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap();
                map.put("addressableResource", this.addressableResource != null ? new ArrayList<Service.UI.Resource>(Collections.singletonList(this.addressableResource)) : Collections.emptyList());
                map.put("encoded", new ArrayList<Boolean>(Collections.singletonList(this.encoded)));
                map.put("listenForChanges", new ArrayList<Boolean>(Collections.singletonList(this.listenForChanges)));
                return map;
            }

            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("addressableResource")) {
                    this.addressableResource = (Service.UI.Resource)((Object)NodeLoader.load(values, Service.UI.Resource.class, (Layer)this).get(0));
                } else if (name.equalsIgnoreCase("encoded")) {
                    this.encoded = (Boolean)BooleanLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("listenForChanges")) {
                    this.listenForChanges = (Boolean)BooleanLoader.load(values, (Layer)this).get(0);
                }
            }

            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("addressableResource")) {
                    this.addressableResource = values.get(0) != null ? (Service.UI.Resource)this.core$().graph().load(((Layer)values.get(0)).core$().id()).as(Service.UI.Resource.class) : null;
                } else if (name.equalsIgnoreCase("encoded")) {
                    this.encoded = (Boolean)values.get(0);
                } else if (name.equalsIgnoreCase("listenForChanges")) {
                    this.listenForChanges = (Boolean)values.get(0);
                }
            }

            protected void sync$(Layer layer) {
                super.sync$(layer);
                if (layer instanceof Request) {
                    this._request = (Request)layer;
                }
            }

            public Create create() {
                return new Create(null);
            }

            public Create create(String name) {
                return new Create(name);
            }

            public Clear clear() {
                return new Clear();
            }

            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }

            public class Create {
                protected final String name;

                public Create(String name) {
                    this.name = name;
                }

                public Exception exception(ExceptionCodes code) {
                    Exception newElement = (Exception)Addressable.this.core$().graph().concept(Exception.class).createNode(this.name, Addressable.this.core$()).as(Exception.class);
                    newElement.core$().set((Layer)newElement, "code", Collections.singletonList(code));
                    return newElement;
                }
            }

            public class Clear {
                public void exception(Predicate<Exception> filter) {
                    new ArrayList<Exception>(Addressable.this.exceptionList()).stream().filter(filter).forEach(Layer::delete$);
                }
            }
        }

        public class Create
        extends Data.Create {
            public Create(String name) {
                super(name);
            }

            public Exception exception(ExceptionCodes code) {
                Exception newElement = (Exception)Request.this.core$().graph().concept(Exception.class).createNode(this.name, Request.this.core$()).as(Exception.class);
                newElement.core$().set((Layer)newElement, "code", Collections.singletonList(code));
                return newElement;
            }
        }

        public class Clear {
            public void exception(Predicate<Exception> filter) {
                new ArrayList<Exception>(Request.this.exceptionList()).stream().filter(filter).forEach(Layer::delete$);
            }
        }
    }

    public static class Notification
    extends Data
    implements Terminal {
        protected To to;
        protected List<Exception> exceptionRefs = new ArrayList<Exception>();
        protected List<Exception> exceptionList = new ArrayList<Exception>();

        public Notification(Node node) {
            super(node);
        }

        public To to() {
            return this.to;
        }

        public List<Exception> exceptionRefs() {
            return this.exceptionRefs;
        }

        public Exception exceptionRefs(int index) {
            return this.exceptionRefs.get(index);
        }

        public List<Exception> exceptionRefs(Predicate<Exception> predicate) {
            return this.exceptionRefs().stream().filter(predicate).collect(Collectors.toList());
        }

        public Notification to(To value) {
            this.to = value;
            return this;
        }

        public List<Exception> exceptionList() {
            return Collections.unmodifiableList(this.exceptionList);
        }

        public Exception exception(int index) {
            return this.exceptionList.get(index);
        }

        public List<Exception> exceptionList(Predicate<Exception> predicate) {
            return this.exceptionList().stream().filter(predicate).collect(Collectors.toList());
        }

        public Exception exception(Predicate<Exception> predicate) {
            return this.exceptionList().stream().filter(predicate).findFirst().orElse(null);
        }

        protected List<Node> componentList$() {
            LinkedHashSet components = new LinkedHashSet(super.componentList$());
            new ArrayList<Exception>(this.exceptionList).forEach(c -> components.add(c.core$()));
            return new ArrayList<Node>(components);
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            map.put("to", new ArrayList<To>(Collections.singletonList(this.to)));
            map.put("exceptionRefs", this.exceptionRefs);
            return map;
        }

        protected void addNode$(Node node) {
            super.addNode$(node);
            if (node.is("Exception")) {
                this.exceptionList.add((Exception)node.as(Exception.class));
            }
        }

        protected void removeNode$(Node node) {
            super.removeNode$(node);
            if (node.is("Exception")) {
                this.exceptionList.remove(node.as(Exception.class));
            }
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("to")) {
                this.to = (To)((Object)WordLoader.load(values, To.class, (Layer)this).get(0));
            } else if (name.equalsIgnoreCase("exceptionRefs")) {
                this.exceptionRefs = NodeLoader.load(values, Exception.class, (Layer)this);
            }
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("to")) {
                this.to = (To)((Object)values.get(0));
            } else if (name.equalsIgnoreCase("exceptionRefs")) {
                this.exceptionRefs = values.stream().map(s -> (Exception)this.graph().core$().load(((Layer)s).core$().id()).as(Exception.class)).collect(Collectors.toList());
            }
        }

        @Override
        public Create create() {
            return new Create(null);
        }

        @Override
        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        @Override
        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }

        public static enum To {
            All,
            Client,
            Display;

        }

        public class Create
        extends Data.Create {
            public Create(String name) {
                super(name);
            }

            public Exception exception(ExceptionCodes code) {
                Exception newElement = (Exception)Notification.this.core$().graph().concept(Exception.class).createNode(this.name, Notification.this.core$()).as(Exception.class);
                newElement.core$().set((Layer)newElement, "code", Collections.singletonList(code));
                return newElement;
            }
        }

        public class Clear {
            public void exception(Predicate<Exception> filter) {
                new ArrayList<Exception>(Notification.this.exceptionList()).stream().filter(filter).forEach(Layer::delete$);
            }
        }
    }

    public static class ExtensionOf
    extends Layer
    implements Terminal {
        protected PassiveView parentView;
        protected PassiveView _passiveView;

        public ExtensionOf(Node node) {
            super(node);
        }

        public PassiveView parentView() {
            return this.parentView;
        }

        public ExtensionOf parentView(PassiveView value) {
            this.parentView = value;
            return this;
        }

        public List<Request> requestList() {
            return this._passiveView.requestList();
        }

        public Request requestList(int index) {
            return this._passiveView.requestList().get(index);
        }

        public List<Notification> notificationList() {
            return this._passiveView.notificationList();
        }

        public Notification notificationList(int index) {
            return this._passiveView.notificationList().get(index);
        }

        public PassiveView asPassiveView() {
            return (PassiveView)this.a$(PassiveView.class);
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("parentView", this.parentView != null ? new ArrayList<PassiveView>(Collections.singletonList(this.parentView)) : Collections.emptyList());
            return map;
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("parentView")) {
                this.parentView = (PassiveView)((Object)NodeLoader.load(values, PassiveView.class, (Layer)this).get(0));
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("parentView")) {
                this.parentView = values.get(0) != null ? (PassiveView)this.core$().graph().load(((Layer)values.get(0)).core$().id()).as(PassiveView.class) : null;
            }
        }

        protected void sync$(Layer layer) {
            super.sync$(layer);
            if (layer instanceof PassiveView) {
                this._passiveView = (PassiveView)layer;
            }
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }

            public Request request() {
                Request newElement = (Request)ExtensionOf.this.core$().graph().concept(Request.class).createNode(this.name, ExtensionOf.this.core$()).as(Request.class);
                return newElement;
            }

            public Notification notification() {
                Notification newElement = (Notification)ExtensionOf.this.core$().graph().concept(Notification.class).createNode(this.name, ExtensionOf.this.core$()).as(Notification.class);
                return newElement;
            }
        }

        public class Clear {
            public void request(Predicate<Request> filter) {
                new ArrayList<Request>(ExtensionOf.this.requestList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void notification(Predicate<Notification> filter) {
                new ArrayList<Notification>(ExtensionOf.this.notificationList()).stream().filter(filter).forEach(Layer::delete$);
            }
        }
    }

    public class Create {
        protected final String name;

        public Create(String name) {
            this.name = name;
        }

        public Request request() {
            Request newElement = (Request)PassiveView.this.core$().graph().concept(Request.class).createNode(this.name, PassiveView.this.core$()).as(Request.class);
            return newElement;
        }

        public Notification notification() {
            Notification newElement = (Notification)PassiveView.this.core$().graph().concept(Notification.class).createNode(this.name, PassiveView.this.core$()).as(Notification.class);
            return newElement;
        }
    }

    public class Clear {
        public void request(Predicate<Request> filter) {
            new ArrayList<Request>(PassiveView.this.requestList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void notification(Predicate<Notification> filter) {
            new ArrayList<Notification>(PassiveView.this.notificationList()).stream().filter(filter).forEach(Layer::delete$);
        }
    }
}

