/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.ui.displays;

import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.konos.builder.OutputItem;
import io.intino.konos.builder.codegeneration.services.ui.Target;
import io.intino.konos.builder.codegeneration.services.ui.templates.RouteDispatcherTemplate;
import io.intino.konos.builder.codegeneration.ui.UIRenderer;
import io.intino.konos.builder.context.CompilationContext;
import io.intino.konos.builder.helpers.CodeGenerationHelper;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.Service;
import io.intino.magritte.framework.Layer;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class RouteDispatcherRenderer
extends UIRenderer {
    private final List<Service.UI> serviceList;
    private final Target target;

    public RouteDispatcherRenderer(CompilationContext compilationContext, List<Service.UI> serviceList, Target target) {
        super(compilationContext);
        this.serviceList = serviceList;
        this.target = target;
    }

    public RouteDispatcherRenderer(CompilationContext compilationContext, Service.UI service, Target target) {
        super(compilationContext);
        this.serviceList = List.of(service);
        this.target = target;
    }

    @Override
    protected void render() {
        FrameBuilder builder = this.buildFrame();
        CodeGenerationHelper.createIfNotExists(CodeGenerationHelper.displaysFolder(this.src(this.target), this.target));
        CodeGenerationHelper.createIfNotExists(CodeGenerationHelper.displaysFolder(this.gen(this.target), this.target));
        File routeDispatcher = CodeGenerationHelper.fileOf(CodeGenerationHelper.displaysFolder(this.src(this.target), this.target), "RouteDispatcher", this.target);
        if (this.target != Target.Android && !routeDispatcher.exists()) {
            Commons.write(routeDispatcher.toPath(), this.setup(this.template()).render((Object)builder.toFrame()));
        }
        Commons.write(CodeGenerationHelper.fileOf(CodeGenerationHelper.displaysFolder(this.gen(this.target), this.target), this.target != Target.Android ? "AbstractRouteDispatcher" : "RouteDispatcher", this.target).toPath(), this.setup(this.template()).render((Object)builder.add("gen").toFrame()));
        if (this.target.equals((Object)Target.Server)) {
            this.context.compiledFiles().add(new OutputItem(this.context.sourceFileOf(this.serviceList.get(0)), CodeGenerationHelper.fileOf(CodeGenerationHelper.displaysFolder(this.gen(this.target), this.target), "AbstractRouteDispatcher", this.target).getAbsolutePath()));
        }
    }

    @Override
    public FrameBuilder buildFrame() {
        FrameBuilder builder = super.buildFrame();
        builder.add("dispatcher");
        this.resources().stream().filter(Service.UI.Resource::isPage).forEach(r -> {
            if (r.isMain()) {
                builder.add("resource", (Object)this.resourceFrame((Service.UI.Resource)((Object)r)).add("main"));
            }
            builder.add("resource", (Object)this.resourceFrame((Service.UI.Resource)((Object)r)));
        });
        return builder;
    }

    private List<Service.UI.Resource> resources() {
        return this.serviceList.stream().map(Service.UI::resourceList).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private FrameBuilder resourceFrame(Service.UI.Resource resource) {
        FrameBuilder result = this.buildBaseFrame().add("resource");
        result.add("name", (Object)resource.name$());
        result.add("pattern", (Object)this.patternOf(resource));
        this.addResourceParams(resource, result);
        return result;
    }

    private void addResourceParams(Service.UI.Resource resource, FrameBuilder result) {
        List<String> params = this.pathParams(resource);
        int index = 0;
        for (String name : params) {
            result.add("param", this.frameOf(index, name, false));
            ++index;
        }
        params = this.queryParams(resource);
        for (String name : params) {
            result.add("param", this.frameOf(index, name, true));
            ++index;
        }
    }

    private Object frameOf(int index, String name, boolean optional) {
        FrameBuilder result = new FrameBuilder().add("param").add("name", (Object)name).add("index", (Object)index);
        if (optional) {
            result.add("optional");
        }
        return result;
    }

    private List<String> pathParams(Service.UI.Resource resource) {
        Stream<String> split = Stream.of(resource.path().split("/"));
        return split.filter(s -> s.startsWith(":")).map(s -> s.substring(1)).collect(Collectors.toList());
    }

    private List<String> queryParams(Service.UI.Resource resource) {
        return resource.parameterList().stream().map(Layer::name$).collect(Collectors.toList());
    }

    private Template template() {
        if (this.target == Target.Android) {
            return new io.intino.konos.builder.codegeneration.accessor.ui.android.templates.RouteDispatcherTemplate();
        }
        return new RouteDispatcherTemplate();
    }
}

