/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.ui.displays.components;

import io.intino.itrules.FrameBuilder;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.ui.RendererWriter;
import io.intino.konos.builder.codegeneration.ui.displays.components.SizedRenderer;
import io.intino.konos.builder.context.CompilationContext;
import io.intino.konos.builder.helpers.ElementHelper;
import io.intino.konos.model.CatalogComponents;
import io.intino.konos.model.Navigable;

public class CollectionRenderer<T extends CatalogComponents.Collection>
extends SizedRenderer<T> {
    public CollectionRenderer(CompilationContext compilationContext, T component, RendererWriter provider) {
        super(compilationContext, component, provider);
    }

    @Override
    public FrameBuilder properties() {
        FrameBuilder result = super.properties();
        result.add("collection");
        if (((CatalogComponents.Collection)this.element).i$(ElementHelper.conceptOf(Navigable.class))) {
            result.add("navigable", (Object)((Navigable)((CatalogComponents.Collection)this.element).a$(Navigable.class)).position().name());
        }
        if (((CatalogComponents.Collection)this.element).sourceClass() != null) {
            result.add("sourceClass", (Object)((CatalogComponents.Collection)this.element).sourceClass());
        }
        if (((CatalogComponents.Collection)this.element).i$(ElementHelper.conceptOf(CatalogComponents.List.class)) || ((CatalogComponents.Collection)this.element).i$(ElementHelper.conceptOf(CatalogComponents.Table.class)) || ((CatalogComponents.Collection)this.element).i$(ElementHelper.conceptOf(CatalogComponents.Grid.class))) {
            result.add("pageSize", (Object)((CatalogComponents.Collection)this.element).pageSize());
        }
        result.add("itemHeight", (Object)this.itemHeight());
        result.add("scrollingMark", (Object)((CatalogComponents.Collection)this.element).scrollingMark());
        if (((CatalogComponents.Collection)this.element).isSelectable()) {
            result.add("selection", (Object)(((CatalogComponents.Collection)this.element).asSelectable().multiple() ? "multiple" : "single"));
        }
        if (((CatalogComponents.Collection)this.element).noItemsMessage() != null) {
            result.add("noItemsMessage", (Object)((CatalogComponents.Collection)this.element).noItemsMessage());
        }
        if (((CatalogComponents.Collection)this.element).noItemsFoundMessage() != null) {
            result.add("noItemsFoundMessage", (Object)((CatalogComponents.Collection)this.element).noItemsFoundMessage());
        }
        this.addColumns(result);
        return result;
    }

    @Override
    protected boolean addSpecificTypes(FrameBuilder builder) {
        super.addSpecificTypes(builder);
        builder.add(CatalogComponents.Collection.class.getSimpleName(), (Object)this.typeOf(this.element));
        if (((CatalogComponents.Collection)this.element).sourceClass() != null) {
            builder.add("sourceClass", (Object)((CatalogComponents.Collection)this.element).sourceClass());
        }
        if (((CatalogComponents.Collection)this.element).i$(ElementHelper.conceptOf(CatalogComponents.Moldable.class))) {
            builder.add("componentType", (Object)Formatters.firstUpperCase(this.nameOf(((CatalogComponents.Moldable)((CatalogComponents.Collection)this.element).a$(CatalogComponents.Moldable.class)).mold(0).item())));
        }
        builder.add("itemClass", (Object)(((CatalogComponents.Collection)this.element).itemClass() != null ? ((CatalogComponents.Collection)this.element).itemClass() : "java.lang.Void"));
        this.addMethodsFrame(builder);
        return false;
    }

    private void addMethodsFrame(FrameBuilder builder) {
        FrameBuilder result = this.addOwner(this.buildBaseFrame()).add("method").add(CatalogComponents.Collection.class.getSimpleName()).add(this.className(((Object)((Object)((CatalogComponents.Collection)this.element))).getClass()));
        result.add("name", (Object)this.nameOf(this.element));
        result.add("concreteBox", (Object)this.boxName());
        if (((CatalogComponents.Collection)this.element).sourceClass() != null) {
            result.add("sourceClass", (Object)((CatalogComponents.Collection)this.element).sourceClass());
        }
        result.add("itemClass", (Object)(((CatalogComponents.Collection)this.element).itemClass() != null ? ((CatalogComponents.Collection)this.element).itemClass() : "java.lang.Void"));
        result.add("itemVariable", (Object)"item");
        this.addSelectionMethod(result);
        if (((CatalogComponents.Collection)this.element).i$(CatalogComponents.Moldable.class)) {
            ((CatalogComponents.Moldable)((CatalogComponents.Collection)this.element).a$(CatalogComponents.Moldable.class)).moldList().forEach(m -> this.addItemFrame(m.item(), result));
        }
        builder.add("methods", (Object)result);
    }

    private void addItemFrame(CatalogComponents.Moldable.Mold.Item item, FrameBuilder builder) {
        FrameBuilder result = this.buildBaseFrame().add("item");
        if (!this.belongsToAccessible(item)) {
            result.add("concreteBox", (Object)this.boxName());
        }
        result.add("methodAccessibility", (Object)(((CatalogComponents.Collection)this.element).i$(ElementHelper.conceptOf(CatalogComponents.Table.class)) || ((CatalogComponents.Collection)this.element).i$(ElementHelper.conceptOf(CatalogComponents.DynamicTable.class)) ? "private" : "public"));
        result.add("name", (Object)this.nameOf(item));
        result.add("methodName", (Object)(((CatalogComponents.Collection)this.element).i$(ElementHelper.conceptOf(CatalogComponents.Table.class)) || ((CatalogComponents.Collection)this.element).i$(ElementHelper.conceptOf(CatalogComponents.DynamicTable.class)) ? this.nameOf(item) : ""));
        String itemClass = ((CatalogComponents.Collection)this.element).itemClass();
        result.add("itemClass", (Object)new FrameBuilder(new String[]{"itemClass", ((CatalogComponents.Collection)this.element).i$(ElementHelper.conceptOf(CatalogComponents.Map.class)) ? "map" : ""}).add("value", (Object)(itemClass != null ? itemClass : "java.lang.Void")));
        result.add("itemVariable", (Object)new FrameBuilder(new String[]{"itemVariable", ((CatalogComponents.Collection)this.element).i$(ElementHelper.conceptOf(CatalogComponents.Map.class)) ? "map" : ""}).add("value", (Object)"item"));
        builder.add("item", (Object)result);
    }

    private void addSelectionMethod(FrameBuilder builder) {
        if (!((CatalogComponents.Collection)this.element).isSelectable()) {
            return;
        }
        builder.add("selectionMethod", (Object)new FrameBuilder(new String[]{"selectionMethod"}));
    }

    private int itemHeight() {
        if (!((CatalogComponents.Collection)this.element).i$(ElementHelper.conceptOf(CatalogComponents.Moldable.class))) {
            return 100;
        }
        return ((CatalogComponents.Moldable)((CatalogComponents.Collection)this.element).a$(CatalogComponents.Moldable.class)).moldList().stream().mapToInt(m -> m.item().height()).max().orElse(100);
    }

    private void addColumns(FrameBuilder result) {
        if (!((CatalogComponents.Collection)this.element).i$(ElementHelper.conceptOf(CatalogComponents.Grid.class))) {
            return;
        }
        CatalogComponents.Grid grid = (CatalogComponents.Grid)((CatalogComponents.Collection)this.element).a$(CatalogComponents.Grid.class);
        grid.columnList().forEach(c -> result.add("column", (Object)this.frameOf((CatalogComponents.Grid.Column)((Object)c))));
    }

    private FrameBuilder frameOf(CatalogComponents.Grid.Column column) {
        FrameBuilder result = new FrameBuilder(new String[]{"column"});
        result.add("name", (Object)column.name$());
        result.add("label", (Object)column.label());
        if (column.width() != -1) {
            result.add("width", (Object)column.width());
        }
        if (column.sortable()) {
            result.add("sortable", (Object)column.sortable());
        }
        if (column.fixed()) {
            result.add("fixed", (Object)column.fixed());
        }
        if (column.pattern() != null) {
            result.add("pattern", (Object)column.pattern());
        }
        result.add("itemClass", (Object)(((CatalogComponents.Collection)this.element).itemClass() != null ? ((CatalogComponents.Collection)this.element).itemClass() : "java.lang.Void"));
        result.add("type", (Object)(column.isClickable() ? "Link" : column.type().name()));
        if (!column.isAddressable()) {
            return result;
        }
        CatalogComponents.Grid.Column.Addressable addressable = column.asAddressable();
        result.add("address", (Object)(addressable.addressableResource() != null ? addressable.addressableResource().path() : ""));
        return result;
    }

    @Override
    protected String className(Class clazz) {
        return super.className(clazz).replace("collection", "");
    }
}

