/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.model.rules;

import io.intino.tara.language.model.Mogram;
import io.intino.tara.language.model.rules.NodeRule;
import java.util.List;

public class ViewRule
implements NodeRule {
    private ERROR_TYPE error = ERROR_TYPE.NAME;

    public boolean accept(Mogram mogram) {
        List components = mogram.components();
        if (components.size() != 1) {
            this.error(ERROR_TYPE.SIZE);
            return false;
        }
        return components.stream().noneMatch(component -> this.hasForbiddenTypes((Mogram)component) || mogram.isAnonymous() && (this.hasFilteredCatalog((Mogram)component) || this.isRenderDisplay((Mogram)component)));
    }

    private boolean hasForbiddenTypes(Mogram component) {
        return component.types().contains("RenderPanels") || component.types().contains("RenderObjects") && this.error(ERROR_TYPE.COMPONENT_NOT_ALLOWED);
    }

    private boolean hasFilteredCatalog(Mogram component) {
        return component.types().contains("RenderCatalogs") && component.parameters().stream().anyMatch(p -> p.name().equals("filtered") && p.values().get(0).toString().equals("true")) && this.error(ERROR_TYPE.NAME);
    }

    private boolean isRenderDisplay(Mogram component) {
        return component.types().contains("RenderDisplay") && this.error(ERROR_TYPE.NAME);
    }

    public String errorMessage() {
        return switch (this.error) {
            default -> throw new IncompatibleClassChangeError();
            case ERROR_TYPE.NAME -> "This View must have name";
            case ERROR_TYPE.SIZE -> "This View must have just one Render";
            case ERROR_TYPE.COMPONENT_NOT_ALLOWED -> "RenderPanels and RenderObjects are not allowed here";
        };
    }

    private boolean error(ERROR_TYPE type) {
        this.error = type;
        return true;
    }

    static enum ERROR_TYPE {
        NAME,
        SIZE,
        COMPONENT_NOT_ALLOWED;

    }
}

