/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.model;

import io.intino.konos.model.Absolute;
import io.intino.konos.model.ActionableComponents;
import io.intino.konos.model.Animated;
import io.intino.konos.model.AutoSize;
import io.intino.konos.model.CatalogComponents;
import io.intino.konos.model.Component;
import io.intino.konos.model.DataComponents;
import io.intino.konos.model.Dataframe;
import io.intino.konos.model.Display;
import io.intino.konos.model.HelperComponents;
import io.intino.konos.model.InteractionComponents;
import io.intino.konos.model.KonosGraph;
import io.intino.konos.model.Multiple;
import io.intino.konos.model.OtherComponents;
import io.intino.konos.model.PassiveView;
import io.intino.konos.model.Relative;
import io.intino.konos.model.Service;
import io.intino.konos.model.Template;
import io.intino.konos.model.VisualizationComponents;
import io.intino.konos.model.rules.Layout;
import io.intino.konos.model.rules.Spacing;
import io.intino.magritte.framework.Layer;
import io.intino.magritte.framework.Node;
import io.intino.magritte.framework.loaders.BooleanLoader;
import io.intino.magritte.framework.loaders.IntegerLoader;
import io.intino.magritte.framework.loaders.NodeLoader;
import io.intino.magritte.framework.loaders.StringLoader;
import io.intino.magritte.framework.loaders.WordLoader;
import io.intino.magritte.framework.tags.Terminal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class Block
extends Component
implements Terminal {
    protected List<Layout> layout = new ArrayList<Layout>();
    protected Spacing spacing;
    protected Hidden hidden;
    protected List<Component> componentList = new ArrayList<Component>();
    protected Drawer _drawer;
    protected Splitter _splitter;
    protected Absolute _absolute;
    protected Relative _relative;
    protected AutoSize _autoSize;
    protected Paper _paper;
    protected Badge _badge;
    protected Parallax _parallax;
    protected Conditional _conditional;
    protected Animated _animated;
    protected Multiple _multiple;
    protected Popover _popover;

    public Block(Node node) {
        super(node);
    }

    public List<Layout> layout() {
        return this.layout;
    }

    public Spacing spacing() {
        return this.spacing;
    }

    public Hidden hidden() {
        return this.hidden;
    }

    public Block layout(List<Layout> values) {
        this.layout = values;
        return this;
    }

    public Block spacing(Spacing value) {
        this.spacing = value;
        return this;
    }

    public Block hidden(Hidden value) {
        this.hidden = value;
        return this;
    }

    public List<Component> componentList() {
        return Collections.unmodifiableList(this.componentList);
    }

    public Component component(int index) {
        return this.componentList.get(index);
    }

    public List<Component> componentList(Predicate<Component> predicate) {
        return this.componentList().stream().filter(predicate).collect(Collectors.toList());
    }

    public Component component(Predicate<Component> predicate) {
        return this.componentList().stream().filter(predicate).findFirst().orElse(null);
    }

    public Splitter asSplitter() {
        Layer as = this.a$(Splitter.class);
        return as != null ? (Splitter)as : (Splitter)this.core$().addAspect(Splitter.class);
    }

    public boolean isSplitter() {
        return this.core$().is(Splitter.class);
    }

    public void removeSplitter() {
        this.core$().removeAspect(Splitter.class);
    }

    public Relative asRelative() {
        Layer as = this.a$(Relative.class);
        return as != null ? (Relative)as : (Relative)this.core$().addAspect(Relative.class);
    }

    public boolean isRelative() {
        return this.core$().is(Relative.class);
    }

    public void removeRelative() {
        this.core$().removeAspect(Relative.class);
    }

    public Absolute asAbsolute() {
        Layer as = this.a$(Absolute.class);
        return as != null ? (Absolute)as : (Absolute)this.core$().addAspect(Absolute.class);
    }

    public boolean isAbsolute() {
        return this.core$().is(Absolute.class);
    }

    public void removeAbsolute() {
        this.core$().removeAspect(Absolute.class);
    }

    public Animated asAnimated() {
        Layer as = this.a$(Animated.class);
        return as != null ? (Animated)as : (Animated)this.core$().addAspect(Animated.class);
    }

    public boolean isAnimated() {
        return this.core$().is(Animated.class);
    }

    public void removeAnimated() {
        this.core$().removeAspect(Animated.class);
    }

    public Badge asBadge() {
        Layer as = this.a$(Badge.class);
        return as != null ? (Badge)as : (Badge)this.core$().addAspect(Badge.class);
    }

    public boolean isBadge() {
        return this.core$().is(Badge.class);
    }

    public void removeBadge() {
        this.core$().removeAspect(Badge.class);
    }

    public Parallax asParallax() {
        return (Parallax)this.a$(Parallax.class);
    }

    public Parallax asParallax(String background) {
        Parallax newElement = (Parallax)this.core$().addAspect(Parallax.class);
        newElement.core$().set((Layer)newElement, "background", Collections.singletonList(background));
        return newElement;
    }

    public boolean isParallax() {
        return this.core$().is(Parallax.class);
    }

    public void removeParallax() {
        this.core$().removeAspect(Parallax.class);
    }

    public Drawer asDrawer() {
        Layer as = this.a$(Drawer.class);
        return as != null ? (Drawer)as : (Drawer)this.core$().addAspect(Drawer.class);
    }

    public boolean isDrawer() {
        return this.core$().is(Drawer.class);
    }

    public void removeDrawer() {
        this.core$().removeAspect(Drawer.class);
    }

    public AutoSize asAutoSize() {
        Layer as = this.a$(AutoSize.class);
        return as != null ? (AutoSize)as : (AutoSize)this.core$().addAspect(AutoSize.class);
    }

    public boolean isAutoSize() {
        return this.core$().is(AutoSize.class);
    }

    public void removeAutoSize() {
        this.core$().removeAspect(AutoSize.class);
    }

    public Popover asPopover() {
        Layer as = this.a$(Popover.class);
        return as != null ? (Popover)as : (Popover)this.core$().addAspect(Popover.class);
    }

    public boolean isPopover() {
        return this.core$().is(Popover.class);
    }

    public void removePopover() {
        this.core$().removeAspect(Popover.class);
    }

    public Conditional asConditional() {
        Layer as = this.a$(Conditional.class);
        return as != null ? (Conditional)as : (Conditional)this.core$().addAspect(Conditional.class);
    }

    public boolean isConditional() {
        return this.core$().is(Conditional.class);
    }

    public void removeConditional() {
        this.core$().removeAspect(Conditional.class);
    }

    public Paper asPaper() {
        Layer as = this.a$(Paper.class);
        return as != null ? (Paper)as : (Paper)this.core$().addAspect(Paper.class);
    }

    public boolean isPaper() {
        return this.core$().is(Paper.class);
    }

    public void removePaper() {
        this.core$().removeAspect(Paper.class);
    }

    public Multiple asMultiple() {
        Layer as = this.a$(Multiple.class);
        return as != null ? (Multiple)as : (Multiple)this.core$().addAspect(Multiple.class);
    }

    public boolean isMultiple() {
        return this.core$().is(Multiple.class);
    }

    public void removeMultiple() {
        this.core$().removeAspect(Multiple.class);
    }

    @Override
    protected List<Node> componentList$() {
        LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList$());
        new ArrayList<Component>(this.componentList).forEach(c -> components.add(c.core$()));
        return new ArrayList<Node>(components);
    }

    @Override
    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap(super.variables$());
        map.put("layout", this.layout);
        map.put("spacing", new ArrayList<Spacing>(Collections.singletonList(this.spacing)));
        map.put("hidden", new ArrayList<Hidden>(Collections.singletonList(this.hidden)));
        return map;
    }

    @Override
    protected void addNode$(Node node) {
        super.addNode$(node);
        if (node.is("Component")) {
            this.componentList.add((Component)node.as(Component.class));
        }
    }

    @Override
    protected void removeNode$(Node node) {
        super.removeNode$(node);
        if (node.is("Component")) {
            this.componentList.remove(node.as(Component.class));
        }
    }

    @Override
    protected void load$(String name, List<?> values) {
        super.load$(name, values);
        if (name.equalsIgnoreCase("layout")) {
            this.layout = WordLoader.load(values, Layout.class, (Layer)this);
        } else if (name.equalsIgnoreCase("spacing")) {
            this.spacing = (Spacing)((Object)WordLoader.load(values, Spacing.class, (Layer)this).get(0));
        } else if (name.equalsIgnoreCase("hidden")) {
            this.hidden = (Hidden)((Object)WordLoader.load(values, Hidden.class, (Layer)this).get(0));
        }
    }

    @Override
    protected void set$(String name, List<?> values) {
        super.set$(name, values);
        if (name.equalsIgnoreCase("layout")) {
            this.layout = new ArrayList(values);
        } else if (name.equalsIgnoreCase("spacing")) {
            this.spacing = (Spacing)((Object)values.get(0));
        } else if (name.equalsIgnoreCase("hidden")) {
            this.hidden = (Hidden)((Object)values.get(0));
        }
    }

    @Override
    public Create create() {
        return new Create(null);
    }

    @Override
    public Create create(String name) {
        return new Create(name);
    }

    @Override
    public Clear clear() {
        return new Clear();
    }

    @Override
    public KonosGraph graph() {
        return (KonosGraph)this.core$().graph().as(KonosGraph.class);
    }

    public static enum Hidden {
        Never,
        Always,
        IfMobile,
        IfNotMobile;

    }

    public static class Splitter
    extends Layer
    implements Terminal {
        protected String splitMobileLabel;
        protected Block _block;

        public Splitter(Node node) {
            super(node);
        }

        public String splitMobileLabel() {
            return this.splitMobileLabel;
        }

        public List<Layout> layout() {
            return this._block.layout();
        }

        public Spacing spacing() {
            return this._block.spacing();
        }

        public Hidden hidden() {
            return this._block.hidden();
        }

        public Splitter splitMobileLabel(String value) {
            this.splitMobileLabel = value;
            return this;
        }

        public Splitter layout(List<Layout> values) {
            this._block.layout(values);
            return this;
        }

        public Splitter spacing(Spacing value) {
            this._block.spacing(value);
            return this;
        }

        public Splitter hidden(Hidden value) {
            this._block.hidden(value);
            return this;
        }

        public List<Component> componentList() {
            return this._block.componentList();
        }

        public Component componentList(int index) {
            return this._block.componentList().get(index);
        }

        public List<Block> blockList() {
            return this._block.blockList();
        }

        public Block blockList(int index) {
            return this._block.blockList().get(index);
        }

        public List<PassiveView.Request> requestList() {
            return this._block.requestList();
        }

        public PassiveView.Request requestList(int index) {
            return this._block.requestList().get(index);
        }

        public List<PassiveView.Notification> notificationList() {
            return this._block.notificationList();
        }

        public PassiveView.Notification notificationList(int index) {
            return this._block.notificationList().get(index);
        }

        public Block asBlock() {
            return (Block)this.a$(Block.class);
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("splitMobileLabel", new ArrayList<String>(Collections.singletonList(this.splitMobileLabel)));
            return map;
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("splitMobileLabel")) {
                this.splitMobileLabel = (String)StringLoader.load(values, (Layer)this).get(0);
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("splitMobileLabel")) {
                this.splitMobileLabel = (String)values.get(0);
            }
        }

        protected void sync$(Layer layer) {
            super.sync$(layer);
            if (layer instanceof Block) {
                this._block = (Block)layer;
            }
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }

            public Component component() {
                Component newElement = (Component)Splitter.this.core$().graph().concept(Component.class).createNode(this.name, Splitter.this.core$()).as(Component.class);
                return newElement;
            }

            public Block block() {
                Block newElement = (Block)Splitter.this.core$().graph().concept(Block.class).createNode(this.name, Splitter.this.core$()).as(Block.class);
                return newElement;
            }

            public PassiveView.Request request() {
                PassiveView.Request newElement = (PassiveView.Request)Splitter.this.core$().graph().concept(PassiveView.Request.class).createNode(this.name, Splitter.this.core$()).as(PassiveView.Request.class);
                return newElement;
            }

            public PassiveView.Notification notification() {
                PassiveView.Notification newElement = (PassiveView.Notification)Splitter.this.core$().graph().concept(PassiveView.Notification.class).createNode(this.name, Splitter.this.core$()).as(PassiveView.Notification.class);
                return newElement;
            }
        }

        public class Clear {
            public void component(Predicate<Component> filter) {
                new ArrayList<Component>(Splitter.this.componentList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void block(Predicate<Block> filter) {
                new ArrayList<Block>(Splitter.this.blockList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void request(Predicate<PassiveView.Request> filter) {
                new ArrayList<PassiveView.Request>(Splitter.this.requestList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void notification(Predicate<PassiveView.Notification> filter) {
                new ArrayList<PassiveView.Notification>(Splitter.this.notificationList()).stream().filter(filter).forEach(Layer::delete$);
            }
        }
    }

    public static class Relative
    extends io.intino.konos.model.Relative
    implements Terminal {
        protected Block _block;

        public Relative(Node node) {
            super(node);
        }

        public List<Layout> layout() {
            return this._block.layout();
        }

        public Spacing spacing() {
            return this._block.spacing();
        }

        public Hidden hidden() {
            return this._block.hidden();
        }

        public Relative layout(List<Layout> values) {
            this._block.layout(values);
            return this;
        }

        public Relative spacing(Spacing value) {
            this._block.spacing(value);
            return this;
        }

        public Relative hidden(Hidden value) {
            this._block.hidden(value);
            return this;
        }

        public List<Component> componentList() {
            return this._block.componentList();
        }

        public Component componentList(int index) {
            return this._block.componentList().get(index);
        }

        public List<Block> blockList() {
            return this._block.blockList();
        }

        public Block blockList(int index) {
            return this._block.blockList().get(index);
        }

        public List<PassiveView.Request> requestList() {
            return this._block.requestList();
        }

        public PassiveView.Request requestList(int index) {
            return this._block.requestList().get(index);
        }

        public List<PassiveView.Notification> notificationList() {
            return this._block.notificationList();
        }

        public PassiveView.Notification notificationList(int index) {
            return this._block.notificationList().get(index);
        }

        public Block asBlock() {
            return (Block)this.a$(Block.class);
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
        }

        protected void sync$(Layer layer) {
            super.sync$(layer);
            if (layer instanceof Block) {
                this._block = (Block)layer;
            }
        }

        @Override
        public Create create() {
            return new Create(null);
        }

        @Override
        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        @Override
        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }

        public class Create
        extends Relative.Create {
            public Create(String name) {
                super(name);
            }

            public Component component() {
                Component newElement = (Component)Relative.this.core$().graph().concept(Component.class).createNode(this.name, Relative.this.core$()).as(Component.class);
                return newElement;
            }

            public Block block() {
                Block newElement = (Block)Relative.this.core$().graph().concept(Block.class).createNode(this.name, Relative.this.core$()).as(Block.class);
                return newElement;
            }

            public PassiveView.Request request() {
                PassiveView.Request newElement = (PassiveView.Request)Relative.this.core$().graph().concept(PassiveView.Request.class).createNode(this.name, Relative.this.core$()).as(PassiveView.Request.class);
                return newElement;
            }

            public PassiveView.Notification notification() {
                PassiveView.Notification newElement = (PassiveView.Notification)Relative.this.core$().graph().concept(PassiveView.Notification.class).createNode(this.name, Relative.this.core$()).as(PassiveView.Notification.class);
                return newElement;
            }
        }

        public class Clear {
            public void component(Predicate<Component> filter) {
                new ArrayList<Component>(Relative.this.componentList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void block(Predicate<Block> filter) {
                new ArrayList<Block>(Relative.this.blockList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void request(Predicate<PassiveView.Request> filter) {
                new ArrayList<PassiveView.Request>(Relative.this.requestList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void notification(Predicate<PassiveView.Notification> filter) {
                new ArrayList<PassiveView.Notification>(Relative.this.notificationList()).stream().filter(filter).forEach(Layer::delete$);
            }
        }
    }

    public static class Absolute
    extends io.intino.konos.model.Absolute
    implements Terminal {
        protected Block _block;

        public Absolute(Node node) {
            super(node);
        }

        public List<Layout> layout() {
            return this._block.layout();
        }

        public Spacing spacing() {
            return this._block.spacing();
        }

        public Hidden hidden() {
            return this._block.hidden();
        }

        public Absolute layout(List<Layout> values) {
            this._block.layout(values);
            return this;
        }

        public Absolute spacing(Spacing value) {
            this._block.spacing(value);
            return this;
        }

        public Absolute hidden(Hidden value) {
            this._block.hidden(value);
            return this;
        }

        public List<Component> componentList() {
            return this._block.componentList();
        }

        public Component componentList(int index) {
            return this._block.componentList().get(index);
        }

        public List<Block> blockList() {
            return this._block.blockList();
        }

        public Block blockList(int index) {
            return this._block.blockList().get(index);
        }

        public List<PassiveView.Request> requestList() {
            return this._block.requestList();
        }

        public PassiveView.Request requestList(int index) {
            return this._block.requestList().get(index);
        }

        public List<PassiveView.Notification> notificationList() {
            return this._block.notificationList();
        }

        public PassiveView.Notification notificationList(int index) {
            return this._block.notificationList().get(index);
        }

        public Block asBlock() {
            return (Block)this.a$(Block.class);
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
        }

        protected void sync$(Layer layer) {
            super.sync$(layer);
            if (layer instanceof Block) {
                this._block = (Block)layer;
            }
        }

        @Override
        public Create create() {
            return new Create(null);
        }

        @Override
        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        @Override
        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }

        public class Create
        extends Absolute.Create {
            public Create(String name) {
                super(Absolute.this, name);
            }

            public Component component() {
                Component newElement = (Component)Absolute.this.core$().graph().concept(Component.class).createNode(this.name, Absolute.this.core$()).as(Component.class);
                return newElement;
            }

            public Block block() {
                Block newElement = (Block)Absolute.this.core$().graph().concept(Block.class).createNode(this.name, Absolute.this.core$()).as(Block.class);
                return newElement;
            }

            public PassiveView.Request request() {
                PassiveView.Request newElement = (PassiveView.Request)Absolute.this.core$().graph().concept(PassiveView.Request.class).createNode(this.name, Absolute.this.core$()).as(PassiveView.Request.class);
                return newElement;
            }

            public PassiveView.Notification notification() {
                PassiveView.Notification newElement = (PassiveView.Notification)Absolute.this.core$().graph().concept(PassiveView.Notification.class).createNode(this.name, Absolute.this.core$()).as(PassiveView.Notification.class);
                return newElement;
            }
        }

        public class Clear {
            public void component(Predicate<Component> filter) {
                new ArrayList<Component>(Absolute.this.componentList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void block(Predicate<Block> filter) {
                new ArrayList<Block>(Absolute.this.blockList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void request(Predicate<PassiveView.Request> filter) {
                new ArrayList<PassiveView.Request>(Absolute.this.requestList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void notification(Predicate<PassiveView.Notification> filter) {
                new ArrayList<PassiveView.Notification>(Absolute.this.notificationList()).stream().filter(filter).forEach(Layer::delete$);
            }
        }
    }

    public static class Animated
    extends io.intino.konos.model.Animated
    implements Terminal {
        protected Block _block;

        public Animated(Node node) {
            super(node);
        }

        public List<Layout> layout() {
            return this._block.layout();
        }

        public Spacing spacing() {
            return this._block.spacing();
        }

        public Hidden hidden() {
            return this._block.hidden();
        }

        public Animated layout(List<Layout> values) {
            this._block.layout(values);
            return this;
        }

        public Animated spacing(Spacing value) {
            this._block.spacing(value);
            return this;
        }

        public Animated hidden(Hidden value) {
            this._block.hidden(value);
            return this;
        }

        public List<Component> componentList() {
            return this._block.componentList();
        }

        public Component componentList(int index) {
            return this._block.componentList().get(index);
        }

        public List<Block> blockList() {
            return this._block.blockList();
        }

        public Block blockList(int index) {
            return this._block.blockList().get(index);
        }

        public List<PassiveView.Request> requestList() {
            return this._block.requestList();
        }

        public PassiveView.Request requestList(int index) {
            return this._block.requestList().get(index);
        }

        public List<PassiveView.Notification> notificationList() {
            return this._block.notificationList();
        }

        public PassiveView.Notification notificationList(int index) {
            return this._block.notificationList().get(index);
        }

        public Block asBlock() {
            return (Block)this.a$(Block.class);
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
        }

        protected void sync$(Layer layer) {
            super.sync$(layer);
            if (layer instanceof Block) {
                this._block = (Block)layer;
            }
        }

        @Override
        public Create create() {
            return new Create(null);
        }

        @Override
        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        @Override
        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }

        public class Create
        extends Animated.Create {
            public Create(String name) {
                super(Animated.this, name);
            }

            public Component component() {
                Component newElement = (Component)Animated.this.core$().graph().concept(Component.class).createNode(this.name, Animated.this.core$()).as(Component.class);
                return newElement;
            }

            public Block block() {
                Block newElement = (Block)Animated.this.core$().graph().concept(Block.class).createNode(this.name, Animated.this.core$()).as(Block.class);
                return newElement;
            }

            public PassiveView.Request request() {
                PassiveView.Request newElement = (PassiveView.Request)Animated.this.core$().graph().concept(PassiveView.Request.class).createNode(this.name, Animated.this.core$()).as(PassiveView.Request.class);
                return newElement;
            }

            public PassiveView.Notification notification() {
                PassiveView.Notification newElement = (PassiveView.Notification)Animated.this.core$().graph().concept(PassiveView.Notification.class).createNode(this.name, Animated.this.core$()).as(PassiveView.Notification.class);
                return newElement;
            }
        }

        public class Clear {
            public void component(Predicate<Component> filter) {
                new ArrayList<Component>(Animated.this.componentList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void block(Predicate<Block> filter) {
                new ArrayList<Block>(Animated.this.blockList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void request(Predicate<PassiveView.Request> filter) {
                new ArrayList<PassiveView.Request>(Animated.this.requestList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void notification(Predicate<PassiveView.Notification> filter) {
                new ArrayList<PassiveView.Notification>(Animated.this.notificationList()).stream().filter(filter).forEach(Layer::delete$);
            }
        }
    }

    public static class Badge
    extends Layer
    implements Terminal {
        protected int value;
        protected int max;
        protected boolean showZero;
        protected Mode mode;
        protected Block _block;

        public Badge(Node node) {
            super(node);
        }

        public int value() {
            return this.value;
        }

        public int max() {
            return this.max;
        }

        public boolean showZero() {
            return this.showZero;
        }

        public Mode mode() {
            return this.mode;
        }

        public List<Layout> layout() {
            return this._block.layout();
        }

        public Spacing spacing() {
            return this._block.spacing();
        }

        public Hidden hidden() {
            return this._block.hidden();
        }

        public Badge value(int value) {
            this.value = value;
            return this;
        }

        public Badge max(int value) {
            this.max = value;
            return this;
        }

        public Badge showZero(boolean value) {
            this.showZero = value;
            return this;
        }

        public Badge mode(Mode value) {
            this.mode = value;
            return this;
        }

        public Badge layout(List<Layout> values) {
            this._block.layout(values);
            return this;
        }

        public Badge spacing(Spacing value) {
            this._block.spacing(value);
            return this;
        }

        public Badge hidden(Hidden value) {
            this._block.hidden(value);
            return this;
        }

        public List<Component> componentList() {
            return this._block.componentList();
        }

        public Component componentList(int index) {
            return this._block.componentList().get(index);
        }

        public List<Block> blockList() {
            return this._block.blockList();
        }

        public Block blockList(int index) {
            return this._block.blockList().get(index);
        }

        public List<PassiveView.Request> requestList() {
            return this._block.requestList();
        }

        public PassiveView.Request requestList(int index) {
            return this._block.requestList().get(index);
        }

        public List<PassiveView.Notification> notificationList() {
            return this._block.notificationList();
        }

        public PassiveView.Notification notificationList(int index) {
            return this._block.notificationList().get(index);
        }

        public Block asBlock() {
            return (Block)this.a$(Block.class);
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("value", new ArrayList<Integer>(Collections.singletonList(this.value)));
            map.put("max", new ArrayList<Integer>(Collections.singletonList(this.max)));
            map.put("showZero", new ArrayList<Boolean>(Collections.singletonList(this.showZero)));
            map.put("mode", new ArrayList<Mode>(Collections.singletonList(this.mode)));
            return map;
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("value")) {
                this.value = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("max")) {
                this.max = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("showZero")) {
                this.showZero = (Boolean)BooleanLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("mode")) {
                this.mode = (Mode)((Object)WordLoader.load(values, Mode.class, (Layer)this).get(0));
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("value")) {
                this.value = (Integer)values.get(0);
            } else if (name.equalsIgnoreCase("max")) {
                this.max = (Integer)values.get(0);
            } else if (name.equalsIgnoreCase("showZero")) {
                this.showZero = (Boolean)values.get(0);
            } else if (name.equalsIgnoreCase("mode")) {
                this.mode = (Mode)((Object)values.get(0));
            }
        }

        protected void sync$(Layer layer) {
            super.sync$(layer);
            if (layer instanceof Block) {
                this._block = (Block)layer;
            }
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }

        public static enum Mode {
            Normal,
            Dot;

        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }

            public Component component() {
                Component newElement = (Component)Badge.this.core$().graph().concept(Component.class).createNode(this.name, Badge.this.core$()).as(Component.class);
                return newElement;
            }

            public Block block() {
                Block newElement = (Block)Badge.this.core$().graph().concept(Block.class).createNode(this.name, Badge.this.core$()).as(Block.class);
                return newElement;
            }

            public PassiveView.Request request() {
                PassiveView.Request newElement = (PassiveView.Request)Badge.this.core$().graph().concept(PassiveView.Request.class).createNode(this.name, Badge.this.core$()).as(PassiveView.Request.class);
                return newElement;
            }

            public PassiveView.Notification notification() {
                PassiveView.Notification newElement = (PassiveView.Notification)Badge.this.core$().graph().concept(PassiveView.Notification.class).createNode(this.name, Badge.this.core$()).as(PassiveView.Notification.class);
                return newElement;
            }
        }

        public class Clear {
            public void component(Predicate<Component> filter) {
                new ArrayList<Component>(Badge.this.componentList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void block(Predicate<Block> filter) {
                new ArrayList<Block>(Badge.this.blockList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void request(Predicate<PassiveView.Request> filter) {
                new ArrayList<PassiveView.Request>(Badge.this.requestList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void notification(Predicate<PassiveView.Notification> filter) {
                new ArrayList<PassiveView.Notification>(Badge.this.notificationList()).stream().filter(filter).forEach(Layer::delete$);
            }
        }
    }

    public static class Parallax
    extends Layer
    implements Terminal {
        protected String background;
        protected Block _block;

        public Parallax(Node node) {
            super(node);
        }

        public String background() {
            return this.background;
        }

        public List<Layout> layout() {
            return this._block.layout();
        }

        public Spacing spacing() {
            return this._block.spacing();
        }

        public Hidden hidden() {
            return this._block.hidden();
        }

        public Parallax background(String value) {
            this.background = value;
            return this;
        }

        public Parallax layout(List<Layout> values) {
            this._block.layout(values);
            return this;
        }

        public Parallax spacing(Spacing value) {
            this._block.spacing(value);
            return this;
        }

        public Parallax hidden(Hidden value) {
            this._block.hidden(value);
            return this;
        }

        public List<Component> componentList() {
            return this._block.componentList();
        }

        public Component componentList(int index) {
            return this._block.componentList().get(index);
        }

        public List<Block> blockList() {
            return this._block.blockList();
        }

        public Block blockList(int index) {
            return this._block.blockList().get(index);
        }

        public List<PassiveView.Request> requestList() {
            return this._block.requestList();
        }

        public PassiveView.Request requestList(int index) {
            return this._block.requestList().get(index);
        }

        public List<PassiveView.Notification> notificationList() {
            return this._block.notificationList();
        }

        public PassiveView.Notification notificationList(int index) {
            return this._block.notificationList().get(index);
        }

        public Block asBlock() {
            return (Block)this.a$(Block.class);
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("background", new ArrayList<String>(Collections.singletonList(this.background)));
            return map;
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("background")) {
                this.background = (String)StringLoader.load(values, (Layer)this).get(0);
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("background")) {
                this.background = (String)values.get(0);
            }
        }

        protected void sync$(Layer layer) {
            super.sync$(layer);
            if (layer instanceof Block) {
                this._block = (Block)layer;
            }
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }

            public Component component() {
                Component newElement = (Component)Parallax.this.core$().graph().concept(Component.class).createNode(this.name, Parallax.this.core$()).as(Component.class);
                return newElement;
            }

            public Block block() {
                Block newElement = (Block)Parallax.this.core$().graph().concept(Block.class).createNode(this.name, Parallax.this.core$()).as(Block.class);
                return newElement;
            }

            public PassiveView.Request request() {
                PassiveView.Request newElement = (PassiveView.Request)Parallax.this.core$().graph().concept(PassiveView.Request.class).createNode(this.name, Parallax.this.core$()).as(PassiveView.Request.class);
                return newElement;
            }

            public PassiveView.Notification notification() {
                PassiveView.Notification newElement = (PassiveView.Notification)Parallax.this.core$().graph().concept(PassiveView.Notification.class).createNode(this.name, Parallax.this.core$()).as(PassiveView.Notification.class);
                return newElement;
            }
        }

        public class Clear {
            public void component(Predicate<Component> filter) {
                new ArrayList<Component>(Parallax.this.componentList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void block(Predicate<Block> filter) {
                new ArrayList<Block>(Parallax.this.blockList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void request(Predicate<PassiveView.Request> filter) {
                new ArrayList<PassiveView.Request>(Parallax.this.requestList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void notification(Predicate<PassiveView.Notification> filter) {
                new ArrayList<PassiveView.Notification>(Parallax.this.notificationList()).stream().filter(filter).forEach(Layer::delete$);
            }
        }
    }

    public static class Drawer
    extends Layer
    implements Terminal {
        protected Position position;
        protected Variant variant;
        protected Block _block;

        public Drawer(Node node) {
            super(node);
        }

        public Position position() {
            return this.position;
        }

        public Variant variant() {
            return this.variant;
        }

        public List<Layout> layout() {
            return this._block.layout();
        }

        public Spacing spacing() {
            return this._block.spacing();
        }

        public Hidden hidden() {
            return this._block.hidden();
        }

        public Drawer position(Position value) {
            this.position = value;
            return this;
        }

        public Drawer variant(Variant value) {
            this.variant = value;
            return this;
        }

        public Drawer layout(List<Layout> values) {
            this._block.layout(values);
            return this;
        }

        public Drawer spacing(Spacing value) {
            this._block.spacing(value);
            return this;
        }

        public Drawer hidden(Hidden value) {
            this._block.hidden(value);
            return this;
        }

        public List<Component> componentList() {
            return this._block.componentList();
        }

        public Component componentList(int index) {
            return this._block.componentList().get(index);
        }

        public List<Block> blockList() {
            return this._block.blockList();
        }

        public Block blockList(int index) {
            return this._block.blockList().get(index);
        }

        public List<PassiveView.Request> requestList() {
            return this._block.requestList();
        }

        public PassiveView.Request requestList(int index) {
            return this._block.requestList().get(index);
        }

        public List<PassiveView.Notification> notificationList() {
            return this._block.notificationList();
        }

        public PassiveView.Notification notificationList(int index) {
            return this._block.notificationList().get(index);
        }

        public Block asBlock() {
            return (Block)this.a$(Block.class);
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("position", new ArrayList<Position>(Collections.singletonList(this.position)));
            map.put("variant", new ArrayList<Variant>(Collections.singletonList(this.variant)));
            return map;
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("position")) {
                this.position = (Position)((Object)WordLoader.load(values, Position.class, (Layer)this).get(0));
            } else if (name.equalsIgnoreCase("variant")) {
                this.variant = (Variant)((Object)WordLoader.load(values, Variant.class, (Layer)this).get(0));
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("position")) {
                this.position = (Position)((Object)values.get(0));
            } else if (name.equalsIgnoreCase("variant")) {
                this.variant = (Variant)((Object)values.get(0));
            }
        }

        protected void sync$(Layer layer) {
            super.sync$(layer);
            if (layer instanceof Block) {
                this._block = (Block)layer;
            }
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }

        public static enum Position {
            Left,
            Top,
            Bottom,
            Right;

        }

        public static enum Variant {
            Permanent,
            Persistent,
            PersistentAndMini,
            Temporary;

        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }

            public Component component() {
                Component newElement = (Component)Drawer.this.core$().graph().concept(Component.class).createNode(this.name, Drawer.this.core$()).as(Component.class);
                return newElement;
            }

            public Block block() {
                Block newElement = (Block)Drawer.this.core$().graph().concept(Block.class).createNode(this.name, Drawer.this.core$()).as(Block.class);
                return newElement;
            }

            public PassiveView.Request request() {
                PassiveView.Request newElement = (PassiveView.Request)Drawer.this.core$().graph().concept(PassiveView.Request.class).createNode(this.name, Drawer.this.core$()).as(PassiveView.Request.class);
                return newElement;
            }

            public PassiveView.Notification notification() {
                PassiveView.Notification newElement = (PassiveView.Notification)Drawer.this.core$().graph().concept(PassiveView.Notification.class).createNode(this.name, Drawer.this.core$()).as(PassiveView.Notification.class);
                return newElement;
            }
        }

        public class Clear {
            public void component(Predicate<Component> filter) {
                new ArrayList<Component>(Drawer.this.componentList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void block(Predicate<Block> filter) {
                new ArrayList<Block>(Drawer.this.blockList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void request(Predicate<PassiveView.Request> filter) {
                new ArrayList<PassiveView.Request>(Drawer.this.requestList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void notification(Predicate<PassiveView.Notification> filter) {
                new ArrayList<PassiveView.Notification>(Drawer.this.notificationList()).stream().filter(filter).forEach(Layer::delete$);
            }
        }
    }

    public static class AutoSize
    extends io.intino.konos.model.AutoSize
    implements Terminal {
        protected Block _block;

        public AutoSize(Node node) {
            super(node);
        }

        public List<Layout> layout() {
            return this._block.layout();
        }

        public Spacing spacing() {
            return this._block.spacing();
        }

        public Hidden hidden() {
            return this._block.hidden();
        }

        public AutoSize layout(List<Layout> values) {
            this._block.layout(values);
            return this;
        }

        public AutoSize spacing(Spacing value) {
            this._block.spacing(value);
            return this;
        }

        public AutoSize hidden(Hidden value) {
            this._block.hidden(value);
            return this;
        }

        public List<Component> componentList() {
            return this._block.componentList();
        }

        public Component componentList(int index) {
            return this._block.componentList().get(index);
        }

        public List<Block> blockList() {
            return this._block.blockList();
        }

        public Block blockList(int index) {
            return this._block.blockList().get(index);
        }

        public List<PassiveView.Request> requestList() {
            return this._block.requestList();
        }

        public PassiveView.Request requestList(int index) {
            return this._block.requestList().get(index);
        }

        public List<PassiveView.Notification> notificationList() {
            return this._block.notificationList();
        }

        public PassiveView.Notification notificationList(int index) {
            return this._block.notificationList().get(index);
        }

        public Block asBlock() {
            return (Block)this.a$(Block.class);
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
        }

        protected void sync$(Layer layer) {
            super.sync$(layer);
            if (layer instanceof Block) {
                this._block = (Block)layer;
            }
        }

        @Override
        public Create create() {
            return new Create(null);
        }

        @Override
        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        @Override
        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }

        public class Create
        extends AutoSize.Create {
            public Create(String name) {
                super(AutoSize.this, name);
            }

            public Component component() {
                Component newElement = (Component)AutoSize.this.core$().graph().concept(Component.class).createNode(this.name, AutoSize.this.core$()).as(Component.class);
                return newElement;
            }

            public Block block() {
                Block newElement = (Block)AutoSize.this.core$().graph().concept(Block.class).createNode(this.name, AutoSize.this.core$()).as(Block.class);
                return newElement;
            }

            public PassiveView.Request request() {
                PassiveView.Request newElement = (PassiveView.Request)AutoSize.this.core$().graph().concept(PassiveView.Request.class).createNode(this.name, AutoSize.this.core$()).as(PassiveView.Request.class);
                return newElement;
            }

            public PassiveView.Notification notification() {
                PassiveView.Notification newElement = (PassiveView.Notification)AutoSize.this.core$().graph().concept(PassiveView.Notification.class).createNode(this.name, AutoSize.this.core$()).as(PassiveView.Notification.class);
                return newElement;
            }
        }

        public class Clear {
            public void component(Predicate<Component> filter) {
                new ArrayList<Component>(AutoSize.this.componentList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void block(Predicate<Block> filter) {
                new ArrayList<Block>(AutoSize.this.blockList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void request(Predicate<PassiveView.Request> filter) {
                new ArrayList<PassiveView.Request>(AutoSize.this.requestList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void notification(Predicate<PassiveView.Notification> filter) {
                new ArrayList<PassiveView.Notification>(AutoSize.this.notificationList()).stream().filter(filter).forEach(Layer::delete$);
            }
        }
    }

    public static class Popover
    extends Layer
    implements Terminal {
        protected Position position;
        protected Block _block;

        public Popover(Node node) {
            super(node);
        }

        public Position position() {
            return this.position;
        }

        public List<Layout> layout() {
            return this._block.layout();
        }

        public Spacing spacing() {
            return this._block.spacing();
        }

        public Hidden hidden() {
            return this._block.hidden();
        }

        public Popover position(Position value) {
            this.position = value;
            return this;
        }

        public Popover layout(List<Layout> values) {
            this._block.layout(values);
            return this;
        }

        public Popover spacing(Spacing value) {
            this._block.spacing(value);
            return this;
        }

        public Popover hidden(Hidden value) {
            this._block.hidden(value);
            return this;
        }

        public List<Component> componentList() {
            return this._block.componentList();
        }

        public Component componentList(int index) {
            return this._block.componentList().get(index);
        }

        public List<Block> blockList() {
            return this._block.blockList();
        }

        public Block blockList(int index) {
            return this._block.blockList().get(index);
        }

        public List<PassiveView.Request> requestList() {
            return this._block.requestList();
        }

        public PassiveView.Request requestList(int index) {
            return this._block.requestList().get(index);
        }

        public List<PassiveView.Notification> notificationList() {
            return this._block.notificationList();
        }

        public PassiveView.Notification notificationList(int index) {
            return this._block.notificationList().get(index);
        }

        public Block asBlock() {
            return (Block)this.a$(Block.class);
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("position", new ArrayList<Position>(Collections.singletonList(this.position)));
            return map;
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("position")) {
                this.position = (Position)((Object)WordLoader.load(values, Position.class, (Layer)this).get(0));
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("position")) {
                this.position = (Position)((Object)values.get(0));
            }
        }

        protected void sync$(Layer layer) {
            super.sync$(layer);
            if (layer instanceof Block) {
                this._block = (Block)layer;
            }
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }

        public static enum Position {
            TopLeft,
            TopCenter,
            TopRight,
            LeftTop,
            LeftCenter,
            LeftBottom,
            RightTop,
            RightCenter,
            RightBottom,
            BottomLeft,
            BottomCenter,
            BottomRight;

        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }

            public Component component() {
                Component newElement = (Component)Popover.this.core$().graph().concept(Component.class).createNode(this.name, Popover.this.core$()).as(Component.class);
                return newElement;
            }

            public Block block() {
                Block newElement = (Block)Popover.this.core$().graph().concept(Block.class).createNode(this.name, Popover.this.core$()).as(Block.class);
                return newElement;
            }

            public PassiveView.Request request() {
                PassiveView.Request newElement = (PassiveView.Request)Popover.this.core$().graph().concept(PassiveView.Request.class).createNode(this.name, Popover.this.core$()).as(PassiveView.Request.class);
                return newElement;
            }

            public PassiveView.Notification notification() {
                PassiveView.Notification newElement = (PassiveView.Notification)Popover.this.core$().graph().concept(PassiveView.Notification.class).createNode(this.name, Popover.this.core$()).as(PassiveView.Notification.class);
                return newElement;
            }
        }

        public class Clear {
            public void component(Predicate<Component> filter) {
                new ArrayList<Component>(Popover.this.componentList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void block(Predicate<Block> filter) {
                new ArrayList<Block>(Popover.this.blockList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void request(Predicate<PassiveView.Request> filter) {
                new ArrayList<PassiveView.Request>(Popover.this.requestList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void notification(Predicate<PassiveView.Notification> filter) {
                new ArrayList<PassiveView.Notification>(Popover.this.notificationList()).stream().filter(filter).forEach(Layer::delete$);
            }
        }
    }

    public static class Conditional
    extends Layer
    implements Terminal {
        protected Component.Option selected;
        protected Block _block;

        public Conditional(Node node) {
            super(node);
        }

        public Component.Option selected() {
            return this.selected;
        }

        public List<Layout> layout() {
            return this._block.layout();
        }

        public Spacing spacing() {
            return this._block.spacing();
        }

        public Hidden hidden() {
            return this._block.hidden();
        }

        public Conditional selected(Component.Option value) {
            this.selected = value;
            return this;
        }

        public Conditional layout(List<Layout> values) {
            this._block.layout(values);
            return this;
        }

        public Conditional spacing(Spacing value) {
            this._block.spacing(value);
            return this;
        }

        public Conditional hidden(Hidden value) {
            this._block.hidden(value);
            return this;
        }

        public List<Component> componentList() {
            return this._block.componentList();
        }

        public Component componentList(int index) {
            return this._block.componentList().get(index);
        }

        public List<Block> blockList() {
            return this._block.blockList();
        }

        public Block blockList(int index) {
            return this._block.blockList().get(index);
        }

        public List<PassiveView.Request> requestList() {
            return this._block.requestList();
        }

        public PassiveView.Request requestList(int index) {
            return this._block.requestList().get(index);
        }

        public List<PassiveView.Notification> notificationList() {
            return this._block.notificationList();
        }

        public PassiveView.Notification notificationList(int index) {
            return this._block.notificationList().get(index);
        }

        public Block asBlock() {
            return (Block)this.a$(Block.class);
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("selected", this.selected != null ? new ArrayList<Component.Option>(Collections.singletonList(this.selected)) : Collections.emptyList());
            return map;
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("selected")) {
                this.selected = (Component.Option)((Object)NodeLoader.load(values, Component.Option.class, (Layer)this).get(0));
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("selected")) {
                this.selected = values.get(0) != null ? (Component.Option)this.core$().graph().load(((Layer)values.get(0)).core$().id()).as(Component.Option.class) : null;
            }
        }

        protected void sync$(Layer layer) {
            super.sync$(layer);
            if (layer instanceof Block) {
                this._block = (Block)layer;
            }
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }

            public Component component() {
                Component newElement = (Component)Conditional.this.core$().graph().concept(Component.class).createNode(this.name, Conditional.this.core$()).as(Component.class);
                return newElement;
            }

            public Block block() {
                Block newElement = (Block)Conditional.this.core$().graph().concept(Block.class).createNode(this.name, Conditional.this.core$()).as(Block.class);
                return newElement;
            }

            public PassiveView.Request request() {
                PassiveView.Request newElement = (PassiveView.Request)Conditional.this.core$().graph().concept(PassiveView.Request.class).createNode(this.name, Conditional.this.core$()).as(PassiveView.Request.class);
                return newElement;
            }

            public PassiveView.Notification notification() {
                PassiveView.Notification newElement = (PassiveView.Notification)Conditional.this.core$().graph().concept(PassiveView.Notification.class).createNode(this.name, Conditional.this.core$()).as(PassiveView.Notification.class);
                return newElement;
            }
        }

        public class Clear {
            public void component(Predicate<Component> filter) {
                new ArrayList<Component>(Conditional.this.componentList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void block(Predicate<Block> filter) {
                new ArrayList<Block>(Conditional.this.blockList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void request(Predicate<PassiveView.Request> filter) {
                new ArrayList<PassiveView.Request>(Conditional.this.requestList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void notification(Predicate<PassiveView.Notification> filter) {
                new ArrayList<PassiveView.Notification>(Conditional.this.notificationList()).stream().filter(filter).forEach(Layer::delete$);
            }
        }
    }

    public static class Paper
    extends Layer
    implements Terminal {
        protected Block _block;

        public Paper(Node node) {
            super(node);
        }

        public List<Layout> layout() {
            return this._block.layout();
        }

        public Spacing spacing() {
            return this._block.spacing();
        }

        public Hidden hidden() {
            return this._block.hidden();
        }

        public Paper layout(List<Layout> values) {
            this._block.layout(values);
            return this;
        }

        public Paper spacing(Spacing value) {
            this._block.spacing(value);
            return this;
        }

        public Paper hidden(Hidden value) {
            this._block.hidden(value);
            return this;
        }

        public List<Component> componentList() {
            return this._block.componentList();
        }

        public Component componentList(int index) {
            return this._block.componentList().get(index);
        }

        public List<Block> blockList() {
            return this._block.blockList();
        }

        public Block blockList(int index) {
            return this._block.blockList().get(index);
        }

        public List<PassiveView.Request> requestList() {
            return this._block.requestList();
        }

        public PassiveView.Request requestList(int index) {
            return this._block.requestList().get(index);
        }

        public List<PassiveView.Notification> notificationList() {
            return this._block.notificationList();
        }

        public PassiveView.Notification notificationList(int index) {
            return this._block.notificationList().get(index);
        }

        public Block asBlock() {
            return (Block)this.a$(Block.class);
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            return map;
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
        }

        protected void sync$(Layer layer) {
            super.sync$(layer);
            if (layer instanceof Block) {
                this._block = (Block)layer;
            }
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }

            public Component component() {
                Component newElement = (Component)Paper.this.core$().graph().concept(Component.class).createNode(this.name, Paper.this.core$()).as(Component.class);
                return newElement;
            }

            public Block block() {
                Block newElement = (Block)Paper.this.core$().graph().concept(Block.class).createNode(this.name, Paper.this.core$()).as(Block.class);
                return newElement;
            }

            public PassiveView.Request request() {
                PassiveView.Request newElement = (PassiveView.Request)Paper.this.core$().graph().concept(PassiveView.Request.class).createNode(this.name, Paper.this.core$()).as(PassiveView.Request.class);
                return newElement;
            }

            public PassiveView.Notification notification() {
                PassiveView.Notification newElement = (PassiveView.Notification)Paper.this.core$().graph().concept(PassiveView.Notification.class).createNode(this.name, Paper.this.core$()).as(PassiveView.Notification.class);
                return newElement;
            }
        }

        public class Clear {
            public void component(Predicate<Component> filter) {
                new ArrayList<Component>(Paper.this.componentList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void block(Predicate<Block> filter) {
                new ArrayList<Block>(Paper.this.blockList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void request(Predicate<PassiveView.Request> filter) {
                new ArrayList<PassiveView.Request>(Paper.this.requestList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void notification(Predicate<PassiveView.Notification> filter) {
                new ArrayList<PassiveView.Notification>(Paper.this.notificationList()).stream().filter(filter).forEach(Layer::delete$);
            }
        }
    }

    public static class Multiple
    extends io.intino.konos.model.Multiple
    implements Terminal {
        protected Block _block;

        public Multiple(Node node) {
            super(node);
        }

        public List<Layout> layout() {
            return this._block.layout();
        }

        public Hidden hidden() {
            return this._block.hidden();
        }

        public Multiple layout(List<Layout> values) {
            this._block.layout(values);
            return this;
        }

        public Multiple hidden(Hidden value) {
            this._block.hidden(value);
            return this;
        }

        public List<Component> componentList() {
            return this._block.componentList();
        }

        public Component componentList(int index) {
            return this._block.componentList().get(index);
        }

        public List<Block> blockList() {
            return this._block.blockList();
        }

        public Block blockList(int index) {
            return this._block.blockList().get(index);
        }

        public List<PassiveView.Request> requestList() {
            return this._block.requestList();
        }

        public PassiveView.Request requestList(int index) {
            return this._block.requestList().get(index);
        }

        public List<PassiveView.Notification> notificationList() {
            return this._block.notificationList();
        }

        public PassiveView.Notification notificationList(int index) {
            return this._block.notificationList().get(index);
        }

        public Block asBlock() {
            return (Block)this.a$(Block.class);
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
        }

        protected void sync$(Layer layer) {
            super.sync$(layer);
            if (layer instanceof Block) {
                this._block = (Block)layer;
            }
        }

        @Override
        public Create create() {
            return new Create(null);
        }

        @Override
        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        @Override
        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }

        public class Create
        extends Multiple.Create {
            public Create(String name) {
                super(name);
            }

            public Component component() {
                Component newElement = (Component)Multiple.this.core$().graph().concept(Component.class).createNode(this.name, Multiple.this.core$()).as(Component.class);
                return newElement;
            }

            public Block block() {
                Block newElement = (Block)Multiple.this.core$().graph().concept(Block.class).createNode(this.name, Multiple.this.core$()).as(Block.class);
                return newElement;
            }

            public PassiveView.Request request() {
                PassiveView.Request newElement = (PassiveView.Request)Multiple.this.core$().graph().concept(PassiveView.Request.class).createNode(this.name, Multiple.this.core$()).as(PassiveView.Request.class);
                return newElement;
            }

            public PassiveView.Notification notification() {
                PassiveView.Notification newElement = (PassiveView.Notification)Multiple.this.core$().graph().concept(PassiveView.Notification.class).createNode(this.name, Multiple.this.core$()).as(PassiveView.Notification.class);
                return newElement;
            }
        }

        public class Clear {
            public void component(Predicate<Component> filter) {
                new ArrayList<Component>(Multiple.this.componentList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void block(Predicate<Block> filter) {
                new ArrayList<Block>(Multiple.this.blockList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void request(Predicate<PassiveView.Request> filter) {
                new ArrayList<PassiveView.Request>(Multiple.this.requestList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void notification(Predicate<PassiveView.Notification> filter) {
                new ArrayList<PassiveView.Notification>(Multiple.this.notificationList()).stream().filter(filter).forEach(Layer::delete$);
            }
        }
    }

    public class Create
    extends Component.Create {
        public Create(String name) {
            super(Block.this, name);
        }

        public Component component() {
            Component newElement = (Component)Block.this.core$().graph().concept(Component.class).createNode(this.name, Block.this.core$()).as(Component.class);
            return newElement;
        }

        public OtherComponents.AlertDialog alertDialog(String title, String message) {
            OtherComponents.AlertDialog newElement = (OtherComponents.AlertDialog)Block.this.core$().graph().concept(OtherComponents.AlertDialog.class).createNode(this.name, Block.this.core$()).as(OtherComponents.AlertDialog.class);
            newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
            newElement.core$().set((Layer)newElement, "message", Collections.singletonList(message));
            return newElement;
        }

        public VisualizationComponents.TemporalSlider temporalSlider(List<CatalogComponents.Collection> collections, List<VisualizationComponents.TemporalSlider.Scales> scales) {
            VisualizationComponents.TemporalSlider newElement = (VisualizationComponents.TemporalSlider)Block.this.core$().graph().concept(VisualizationComponents.TemporalSlider.class).createNode(this.name, Block.this.core$()).as(VisualizationComponents.TemporalSlider.class);
            newElement.core$().set((Layer)newElement, "collections", collections);
            newElement.core$().set((Layer)newElement, "scales", scales);
            return newElement;
        }

        public ActionableComponents.IconSplitButton iconSplitButton(String title, List<String> options, String defaultOption, String icon) {
            ActionableComponents.IconSplitButton newElement = (ActionableComponents.IconSplitButton)Block.this.core$().graph().concept(ActionableComponents.IconSplitButton.class).createNode(this.name, Block.this.core$()).as(ActionableComponents.IconSplitButton.class);
            newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
            newElement.core$().set((Layer)newElement, "options", options);
            newElement.core$().set((Layer)newElement, "defaultOption", Collections.singletonList(defaultOption));
            newElement.core$().set((Layer)newElement, "icon", Collections.singletonList(icon));
            return newElement;
        }

        public OtherComponents.ProxyStamp proxyStamp(String proxy, Service.UI.Use from) {
            OtherComponents.ProxyStamp newElement = (OtherComponents.ProxyStamp)Block.this.core$().graph().concept(OtherComponents.ProxyStamp.class).createNode(this.name, Block.this.core$()).as(OtherComponents.ProxyStamp.class);
            newElement.core$().set((Layer)newElement, "proxy", Collections.singletonList(proxy));
            newElement.core$().set((Layer)newElement, "from", Collections.singletonList(from));
            return newElement;
        }

        public ActionableComponents.IconToggle iconToggle(String title, String icon) {
            ActionableComponents.IconToggle newElement = (ActionableComponents.IconToggle)Block.this.core$().graph().concept(ActionableComponents.IconToggle.class).createNode(this.name, Block.this.core$()).as(ActionableComponents.IconToggle.class);
            newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
            newElement.core$().set((Layer)newElement, "icon", Collections.singletonList(icon));
            return newElement;
        }

        public VisualizationComponents.Timeline timeline() {
            VisualizationComponents.Timeline newElement = (VisualizationComponents.Timeline)Block.this.core$().graph().concept(VisualizationComponents.Timeline.class).createNode(this.name, Block.this.core$()).as(VisualizationComponents.Timeline.class);
            return newElement;
        }

        public OtherComponents.Divider divider() {
            OtherComponents.Divider newElement = (OtherComponents.Divider)Block.this.core$().graph().concept(OtherComponents.Divider.class).createNode(this.name, Block.this.core$()).as(OtherComponents.Divider.class);
            return newElement;
        }

        public DataComponents.Text text() {
            DataComponents.Text newElement = (DataComponents.Text)Block.this.core$().graph().concept(DataComponents.Text.class).createNode(this.name, Block.this.core$()).as(DataComponents.Text.class);
            return newElement;
        }

        public OtherComponents.Snackbar snackbar() {
            OtherComponents.Snackbar newElement = (OtherComponents.Snackbar)Block.this.core$().graph().concept(OtherComponents.Snackbar.class).createNode(this.name, Block.this.core$()).as(OtherComponents.Snackbar.class);
            return newElement;
        }

        public CatalogComponents.GroupingToolbar groupingToolbar(List<CatalogComponents.Grouping> groupings) {
            CatalogComponents.GroupingToolbar newElement = (CatalogComponents.GroupingToolbar)Block.this.core$().graph().concept(CatalogComponents.GroupingToolbar.class).createNode(this.name, Block.this.core$()).as(CatalogComponents.GroupingToolbar.class);
            newElement.core$().set((Layer)newElement, "groupings", groupings);
            return newElement;
        }

        public ActionableComponents.MaterialIconButton materialIconButton(String title, String icon) {
            ActionableComponents.MaterialIconButton newElement = (ActionableComponents.MaterialIconButton)Block.this.core$().graph().concept(ActionableComponents.MaterialIconButton.class).createNode(this.name, Block.this.core$()).as(ActionableComponents.MaterialIconButton.class);
            newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
            newElement.core$().set((Layer)newElement, "icon", Collections.singletonList(icon));
            return newElement;
        }

        public OtherComponents.Progress progress() {
            OtherComponents.Progress newElement = (OtherComponents.Progress)Block.this.core$().graph().concept(OtherComponents.Progress.class).createNode(this.name, Block.this.core$()).as(OtherComponents.Progress.class);
            return newElement;
        }

        public VisualizationComponents.Header header() {
            VisualizationComponents.Header newElement = (VisualizationComponents.Header)Block.this.core$().graph().concept(VisualizationComponents.Header.class).createNode(this.name, Block.this.core$()).as(VisualizationComponents.Header.class);
            return newElement;
        }

        public CatalogComponents.Sorting sorting(List<CatalogComponents.Collection> collections) {
            CatalogComponents.Sorting newElement = (CatalogComponents.Sorting)Block.this.core$().graph().concept(CatalogComponents.Sorting.class).createNode(this.name, Block.this.core$()).as(CatalogComponents.Sorting.class);
            newElement.core$().set((Layer)newElement, "collections", collections);
            return newElement;
        }

        public ActionableComponents.SplitButton splitButton(String title, List<String> options, String defaultOption) {
            ActionableComponents.SplitButton newElement = (ActionableComponents.SplitButton)Block.this.core$().graph().concept(ActionableComponents.SplitButton.class).createNode(this.name, Block.this.core$()).as(ActionableComponents.SplitButton.class);
            newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
            newElement.core$().set((Layer)newElement, "options", options);
            newElement.core$().set((Layer)newElement, "defaultOption", Collections.singletonList(defaultOption));
            return newElement;
        }

        public CatalogComponents.Grid grid() {
            CatalogComponents.Grid newElement = (CatalogComponents.Grid)Block.this.core$().graph().concept(CatalogComponents.Grid.class).createNode(this.name, Block.this.core$()).as(CatalogComponents.Grid.class);
            return newElement;
        }

        public VisualizationComponents.RangeSlider rangeSlider() {
            VisualizationComponents.RangeSlider newElement = (VisualizationComponents.RangeSlider)Block.this.core$().graph().concept(VisualizationComponents.RangeSlider.class).createNode(this.name, Block.this.core$()).as(VisualizationComponents.RangeSlider.class);
            return newElement;
        }

        public CatalogComponents.Moldable.Mold.Heading heading() {
            CatalogComponents.Moldable.Mold.Heading newElement = (CatalogComponents.Moldable.Mold.Heading)Block.this.core$().graph().concept(CatalogComponents.Moldable.Mold.Heading.class).createNode(this.name, Block.this.core$()).as(CatalogComponents.Moldable.Mold.Heading.class);
            return newElement;
        }

        public OtherComponents.Icon icon(String icon) {
            OtherComponents.Icon newElement = (OtherComponents.Icon)Block.this.core$().graph().concept(OtherComponents.Icon.class).createNode(this.name, Block.this.core$()).as(OtherComponents.Icon.class);
            newElement.core$().set((Layer)newElement, "icon", Collections.singletonList(icon));
            return newElement;
        }

        public VisualizationComponents.DocumentEditor documentEditor() {
            VisualizationComponents.DocumentEditor newElement = (VisualizationComponents.DocumentEditor)Block.this.core$().graph().concept(VisualizationComponents.DocumentEditor.class).createNode(this.name, Block.this.core$()).as(VisualizationComponents.DocumentEditor.class);
            return newElement;
        }

        public OtherComponents.Card card() {
            OtherComponents.Card newElement = (OtherComponents.Card)Block.this.core$().graph().concept(OtherComponents.Card.class).createNode(this.name, Block.this.core$()).as(OtherComponents.Card.class);
            return newElement;
        }

        public ActionableComponents.Link link(String title) {
            ActionableComponents.Link newElement = (ActionableComponents.Link)Block.this.core$().graph().concept(ActionableComponents.Link.class).createNode(this.name, Block.this.core$()).as(ActionableComponents.Link.class);
            newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
            return newElement;
        }

        public ActionableComponents.MaterialIconSplitButton materialIconSplitButton(String title, List<String> options, String defaultOption, String icon) {
            ActionableComponents.MaterialIconSplitButton newElement = (ActionableComponents.MaterialIconSplitButton)Block.this.core$().graph().concept(ActionableComponents.MaterialIconSplitButton.class).createNode(this.name, Block.this.core$()).as(ActionableComponents.MaterialIconSplitButton.class);
            newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
            newElement.core$().set((Layer)newElement, "options", options);
            newElement.core$().set((Layer)newElement, "defaultOption", Collections.singletonList(defaultOption));
            newElement.core$().set((Layer)newElement, "icon", Collections.singletonList(icon));
            return newElement;
        }

        public VisualizationComponents.Dashboard dashboard() {
            VisualizationComponents.Dashboard newElement = (VisualizationComponents.Dashboard)Block.this.core$().graph().concept(VisualizationComponents.Dashboard.class).createNode(this.name, Block.this.core$()).as(VisualizationComponents.Dashboard.class);
            return newElement;
        }

        public CatalogComponents.List list() {
            CatalogComponents.List newElement = (CatalogComponents.List)Block.this.core$().graph().concept(CatalogComponents.List.class).createNode(this.name, Block.this.core$()).as(CatalogComponents.List.class);
            return newElement;
        }

        public ActionableComponents.Button button(String title) {
            ActionableComponents.Button newElement = (ActionableComponents.Button)Block.this.core$().graph().concept(ActionableComponents.Button.class).createNode(this.name, Block.this.core$()).as(ActionableComponents.Button.class);
            newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
            return newElement;
        }

        public VisualizationComponents.Kpi kpi(double value) {
            VisualizationComponents.Kpi newElement = (VisualizationComponents.Kpi)Block.this.core$().graph().concept(VisualizationComponents.Kpi.class).createNode(this.name, Block.this.core$()).as(VisualizationComponents.Kpi.class);
            newElement.core$().set((Layer)newElement, "value", Collections.singletonList(value));
            return newElement;
        }

        public ActionableComponents.Toggle toggle(String title) {
            ActionableComponents.Toggle newElement = (ActionableComponents.Toggle)Block.this.core$().graph().concept(ActionableComponents.Toggle.class).createNode(this.name, Block.this.core$()).as(ActionableComponents.Toggle.class);
            newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
            return newElement;
        }

        public OtherComponents.MaterialIcon materialIcon(String icon) {
            OtherComponents.MaterialIcon newElement = (OtherComponents.MaterialIcon)Block.this.core$().graph().concept(OtherComponents.MaterialIcon.class).createNode(this.name, Block.this.core$()).as(OtherComponents.MaterialIcon.class);
            newElement.core$().set((Layer)newElement, "icon", Collections.singletonList(icon));
            return newElement;
        }

        public CatalogComponents.Map map() {
            CatalogComponents.Map newElement = (CatalogComponents.Map)Block.this.core$().graph().concept(CatalogComponents.Map.class).createNode(this.name, Block.this.core$()).as(CatalogComponents.Map.class);
            return newElement;
        }

        public InteractionComponents.Toolbar toolbar() {
            InteractionComponents.Toolbar newElement = (InteractionComponents.Toolbar)Block.this.core$().graph().concept(InteractionComponents.Toolbar.class).createNode(this.name, Block.this.core$()).as(InteractionComponents.Toolbar.class);
            return newElement;
        }

        public DataComponents.File file() {
            DataComponents.File newElement = (DataComponents.File)Block.this.core$().graph().concept(DataComponents.File.class).createNode(this.name, Block.this.core$()).as(DataComponents.File.class);
            return newElement;
        }

        public ActionableComponents.MaterialIconToggle materialIconToggle(String title, String icon) {
            ActionableComponents.MaterialIconToggle newElement = (ActionableComponents.MaterialIconToggle)Block.this.core$().graph().concept(ActionableComponents.MaterialIconToggle.class).createNode(this.name, Block.this.core$()).as(ActionableComponents.MaterialIconToggle.class);
            newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
            newElement.core$().set((Layer)newElement, "icon", Collections.singletonList(icon));
            return newElement;
        }

        public OtherComponents.TemplateStamp templateStamp(Template template) {
            OtherComponents.TemplateStamp newElement = (OtherComponents.TemplateStamp)Block.this.core$().graph().concept(OtherComponents.TemplateStamp.class).createNode(this.name, Block.this.core$()).as(OtherComponents.TemplateStamp.class);
            newElement.core$().set((Layer)newElement, "template", Collections.singletonList(template));
            return newElement;
        }

        public ActionableComponents.AvatarIconButton avatarIconButton(String title) {
            ActionableComponents.AvatarIconButton newElement = (ActionableComponents.AvatarIconButton)Block.this.core$().graph().concept(ActionableComponents.AvatarIconButton.class).createNode(this.name, Block.this.core$()).as(ActionableComponents.AvatarIconButton.class);
            newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
            return newElement;
        }

        public CatalogComponents.Moldable.Mold.Item item(int height) {
            CatalogComponents.Moldable.Mold.Item newElement = (CatalogComponents.Moldable.Mold.Item)Block.this.core$().graph().concept(CatalogComponents.Moldable.Mold.Item.class).createNode(this.name, Block.this.core$()).as(CatalogComponents.Moldable.Mold.Item.class);
            newElement.core$().set((Layer)newElement, "height", Collections.singletonList(height));
            return newElement;
        }

        public DataComponents.Date date() {
            DataComponents.Date newElement = (DataComponents.Date)Block.this.core$().graph().concept(DataComponents.Date.class).createNode(this.name, Block.this.core$()).as(DataComponents.Date.class);
            return newElement;
        }

        public HelperComponents.Row row(List<CatalogComponents.Moldable.Mold.Item> items) {
            HelperComponents.Row newElement = (HelperComponents.Row)Block.this.core$().graph().concept(HelperComponents.Row.class).createNode(this.name, Block.this.core$()).as(HelperComponents.Row.class);
            newElement.core$().set((Layer)newElement, "items", items);
            return newElement;
        }

        public CatalogComponents.DynamicTable dynamicTable() {
            CatalogComponents.DynamicTable newElement = (CatalogComponents.DynamicTable)Block.this.core$().graph().concept(CatalogComponents.DynamicTable.class).createNode(this.name, Block.this.core$()).as(CatalogComponents.DynamicTable.class);
            return newElement;
        }

        public VisualizationComponents.Chart chart(Dataframe input, String query) {
            VisualizationComponents.Chart newElement = (VisualizationComponents.Chart)Block.this.core$().graph().concept(VisualizationComponents.Chart.class).createNode(this.name, Block.this.core$()).as(VisualizationComponents.Chart.class);
            newElement.core$().set((Layer)newElement, "input", Collections.singletonList(input));
            newElement.core$().set((Layer)newElement, "query", Collections.singletonList(query));
            return newElement;
        }

        public Template template() {
            Template newElement = (Template)Block.this.core$().graph().concept(Template.class).createNode(this.name, Block.this.core$()).as(Template.class);
            return newElement;
        }

        public VisualizationComponents.Stepper stepper() {
            VisualizationComponents.Stepper newElement = (VisualizationComponents.Stepper)Block.this.core$().graph().concept(VisualizationComponents.Stepper.class).createNode(this.name, Block.this.core$()).as(VisualizationComponents.Stepper.class);
            return newElement;
        }

        public OtherComponents.Frame frame(String url) {
            OtherComponents.Frame newElement = (OtherComponents.Frame)Block.this.core$().graph().concept(OtherComponents.Frame.class).createNode(this.name, Block.this.core$()).as(OtherComponents.Frame.class);
            newElement.core$().set((Layer)newElement, "url", Collections.singletonList(url));
            return newElement;
        }

        public OtherComponents.User user() {
            OtherComponents.User newElement = (OtherComponents.User)Block.this.core$().graph().concept(OtherComponents.User.class).createNode(this.name, Block.this.core$()).as(OtherComponents.User.class);
            return newElement;
        }

        public OtherComponents.HtmlViewer htmlViewer() {
            OtherComponents.HtmlViewer newElement = (OtherComponents.HtmlViewer)Block.this.core$().graph().concept(OtherComponents.HtmlViewer.class).createNode(this.name, Block.this.core$()).as(OtherComponents.HtmlViewer.class);
            return newElement;
        }

        public OtherComponents.Dialog dialog(String title) {
            OtherComponents.Dialog newElement = (OtherComponents.Dialog)Block.this.core$().graph().concept(OtherComponents.Dialog.class).createNode(this.name, Block.this.core$()).as(OtherComponents.Dialog.class);
            newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
            return newElement;
        }

        public DataComponents.Number number() {
            DataComponents.Number newElement = (DataComponents.Number)Block.this.core$().graph().concept(DataComponents.Number.class).createNode(this.name, Block.this.core$()).as(DataComponents.Number.class);
            return newElement;
        }

        public CatalogComponents.Table table() {
            CatalogComponents.Table newElement = (CatalogComponents.Table)Block.this.core$().graph().concept(CatalogComponents.Table.class).createNode(this.name, Block.this.core$()).as(CatalogComponents.Table.class);
            return newElement;
        }

        public CatalogComponents.SearchBox searchBox(List<CatalogComponents.Collection> collections) {
            CatalogComponents.SearchBox newElement = (CatalogComponents.SearchBox)Block.this.core$().graph().concept(CatalogComponents.SearchBox.class).createNode(this.name, Block.this.core$()).as(CatalogComponents.SearchBox.class);
            newElement.core$().set((Layer)newElement, "collections", collections);
            return newElement;
        }

        public VisualizationComponents.Slider slider() {
            VisualizationComponents.Slider newElement = (VisualizationComponents.Slider)Block.this.core$().graph().concept(VisualizationComponents.Slider.class).createNode(this.name, Block.this.core$()).as(VisualizationComponents.Slider.class);
            return newElement;
        }

        public VisualizationComponents.Reel reel() {
            VisualizationComponents.Reel newElement = (VisualizationComponents.Reel)Block.this.core$().graph().concept(VisualizationComponents.Reel.class).createNode(this.name, Block.this.core$()).as(VisualizationComponents.Reel.class);
            return newElement;
        }

        public VisualizationComponents.DateNavigator dateNavigator() {
            VisualizationComponents.DateNavigator newElement = (VisualizationComponents.DateNavigator)Block.this.core$().graph().concept(VisualizationComponents.DateNavigator.class).createNode(this.name, Block.this.core$()).as(VisualizationComponents.DateNavigator.class);
            return newElement;
        }

        public OtherComponents.MicroSite microSite(String site) {
            OtherComponents.MicroSite newElement = (OtherComponents.MicroSite)Block.this.core$().graph().concept(OtherComponents.MicroSite.class).createNode(this.name, Block.this.core$()).as(OtherComponents.MicroSite.class);
            newElement.core$().set((Layer)newElement, "site", Collections.singletonList(site));
            return newElement;
        }

        public ActionableComponents.Switch switch$(String title) {
            ActionableComponents.Switch newElement = (ActionableComponents.Switch)Block.this.core$().graph().concept(ActionableComponents.Switch.class).createNode(this.name, Block.this.core$()).as(ActionableComponents.Switch.class);
            newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
            return newElement;
        }

        public OtherComponents.DisplayStamp displayStamp(Display display) {
            OtherComponents.DisplayStamp newElement = (OtherComponents.DisplayStamp)Block.this.core$().graph().concept(OtherComponents.DisplayStamp.class).createNode(this.name, Block.this.core$()).as(OtherComponents.DisplayStamp.class);
            newElement.core$().set((Layer)newElement, "display", Collections.singletonList(display));
            return newElement;
        }

        public VisualizationComponents.Spinner spinner() {
            VisualizationComponents.Spinner newElement = (VisualizationComponents.Spinner)Block.this.core$().graph().concept(VisualizationComponents.Spinner.class).createNode(this.name, Block.this.core$()).as(VisualizationComponents.Spinner.class);
            return newElement;
        }

        public OtherComponents.OwnerTemplateStamp ownerTemplateStamp(Service.UI.Use owner, String template) {
            OtherComponents.OwnerTemplateStamp newElement = (OtherComponents.OwnerTemplateStamp)Block.this.core$().graph().concept(OtherComponents.OwnerTemplateStamp.class).createNode(this.name, Block.this.core$()).as(OtherComponents.OwnerTemplateStamp.class);
            newElement.core$().set((Layer)newElement, "owner", Collections.singletonList(owner));
            newElement.core$().set((Layer)newElement, "template", Collections.singletonList(template));
            return newElement;
        }

        public ActionableComponents.IconButton iconButton(String title, String icon) {
            ActionableComponents.IconButton newElement = (ActionableComponents.IconButton)Block.this.core$().graph().concept(ActionableComponents.IconButton.class).createNode(this.name, Block.this.core$()).as(ActionableComponents.IconButton.class);
            newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
            newElement.core$().set((Layer)newElement, "icon", Collections.singletonList(icon));
            return newElement;
        }

        public OtherComponents.Chip chip() {
            OtherComponents.Chip newElement = (OtherComponents.Chip)Block.this.core$().graph().concept(OtherComponents.Chip.class).createNode(this.name, Block.this.core$()).as(OtherComponents.Chip.class);
            return newElement;
        }

        public CatalogComponents.Grid.Column column(String label, CatalogComponents.Grid.Column.Type type) {
            CatalogComponents.Grid.Column newElement = (CatalogComponents.Grid.Column)Block.this.core$().graph().concept(CatalogComponents.Grid.Column.class).createNode(this.name, Block.this.core$()).as(CatalogComponents.Grid.Column.class);
            newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
            newElement.core$().set((Layer)newElement, "type", Collections.singletonList(type));
            return newElement;
        }

        public DataComponents.Location location() {
            DataComponents.Location newElement = (DataComponents.Location)Block.this.core$().graph().concept(DataComponents.Location.class).createNode(this.name, Block.this.core$()).as(DataComponents.Location.class);
            return newElement;
        }

        @Override
        public Block block() {
            Block newElement = (Block)Block.this.core$().graph().concept(Block.class).createNode(this.name, Block.this.core$()).as(Block.class);
            return newElement;
        }

        public HelperComponents.HelperComponent helperComponent() {
            HelperComponents.HelperComponent newElement = (HelperComponents.HelperComponent)Block.this.core$().graph().concept(HelperComponents.HelperComponent.class).createNode(this.name, Block.this.core$()).as(HelperComponents.HelperComponent.class);
            return newElement;
        }

        public CatalogComponents.Magazine magazine() {
            CatalogComponents.Magazine newElement = (CatalogComponents.Magazine)Block.this.core$().graph().concept(CatalogComponents.Magazine.class).createNode(this.name, Block.this.core$()).as(CatalogComponents.Magazine.class);
            return newElement;
        }

        public DataComponents.Image image() {
            DataComponents.Image newElement = (DataComponents.Image)Block.this.core$().graph().concept(DataComponents.Image.class).createNode(this.name, Block.this.core$()).as(DataComponents.Image.class);
            return newElement;
        }

        public CatalogComponents.Grouping grouping(List<CatalogComponents.Collection> collections) {
            CatalogComponents.Grouping newElement = (CatalogComponents.Grouping)Block.this.core$().graph().concept(CatalogComponents.Grouping.class).createNode(this.name, Block.this.core$()).as(CatalogComponents.Grouping.class);
            newElement.core$().set((Layer)newElement, "collections", collections);
            return newElement;
        }

        public VisualizationComponents.Stepper.Step step() {
            VisualizationComponents.Stepper.Step newElement = (VisualizationComponents.Stepper.Step)Block.this.core$().graph().concept(VisualizationComponents.Stepper.Step.class).createNode(this.name, Block.this.core$()).as(VisualizationComponents.Stepper.Step.class);
            return newElement;
        }

        public OtherComponents.Selector selector() {
            OtherComponents.Selector newElement = (OtherComponents.Selector)Block.this.core$().graph().concept(OtherComponents.Selector.class).createNode(this.name, Block.this.core$()).as(OtherComponents.Selector.class);
            return newElement;
        }

        public OtherComponents.DecisionDialog decisionDialog(String title) {
            OtherComponents.DecisionDialog newElement = (OtherComponents.DecisionDialog)Block.this.core$().graph().concept(OtherComponents.DecisionDialog.class).createNode(this.name, Block.this.core$()).as(OtherComponents.DecisionDialog.class);
            newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
            return newElement;
        }

        public OtherComponents.Tooltip tooltip() {
            OtherComponents.Tooltip newElement = (OtherComponents.Tooltip)Block.this.core$().graph().concept(OtherComponents.Tooltip.class).createNode(this.name, Block.this.core$()).as(OtherComponents.Tooltip.class);
            return newElement;
        }

        public VisualizationComponents.Eventline eventline() {
            VisualizationComponents.Eventline newElement = (VisualizationComponents.Eventline)Block.this.core$().graph().concept(VisualizationComponents.Eventline.class).createNode(this.name, Block.this.core$()).as(VisualizationComponents.Eventline.class);
            return newElement;
        }

        public OtherComponents.CollectionDialog collectionDialog(String title) {
            OtherComponents.CollectionDialog newElement = (OtherComponents.CollectionDialog)Block.this.core$().graph().concept(OtherComponents.CollectionDialog.class).createNode(this.name, Block.this.core$()).as(OtherComponents.CollectionDialog.class);
            newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
            return newElement;
        }

        public VisualizationComponents.AppDirectory appDirectory() {
            VisualizationComponents.AppDirectory newElement = (VisualizationComponents.AppDirectory)Block.this.core$().graph().concept(VisualizationComponents.AppDirectory.class).createNode(this.name, Block.this.core$()).as(VisualizationComponents.AppDirectory.class);
            return newElement;
        }
    }

    public class Clear
    extends Component.Clear {
        public Clear() {
            super(Block.this);
        }

        public void component(Predicate<Component> filter) {
            new ArrayList<Component>(Block.this.componentList()).stream().filter(filter).forEach(Layer::delete$);
        }
    }
}

