/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration;

import io.intino.itrules.FrameBuilder;
import io.intino.konos.builder.CompilerConfiguration;
import io.intino.konos.builder.codegeneration.services.ui.Target;
import io.intino.konos.builder.context.CompilationContext;
import io.intino.konos.builder.context.KonosException;
import io.intino.konos.builder.helpers.ElementHelper;
import io.intino.konos.model.CatalogComponents;
import io.intino.konos.model.HelperComponents;
import io.intino.konos.model.Service;
import io.intino.magritte.framework.Layer;
import java.io.File;
import java.util.Map;

public abstract class Renderer {
    protected final CompilationContext context;
    protected final ElementHelper elementHelper;

    protected Renderer(CompilationContext context) {
        this.context = context;
        this.elementHelper = new ElementHelper();
    }

    public void execute() throws KonosException {
        this.render();
    }

    protected abstract void render() throws KonosException;

    public String project() {
        return this.context.project();
    }

    public String boxName() {
        return this.context.boxName();
    }

    protected CompilerConfiguration configuration() {
        return this.context.configuration();
    }

    protected String packageName() {
        return this.context.packageName();
    }

    protected String module() {
        return this.context.module();
    }

    protected String parent() {
        return this.context.parent();
    }

    protected File root(Target target) {
        return this.context.root(target);
    }

    protected File res(Target target) {
        return this.context.res(target);
    }

    protected File src(Target target) {
        return this.context.src(target);
    }

    protected File gen(Target target) {
        return this.context.gen(target);
    }

    protected Map<String, String> classes() {
        return this.context.classes();
    }

    public FrameBuilder buildBaseFrame() {
        return new FrameBuilder().add("box", (Object)this.boxName()).add("package", (Object)this.context.packageName());
    }

    protected boolean isRendered(Layer element) {
        if (element == null) {
            return false;
        }
        if (element.i$(ElementHelper.conceptOf(CatalogComponents.Moldable.Mold.Item.class))) {
            return false;
        }
        if (element.i$(ElementHelper.conceptOf(HelperComponents.Row.class))) {
            return false;
        }
        return !this.context.cache().isModified(element);
    }

    protected boolean isRoot(Layer element) {
        return element.core$().owner() == null || element.core$().owner() == element.core$().model();
    }

    protected boolean isCustomParameter(String value) {
        return value != null && value.startsWith("{");
    }

    protected String customParameterValue(String value) {
        return value != null ? value.substring(1, value.length() - 1) : "";
    }

    protected boolean isMobile(Service.UI service) {
        return service.targets().contains((Object)Service.UI.Targets.Android) || service.targets().contains((Object)Service.UI.Targets.IOS);
    }
}

