/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.accessor.ui.android.resource;

import cottons.utils.StringHelper;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.accessor.ui.android.templates.PageTemplate;
import io.intino.konos.builder.codegeneration.services.ui.Target;
import io.intino.konos.builder.context.CompilationContext;
import io.intino.konos.builder.helpers.CodeGenerationHelper;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.builder.helpers.ElementHelper;
import io.intino.konos.model.Display;
import io.intino.konos.model.KonosGraph;
import io.intino.konos.model.Service;
import io.intino.konos.model.Template;
import java.io.File;

public class ResourceRenderer
extends io.intino.konos.builder.codegeneration.ui.resource.ResourceRenderer {
    public ResourceRenderer(CompilationContext compilationContext, Service.UI.Resource resource) {
        super(compilationContext, resource, Target.Android);
    }

    @Override
    public void render() {
        if (!this.resource.isPage()) {
            return;
        }
        this.writeActivity(this.buildFrame());
        this.writeActivityTemplate(this.buildFrame());
    }

    private void writeActivity(FrameBuilder builder) {
        builder.add("activity");
        File file = Commons.kotlinFile(this.src(this.target), File.separator + "pages" + File.separator + Formatters.firstUpperCase(this.resource.name$()) + "Activity");
        file.getParentFile().mkdirs();
        Commons.write(file.toPath(), this.setup(new PageTemplate()).render((Object)builder.toFrame()));
    }

    private void writeActivityTemplate(FrameBuilder builder) {
        builder.add("template");
        File file = new File(this.res(this.target) + File.separator + "layout" + File.separator + StringHelper.camelCaseToSnakeCase((String)this.resource.name$()).replace("-", "_") + "_activity.xml");
        file.getParentFile().mkdirs();
        Commons.write(file.toPath(), this.setup(new PageTemplate()).render((Object)builder.toFrame()));
    }

    @Override
    public FrameBuilder buildFrame() {
        FrameBuilder result = super.buildFrame().add("resource");
        Service.UI uiService = (Service.UI)this.resource.core$().ownerAs(Service.UI.class);
        result.add("name", (Object)this.resource.name$());
        if (this.resource.isMain()) {
            result.add("main");
        }
        Template template = KonosGraph.templateFor(this.resource);
        result.add("path", (Object)this.resource.path());
        result.add("pageDisplay", (Object)template.name$());
        result.add("pageDisplayId", (Object)this.shortId(template));
        result.add("pageDisplayType", (Object)this.typeOf(template));
        uiService.useList().forEach(use -> result.add("accessibleImport", (Object)this.accessibleImportFrame((Service.UI.Use)((Object)use))));
        this.addPageDisplayOrigin(result, template);
        return result;
    }

    private void addPageDisplayOrigin(FrameBuilder builder, Display display) {
        FrameBuilder originFrame = new FrameBuilder();
        if (ElementHelper.isRoot(display)) {
            originFrame.add("decorated", (Object)"");
        }
        if (ElementHelper.isRoot(display) && CodeGenerationHelper.hasAbstractClass(display, Target.Android)) {
            originFrame.add("hasAbstract", (Object)"");
        }
        builder.add("pageDisplayOrigin", (Object)originFrame);
    }

    private Frame accessibleImportFrame(Service.UI.Use use) {
        FrameBuilder result = new FrameBuilder(new String[]{"accessibleImport"});
        result.add("name", (Object)use.name$());
        result.add("url", (Object)use.url());
        result.add("elements", (Object)StringHelper.camelCaseToSnakeCase((String)use.service()));
        result.add("service", (Object)use.service());
        return result.toFrame();
    }
}

