/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.ui.displays.components;

import io.intino.itrules.FrameBuilder;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.services.ui.Target;
import io.intino.konos.builder.codegeneration.ui.RendererWriter;
import io.intino.konos.builder.codegeneration.ui.UIRenderer;
import io.intino.konos.builder.codegeneration.ui.displays.DisplayRenderer;
import io.intino.konos.builder.codegeneration.ui.displays.components.ComponentRendererFactory;
import io.intino.konos.builder.context.CompilationContext;
import io.intino.konos.builder.helpers.ElementHelper;
import io.intino.konos.builder.utils.LRUCache;
import io.intino.konos.model.Block;
import io.intino.konos.model.CatalogComponents;
import io.intino.konos.model.Component;
import io.intino.konos.model.DataComponents;
import io.intino.konos.model.Display;
import io.intino.konos.model.Editable;
import io.intino.konos.model.HelperComponents;
import io.intino.konos.model.KonosGraph;
import io.intino.konos.model.Labeled;
import io.intino.konos.model.Multiple;
import io.intino.konos.model.OtherComponents;
import io.intino.konos.model.PassiveView;
import io.intino.konos.model.Service;
import io.intino.konos.model.Template;
import io.intino.magritte.framework.Layer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import joptsimple.internal.Strings;

public class ComponentRenderer<C extends Component>
extends DisplayRenderer<C> {
    private boolean buildChildren = false;
    private boolean decorated;
    private Display owner;
    public static final Map<String, FrameBuilder> componentFrameMap = Collections.synchronizedMap(new LRUCache(10000));

    public ComponentRenderer(CompilationContext compilationContext, C component, RendererWriter provider) {
        super(compilationContext, component, provider);
        this.decorated = ElementHelper.isRoot(component);
    }

    @Override
    public final FrameBuilder buildFrame() {
        String frameId = this.frameId();
        if (componentFrameMap.containsKey(frameId)) {
            return componentFrameMap.get(frameId);
        }
        FrameBuilder builder = super.buildFrame().add("component");
        if (!this.belongsToAccessible((Display)this.element)) {
            builder.add("concreteBox", (Object)this.boxName());
        }
        if (this.isEmbeddedComponent((Component)this.element)) {
            builder.add("embedded");
        }
        this.addOwner(builder);
        this.addProperties(builder);
        if (this.buildChildren) {
            builder.add("child");
        }
        builder.add("methodName", (Object)(((Component)this.element).i$(ElementHelper.conceptOf(Block.Conditional.class)) && !((Component)this.element).i$(ElementHelper.conceptOf(Block.Multiple.class)) ? "initConditional" : "init"));
        this.addSpecificTypes(builder);
        this.addParentPath((Component)this.element, builder);
        this.addComponents((Component)this.element, builder);
        this.addReferences((Component)this.element, builder);
        this.addFacets((PassiveView)this.element, builder);
        this.addExtends((Component)this.element, builder);
        this.addImplements((Component)this.element, builder);
        this.fill(builder);
        componentFrameMap.put(frameId, builder);
        return builder;
    }

    public static void clearCache() {
        componentFrameMap.clear();
    }

    public void buildChildren(boolean value) {
        this.buildChildren = value;
    }

    public void decorated(boolean value) {
        this.decorated = value;
    }

    public Display owner() {
        return this.owner;
    }

    public void owner(Display owner) {
        this.owner = owner;
    }

    protected void addParentPath(Component component, FrameBuilder builder) {
        Component parentComponent = (Component)component.core$().ownerAs(Component.class);
        ArrayList<String> parentPath = new ArrayList<String>();
        while (!(parentComponent == null || ElementHelper.isRoot(parentComponent) || parentComponent.i$(ElementHelper.conceptOf(CatalogComponents.Moldable.Mold.Item.class)) || parentComponent.i$(ElementHelper.conceptOf(HelperComponents.Row.class)))) {
            parentPath.add(0, this.shortId(parentComponent));
            parentComponent = (Component)parentComponent.core$().ownerAs(Component.class);
        }
        if (!parentPath.isEmpty()) {
            builder.add("parentPath", (Object)Strings.join(parentPath, (String)"."));
        }
    }

    protected FrameBuilder addOwner(FrameBuilder builder) {
        if (this.owner != null) {
            builder.add("owner", (Object)((ElementHelper.isRoot(this.owner) ? "Abstract" : "") + Formatters.firstUpperCase(this.owner.name$())));
        }
        Component parentComponent = (Component)((Component)this.element).core$().ownerAs(Component.class);
        if (((Component)this.element).i$(ElementHelper.conceptOf(OtherComponents.BaseStamp.class)) && parentComponent != null && !ElementHelper.isRoot(parentComponent)) {
            builder.add("parentId", (Object)this.shortId(parentComponent));
        }
        return builder;
    }

    @Override
    protected void addDecoratedFrames(FrameBuilder builder) {
        this.addDecoratedFrames(builder, this.decorated);
    }

    protected void fill(FrameBuilder builder) {
    }

    private void addComponents(Component component, FrameBuilder builder) {
        this.addComponentsImports(builder);
        this.components(component).forEach(c -> {
            Display virtualParent = this.virtualParent() != null ? this.virtualParent() : (c.i$(ElementHelper.conceptOf(CatalogComponents.Collection.class)) && component.i$(ElementHelper.conceptOf(OtherComponents.Selector.CollectionBox.class)) ? component : null);
            FrameBuilder componentBuilder = this.buildChildren ? this.childFrame((Component)((Object)c), virtualParent) : this.componentFrame((Component)((Object)c), virtualParent);
            builder.add("component", (Object)componentBuilder);
        });
    }

    private void addReferences(Component component, FrameBuilder builder) {
        LinkedHashSet<Component> components = new LinkedHashSet<Component>(this.references(component));
        if (this.writer.target() == Target.Server) {
            builder.add("componentReferences", (Object)this.componentReferencesFrame());
        }
        components.forEach(c -> builder.add("reference", (Object)this.referenceFrame((Component)((Object)c))));
    }

    private FrameBuilder referenceFrame(Component component) {
        ComponentRenderer renderer = (ComponentRenderer)ComponentRendererFactory.renderer(this.context, component, this.writer);
        FrameBuilder builder = new FrameBuilder(new String[]{"reference"}).add(this.typeOf(component)).add("name", (Object)component.name$());
        if (this.isEmbeddedComponent(component)) {
            builder.add("embedded");
        }
        Component parentComponent = (Component)component.core$().ownerAs(Component.class);
        builder.add("box", (Object)this.boxName());
        if (!this.belongsToAccessible(component)) {
            builder.add("concreteBox", (Object)this.boxName());
        }
        builder.add("id", (Object)this.shortId(component));
        if (parentComponent != null) {
            builder.add("parentId", (Object)this.nameOf(parentComponent));
        }
        builder.add("properties", (Object)renderer.properties());
        this.addOwner(builder);
        this.addExtends(component, builder);
        return builder;
    }

    protected FrameBuilder childFrame(Component component, Display virtualParent) {
        UIRenderer uiRenderer = this.componentRenderer(component, virtualParent);
        FrameBuilder frameBuilder = uiRenderer.buildFrame();
        String[] ancestors = this.ancestors(component);
        Component parent = (Component)component.core$().ownerAs(Component.class);
        if (parent != null) {
            frameBuilder.add("parent", (Object)this.nameOf(parent));
        }
        if (this.isEmbeddedComponent(component)) {
            frameBuilder.add("embedded");
        }
        if (!frameBuilder.contains("ancestors")) {
            frameBuilder.add("ancestors", (Object)ancestors);
        }
        if (!frameBuilder.contains("ancestorsNotMe")) {
            frameBuilder.add("ancestorsNotMe", (Object)(ancestors.length > 0 ? Arrays.copyOfRange(ancestors, 1, ancestors.length) : new String[]{}));
        }
        frameBuilder.add("value", (Object)uiRenderer.buildFrame().add("addType", (Object)this.typeOf(component)));
        return frameBuilder;
    }

    public FrameBuilder properties() {
        FrameBuilder result = new FrameBuilder().add("properties").add(this.typeOf(this.element));
        if (((Component)this.element).color() != null && !((Component)this.element).color().isEmpty()) {
            result.add("color", (Object)((Component)this.element).color());
        }
        if (((Component)this.element).isOption()) {
            result.add("name", (Object)((Component)this.element).asOption().name$());
        }
        if (((Component)this.element).i$(ElementHelper.conceptOf(Labeled.class))) {
            result.add("label", (Object)((Labeled)((Component)this.element).a$(Labeled.class)).label());
        }
        if (!((Component)this.element).visible()) {
            result.add("visible", (Object)((Component)this.element).visible());
        }
        if (((Component)this.element).isTraceable()) {
            result.add("traceable", (Object)true);
        }
        if (((Component)this.element).i$(ElementHelper.conceptOf(Multiple.class))) {
            Multiple abstractMultiple = (Multiple)((Component)this.element).a$(Multiple.class);
            result.add("multiple");
            result.add("instances", (Object)this.nameOf(this.element));
            result.add("multipleArrangement", (Object)abstractMultiple.arrangement().name());
            result.add("multipleSpacing", (Object)abstractMultiple.spacing().value());
            result.add("multipleNoItemsMessage", (Object)(abstractMultiple.noItemsMessage() != null ? abstractMultiple.noItemsMessage() : ""));
            result.add("multipleWrapItems", (Object)abstractMultiple.wrapItems());
            result.add("multipleEditable", (Object)((Component)this.element).i$(ElementHelper.conceptOf(Editable.class)));
            result.add("multipleCollapsed", (Object)((Multiple)((Component)this.element).a$(Multiple.class)).collapsed());
            result.add("multipleMin", (Object)(abstractMultiple.count() != null ? abstractMultiple.count().min() : 0));
            result.add("multipleMax", (Object)(abstractMultiple.count() != null ? abstractMultiple.count().max() : -1));
            result.add("multipleAlign", (Object)"stretch");
        }
        if (((Component)this.element).format() != null) {
            String[] format = (String[])((Component)this.element).format().stream().map(Layer::name$).sorted().toArray(String[]::new);
            result.add("format", (Object)format);
        }
        return result;
    }

    protected String className(Class clazz) {
        return clazz.getSimpleName().toLowerCase();
    }

    protected String[] ancestors(Component component) {
        ArrayList<String> result = new ArrayList<String>();
        Component parent = (Component)component.core$().ownerAs(Component.class);
        while (parent != null) {
            result.add(0, this.nameOf(parent));
            if (parent.i$(ElementHelper.conceptOf(CatalogComponents.Moldable.Mold.Item.class))) break;
            parent = (Component)parent.core$().ownerAs(Component.class);
        }
        return result.toArray(new String[0]);
    }

    private UIRenderer componentRenderer(Component component, Display virtualParent) {
        ComponentRenderer renderer = (ComponentRenderer)ComponentRendererFactory.renderer(this.context, component, this.writer);
        renderer.buildChildren(true);
        renderer.decorated(this.decorated);
        renderer.owner(this.owner);
        renderer.virtualParent(virtualParent);
        return renderer;
    }

    private List<Component> references(Component component) {
        if (((Component)this.element).i$(ElementHelper.conceptOf(HelperComponents.Row.class))) {
            return ((HelperComponents.Row)((Component)this.element).a$(HelperComponents.Row.class)).items().stream().map(i -> (Component)i.a$(Component.class)).collect(Collectors.toList());
        }
        if (((Component)this.element).i$(ElementHelper.conceptOf(OtherComponents.Selector.CollectionBox.class)) && ((OtherComponents.Selector.CollectionBox)((Component)this.element).a$(OtherComponents.Selector.CollectionBox.class)).source() != null) {
            return Collections.emptyList();
        }
        return component.components();
    }

    private void addExtends(Component element, FrameBuilder builder) {
        builder.add("extends", (Object)this.extendsFrame(element));
    }

    protected FrameBuilder extendsFrame(Component element) {
        FrameBuilder result = this.buildBaseFrame().add("extends");
        if (element.i$(ElementHelper.conceptOf(DataComponents.Image.class))) {
            result.add("image");
        }
        if (element.i$(ElementHelper.conceptOf(CatalogComponents.Collection.class))) {
            result.add("collection");
        }
        if (element.i$(ElementHelper.conceptOf(CatalogComponents.Table.class))) {
            result.add("table");
        }
        if (element.i$(ElementHelper.conceptOf(CatalogComponents.DynamicTable.class))) {
            result.add("dynamictable");
        }
        if (element.i$(ElementHelper.conceptOf(CatalogComponents.Grid.class))) {
            result.add("grid");
        }
        result.add("name", (Object)this.nameOf(element));
        if (!this.addSpecificTypes(result)) {
            result.add("type", (Object)this.type());
        }
        this.addFacets(element, result);
        this.addDecoratedFrames(result, this.decorated);
        return result;
    }

    protected boolean addSpecificTypes(FrameBuilder builder) {
        if (((Component)this.element).i$(ElementHelper.conceptOf(Multiple.class))) {
            String objectType;
            Multiple multiple = (Multiple)((Component)this.element).a$(Multiple.class);
            String message = multiple.noItemsMessage();
            if (message != null) {
                builder.add("noItemsMessage", (Object)message);
            }
            FrameBuilder methodsFrame = this.addOwner(this.buildBaseFrame()).add("method").add("multiple");
            if (multiple.collapsed()) {
                methodsFrame.add("collapsable");
            }
            methodsFrame.add("componentType", (Object)this.multipleComponentType(this.element));
            methodsFrame.add("componentName", (Object)this.multipleComponentName(this.element));
            if (((Component)this.element).i$(ElementHelper.conceptOf(OtherComponents.OwnerTemplateStamp.class))) {
                methodsFrame.add("componentOwnerBox", (Object)((OtherComponents.OwnerTemplateStamp)((Component)this.element).a$(OtherComponents.OwnerTemplateStamp.class)).owner().name());
            }
            if (((Component)this.element).i$(ElementHelper.conceptOf(Editable.class))) {
                methodsFrame.add("editableMethods", (Object)new FrameBuilder(new String[]{"editableMethods"}));
                if (!this.isMultipleSpecificComponent(this.element)) {
                    methodsFrame.add("editableClass", (Object)this.editableClassFrame());
                }
            }
            if ((objectType = this.multipleObjectType(this.element)) != null) {
                methodsFrame.add("objectType", (Object)objectType);
                if (!objectType.equals("java.lang.Void")) {
                    methodsFrame.add("objectTypeValue", (Object)"value");
                }
            }
            methodsFrame.add("name", (Object)this.nameOf(this.element));
            builder.add("methods", (Object)methodsFrame);
            builder.add("multiple");
            builder.add("componentType", (Object)this.multipleComponentType(this.element));
            builder.add("componentName", (Object)this.multipleComponentName(this.element));
            if (!this.isMultipleSpecificComponent(this.element) && ((Component)this.element).i$(ElementHelper.conceptOf(Editable.class))) {
                builder.add("componentPrefix", (Object)this.nameOf(this.element));
            }
            if (objectType != null) {
                builder.add("objectType", (Object)objectType);
            }
        }
        if (((Component)this.element).i$(ElementHelper.conceptOf(Template.class))) {
            builder.add("template");
            String modelClass = ((Template)((Component)this.element).a$(Template.class)).modelClass();
            builder.add("componentType", (Object)this.nameOf(this.element));
            builder.add("objectType", (Object)(modelClass != null ? modelClass : "java.lang.Void"));
            return true;
        }
        if (((Component)this.element).i$(ElementHelper.conceptOf(OtherComponents.BaseStamp.class)) && !((Component)this.element).i$(ElementHelper.conceptOf(OtherComponents.DisplayStamp.class))) {
            builder.add("basestamp");
            if (!((Component)this.element).i$(ElementHelper.conceptOf(Multiple.class))) {
                builder.add("single");
            }
            if (((Component)this.element).i$(ElementHelper.conceptOf(OtherComponents.OwnerTemplateStamp.class))) {
                builder.add("ownertemplatestamp");
            }
            if (((Component)this.element).i$(ElementHelper.conceptOf(OtherComponents.DisplayStamp.class))) {
                builder.add("displaystamp");
            }
            if (((Component)this.element).i$(ElementHelper.conceptOf(OtherComponents.ProxyStamp.class))) {
                builder.add("proxystamp");
            }
            String templateName = this.templateName((OtherComponents.BaseStamp)((Component)this.element).a$(OtherComponents.BaseStamp.class));
            builder.add("template", (Object)templateName);
            builder.add("type", (Object)templateName);
            builder.add("generic", this.genericOf((OtherComponents.BaseStamp)((Component)this.element).a$(OtherComponents.BaseStamp.class)));
            if (((Component)this.element).i$(ElementHelper.conceptOf(OtherComponents.OwnerTemplateStamp.class))) {
                Service.UI.Use owner = ((OtherComponents.OwnerTemplateStamp)((Component)this.element).a$(OtherComponents.OwnerTemplateStamp.class)).owner();
                builder.add("ownerPackage", (Object)this.ownerTemplateStampPackage(owner));
                builder.add("ownerBox", (Object)this.ownerTemplateStampBox(owner));
            }
            return true;
        }
        if (((Component)this.element).i$(ElementHelper.conceptOf(CatalogComponents.Moldable.Mold.Item.class))) {
            builder.add("item");
            CatalogComponents.Collection collection = (CatalogComponents.Collection)((CatalogComponents.Moldable.Mold.Item)((Component)this.element).a$(CatalogComponents.Moldable.Mold.Item.class)).core$().ownerAs(CatalogComponents.Collection.class);
            builder.add("itemClass", (Object)(collection.itemClass() != null ? collection.itemClass() : "java.lang.Void"));
            return true;
        }
        return false;
    }

    private String ownerTemplateStampBox(Service.UI.Use use) {
        return use.package$() + ".box." + use.name();
    }

    private Object genericOf(OtherComponents.BaseStamp stamp) {
        if (stamp.i$(ElementHelper.conceptOf(OtherComponents.TemplateStamp.class)) && ((OtherComponents.TemplateStamp)((Component)this.element).a$(OtherComponents.TemplateStamp.class)).template() != null) {
            boolean parent = KonosGraph.isParent(this.context.graphName(), ((OtherComponents.TemplateStamp)((Component)this.element).a$(OtherComponents.TemplateStamp.class)).template());
            return parent ? "<>" : "";
        }
        return "";
    }

    private String templateName(OtherComponents.BaseStamp stamp) {
        if (stamp.i$(ElementHelper.conceptOf(OtherComponents.OwnerTemplateStamp.class))) {
            return ((OtherComponents.OwnerTemplateStamp)stamp.a$(OtherComponents.OwnerTemplateStamp.class)).template();
        }
        if (stamp.i$(ElementHelper.conceptOf(OtherComponents.TemplateStamp.class))) {
            Template template = ((OtherComponents.TemplateStamp)stamp.a$(OtherComponents.TemplateStamp.class)).template();
            return template != null ? template.name$() : null;
        }
        return null;
    }

    private FrameBuilder editableClassFrame() {
        FrameBuilder result = new FrameBuilder(new String[]{"editableClass"});
        result.add("componentType", (Object)this.multipleComponentType(this.element));
        result.add("componentName", (Object)this.multipleComponentName(this.element));
        this.addDecoratedFrames(result, this.decorated);
        result.add("componentProperties", (Object)this.properties().add("componentClass"));
        return result;
    }

    private void addProperties(FrameBuilder builder) {
        FrameBuilder properties = this.properties();
        if (properties.slots() <= 0) {
            return;
        }
        builder.add("properties", (Object)this.properties());
    }

    protected FrameBuilder fileMethodFrame(String method, String value) {
        FrameBuilder result = new FrameBuilder(new String[]{"fileMethod"}).add("name", (Object)method).add("value", (Object)value);
        this.addOwner(result);
        return result;
    }

    protected FrameBuilder resourceMethodFrame(String method, String value) {
        FrameBuilder result = new FrameBuilder(new String[]{"resourceMethod"}).add("name", (Object)method).add("value", (Object)this.fixResourceValue(value));
        this.addOwner(result);
        return result;
    }

    protected FrameBuilder parameterMethodFrame(String name, String value) {
        FrameBuilder frame = new FrameBuilder(new String[]{"parameter"});
        frame.add("name", (Object)name);
        frame.add("value", (Object)value);
        this.addOwner(frame);
        return frame;
    }

    protected String fixResourceValue(String value) {
        return value.startsWith("/") ? value : "/" + value;
    }

    private void addImplements(C element, FrameBuilder builder) {
        if (!((Component)((Object)element)).isOption()) {
            return;
        }
        builder.add("implements", (Object)new FrameBuilder(new String[]{"implements", "option"}).add("option", (Object)""));
    }

    private FrameBuilder componentReferencesFrame() {
        FrameBuilder result = new FrameBuilder(new String[]{"componentReferences"});
        List<Component> componentList = null;
        if (((Component)this.element).i$(ElementHelper.conceptOf(Block.class))) {
            componentList = ((Block)((Component)this.element).a$(Block.class)).componentList();
        } else if (((Component)this.element).i$(ElementHelper.conceptOf(Template.class))) {
            componentList = ((Template)((Component)this.element).a$(Template.class)).componentList();
        } else if (((Component)this.element).i$(ElementHelper.conceptOf(OtherComponents.Dialog.class))) {
            componentList = ((OtherComponents.Dialog)((Component)this.element).a$(OtherComponents.Dialog.class)).componentList();
        } else if (((Component)this.element).i$(ElementHelper.conceptOf(CatalogComponents.Moldable.Mold.Item.class))) {
            componentList = ((CatalogComponents.Moldable.Mold.Item)((Component)this.element).a$(CatalogComponents.Moldable.Mold.Item.class)).componentList();
        }
        if (componentList == null) {
            return result;
        }
        result.add("forRoot");
        componentList.forEach(c -> this.addComponent((Component)((Object)c), this.virtualParent(), result));
        return componentList.size() > 0 ? result : null;
    }

    private String frameId() {
        return this.nameOf(this.element) + (this.buildChildren && this.virtualParent() != null ? this.virtualParent().name$() : "") + (this.owner != null ? this.owner.name$() : "") + this.writer.target().name() + this.buildChildren + this.decorated;
    }
}

