/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.accessor.ui.android.templates;

import io.intino.itrules.Rule;
import io.intino.itrules.RuleSet;
import io.intino.itrules.Template;

public class RouteDispatcherTemplate
extends Template {
    public RuleSet ruleSet() {
        return new RuleSet().add(new Rule[]{this.rule().condition(this.type("dispatcher"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("package ")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".mobile.android.displays\n\nimport android.content.Context\nimport android.content.Intent\nimport android.os.Bundle\nimport ")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".mobile.android.pages.HomeActivity\nimport ")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".mobile.android.pages.MicroSiteActivity\nimport ")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".mobile.android.pages.WidgetTypeActivity\nimport ")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".mobile.android.pages.WidgetsActivity\nimport java.util.regex.Matcher\nimport java.util.regex.Pattern\n\nclass RouteDispatcher {\n    private var info : HashMap<String, RouteInfo> = hashMapOf()\n\n    init {\n        ")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("resource", new String[]{"patternRegister"}).multiple("\n")})}).output(new Rule.Output[]{this.literal("\n    }\n\n    fun dispatch(context: Context, address: String) : Intent? {\n        val info = infoOf(address) ?: return null\n        val intent = Intent(context, info.activityClass)\n        addParameters(intent, address, info)\n        return intent\n    }\n\n    private fun infoOf(address: String): RouteInfo? {\n        ")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("resource", new String[]{"info"}).multiple("\n")})}).output(new Rule.Output[]{this.literal("\n        return null\n    }\n\n    private fun matches(address: String, info: RouteInfo): Boolean {\n        if (address.matches(info.pattern)) return true\n        if (!address.endsWith(\"/\")) return false\n        return address.substring(0, address.length-1).matches(info.pattern)\n    }\n\n    private fun addParameters(intent: Intent, address: String, info: RouteInfo) {\n        val b = Bundle()\n        val parameters = paramsOf(address, info)\n        for (i in 0 until info.parameterNames.size) {\n            b.putString(info.parameterNames[i], parameters.get(i))\n        }\n        intent.putExtras(b)\n    }\n\n    private fun paramsOf(address: String, info: RouteInfo?): List<String?> {\n        if (info == null) return emptyList<String>()\n        val p: Pattern = Pattern.compile(info.pattern.pattern)\n        val m: Matcher = matcherOf(p, address) ?: return emptyList()\n        val result: MutableList<String?> = ArrayList()\n        for (i in 1..m.groupCount()) result.add(m.group(i)?.split(\"\\\\?\")!!.get(0))\n        return addQueryStringParams(address, result)\n    }\n\n    private fun matcherOf(pattern: Pattern, address: String): Matcher? {\n        var result: Matcher = pattern.matcher(address)\n        if (result.find()) return result\n        if (!address.endsWith(\"/\")) return null\n        result = pattern.matcher(address.substring(0, address.length-1))\n        return if (result.find()) result else null\n    }\n\n    private fun addQueryStringParams(address: String, result: MutableList<String?>): List<String?> {\n        if (address.indexOf(\"?\") == -1) return result\n        val parameters = address.split(\"\\\\?\".toRegex()).dropLastWhile { it.isEmpty() }\n            .toTypedArray()[1].split(\"&\".toRegex()).dropLastWhile { it.isEmpty() }.toTypedArray()\n        for (i in parameters.indices) {\n            result.add(parameters[i].split(\"=\".toRegex()).dropLastWhile { it.isEmpty() }\n                .toTypedArray()[1])\n        }\n        return result\n    }\n\n    private class RouteInfo(pattern: String, var activityClass: Class<*>, var parameterNames: List<String>) {\n        var pattern : Regex = pattern.toRegex()\n    }\n\n}")}), this.rule().condition(this.allTypes(new String[]{"resource", "main"}), new Rule.Condition[]{this.trigger("patternregister")}), this.rule().condition(this.type("resource"), new Rule.Condition[]{this.trigger("patternregister")}).output(new Rule.Output[]{this.literal("info.put(\"")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal("\", RouteInfo(\"")}).output(new Rule.Output[]{this.mark("pattern", new String[0])}).output(new Rule.Output[]{this.literal("\", ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal("Activity::class.java, listOf(")}).output(new Rule.Output[]{this.mark("param", new String[0]).multiple(",")}).output(new Rule.Output[]{this.literal(")))")}), this.rule().condition(this.allTypes(new String[]{"resource", "main"}), new Rule.Condition[]{this.trigger("info")}).output(new Rule.Output[]{this.literal("if (matches(address, info.get(\"")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal("\")!!)) return info.get(\"")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal("\")")}), this.rule().condition(this.type("resource"), new Rule.Condition[]{this.trigger("info")}).output(new Rule.Output[]{this.literal("else if (matches(address, info.get(\"")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal("\")!!)) return info.get(\"")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal("\")")}), this.rule().condition(this.type("param"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("\"")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal("\"")})});
    }
}

