/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.model;

import io.intino.konos.model.KonosGraph;
import io.intino.konos.model.Sensor;
import io.intino.magritte.framework.Layer;
import io.intino.magritte.framework.Node;
import io.intino.magritte.framework.loaders.StringLoader;
import io.intino.magritte.framework.tags.Terminal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class Feeder
extends Layer
implements Terminal {
    protected List<String> tanks = new ArrayList<String>();
    protected List<Sensor> sensorList = new ArrayList<Sensor>();

    public Feeder(Node node) {
        super(node);
    }

    public List<String> tanks() {
        return this.tanks;
    }

    public String tanks(int index) {
        return this.tanks.get(index);
    }

    public List<String> tanks(Predicate<String> predicate) {
        return this.tanks().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<Sensor> sensorList() {
        return Collections.unmodifiableList(this.sensorList);
    }

    public Sensor sensor(int index) {
        return this.sensorList.get(index);
    }

    public List<Sensor> sensorList(Predicate<Sensor> predicate) {
        return this.sensorList().stream().filter(predicate).collect(Collectors.toList());
    }

    public Sensor sensor(Predicate<Sensor> predicate) {
        return this.sensorList().stream().filter(predicate).findFirst().orElse(null);
    }

    protected List<Node> componentList$() {
        LinkedHashSet components = new LinkedHashSet(super.componentList$());
        new ArrayList<Sensor>(this.sensorList).forEach(c -> components.add(c.core$()));
        return new ArrayList<Node>(components);
    }

    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap();
        map.put("tanks", this.tanks);
        return map;
    }

    protected void addNode$(Node node) {
        super.addNode$(node);
        if (node.is("Sensor")) {
            this.sensorList.add((Sensor)node.as(Sensor.class));
        }
    }

    protected void removeNode$(Node node) {
        super.removeNode$(node);
        if (node.is("Sensor")) {
            this.sensorList.remove(node.as(Sensor.class));
        }
    }

    protected void load$(String name, List<?> values) {
        super.load$(name, values);
        if (name.equalsIgnoreCase("tanks")) {
            this.tanks = StringLoader.load(values, (Layer)this);
        }
    }

    protected void set$(String name, List<?> values) {
        super.set$(name, values);
        if (name.equalsIgnoreCase("tanks")) {
            this.tanks = new ArrayList(values);
        }
    }

    public Create create() {
        return new Create(null);
    }

    public Create create(String name) {
        return new Create(name);
    }

    public Clear clear() {
        return new Clear();
    }

    public KonosGraph graph() {
        return (KonosGraph)this.core$().graph().as(KonosGraph.class);
    }

    public class Create {
        protected final String name;

        public Create(String name) {
            this.name = name;
        }

        public Sensor sensor() {
            Sensor newElement = (Sensor)Feeder.this.core$().graph().concept(Sensor.class).createNode(this.name, Feeder.this.core$()).as(Sensor.class);
            return newElement;
        }
    }

    public class Clear {
        public void sensor(Predicate<Sensor> filter) {
            new ArrayList<Sensor>(Feeder.this.sensorList()).stream().filter(filter).forEach(Layer::delete$);
        }
    }
}

