/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.accessor.ui.android;

import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.konos.builder.codegeneration.accessor.ui.android.templates.AbstractDesktopTemplate;
import io.intino.konos.builder.codegeneration.accessor.ui.android.templates.AbstractDisplayTemplate;
import io.intino.konos.builder.codegeneration.accessor.ui.android.templates.DisplayTemplate;
import io.intino.konos.builder.codegeneration.accessor.ui.android.templates.PassiveViewNotifierTemplate;
import io.intino.konos.builder.codegeneration.accessor.ui.android.templates.PassiveViewRequesterTemplate;
import io.intino.konos.builder.codegeneration.services.ui.Target;
import io.intino.konos.builder.codegeneration.services.ui.UiRendererWriter;
import io.intino.konos.builder.context.CompilationContext;
import io.intino.konos.builder.helpers.CodeGenerationHelper;
import io.intino.konos.builder.helpers.ElementHelper;
import io.intino.konos.model.PassiveView;
import io.intino.konos.model.Template;
import io.intino.magritte.framework.Layer;
import java.io.File;

public class AndroidRendererWriter
extends UiRendererWriter {
    public AndroidRendererWriter(CompilationContext context) {
        super(context, Target.Android);
    }

    @Override
    public boolean write(Layer element, String type, FrameBuilder builder) {
        this.writeSrc(element, type, builder);
        this.writeGen(element, type, builder);
        this.writeLayout(element, type, builder);
        this.writeShared(element, type, builder);
        return true;
    }

    @Override
    public boolean writeNotifier(PassiveView element, FrameBuilder builder) {
        Frame frame = builder.toFrame();
        String name = this.nameOfPassiveViewFile(element, frame, "Notifier");
        if (!this.hasConcreteNotifier(element)) {
            return false;
        }
        this.writeFrame(CodeGenerationHelper.displayNotifierFolder(this.src(Target.MobileShared), this.target), element, name, this.notifierTemplate(element, builder).render((Object)frame));
        return true;
    }

    @Override
    public boolean writeRequester(PassiveView element, FrameBuilder builder) {
        Frame frame = builder.toFrame();
        String name = this.nameOfPassiveViewFile(element, frame, "Requester");
        if (!this.hasConcreteRequester(element)) {
            return false;
        }
        this.writeFrame(CodeGenerationHelper.displayRequesterFolder(this.gen(Target.MobileShared), this.target), element, name, this.requesterTemplate(element, builder).render((Object)frame));
        return true;
    }

    @Override
    public boolean writePushRequester(PassiveView element, FrameBuilder builder) {
        return false;
    }

    private void writeSrc(Layer element, String type, FrameBuilder builder) {
        Template template = this.srcTemplate(element, builder);
        if (template == null) {
            return;
        }
        String newDisplay = CodeGenerationHelper.displayFilename(element.name$(), this.isAccessible(builder) ? "Proxy" : "");
        File file = CodeGenerationHelper.displayFile(this.src(), newDisplay, type, this.target);
        if (!element.i$(io.intino.konos.model.Template.class) && file.exists()) {
            return;
        }
        this.writeFrame(CodeGenerationHelper.displayFolder(this.src(), type, this.target), element, newDisplay, template.render((Object)builder.toFrame()));
    }

    private void writeGen(Layer element, String type, FrameBuilder builder) {
        Template template = this.genTemplate(element, builder);
        if (template == null) {
            return;
        }
        String newDisplay = CodeGenerationHelper.displayFilename(element.name$(), this.isAccessible(builder) ? "Proxy" : "");
        File file = CodeGenerationHelper.displayFile(this.gen(), newDisplay, type, this.target);
        if (file.exists()) {
            return;
        }
        this.writeFrame(CodeGenerationHelper.displayFolder(this.gen(), type, this.target), element, newDisplay, template.render((Object)builder.toFrame()));
    }

    private void writeLayout(Layer element, String type, FrameBuilder builder) {
        builder.add("res");
        Template template = this.resTemplate(element, builder);
        if (template == null) {
            return;
        }
        String newDisplay = CodeGenerationHelper.displayFilename(element.name$(), this.isAccessible(builder) ? "Proxy" : "");
        File file = CodeGenerationHelper.displayFile(this.res(), newDisplay, type, Target.AndroidResource);
        if (this.hasAbstractClass(element) && file.exists()) {
            return;
        }
        this.writeFrame(CodeGenerationHelper.displayFolder(this.res(), type, Target.AndroidResource), element, newDisplay, template.render((Object)builder.toFrame()), Target.AndroidResource);
    }

    private void writeShared(Layer element, String type, FrameBuilder builder) {
        if (!this.hasAbstractClass(element)) {
            return;
        }
        builder.add("interface");
        Template template = this.srcTemplate(element, builder);
        if (template == null) {
            return;
        }
        String newDisplay = CodeGenerationHelper.displayFilename(element.name$(), this.isAccessible(builder) ? "Proxy" : "");
        this.writeFrame(CodeGenerationHelper.displayFolder(this.src(Target.MobileShared), type, Target.MobileShared), element, newDisplay, template.render((Object)builder.toFrame()), Target.MobileShared);
    }

    public Template srcTemplate(Layer layer, FrameBuilder builder) {
        if (this.isAccessible(builder)) {
            return null;
        }
        if (!ElementHelper.isRoot(layer)) {
            return null;
        }
        return this.setup(new DisplayTemplate());
    }

    public Template genTemplate(Layer layer, FrameBuilder builder) {
        if (layer.i$(Template.Desktop.class)) {
            return this.setup(new AbstractDesktopTemplate());
        }
        return this.setup(new AbstractDisplayTemplate());
    }

    public Template resTemplate(Layer layer, FrameBuilder builder) {
        if (layer.i$(Template.Desktop.class)) {
            return this.setup(new AbstractDesktopTemplate());
        }
        return this.setup(new AbstractDisplayTemplate());
    }

    public Template notifierTemplate(PassiveView element, FrameBuilder builder) {
        return this.setup(new PassiveViewNotifierTemplate());
    }

    public Template requesterTemplate(PassiveView element, FrameBuilder builder) {
        return this.setup(new PassiveViewRequesterTemplate());
    }

    public Template pushRequesterTemplate(PassiveView element, FrameBuilder builder) {
        return null;
    }
}

